/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_PointSymbol_ComboBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ElementPlotOptionsWidget
extends GridLayoutWidget
implements ActionListener,
ItemListener {
    protected JCheckBox m_showCheck;
    protected JTextField m_sizeText = new JTextField("3");
    protected Java2D_PointSymbol_ComboBox m_symbolCombo = new Java2D_PointSymbol_ComboBox();
    protected JCheckBox m_useColorCheck = new JCheckBox("Use color scale (column selected below)");
    protected JButton m_colorButton = new JButton("Select fixed color");
    protected GenericObjectListener m_listener = new GenericObjectListener();

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public ElementPlotOptionsWidget(String table) {
        super(0, table + " display options");
        try {
            boolean colStretch0 = true;
            int colStretch1 = 10;
            int row = 0;
            this.m_showCheck = new JCheckBox("Display ");
            this.addComponent(this.m_showCheck, row, 0, 1.0, (double)colStretch0);
            this.addComponent(this.m_useColorCheck, row, 1, 1.0, colStretch1);
            this.addComponent(new JLabel("Color"), ++row, 0, 1.0, (double)colStretch0);
            this.addComponent(this.m_colorButton, row, 1, 1.0, colStretch1);
            this.addComponent(new JLabel("Symbol"), ++row, 0, 1.0, (double)colStretch0);
            this.addComponent(this.m_symbolCombo, row, 1, 1.0, colStretch1);
            this.addComponent(new JLabel("Symbol size"), ++row, 0, 1.0, (double)colStretch0);
            this.addComponent(this.m_sizeText, row, 1, 1.0, colStretch1);
            ++row;
            this.m_colorButton.addActionListener(this);
            this.m_showCheck.addActionListener(this);
            this.m_useColorCheck.addActionListener(this);
            this.m_sizeText.addActionListener(this);
            this.m_symbolCombo.addItemListener(this);
            this.m_showCheck.setSelected(true);
            this.m_useColorCheck.setSelected(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.m_listener.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setSymbolColor(Color c) {
        this.m_colorButton.setBackground(c);
    }

    public Color symbolColor() {
        return this.m_colorButton.getBackground();
    }

    public int symbolSize(int min, int max) {
        return Tools_Widget.extractInteger(this.m_sizeText, 7, min, max);
    }

    public boolean useColorScale() {
        return this.m_useColorCheck.isSelected();
    }

    public void setDisplay(boolean display) {
        this.m_showCheck.setSelected(display);
    }

    public boolean display() {
        return this.m_showCheck.isSelected();
    }

    public void setSelectedSymbol(Java2D_PointSymbol s) {
        try {
            this.m_symbolCombo.setSelectedSymbol(s);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Java2D_PointSymbol selectedSymbol() {
        try {
            return this.m_symbolCombo.selectedSymbol();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return Java2D_PointSymbol.X;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_colorButton) {
                Color c = JColorChooser.showDialog(null, "", this.m_colorButton.getBackground());
                if (c == null) {
                    return;
                }
                this.m_colorButton.setBackground(c);
            }
            this.m_listener.broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

