/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CardWidget
extends LinearLayoutWidget
implements ItemListener {
    protected JPanel m_mainPanel = new JPanel();
    protected JComboBox<String> m_selectionCombo = new JComboBox();
    protected CardLayout m_cardLayout = new CardLayout();

    public CardWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            this.m_mainPanel.setLayout(this.m_cardLayout);
            this.m_selectionCombo.setForeground(Color.BLUE);
            this.m_selectionCombo.setEditable(false);
            this.m_selectionCombo.addItemListener(this);
            Tools_FontChanger.changeSizeOfFont(this.m_selectionCombo, 1);
            this.addComponent(this.m_selectionCombo, 0);
            this.addComponent(this.m_mainPanel, 10);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setSelectedIndex(int index) {
        try {
            if (index >= 0 && index < this.m_selectionCombo.getItemCount()) {
                this.m_selectionCombo.setSelectedIndex(index);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addCardPanel(String label, JComponent panel) {
        try {
            this.m_mainPanel.add((Component)panel, label);
            this.m_selectionCombo.addItem(label);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.m_selectionCombo) {
                this.m_cardLayout.show(this.m_mainPanel, (String)e.getItem());
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

