/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Shared;

import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Sequence.Action_RunSequence;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_MainWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.Timer;

public class BatchProcessingDialog
extends JDialog
implements ActionListener {
    protected Sequence_MainWidget m_mainWidget;
    protected JButton m_btnOK = new JButton("Launch job");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected Timer m_timer = new Timer(2000, this);

    public BatchProcessingDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            this.m_mainWidget = new Sequence_MainWidget("Batch", EnsembleWorker_Sequence.SequenceType.Processing);
            this.getContentPane().add((Component)this.m_mainWidget, "Center");
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            this.m_btnCancel = bottom.createButton("Cancel", this, 0);
            this.m_btnOK = bottom.createButton("Launch job", this, 0);
            bottom.addStretch(10);
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setSize(this.getSize().width + 150, this.getSize().height + 500);
            this.setLocationRelativeTo(null);
            this.m_timer.start();
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Action_RunSequence getRunSequence() throws Exception {
        Action_RunSequence action = new Action_RunSequence();
        action.Hasher.string_put("Description", "Batch job");
        action.Hasher.bool_put("RequiresDelayTimeData", false);
        action.Hasher.bool_put("RequiresRefractionStaticsProject", false);
        action.Sequence = this.m_mainWidget.sequence();
        return action;
    }

    public void runJob() {
        try {
            Action_RunSequence action = new Action_RunSequence();
            action.SharedData.Type = EnsembleWorker_Sequence.SequenceType.Processing;
            action.Sequence = this.m_mainWidget.sequence();
            action.Hasher.string_put("Description", "Batch job");
            action.Hasher.bool_put("RequiresDelayTimeData", false);
            action.Hasher.bool_put("RequiresRefractionStaticsProject", true);
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            project.executeSingleAction(action);
            this.dispose();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                this.runJob();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

