/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Segy;

import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Shared.FileWidget;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class TraceSelectSegyFileDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected FileWidget m_inputWidget;
    protected FileWidget m_outputWidget;
    protected JTextField m_textOffset = new JTextField("97");
    protected JTextField m_textMinValid = new JTextField("300");
    protected JTextField m_textMaxValid = new JTextField("300");
    protected JLabel m_label = new JLabel("");
    protected JButton m_btnOK;
    protected JButton m_btnCancel;

    public TraceSelectSegyFileDialog() {
        try {
            this.m_inputWidget = new FileWidget(false, 3, "Input file name", this);
            this.m_outputWidget = new FileWidget(false, 3, "Output file name", this);
            this.m_outputWidget.setEditable();
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            main.addComponent(this.m_inputWidget, 0);
            main.addComponent(this.m_outputWidget, 0);
            GridLayoutWidget grid = main.createGridLayoutWidget(3, "Selection options", 0);
            grid.addSimple(0, new JLabel("Header offset"), this.m_textOffset);
            grid.addSimple(1, new JLabel("Minimum acceptable"), this.m_textMinValid);
            grid.addSimple(2, new JLabel("Maximum acceptable"), this.m_textMaxValid);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            this.m_btnOK = bottom.createButton("Create output file", this, 0);
            this.m_btnCancel = bottom.createButton("Cancel", this, 0);
            bottom.addComponent(this.m_label, 10);
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setSize(850, this.getSize().height);
            this.setTitle("segy file header filter utility");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    public boolean work() {
        try {
            String inputFile = this.m_inputWidget.getText();
            String outputFile = this.m_outputWidget.getText();
            this.m_label.setForeground(Color.RED);
            if (!Tools_FileSystem.exists_file(inputFile)) {
                this.m_label.setText("Input file does not exist");
                return false;
            }
            Segy segy = new Segy();
            segy.setFileName(inputFile);
            if (!segy.isFileOK()) {
                this.m_label.setText("Input file is not a valid segy file");
                return false;
            }
            if (Tools_FileSystem.exists_file(outputFile)) {
                this.m_label.setText("Output file already exists");
                return false;
            }
            if (inputFile.equalsIgnoreCase(outputFile)) {
                this.m_label.setText("Same files");
                return false;
            }
            this.m_label.setForeground(Color.BLUE);
            this.m_label.setText("");
            this.m_label.paintImmediately(0, 0, 1000, 30);
            int header = Tools_Widget.extractInteger(this.m_textOffset, 1, 1, 237);
            int min = Tools_Widget.extractInteger(this.m_textMinValid, 1, -9999999, 999999999);
            int max = Tools_Widget.extractInteger(this.m_textMaxValid, 1, -9999999, 999999999);
            segy.outputHeaderFilteredVersion(outputFile, header - 1, min, max);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                if (!this.work()) {
                    return;
                }
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

