/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Segy;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Parameter.TextFieldInt;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Sequence.Action_RunSequence;
import com.PecosLibrary.Ensemble.Worker.Import.EnsembleWorker_ScanSegy;
import com.PecosLibrary.Ensemble.Worker.Output.EnsembleWorker_PickFileOutput;
import com.PecosLibrary.Ensemble.Worker.Picker.EnsembleWorker_ThresholdPicker;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_MainWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_VertStackedEnsembleDisplayWidget;
import com.PecosLibrary.Windows.Shared.CardWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Segy_DataDisplayWidget
extends JSplitPane
implements ItemListener,
ChangeListener,
ActionListener,
GenericObjectListener.Listener {
    protected CardWidget m_cardWidget = new CardWidget();
    protected Java2D_VertStackedEnsembleDisplayWidget m_mainWidget = new Java2D_VertStackedEnsembleDisplayWidget(1);
    protected Sequence_MainWidget m_sequenceWidget;
    protected TextFieldInt m_firstTraceText = new TextFieldInt();
    protected TextFieldInt m_traceCountText = new TextFieldInt();
    protected JSlider m_firstTraceSlider = new JSlider();
    protected boolean m_bIgnoreSlider = true;
    protected JButton m_reloadButton;
    protected Segy m_segy;
    protected Segy_Dictionary m_dict;
    protected long[] m_indices = new long[400];
    protected Ensemble m_inputEnsemble = new Ensemble();
    protected Ensemble m_processedEnsemble = new Ensemble();

    public Segy_DataDisplayWidget(Segy segy, Segy_Dictionary dict) {
        super(1);
        try {
            this.m_dict = dict;
            this.m_dict.getListenerController().addListener(this);
            this.m_segy = segy;
            this.m_segy.getListenerController().addListener(this);
            this.setLeftComponent(this.createDisplayWidget());
            this.setRightComponent(this.createOptionsWidget());
            this.setResizeWeight(1.0);
            this.m_mainWidget.setAxisType(Java2D_EnsembleAxisEnum.UniformSpacing);
            this.m_mainWidget.setVisibleCount(1);
            this.m_mainWidget.addZoomer();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected JComponent createDisplayWidget() {
        try {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)this.m_mainWidget, "Center");
            panel.add((Component)this.createIOWidget(), "North");
            return panel;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected JComponent createIOWidget() {
        try {
            LinearLayoutWidget w = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            w.createLabel("Count", 0, 0);
            this.m_traceCountText.setPreferredSize(new Dimension(75, 15));
            w.addComponent(this.m_traceCountText, 0);
            w.createLabel("First", 0, 0);
            this.m_firstTraceText.setPreferredSize(new Dimension(75, 15));
            w.addComponent(this.m_firstTraceText, 0);
            this.m_firstTraceText.addActionListener(this);
            this.m_traceCountText.addActionListener(this);
            w.addComponent(this.m_firstTraceSlider, 10);
            this.m_firstTraceSlider.addChangeListener(this);
            this.m_reloadButton = w.createButton("Reload", this, 0);
            return w;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected JComponent createOptionsWidget() {
        try {
            this.m_sequenceWidget = new Sequence_MainWidget("Segy", EnsembleWorker_Sequence.SequenceType.Interactive);
            this.m_sequenceWidget.sequence().addListener(this);
            return this.m_sequenceWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void setSegy(Segy segy) {
        try {
            if (segy == null) {
                return;
            }
            this.m_segy = segy;
            this.m_segy.getListenerController().addListener(this);
            this.handleSegyChanged();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void performWorkOnInputEnsemble() {
        try {
            this.m_processedEnsemble.clearTraces(true);
            this.m_inputEnsemble.copyToOtherEnsemble(this.m_processedEnsemble);
            this.m_processedEnsemble = this.m_sequenceWidget.sequence().work(this.m_processedEnsemble);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void loadEnsemble() {
        try {
            if (!this.m_segy.isFileOK()) {
                this.handleSegyChanged();
                return;
            }
            int first = this.m_firstTraceText.getInt(1);
            int count = this.m_traceCountText.getInt(100);
            this.clear();
            for (int n = 0; n < count; ++n) {
                this.m_indices[n] = first + n - 1;
            }
            this.m_inputEnsemble.clearDictionary();
            this.m_inputEnsemble.clearTraces(false);
            this.m_segy.setSegyDictionary(this.m_dict);
            this.m_segy.populateEnsemble(this.m_inputEnsemble, this.m_indices, count, true, true);
            float readTime = (float)(1.0E-6 * (double)this.m_segy.ReadTime);
            Tools_Ensemble.computeAverageAmplitude(this.m_inputEnsemble, "AVGAMP");
            Tools_Ensemble.computeMaximumAmplitude(this.m_inputEnsemble, "MAXAMP");
            this.performWorkOnInputEnsemble();
            this.m_mainWidget.setEnsemble(0, this.m_processedEnsemble);
            this.m_mainWidget.clearAndLoadWigglePaintables();
            this.m_mainWidget.unzoom();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            if (e.getSource() == this.m_firstTraceSlider) {
                if (this.m_bIgnoreSlider) {
                    return;
                }
                int v = this.m_firstTraceSlider.getValue();
                this.m_firstTraceText.setText(Integer.toString(v));
                this.loadEnsemble();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_firstTraceText) {
                int n = Tools_Widget.extractInteger(this.m_firstTraceText, 1, 1, (int)this.m_segy.traceCount() - 2);
                this.m_firstTraceSlider.setValue(n);
                this.loadEnsemble();
                return;
            }
            if (e.getSource() == this.m_firstTraceText) {
                this.loadEnsemble();
                return;
            }
            if (e.getSource() == this.m_traceCountText) {
                this.loadEnsemble();
                return;
            }
            if (e.getSource() == this.m_reloadButton) {
                this.loadEnsemble();
                return;
            }
            if (e.getSource() == this.m_traceCountText) {
                this.loadEnsemble();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void clear() {
    }

    public void handleSegyChanged() {
        try {
            this.m_bIgnoreSlider = true;
            this.clear();
            this.m_traceCountText.setEnabled(this.m_segy.isFileOK());
            this.m_firstTraceText.setEnabled(this.m_segy.isFileOK());
            this.m_firstTraceSlider.setEnabled(this.m_segy.isFileOK());
            this.m_reloadButton.setEnabled(this.m_segy.isFileOK());
            if (!this.m_segy.isFileOK()) {
                return;
            }
            int nt = (int)this.m_segy.traceCount();
            this.m_firstTraceText.setRange(1, nt);
            this.m_traceCountText.setRange(10, 400);
            this.m_firstTraceText.setText("1");
            this.m_firstTraceSlider.setValue(1);
            this.m_firstTraceSlider.setMaximum(nt);
            this.m_bIgnoreSlider = false;
            this.loadEnsemble();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void tryToLaunchBatchPicker(Object data) {
        try {
            EnsembleWorker_Sequence sequence = this.m_sequenceWidget.sequence();
            Object md = sequence.MessageData.ExtraData;
            if (md == null) {
                return;
            }
            boolean isPicker = md instanceof EnsembleWorker_ThresholdPicker;
            if (!isPicker) {
                return;
            }
            EnsembleWorker_Base picker = (EnsembleWorker_Base)md;
            System.out.println("tryToLaunchBatchPicker");
            EnsembleWorker_Sequence runSequence = new EnsembleWorker_Sequence(EnsembleWorker_Sequence.SequenceType.Processing);
            EnsembleWorker_ScanSegy scanner = new EnsembleWorker_ScanSegy();
            scanner.appendSegyFile(this.m_segy.fileName());
            scanner.setDictionaryFileName(this.m_dict.getFileName());
            runSequence.add(scanner);
            for (int n = 0; n < sequence.size(); ++n) {
                EnsembleWorker_Base worker = sequence.worker(n);
                if (worker.WorkerTurnedOn) {
                    runSequence.add(worker);
                }
                if (worker != picker) continue;
                n = 10000000;
            }
            EnsembleWorker_PickFileOutput pfo = new EnsembleWorker_PickFileOutput();
            String column = "";
            if (md instanceof EnsembleWorker_ThresholdPicker) {
                EnsembleWorker_ThresholdPicker p = (EnsembleWorker_ThresholdPicker)md;
                column = p.getColumnName();
            }
            pfo.setColumnName(column);
            runSequence.add(pfo);
            Action_RunSequence action = new Action_RunSequence();
            action.Sequence = sequence;
            action.Hasher.string_put("Description", "Batch auto picker");
            action.Hasher.bool_put("RequiresDelayTimeData", false);
            action.Hasher.bool_put("RequiresRefractionStaticsProject", false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_segy || sender == this.m_dict) {
                this.handleSegyChanged();
                return;
            }
            if (sender == this.m_sequenceWidget.sequence()) {
                if (this.m_sequenceWidget.sequence().MessageData.SequenceModified) {
                    this.performWorkOnInputEnsemble();
                    this.m_mainWidget.forcePaintAll();
                }
                if (this.m_sequenceWidget.sequence().MessageData.MessageFromWorker) {
                    this.tryToLaunchBatchPicker(data);
                }
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }
}

