/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Uphole;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Math.Interpolator_EmptyGrid;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Uphole.UpholeSimple;
import com.PecosLibrary.Refraction.Uphole.UpholeSimple_Location;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_VerticalStackWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_PaintableDatabaseProfile;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_AxisLines;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_LineSegment;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Line;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MouseMove;
import com.PecosLibrary.Windows.Shared.PopupMenuButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UpholeWidgetV2
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener,
ItemListener,
Messenger.Listener,
PopupMenuButton.Listener,
ISaveableFrame,
ChangeListener {
    protected JButton m_btn_import_csv_xydt = new JButton("Import CSV: (X,Y,Depth,Time)");
    protected JButton m_btn_import_csv_xyzdt = new JButton("Import CSV: (X,Y,Z,Depth,Time)");
    protected JButton m_btn_import_simple = new JButton("Import simple ASCII format - depth/time pairs");
    protected JCheckBox m_chk_shots = new JCheckBox("Show shots");
    protected JCheckBox m_chk_recs = new JCheckBox("Show receivers");
    protected JButton m_btn_reload_plot = new JButton("Reload plot");
    protected JComboBox m_combo_map_mouse_mode = new JComboBox();
    protected UpholeSimple m_uphole;
    protected Java2D_SimpleComposite m_map_widget;
    protected Java2D_UserEventConsumer_ButtonPressed m_leftClickUEC;
    protected Java2D_UserEventConsumer_MouseMove m_mouseMoveUEC;
    protected Java2D_UserEventConsumer_Line m_lineUEC;
    protected JTextField m_txt_vert_scalar = new JTextField("20");
    protected Java2D_SimpleComposite m_map_interp_widget;
    protected JTextField m_txt_map_interp_depth = new JTextField("50");
    protected JTextField m_txt_map_interp_bin_size = new JTextField("250");
    protected JComboBox m_cmb_map_interp_type = new JComboBox();
    protected JButton m_btn_map_interp_reload_plot = new JButton("Reload plot");
    protected Java2D_SimpleComposite m_vint_widget;
    protected Java2D_SimpleComposite m_time_widget;
    protected Java2D_VerticalStackWidget m_profile_widget;
    public Java2D_Paintable_LineSegment m_profile_line = new Java2D_Paintable_LineSegment();

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Refraction.Uphole.UpholeWidgetV2";
    }

    @Override
    public String TAB_LABEL() {
        return "Uphole";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "Uphole surveys";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public UpholeWidgetV2() {
        super(1);
        try {
            this.m_uphole = RefractionStaticsProject.singleton().uphole_simple_get();
            this.m_leftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
            this.m_leftClickUEC.addListener(this);
            this.m_mouseMoveUEC = new Java2D_UserEventConsumer_MouseMove();
            this.m_mouseMoveUEC.addListener(this);
            this.m_lineUEC = new Java2D_UserEventConsumer_Line();
            this.m_lineUEC.addListener(this);
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRight());
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            ParameterTree tree = p.information().ParameterTree_get("simple_uphole");
            double vert_scalar = tree.double_get("vert_scalar", 20.0);
            String s = Double.toString(vert_scalar);
            this.m_txt_vert_scalar.setText(s);
            s = this.m_txt_vert_scalar.getText();
            this.recompute_interp();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected JComponent createUpperLeft() {
        try {
            LinearLayoutWidget left = LinearLayoutWidget.vert(0, null);
            left.addComponent(this.m_btn_import_csv_xydt, 0);
            left.addComponent(this.m_btn_import_csv_xyzdt, 0);
            left.addComponent(this.m_btn_import_simple, 0);
            this.m_btn_import_simple.addActionListener(this);
            this.m_btn_import_csv_xydt.addActionListener(this);
            this.m_btn_import_csv_xyzdt.addActionListener(this);
            left.addHorzPair(new JLabel("Vertical interpolation scalar"), 1, this.m_txt_vert_scalar, 8);
            this.m_txt_vert_scalar.addActionListener(this);
            left.addStretch(10);
            LinearLayoutWidget sub = LinearLayoutWidget.horz(0, null);
            sub.addComponent(this.m_chk_shots, 0);
            sub.addComponent(this.m_chk_recs, 0);
            sub.addComponent(this.m_btn_reload_plot, 0);
            sub.addStretch(10);
            left.addComponent(sub, 0);
            this.m_chk_shots.addActionListener(this);
            this.m_chk_recs.addActionListener(this);
            this.m_btn_reload_plot.addActionListener(this);
            sub = LinearLayoutWidget.horz(0, null);
            sub.addComponent(new JLabel("Select mouse mode"), 0);
            sub.addComponent(this.m_combo_map_mouse_mode, 0);
            this.m_combo_map_mouse_mode.addItem("Select uphole location");
            this.m_combo_map_mouse_mode.addItem("Drag profile line");
            this.m_combo_map_mouse_mode.addActionListener(this);
            sub.addStretch(10);
            left.addComponent(sub, 0);
            return left;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected JComponent createLowerLeft() {
        try {
            this.m_map_widget = new Java2D_SimpleComposite(true);
            this.m_map_widget.setAxesVisible(true, true);
            this.m_map_widget.setScrollVisible(true, true);
            this.m_map_widget.mainWidget().addZoomer();
            return this.m_map_widget;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected void load_map_uec() {
        try {
            Java2D_Widget w1 = this.m_map_widget.mainWidget();
            w1.clearEventConsumerList();
            Java2D_Widget w2 = this.m_map_interp_widget.mainWidget();
            w2.clearEventConsumerList();
            if (this.m_uphole.List.size() >= 1) {
                if (this.m_combo_map_mouse_mode.getSelectedIndex() == 0) {
                    w1.addEventConsumer(this.m_leftClickUEC);
                    w1.addEventConsumer(this.m_mouseMoveUEC);
                    w2.addEventConsumer(this.m_leftClickUEC);
                    w2.addEventConsumer(this.m_mouseMoveUEC);
                } else {
                    w1.addEventConsumer(this.m_lineUEC);
                    w2.addEventConsumer(this.m_lineUEC);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void reload_map_plot() {
        try {
            Java2D_Widget w = this.m_map_widget.mainWidget();
            w.clearPaintableList();
            w.clearEventConsumerList();
            if (this.m_chk_shots.isSelected()) {
                w.addPaintable(this.createPT("Shot"), 0);
            }
            if (this.m_chk_recs.isSelected()) {
                w.addPaintable(this.createPT("Receiver"), 0);
            }
            w.addPaintable(this.m_uphole, 0);
            w.addPaintable(this.m_profile_line, 1000);
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
            this.load_map_uec();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected Java2D_Paintable_Table createPT(String tableName) {
        try {
            Java2D_Paintable_Table painter = new Java2D_Paintable_Table();
            String colID = tableName + "ID";
            painter.setDefaultWorldSize();
            painter.DrawErrorVectors = false;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (tableName == "Receiver") {
                painter.setTable(p.receiverTable());
                painter.Symbol = Java2D_PointSymbol.Plus;
            }
            if (tableName == "Shot") {
                painter.setTable(p.shotTable());
                painter.Symbol = Java2D_PointSymbol.HollowSquare;
            }
            painter.UseColorScale = false;
            painter.FixedColor = Color.LIGHT_GRAY;
            painter.DrawMoveVectors = false;
            painter.setAxisX("Easting");
            painter.setAxisY("Northing");
            return painter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeft() {
        try {
            JSplitPane split = new JSplitPane(0);
            split.setTopComponent(this.createUpperLeft());
            split.setBottomComponent(this.createLowerLeft());
            return split;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected void load_interp_map() {
        try {
            Java2D_Widget w = this.m_map_interp_widget.mainWidget();
            w.clearPaintableList();
            w.clearEventConsumerList();
            if (this.m_uphole.List.size() >= 1) {
                double depth = Tools_Widget.extractDouble(this.m_txt_map_interp_depth, 0.0, 0.0, 2000.0);
                double bin_size = Tools_Widget.extractDouble(this.m_txt_map_interp_bin_size, 100.0, 5.0, 1000.0);
                boolean use_time = this.m_cmb_map_interp_type.getSelectedIndex() == 0;
                Interpolator_EmptyGrid interp = new Interpolator_EmptyGrid(this.m_uphole, bin_size, use_time, depth);
                w.addPaintable(interp, 0);
                w.addPaintable(this.m_profile_line, 1000);
            }
            w.addPaintable(this.m_uphole, 2000);
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
            this.load_map_uec();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void load_profiles() {
        try {
            Java2D_Widget w2 = this.m_vint_widget.mainWidget();
            w2.clearPaintableList();
            w2.clearEventConsumerList();
            Java2D_Widget w1 = this.m_time_widget.mainWidget();
            w1.clearPaintableList();
            w1.clearEventConsumerList();
            if (this.m_uphole.SelectedLocation == null) {
                return;
            }
            w1.addPaintable(this.m_uphole, 4001);
            w2.addPaintable(this.m_uphole, 4000);
            w1.addPaintable(this.m_uphole.SelectedLocation, 1000);
            w2.addPaintable(this.m_uphole.SelectedLocation, 2000);
            Java2D_Paintable_AxisLines axis = new Java2D_Paintable_AxisLines();
            axis.DrawHorizontalLines = true;
            axis.DrawVerticalLines = true;
            w1.addPaintable(axis, 1000);
            w1.addPaintable(this.m_uphole.SelectedLocation, 1000);
            axis = new Java2D_Paintable_AxisLines();
            axis.DrawHorizontalLines = true;
            axis.DrawVerticalLines = true;
            w2.addPaintable(axis, 1000);
            w2.addPaintable(this.m_uphole.SelectedLocation, 2000);
            w1.transform().setTechnique(Java2D_Transform.Technique.Inverted);
            w2.transform().setTechnique(Java2D_Transform.Technique.Inverted);
            this.m_time_widget.setHorizontalTitle("Time");
            this.m_time_widget.setVerticalTitle("Depth");
            this.m_vint_widget.setHorizontalTitle("Interval velocity");
            this.m_vint_widget.setVerticalTitle("Depth");
            w1.mooz();
            w2.mooz();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected JComponent createProfileWidget() {
        try {
            LinearLayoutWidget left = LinearLayoutWidget.vert(0, null);
            LinearLayoutWidget top = LinearLayoutWidget.horz(0, null);
            this.m_profile_widget = new Java2D_VerticalStackWidget(2);
            top.addStretch(10);
            left.addComponent(top, 0);
            left.addComponent(this.m_profile_widget, 10);
            return left;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected JComponent createInterpMap() {
        try {
            LinearLayoutWidget left = LinearLayoutWidget.vert(0, null);
            this.m_map_interp_widget = new Java2D_SimpleComposite(false);
            this.m_map_interp_widget.setAxesVisible(true, true);
            this.m_map_interp_widget.setScrollVisible(true, true);
            this.m_map_interp_widget.mainWidget().addZoomer();
            LinearLayoutWidget top = LinearLayoutWidget.horz(0, null);
            this.m_cmb_map_interp_type.addItem("Time at selected depth");
            this.m_cmb_map_interp_type.addItem("Velocity at selected depth");
            top.addComponent(this.m_cmb_map_interp_type, 1);
            top.addComponent(new JLabel("    Depth:"), 0);
            top.addComponent(this.m_txt_map_interp_depth, 1);
            this.m_cmb_map_interp_type.addActionListener(this);
            this.m_txt_map_interp_depth.addActionListener(this);
            top.addComponent(new JLabel("    Grid size:"), 0);
            top.addComponent(this.m_txt_map_interp_bin_size, 1);
            this.m_txt_map_interp_bin_size.addActionListener(this);
            top.addComponent(this.m_btn_map_interp_reload_plot, 1);
            this.m_btn_map_interp_reload_plot.addActionListener(this);
            top.addStretch(10);
            left.addComponent(top, 0);
            left.addComponent(this.m_map_interp_widget, 10);
            return left;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected JComponent createRight() {
        try {
            JTabbedPane tabs = new JTabbedPane();
            JSplitPane splitter = new JSplitPane(1);
            this.m_vint_widget = new Java2D_SimpleComposite(false);
            this.m_vint_widget.setAxesVisible(true, true);
            this.m_vint_widget.setColorScaleVisible(false);
            this.m_vint_widget.setScrollVisible(true, true);
            this.m_vint_widget.mainWidget().addZoomer();
            this.m_time_widget = new Java2D_SimpleComposite(false);
            this.m_time_widget.setAxesVisible(true, true);
            this.m_time_widget.setColorScaleVisible(false);
            this.m_time_widget.setScrollVisible(true, true);
            this.m_time_widget.mainWidget().addZoomer();
            this.m_vint_widget.setMinimumSize(new Dimension(300, 300));
            this.m_time_widget.setMinimumSize(new Dimension(300, 300));
            splitter.setLeftComponent(this.m_time_widget);
            splitter.setRightComponent(this.m_vint_widget);
            tabs.add("Selected uphole location", splitter);
            tabs.add("Map view interpolation", this.createInterpMap());
            tabs.add("Vertical profiles", this.createProfileWidget());
            return tabs;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    @Override
    public void handlePopupMenuButton(PopupMenuButton button, String text) {
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    protected void handle_line_uec() {
        try {
            this.m_profile_widget.clear();
            if (this.m_profile_line.X1 < -9999.0) {
                return;
            }
            this.m_profile_line.DrawSymbols = false;
            this.m_profile_line.Valid = true;
            this.m_profile_line.PaintLevel = 0;
            this.m_profile_line.LineColor = Color.BLACK;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (this.m_uphole.List.size() < 1) {
                return;
            }
            Java2D_PaintableDatabaseProfile pr = new Java2D_PaintableDatabaseProfile("Elevation", this.m_profile_line.X1, this.m_profile_line.Y1, this.m_profile_line.X2, this.m_profile_line.Y2, 200);
            pr.prep_uphole_arrays(this.m_uphole);
            this.m_profile_widget.mainWidget(0).addPaintable(pr, 2000);
            this.m_profile_widget.mainWidget(1).addPaintable(pr, 2001);
            Java2D_Paintable_AxisLines axis = new Java2D_Paintable_AxisLines();
            axis.DrawHorizontalLines = true;
            axis.DrawVerticalLines = false;
            this.m_profile_widget.mainWidget(0).addPaintable(axis, 1000);
            this.m_profile_widget.mainWidget(1).addPaintable(axis, 1000);
            this.m_profile_widget.setTransform(Java2D_Transform.Technique.Normal);
            this.m_profile_widget.unzoom();
            this.m_map_widget.mainWidget().mooz();
            this.m_map_interp_widget.mainWidget().mooz();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_lineUEC) {
                if (this.m_lineUEC.Dragging) {
                    return;
                }
                if (this.m_uphole.List.size() >= 1) {
                    this.m_profile_line.X1 = this.m_lineUEC.StartWorldX;
                    this.m_profile_line.Y1 = this.m_lineUEC.StartWorldY;
                    this.m_profile_line.X2 = this.m_lineUEC.EndWorldX;
                    this.m_profile_line.Y2 = this.m_lineUEC.EndWorldY;
                    this.handle_line_uec();
                }
                return;
            }
            if (sender == this.m_mouseMoveUEC) {
                if (this.m_uphole.List.size() >= 1) {
                    this.m_uphole.interpolate_arrays(this.m_mouseMoveUEC.WorldX, this.m_mouseMoveUEC.WorldY);
                    this.m_vint_widget.mainWidget().mooz();
                    this.m_time_widget.mainWidget().mooz();
                }
                return;
            }
            if (sender == this.m_leftClickUEC) {
                this.m_uphole.select(this.m_leftClickUEC.WorldX, this.m_leftClickUEC.WorldY);
                this.m_map_interp_widget.mainWidget().mooz();
                this.m_map_widget.mainWidget().mooz();
                this.load_profiles();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btn_map_interp_reload_plot || e.getSource() == this.m_txt_map_interp_bin_size || e.getSource() == this.m_txt_map_interp_depth || e.getSource() == this.m_cmb_map_interp_type) {
                this.load_interp_map();
            }
            if (e.getSource() == this.m_combo_map_mouse_mode) {
                this.load_map_uec();
            }
            if (e.getSource() == this.m_txt_vert_scalar) {
                this.recompute_interp();
                this.handle_line_uec();
            }
            if (e.getSource() == this.m_btn_reload_plot || e.getSource() == this.m_chk_recs || e.getSource() == this.m_chk_shots) {
                this.reload_map_plot();
            }
            if (e.getSource() == this.m_btn_import_simple) {
                this.import_simple();
            }
            if (e.getSource() == this.m_btn_import_csv_xydt) {
                this.import_xydt();
            }
            if (e.getSource() == this.m_btn_import_csv_xyzdt) {
                this.import_xyzdt();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void import_xydt() {
        try {
            String file = Tools_Chooser.getFileName();
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            p.uphole_simple_get().read_xydt(file);
            this.interpolate_z_from_geometry();
            p.uphole_save_xyzdt();
            this.recompute_interp();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void import_xyzdt() {
        try {
            String file = Tools_Chooser.getFileName();
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            p.uphole_simple_get().read_xyzdt(file);
            p.uphole_save_xyzdt();
            this.recompute_interp();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void import_simple() {
        try {
            String file = Tools_Chooser.getFileName();
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            p.uphole_simple_get().read_simple(file);
            this.interpolate_z_from_geometry();
            p.uphole_save_xyzdt();
            this.recompute_interp();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void interpolate_z_from_geometry() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            UpholeSimple uphole = p.uphole_simple_get();
            for (UpholeSimple_Location loc : uphole.List) {
                double sum1 = 0.0;
                double sum2 = 1.0E-20;
                for (int iter = 0; iter <= 1; ++iter) {
                    Table_Abstract table = p.shotTable();
                    if (iter == 1) {
                        table = p.receiverTable();
                    }
                    int indexX = table.column_indexOfColumn("Easting");
                    int indexY = table.column_indexOfColumn("Northing");
                    int indexZ = table.column_indexOfColumn("Elevation");
                    int indexKilled = table.column_indexOfColumn("Killed");
                    for (int n = 0; n < table.row_count(); ++n) {
                        if (table.getBool(n, indexKilled)) continue;
                        double x = table.getDouble(n, indexX);
                        double y = table.getDouble(n, indexY);
                        double z = table.getDouble(n, indexZ);
                        double dx = x - loc.Easting;
                        double dy = y - loc.Northing;
                        double d2 = dx * dx + dy * dy;
                        double w = 1000000.0 / (1000000.0 + d2 * d2);
                        sum1 += z * w;
                        sum2 += w;
                    }
                }
                loc.Elevation = sum1 / sum2;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void recompute_interp() {
        try {
            String s = this.m_txt_vert_scalar.getText();
            double vert_scalar = Tools_Widget.extractDouble(this.m_txt_vert_scalar, 10.0, 3.0, 100.0);
            this.m_uphole.compute_vint();
            this.m_uphole.compute_vint_interp_arrays(150, vert_scalar);
            this.reload_map_plot();
            this.load_profiles();
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            ParameterTree tree = p.information().ParameterTree_get("simple_uphole");
            tree.double_put("vert_scalar", vert_scalar);
            p.saveInformation();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

