/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Uphole;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_CustomModel;
import com.PecosLibrary.Refraction.Uphole.UpholeImportData;
import com.PecosLibrary.Refraction.Uphole.UpholeModel;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class Page_ImportUphole_Coords
extends LinearLayoutWidget
implements ISimpleWizardPage,
ActionListener,
GenericObjectListener.Listener {
    protected UpholeImportData m_data;
    protected ComboStringListWrapper m_columnXCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_columnYCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_columnZCombo = new ComboStringListWrapper();
    protected JTable m_qcTable = new JTable();
    protected Table_CustomModel m_qcModel;

    public Page_ImportUphole_Coords(UpholeImportData data) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_data = data;
            GridLayoutWidget grid = this.createGridLayoutWidget(3, "Select coordinate columns", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Easting column"), this.m_columnXCombo);
            grid.addSimple(row++, new JLabel("Northing column"), this.m_columnYCombo);
            grid.addSimple(row++, new JLabel("Elevation column"), this.m_columnZCombo);
            this.reloadColumns();
            this.m_columnXCombo.addActionListener(this);
            this.m_columnYCombo.addActionListener(this);
            this.m_columnZCombo.addActionListener(this);
            LinearLayoutWidget qc = this.createVertical(3, "Column QC view", 0);
            this.m_qcTable.setGridColor(Color.BLACK);
            this.m_qcTable.setShowGrid(true);
            qc.addComponent(new JScrollPane(this.m_qcTable), 0);
            this.reloadTable();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadColumns() {
        try {
            this.m_columnXCombo.setStringArray(this.m_data.MasterColumnList);
            this.m_columnYCombo.setStringArray(this.m_data.MasterColumnList);
            this.m_columnZCombo.setStringArray(this.m_data.MasterColumnList);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadTable() {
        try {
            Table_Memory table = new Table_Memory();
            table.setName("QC");
            int indexX = table.column_append("Easting", DataType.Double);
            int indexY = table.column_append("Northing", DataType.Double);
            int indexZ = table.column_append("Elevation", DataType.Double);
            if (this.m_data.ImportFileName.length() < 1) {
                return;
            }
            if (this.m_columnXCombo.getSelectedString().length() < 1) {
                return;
            }
            if (this.m_columnYCombo.getSelectedString().length() < 1) {
                return;
            }
            if (this.m_columnZCombo.getSelectedString().length() < 1) {
                return;
            }
            Table_Abstract bigTable = UpholeModel.importSurvey_ScanColumns(this.m_data);
            int indexX_big = bigTable.column_indexOfColumn(this.m_columnXCombo.getSelectedString());
            int indexY_big = bigTable.column_indexOfColumn(this.m_columnYCombo.getSelectedString());
            int indexZ_big = bigTable.column_indexOfColumn(this.m_columnZCombo.getSelectedString());
            for (int n = 0; n < 5; ++n) {
                double value;
                if (n >= bigTable.row_count()) continue;
                table.row_increment();
                if (bigTable.canConvertToDouble(n, indexX_big)) {
                    value = bigTable.getDouble(n, indexX_big);
                    table.putDouble(n, indexX, value);
                }
                if (bigTable.canConvertToDouble(n, indexY_big)) {
                    value = bigTable.getDouble(n, indexY_big);
                    table.putDouble(n, indexY, value);
                }
                if (!bigTable.canConvertToDouble(n, indexZ_big)) continue;
                value = bigTable.getDouble(n, indexZ_big);
                table.putDouble(n, indexZ, value);
            }
            this.m_qcModel = new Table_CustomModel(table);
            this.m_qcTable.setModel(this.m_qcModel);
            Table_CustomModel.BoldCellRenderer renderer = this.m_qcModel.getBoldCellRenderer();
            for (int c = 0; c < this.m_qcTable.getColumnCount(); ++c) {
                this.m_qcTable.getColumnModel().getColumn(c).setHeaderRenderer(renderer);
            }
            this.m_qcTable.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void updateXYZColumns() {
        try {
            for (String column : this.m_data.MasterColumnList) {
                if (column.equalsIgnoreCase(this.m_columnXCombo.getSelectedString())) {
                    this.m_data.MasterColumnList.set(this.m_data.MasterColumnList.indexOf(column), "Easting");
                }
                if (column.equalsIgnoreCase(this.m_columnYCombo.getSelectedString())) {
                    this.m_data.MasterColumnList.set(this.m_data.MasterColumnList.indexOf(column), "Northing");
                }
                if (!column.equalsIgnoreCase(this.m_columnZCombo.getSelectedString())) continue;
                this.m_data.MasterColumnList.set(this.m_data.MasterColumnList.indexOf(column), "Elevation");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void leavingPage() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_columnXCombo || e.getSource() == this.m_columnYCombo || e.getSource() == this.m_columnZCombo) {
                this.reloadTable();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void activatePage() {
        this.reloadColumns();
        this.reloadTable();
    }

    @Override
    public void dialogJustOpened() {
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    @Override
    public boolean okayToGoToNextPage() {
        try {
            if (this.m_columnXCombo.getSelectedString().equalsIgnoreCase(this.m_columnYCombo.getSelectedString()) || this.m_columnXCombo.getSelectedString().equalsIgnoreCase(this.m_columnZCombo.getSelectedString()) || this.m_columnZCombo.getSelectedString().equalsIgnoreCase(this.m_columnYCombo.getSelectedString())) {
                JOptionPane.showMessageDialog(null, "Easting, Northing, and Elevation cannot be the same column", "Error: columns not unique", 0);
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }
}

