/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.ITraceTableScannerMonitor;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class TraceTable_SetConstDialog
extends JDialog
implements ActionListener,
ItemListener,
ITraceTableScannerMonitor,
GenericObjectListener.Listener {
    protected JButton m_btnOK = new JButton("Apply");
    protected JButton m_btnCancel = new JButton("Close");
    protected ComboStringListWrapper m_combo = new ComboStringListWrapper();
    protected JTextField m_txt = new JTextField("1");
    protected JLabel m_lbl = new JLabel(" ");
    protected JProgressBar m_progress = new JProgressBar();
    public boolean OK = false;

    public TraceTable_SetConstDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            GridLayoutWidget grid = middle.createGridLayoutWidget(3, null, 0);
            grid.addSimple(0, new JLabel("Select column"), this.m_combo);
            grid.addSimple(1, new JLabel("New value"), this.m_txt);
            this.m_combo.setPreferredSelected("TraceCode");
            this.m_combo.listener().addListener(this);
            middle.addComponent(this.m_lbl, 0);
            this.m_progress.setMaximum(1000);
            middle.addComponent(this.m_progress, 0);
            middle.addStretch(10);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            bottom.addStretch(10);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setSize(this.getSize().width + 50, this.getSize().height);
            this.setTitle("Set column to constant");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setPercentDone(double percent) {
        try {
            percent = Math.max(percent, 0.0);
            percent = Math.min(percent, 99.99);
            this.m_progress.setValue((int)(10.0 * percent));
            this.m_progress.paintImmediately(0, 0, 500, 30);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setMessage(String message) {
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    protected void loadColumns() {
        try {
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            ArrayList<String> cols = null;
            cols = table.columns();
            this.m_combo.setStringArray(cols);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            this.OK = false;
            this.loadColumns();
            this.m_progress.setValue(0);
            this.checkColName();
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean checkColName() {
        try {
            boolean fixed;
            String col = this.m_combo.getSelectedString();
            boolean bl = fixed = col.equalsIgnoreCase("ShotID") || col.equalsIgnoreCase("ReceiverID") || col.equalsIgnoreCase("Inline") || col.equalsIgnoreCase("Crossline") || col.equalsIgnoreCase("FileID") || col.equalsIgnoreCase("IndexInFile");
            if (fixed) {
                this.m_btnOK.setEnabled(false);
                this.m_lbl.setText("Cannot modify the selected column");
                this.m_lbl.setForeground(Color.red);
                return false;
            }
            this.m_lbl.setText("    ");
            this.m_btnOK.setEnabled(true);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.checkColName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void work() {
        try {
            if (!this.checkColName()) {
                return;
            }
            String col = this.m_combo.getSelectedString();
            int res = JOptionPane.showConfirmDialog(this, "Okay to overwrite contents of " + col + "?", "Confirm column modification", 2, 2, null);
            if (res != 0) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            int index = table.column_indexOfColumn(col);
            DataType type = table.column_type(index);
            if (type == DataType.Int || type == DataType.Short) {
                int v = Tools_Widget.extractInteger(this.m_txt, 0, -100000000, 100000000);
                for (long row = 0L; row < table.rowCount(); ++row) {
                    table.putInt(row, index, v);
                    if (row % 10000L != 0L) continue;
                    this.setPercentDone(100.0 * (double)row / (double)table.rowCount());
                }
            } else {
                float v = (float)Tools_Widget.extractDouble(this.m_txt, 0.0, -1.0E8, 1.0E8);
                for (long row = 0L; row < table.rowCount(); ++row) {
                    table.putFloat(row, index, v);
                    if (row % 10000L != 0L) continue;
                    this.setPercentDone(100.0 * (double)row / (double)table.rowCount());
                }
            }
            table.saveCurrentSection();
            this.setCursor(Cursor.getDefaultCursor());
            this.m_progress.setValue(0);
            this.OK = true;
            this.dispose();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                this.work();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            this.setCursor(Cursor.getDefaultCursor());
            ExceptionMonitor.add(error);
        }
    }
}

