/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Tomography;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.History;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Action.Tomography.Action_Eikonal3D_ExportSegy;
import com.PecosLibrary.Action.Tomography.Action_Eikonal3D_NewThreadModel_Disk;
import com.PecosLibrary.Action.Tomography.Action_Eikonal_DiskBased;
import com.PecosLibrary.Data.TraceTable.TraceTable_Scanner_TomoSynth;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Math.InversePowerInterpolator;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3D;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3DProfile;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3D_Polygon;
import com.PecosLibrary.Refraction.Tomography.TomoEikonal3D_XtGeoConnection;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_VerticalStackWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_LineSegment;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Line;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MouseoverInfo;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MultiLineSegments;
import com.PecosLibrary.Windows.Refraction.Tomography.TomoLayerNewModelDialog;
import com.PecosLibrary.Windows.Shared.FileWidget;
import com.PecosLibrary.Windows.Shared.MultiTextDialog;
import com.PecosLibrary.Windows.Shared.PopupMenuButton;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TomoEikonal3DWidget
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener,
ItemListener,
Messenger.Listener,
PopupMenuButton.Listener,
ISaveableFrame,
ChangeListener {
    protected SelectedProfileInfo m_selectedProfileInfo;
    protected MapWidget m_smallMapWidget = new MapWidget(true, false);
    protected MapWidget m_bigMapWidget = new MapWidget(false, true);
    protected Java2D_VerticalStackWidget m_profileDisplayWidget;
    protected Java2D_UserEventConsumer_Line m_profileLineUEC = new Java2D_UserEventConsumer_Line();
    protected Java2D_UserEventConsumer_ButtonPressed m_leftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
    protected Java2D_UserEventConsumer_MultiLineSegments m_polygonUEH = new Java2D_UserEventConsumer_MultiLineSegments();
    protected JButton m_btnClearPolygon;
    protected JButton m_btnCutInside;
    protected JButton m_btnSaveModel;
    protected JButton m_btnCreateNew;
    protected JButton m_btnReload;
    protected ComboStringListWrapper m_modelCombo = new ComboStringListWrapper();
    protected boolean m_ignoreModelCombo = true;
    protected JLabel m_lblSizeX = new JLabel("", 4);
    protected JLabel m_lblSizeZ = new JLabel("", 4);
    protected JLabel m_lblNumInline = new JLabel("", 4);
    protected JLabel m_lblNumCrossline = new JLabel("", 4);
    protected JLabel m_lblNumZ = new JLabel("", 4);
    protected JLabel m_lblMemory = new JLabel("", 4);
    protected RadioPanel m_radWhichLowerPlot;
    protected JLabel m_lblProfileStartX = new JLabel("", 4);
    protected JLabel m_lblProfileStartY = new JLabel("", 4);
    protected JLabel m_lblProfileEndX = new JLabel("", 4);
    protected JLabel m_lblProfileEndY = new JLabel("", 4);
    protected JButton m_btnSetProfile = new JButton("Set profile manually");
    protected JTextField m_txtMinOffset = new JTextField("200");
    protected JTextField m_txtMaxOffset = new JTextField("6000");
    protected JTextField m_txtNumIter = new JTextField("10");
    protected JTextField m_txtOffsetCorner = new JTextField("75");
    protected JTextField m_txtSmoothRadius = new JTextField("2");
    protected JTextField m_txtNumThreads = new JTextField("2");
    protected JButton m_btnUpdateThreads;
    protected JButton m_btnUpdateThreadsNC;
    protected ComboStringListWrapper m_pickVersionCombo;
    protected JTextField m_txtPickShift = new JTextField("0");
    protected JTextField m_txtAzimuthCenter = new JTextField("45");
    protected JTextField m_txtAzimuthRadius = new JTextField("45");
    protected JCheckBox m_chkApplyAzimuth = new JCheckBox("Apply azimuth restrictions");
    protected JTextField m_txtHybridVel = new JTextField("5000");
    protected JTextField m_txtHybridTimeShift = new JTextField("200");
    protected JCheckBox m_chkHybridCompute = new JCheckBox("Compute hybrid time errors");
    protected JTextField m_txtDecimation = new JTextField("1");
    protected JCheckBox m_chkDecimatePick = new JCheckBox("Decimate picks ");
    protected JCheckBox m_chkApplyUphole = new JCheckBox("Lock shallow velocity using uphole survey");
    protected ComboStringListWrapper m_comboUpholeTable = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboUpholeX = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboUpholeY = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboUpholeZ = new ComboStringListWrapper();
    protected ComboStringListWrapper m_comboUpholeV = new ComboStringListWrapper();
    protected JButton m_btnComboReloadTables = new JButton("Reload list of tables");
    protected DefaultListModel<String> m_historyListModel = new DefaultListModel();
    protected JList<String> m_historyList = new JList();
    protected JButton m_btnReloadHistory;
    protected JTextField m_txtWeatheringVelocityDepth = new JTextField("100");
    protected JButton m_btnSetWeatheringVelocity;
    protected JCheckBox m_chkComputeRefractorElevation = new JCheckBox("Use the new weathering velocity to update the first refractor elevation");
    protected JButton m_btnSmoothModel = new JButton("Create smoothed model");
    protected JTextField m_txtSmoothHorz = new JTextField("3");
    protected JTextField m_txtSmoothVert = new JTextField("0");
    protected JTextField m_txtSmoothNewModelName = new JTextField("");
    protected JButton m_btnResample = new JButton("Create resampled model");
    protected JTextField m_txtResampleMaxDepth = new JTextField("400");
    protected JTextField m_txtResampleHorzSpacing = new JTextField("50");
    protected JTextField m_txtResampleVertSpacing = new JTextField("30");
    protected JTextField m_txtResampleNewModelName = new JTextField("");
    protected JButton m_btnStaticsReloadColumns;
    protected JButton m_btnStatics;
    protected ButtonGroup m_intGroup = new ButtonGroup();
    protected JRadioButton m_radIntElev = new JRadioButton("Fixed elevation");
    protected JRadioButton m_radIntDepth = new JRadioButton("Fixed depth");
    protected JRadioButton m_radIntVel = new JRadioButton("Fixed velocity");
    protected JRadioButton m_radIntCol = new JRadioButton("Database column");
    protected ComboStringListWrapper m_comboIntCol = new ComboStringListWrapper();
    protected JLabel m_lblStaticsResult = new JLabel(" ");
    protected JTextField m_txtStaticsName = new JTextField("Tomo3D");
    protected JTextField m_txtIntDatumDepth = new JTextField("400");
    protected JTextField m_txtIntDatumVelocity = new JTextField("5000");
    protected JTextField m_txtIntDatumElev = new JTextField("-200");
    protected JCheckBox m_chkApplyResidual = new JCheckBox("Apply residual correction");
    protected JTextField m_txtResidCorrMult = new JTextField("1");
    protected ButtonGroup m_finalGroup = new ButtonGroup();
    protected JRadioButton m_radFinalElev = new JRadioButton("Fixed elevation");
    protected JRadioButton m_radFinalCol = new JRadioButton("Database column");
    protected ComboStringListWrapper m_comboFinalCol = new ComboStringListWrapper();
    protected JTextField m_txtFinalDatumElev = new JTextField("2000");
    protected JTextField m_txtRepVel = new JTextField("10000");
    protected ButtonGroup m_shiftGroup = new ButtonGroup();
    protected JRadioButton m_radShiftNone = new JRadioButton("Do not modify the statics");
    protected JRadioButton m_radShiftZero = new JRadioButton("Convert the statics to zero mean");
    protected JRadioButton m_radShiftTie = new JRadioButton("Tie the statics to another column");
    protected ComboStringListWrapper m_comboShiftCol = new ComboStringListWrapper();
    protected JTabbedPane m_topTabs;
    protected JButton m_btnExportMPI;
    protected JTextField m_txtMPIPath = new JTextField("/Users/matt/Data/MPI");
    protected JLabel m_lblMaxElev = new JLabel("");
    protected JLabel m_lblMinElev = new JLabel("");
    protected JButton m_btnRefreshInfo = new JButton("Reload model info");
    protected JTextField m_txtMod_MaxElev = new JTextField("");
    protected JTextField m_txtMod_MaxVel = new JTextField("");
    protected JTextField m_txtMod_MinElev = new JTextField("");
    protected JTextField m_txtMod_MinVel = new JTextField("");
    protected JButton m_btnSetVel = new JButton("Set velocity");
    protected JCheckBox m_chkInsidePolygon = new JCheckBox("Only inside polygon");
    protected JButton m_btnSmooth;
    protected JButton m_btnCreateSynth;
    protected JProgressBar m_progress = new JProgressBar();
    protected JTextField m_txtSegyDatumTop = new JTextField("2000");
    protected JTextField m_txtSegySampleSize = new JTextField("50");
    protected JTextField m_txtSegyDatumBottom = new JTextField("0");
    protected JButton m_btnSegyExport;
    protected JButton m_btnSegyExportCount;
    protected JButton m_btnSegyExport_Grid;
    protected JButton m_btnSegyExportCount_Grid;
    protected FileWidget m_segyFileWidget;
    protected TomoLayerNewModelDialog m_newDlg;
    protected String m_staticsColName;
    TomoEikonal3DProfile m_profile;
    protected Java2D_Polygon m_polygon = null;

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Refraction.Tomography.TomoEikonal3DWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "Tomo3D";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "Tomo3D";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public TomoEikonal3DWidget() {
        super(1);
        try {
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRight());
            Messenger.singleton().addListener(this);
            this.reloadModelCombo();
            this.loadModel();
            this.reloadUEH();
            this.reloadListOfTable();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected ComboStringListWrapper createPickCombo() {
        try {
            ComboStringListWrapper combo = new ComboStringListWrapper("FBP_User");
            ITraceTable traceTable = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            ArrayList<String> pickCols = traceTable.columns("FBP_");
            combo.setStringArray(pickCols);
            combo.listener().addListener(this);
            return combo;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRight() {
        try {
            this.m_topTabs = new JTabbedPane();
            this.m_topTabs.addTab("Map view", this.m_bigMapWidget);
            this.m_bigMapWidget.CompositeWidget.mainWidget().addEventConsumer(this.m_polygonUEH);
            this.m_polygonUEH.addListener(this);
            this.m_polygonUEH.DefiningPolygon = true;
            this.m_btnClearPolygon = this.m_bigMapWidget.Bottom.createButton("Clear polygon", this, 0);
            this.m_btnCutInside = this.m_bigMapWidget.Bottom.createButton("Interpolate inside polygon", this, 0);
            this.m_btnSaveModel = this.m_bigMapWidget.Bottom.createButton("Save model", this, 0);
            this.m_profileDisplayWidget = new Java2D_VerticalStackWidget(2);
            this.m_topTabs.addTab("Profile", this.m_profileDisplayWidget);
            this.m_topTabs.addChangeListener(this);
            return this.m_topTabs;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeft() {
        try {
            JTabbedPane topTabs = new JTabbedPane();
            topTabs.addTab("Model", this.createModelTab());
            topTabs.addTab("Update", this.createUpdateTab());
            topTabs.addTab("Mod", this.createModTab());
            topTabs.addTab("Statics", this.createStaticsTab());
            topTabs.addTab("Extra", this.createExtraTab());
            topTabs.addTab("History", this.createHistoryTab());
            if (SharedApplicationData.allowTestCode()) {
                topTabs.addTab("Synthetics", this.createSynthTab());
            }
            return topTabs;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            this.reloadUEH();
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected void smoothVel() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            TomoEikonal3D model = p.getEikonal3D();
            model.smooth_external(1, 1);
            model.save(model.name());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setSynthVel() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Java2D_Polygon poly = null;
            TomoEikonal3D model = p.getEikonal3D();
            double min = model.originZ();
            double max = min + model.binSizeVert() * (double)(model.numZ() - 1);
            double z1 = Tools_Widget.extractDouble(this.m_txtMod_MinElev, min - 1.0, min - 1.0, max - 1.0);
            double v1 = Tools_Widget.extractDouble(this.m_txtMod_MinVel, 3000.0, 500.0, 20000.0);
            double z2 = Tools_Widget.extractDouble(this.m_txtMod_MaxElev, z1 + 200.0, z1 + 10.0, max + 1.0);
            double v2 = Tools_Widget.extractDouble(this.m_txtMod_MaxVel, 3000.0, 500.0, 20000.0);
            if (this.m_chkInsidePolygon.isSelected()) {
                poly = p.polygon();
            }
            model.setLayerVel(z1, v1, z2, v2, poly);
            model.save(model.name());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void refreshModelInfo() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            TomoEikonal3D model = p.getEikonal3D();
            double min = model.originZ();
            double max = min + model.binSizeVert() * (double)(model.numZ() - 1);
            this.m_lblMaxElev.setText(Double.toString(max));
            this.m_lblMinElev.setText(Double.toString(min));
            this.m_txtMod_MaxElev.setText(Double.toString(max + 1.0));
            this.m_txtMod_MinElev.setText(Double.toString(min - 1.0));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void createSynth() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            TomoEikonal3D model = p.getEikonal3D();
            TraceTable_Scanner_TomoSynth scanner = new TraceTable_Scanner_TomoSynth();
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            scanner.scan(table, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createSynthTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            GridLayoutWidget grid = main.createGridLayoutWidget(5, "Model info", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Maximum elevation"), this.m_lblMaxElev);
            grid.addSimple(row++, new JLabel("Minimum elevation"), this.m_lblMinElev);
            grid.addSimple(row++, new JLabel(" "), this.m_btnRefreshInfo);
            this.m_btnRefreshInfo.addActionListener(this);
            grid = main.createGridLayoutWidget(0, "Model mod", 0);
            row = 0;
            grid.addSimple(row++, new JLabel("Top elevation"), this.m_txtMod_MaxElev);
            grid.addSimple(row++, new JLabel("Top velocity"), this.m_txtMod_MaxVel);
            grid.addSimple(row++, new JLabel("Bottom elevation"), this.m_txtMod_MinElev);
            grid.addSimple(row++, new JLabel("Bottom velocity"), this.m_txtMod_MinVel);
            grid.addSimple(row++, new JLabel(" "), this.m_chkInsidePolygon);
            grid.addSimple(row++, new JLabel(" "), this.m_btnSetVel);
            this.m_btnSetVel.addActionListener(this);
            this.m_btnSmooth = main.createButton("Smooth current velocity field", this, 0);
            this.m_btnCreateSynth = main.createButton("Create synthetics", this, 0);
            main.addComponent(this.m_progress, 0);
            main.addStretch(5);
            main.addHorzPair(new JLabel("MPI export path"), 0, this.m_txtMPIPath, 9);
            this.m_btnExportMPI = main.createButton("Export data for MPI test", this, 0);
            main.addStretch(10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createModTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Modify node spacing", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Horizontal node size"), this.m_txtResampleHorzSpacing);
            grid.addSimple(row++, new JLabel("Vertical node size"), this.m_txtResampleVertSpacing);
            grid.addSimple(row++, new JLabel("Maximum depth"), this.m_txtResampleMaxDepth);
            grid.addSimple(row++, new JLabel("New model name"), this.m_txtResampleNewModelName);
            grid.addSimple(row++, new JLabel(" "), this.m_btnResample);
            this.m_btnResample.addActionListener(this);
            grid = main.createGridLayoutWidget(0, "Model smoothing", 0);
            row = 0;
            grid.addSimple(row++, new JLabel("Horizontal smoothing (nodes)"), this.m_txtSmoothHorz);
            grid.addSimple(row++, new JLabel("Vertical smoothing (nodes)"), this.m_txtSmoothVert);
            grid.addSimple(row++, new JLabel("New model name"), this.m_txtSmoothNewModelName);
            grid.addSimple(row++, new JLabel(" "), this.m_btnSmoothModel);
            this.m_btnSmoothModel.addActionListener(this);
            main.addStretch(10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createHistoryTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            this.m_btnReloadHistory = main.createButton("Reload history", this, 0);
            main.addComponent(new JScrollPane(this.m_historyList), 10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadHistory() {
        try {
            this.m_historyListModel.clear();
            TomoEikonal3D tomo = RefractionStaticsProject.singleton().getEikonal3D();
            if (tomo != null) {
                History h = tomo.getHistory();
                h.fillDefaultListModel(this.m_historyListModel);
            }
            this.m_historyList.setModel(this.m_historyListModel);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createStaticsTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            this.m_btnStaticsReloadColumns = main.createButton("Reload list of database columns", this, 0);
            this.m_intGroup.add(this.m_radIntElev);
            this.m_intGroup.add(this.m_radIntDepth);
            this.m_intGroup.add(this.m_radIntVel);
            this.m_intGroup.add(this.m_radIntCol);
            this.m_radIntElev.setSelected(true);
            this.m_radIntElev.addActionListener(this);
            this.m_radIntDepth.addActionListener(this);
            this.m_radIntVel.addActionListener(this);
            this.m_radIntCol.addActionListener(this);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Intermediate datum options", 0);
            int row = 0;
            grid.addSimple(row++, this.m_radIntElev, this.m_txtIntDatumElev);
            grid.addSimple(row++, this.m_radIntDepth, this.m_txtIntDatumDepth);
            grid.addSimple(row++, this.m_radIntVel, this.m_txtIntDatumVelocity);
            grid.addSimple(row++, this.m_radIntCol, this.m_comboIntCol);
            this.m_txtIntDatumElev.setEnabled(this.m_radIntElev.isSelected());
            this.m_txtIntDatumDepth.setEnabled(this.m_radIntDepth.isSelected());
            this.m_txtIntDatumVelocity.setEnabled(this.m_radIntVel.isSelected());
            this.m_comboIntCol.setEnabled(this.m_radIntCol.isSelected());
            this.m_finalGroup.add(this.m_radFinalElev);
            this.m_finalGroup.add(this.m_radFinalCol);
            this.m_radFinalElev.setSelected(true);
            this.m_radFinalElev.addActionListener(this);
            this.m_radFinalCol.addActionListener(this);
            this.m_txtFinalDatumElev.setEnabled(this.m_radFinalElev.isSelected());
            this.m_comboFinalCol.setEnabled(this.m_radFinalCol.isSelected());
            grid = main.createGridLayoutWidget(0, "Final datum options", 0);
            row = 0;
            grid.addSimple(row++, this.m_radFinalElev, this.m_txtFinalDatumElev);
            grid.addSimple(row++, this.m_radFinalCol, this.m_comboFinalCol);
            grid.addSimple(row++, new JLabel("Replacement velocity"), this.m_txtRepVel);
            String s = "<HTML><font color=\"blue\">Residual terms are computed during batch update </font></HTML>";
            LinearLayoutWidget res = main.createVertical(0, "Residual correction options", 0);
            res.addComponent(new JLabel(s, 0), 0);
            res.addComponent(this.m_chkApplyResidual, 0);
            this.m_chkApplyResidual.setSelected(true);
            res.addHorzPair(new JLabel("Residual multiplier"), 0, this.m_txtResidCorrMult, 10);
            s = "<HTML><font color=\"blue\">Stack picks are made in the tomo stacks display</font></HTML>";
            this.m_shiftGroup.add(this.m_radShiftNone);
            this.m_shiftGroup.add(this.m_radShiftZero);
            this.m_shiftGroup.add(this.m_radShiftTie);
            this.m_radShiftNone.setSelected(true);
            this.m_radShiftNone.addActionListener(this);
            this.m_radShiftZero.addActionListener(this);
            this.m_radShiftTie.addActionListener(this);
            LinearLayoutWidget shift = main.createVertical(0, "Bulk shift options", 0);
            shift.addComponent(this.m_radShiftNone, 0);
            shift.addComponent(this.m_radShiftZero, 0);
            shift.addComponent(this.m_radShiftTie, 0);
            shift.addComponent(this.m_comboShiftCol, 0);
            this.m_comboShiftCol.setEnabled(this.m_radShiftTie.isSelected());
            main.addHorzPair(new JLabel("Statics name"), 0, this.m_txtStaticsName, 10);
            this.m_btnStatics = main.createButton("Compute statics", this, 0);
            main.addComponent(this.m_lblStaticsResult, 0);
            main.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            ArrayList<String> cols = Tools_RefractionStaticsProject.getColumnList_Intersection();
            this.m_comboIntCol.setStringArray(cols);
            this.m_comboFinalCol.setStringArray(cols);
            this.m_comboShiftCol.setStringArray(cols);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createUpdateTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            this.m_pickVersionCombo = this.createPickCombo();
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Batch update options", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Minimum offset"), this.m_txtMinOffset);
            grid.addSimple(row++, new JLabel("Maximum offset"), this.m_txtMaxOffset);
            grid.addSimple(row++, new JLabel("Number of iterations"), this.m_txtNumIter);
            grid.addSimple(row++, new JLabel("Offset weight corner"), this.m_txtOffsetCorner);
            grid.addSimple(row++, new JLabel("Smooth radius (nodes)"), this.m_txtSmoothRadius);
            grid.addSimple(row++, new JLabel("Pick version"), this.m_pickVersionCombo);
            grid.addSimple(row++, new JLabel("Pick shift (ms)"), this.m_txtPickShift);
            grid.addSimple(row++, new JLabel("Number of threads"), this.m_txtNumThreads);
            JTabbedPane tabs = new JTabbedPane();
            LinearLayoutWidget sub = LinearLayoutWidget.vert(0, null);
            grid = sub.createGridLayoutWidget(0, null, 0);
            row = 0;
            grid.addSimple(row++, new JLabel(" "), this.m_chkApplyAzimuth);
            grid.addSimple(row++, new JLabel("Center azimuth"), this.m_txtAzimuthCenter);
            grid.addSimple(row++, new JLabel("Azimuth radius"), this.m_txtAzimuthRadius);
            sub.addStretch(10);
            tabs.addTab("Azimuth", sub);
            String s = "<html>The hybrid picks time will be stored in FBP_Back3.<br><html>FBP_Back3 = Error + (Time shift) + Offset / Velocity<br><html>You must run the multithreaded update routine</html>";
            sub = LinearLayoutWidget.vert(0, null);
            grid = sub.createGridLayoutWidget(0, null, 0);
            row = 0;
            grid.addComponent(new JLabel(s), row++, 0, 1.0, 1.0, 1, 2);
            grid.addSimple(row++, new JLabel(" "), this.m_chkHybridCompute);
            grid.addSimple(row++, new JLabel("LMO velocity"), this.m_txtHybridVel);
            grid.addSimple(row++, new JLabel("Time shift"), this.m_txtHybridTimeShift);
            sub.addStretch(10);
            tabs.addTab("Hybrid", sub);
            sub = LinearLayoutWidget.vert(0, null);
            grid = sub.createGridLayoutWidget(0, null, 0);
            row = 0;
            grid.addSimple(row++, new JLabel(" "), this.m_chkDecimatePick);
            grid.addSimple(row++, new JLabel("Decimation ( >= 1 ) "), this.m_txtDecimation);
            sub.addStretch(10);
            tabs.addTab("Decimation", sub);
            sub = LinearLayoutWidget.vert(0, null);
            grid = sub.createGridLayoutWidget(0, null, 0);
            row = 0;
            grid.addSimple(row++, new JLabel(" "), this.m_chkApplyUphole);
            grid.addSimple(row++, new JLabel("Database table"), this.m_comboUpholeTable);
            grid.addSimple(row++, new JLabel(" "), this.m_btnComboReloadTables);
            grid.addSimple(row++, new JLabel("Easting"), this.m_comboUpholeX);
            grid.addSimple(row++, new JLabel("Northing"), this.m_comboUpholeY);
            grid.addSimple(row++, new JLabel("Elevation"), this.m_comboUpholeZ);
            grid.addSimple(row++, new JLabel("Velocity"), this.m_comboUpholeV);
            this.m_btnComboReloadTables.addActionListener(this);
            this.m_comboUpholeTable.listener().addListener(this);
            sub.addStretch(10);
            tabs.addTab("Uphole survey", sub);
            main.addComponent(tabs, 0);
            main.createGapLabel(12);
            this.m_btnUpdateThreads = main.createButton("Start batch update - multiple threads", this, 0);
            main.createGapLabel(12);
            main.addComponent(new JLabel("This routine can handle much  larger surveys..."), 0);
            this.m_btnUpdateThreadsNC = main.createButton("Start batch update", this, 0);
            main.createGapLabel(12);
            int np = Runtime.getRuntime().availableProcessors();
            if (np <= 2) {
                this.m_btnUpdateThreads.setEnabled(false);
                this.m_txtNumThreads.setEnabled(false);
                JLabel lbl = new JLabel("Must have more than two cores to run multithreaded");
                lbl.setForeground(Color.red);
                grid.addComponent(lbl, row++, 0, 1.0, 1.0, 1, 2);
            }
            main.addStretch(10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createExtraTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(3, null);
            LinearLayoutWidget sub = main.createVertical(0, "Weathering velocity for delay time model", 0);
            JLabel lbl = new JLabel("You must assign branches first!", 0);
            lbl.setForeground(Color.red);
            sub.addComponent(lbl, 0);
            sub.addHorzPair(new JLabel("Depth at which to compute weathering velocity"), 0, this.m_txtWeatheringVelocityDepth, 10);
            sub.addComponent(this.m_chkComputeRefractorElevation, 0);
            this.m_chkComputeRefractorElevation.setSelected(true);
            this.m_btnSetWeatheringVelocity = sub.createButton("Set weathering velocity", this, 0);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "SEG-Y model export options", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Top datum (ft/m)"), this.m_txtSegyDatumTop);
            grid.addSimple(row++, new JLabel("Bottom datum (ft/m)"), this.m_txtSegyDatumBottom);
            grid.addSimple(row++, new JLabel("Sample size (ft/m)"), this.m_txtSegySampleSize);
            this.m_segyFileWidget = new FileWidget(false, 0, "Select output SEG-Y file", null);
            main.addComponent(this.m_segyFileWidget, 0);
            LinearLayoutWidget sub1 = main.createVertical(0, "These export options use the tomography grid", 0);
            this.m_btnSegyExport = sub1.createButton("Export velocity field to SEG-Y", this, 0);
            this.m_btnSegyExportCount = sub1.createButton("Export node counts to SEG-Y", this, 0);
            sub1 = main.createVertical(0, "These export options use the project grid", 0);
            this.m_btnSegyExport_Grid = sub1.createButton("Export velocity field to SEG-Y", this, 0);
            this.m_btnSegyExportCount_Grid = sub1.createButton("Export node counts to SEG-Y", this, 0);
            Tools_FontChanger.changeSizeOfFont(main, -2, null, true);
            main.addStretch(10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createModelTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            LinearLayoutWidget sub = main.createHorizontal(0, "Select model", 0);
            sub.addComponent(this.m_modelCombo, 10);
            this.m_modelCombo.listener().addListener(this);
            this.m_btnReload = sub.createButton("Reload list", this, 0);
            this.m_btnCreateNew = sub.createButton("New model", this, 0);
            GridLayoutWidget grid = main.createGridLayoutWidget(0, "Model description", 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Horizontal node spacing"), this.m_lblSizeX);
            grid.addSimple(row++, new JLabel("Vertical node spacing"), this.m_lblSizeZ);
            grid.addSimple(row++, new JLabel("Inline node count"), this.m_lblNumInline);
            grid.addSimple(row++, new JLabel("Crossline node count"), this.m_lblNumCrossline);
            grid.addSimple(row++, new JLabel("Vertical node count"), this.m_lblNumZ);
            grid.addSimple(row++, new JLabel("Total model memory (MB)"), this.m_lblMemory);
            this.m_radWhichLowerPlot = new RadioPanel(LinearLayoutWidget.Direction.Horizontal, "Select lower profile plot", "Display statistical weight", "Display approximate node hit count");
            main.addComponent(this.m_radWhichLowerPlot, 0);
            this.m_radWhichLowerPlot.setSelectedIndex(1);
            JLabel lbl = new JLabel("Left-click and drag to display profiles", 0);
            lbl.setForeground(Color.blue);
            lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            main.addComponent(lbl, 0);
            GridLayoutWidget profileGrid = main.createGridLayoutWidget(0, "Profile info", 0);
            int profileRow = 0;
            profileGrid.addSimple(profileRow++, new JLabel("Start: "), this.m_lblProfileStartX, this.m_lblProfileStartY);
            profileGrid.addSimple(profileRow++, new JLabel("End: "), this.m_lblProfileEndX, this.m_lblProfileEndY);
            this.m_btnSetProfile.addActionListener(this);
            profileGrid.addComponent(this.m_btnSetProfile, profileRow++, 0);
            main.addComponent(this.m_smallMapWidget, 11);
            this.m_profileLineUEC.addListener(this);
            this.m_leftClickUEC.addListener(this);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadUEH() {
        try {
            this.m_smallMapWidget.CompositeWidget.mainWidget().clearEventConsumerList();
            this.m_smallMapWidget.CompositeWidget.mainWidget().addZoomer();
            if (this.m_topTabs != null) {
                if (this.m_topTabs.getSelectedIndex() == 1) {
                    this.m_smallMapWidget.CompositeWidget.mainWidget().addEventConsumer(this.m_profileLineUEC);
                }
                if (this.m_topTabs.getSelectedIndex() == 2) {
                    this.m_smallMapWidget.CompositeWidget.mainWidget().addEventConsumer(this.m_leftClickUEC);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadListOfTable() {
        try {
            IDatabaseConnection database = RefractionStaticsProject.singleton().importDatabase();
            ArrayList<String> tables = database.getTableNames();
            this.m_comboUpholeTable.setStringArray(tables);
            this.reloadListOfColumns();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadListOfColumns() {
        try {
            IDatabaseConnection database = RefractionStaticsProject.singleton().importDatabase();
            ArrayList<String> tables = database.getTableNames();
            if (tables.size() < 1) {
                this.m_comboUpholeX.setStringArray(new ArrayList<String>());
                this.m_comboUpholeY.setStringArray(new ArrayList<String>());
                this.m_comboUpholeZ.setStringArray(new ArrayList<String>());
                this.m_comboUpholeV.setStringArray(new ArrayList<String>());
                return;
            }
            String tableName = this.m_comboUpholeTable.getSelectedString();
            ArrayList<String> cols = database.listOfColumnNames(tableName);
            this.m_comboUpholeX.setStringArray(cols);
            this.m_comboUpholeY.setStringArray(cols);
            this.m_comboUpholeZ.setStringArray(cols);
            this.m_comboUpholeV.setStringArray(cols);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadModelCombo() {
        try {
            this.m_ignoreModelCombo = true;
            String tomoPath = RefractionStaticsProject.singleton().eikonal3DProjectsPath();
            ArrayList<String> subdirs = Tools_FileSystem.subdirectories(tomoPath, false);
            ArrayList<String> models = new ArrayList<String>();
            for (String s : subdirs) {
                if (s.equalsIgnoreCase("ShotRecStacks")) continue;
                models.add(s);
            }
            this.m_modelCombo.setStringArray(models);
            this.m_ignoreModelCombo = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void handleNewModel() {
        try {
            this.m_profile = null;
            TomoEikonal3D model = RefractionStaticsProject.singleton().getEikonal3D();
            this.m_smallMapWidget.handleNewModel();
            this.m_bigMapWidget.handleNewModel();
            this.reloadHistory();
            if (model == null) {
                this.m_lblSizeX.setText("");
                this.m_lblSizeZ.setText("");
                this.m_lblNumInline.setText("");
                this.m_lblNumCrossline.setText("");
                this.m_lblNumZ.setText("");
                this.m_lblMemory.setText("");
                return;
            }
            if (this.m_selectedProfileInfo == null) {
                this.m_lblProfileStartX.setText("");
                this.m_lblProfileStartY.setText("");
                this.m_lblProfileEndX.setText("");
                this.m_lblProfileEndY.setText("");
            }
            this.m_lblSizeX.setText(Double.toString(model.binSizeHorz()));
            this.m_lblSizeZ.setText(Double.toString(model.binSizeVert()));
            this.m_lblNumInline.setText(Integer.toString(model.numX()));
            this.m_lblNumCrossline.setText(Integer.toString(model.numY()));
            this.m_lblNumZ.setText(Integer.toString(model.numZ()));
            double numNodes = (double)model.numX() * (double)model.numY() * (double)model.numZ();
            double mem = 8.0 * numNodes;
            int mb = 1 + (int)(mem *= 1.0E-6);
            this.m_lblMemory.setText(Integer.toString(mb));
            this.m_smallMapWidget.reloadPlot();
            this.m_bigMapWidget.reloadPlot();
            if (this.m_selectedProfileInfo != null) {
                if (this.m_selectedProfileInfo.StartWorldX != 0.0 && this.m_selectedProfileInfo.StartWorldY != 0.0 && this.m_selectedProfileInfo.EndWorldX != 0.0 && this.m_selectedProfileInfo.EndWorldY != 0.0) {
                    this.m_profileLineUEC.StartPixelX = this.m_selectedProfileInfo.StartPixelX;
                    this.m_profileLineUEC.StartPixelY = this.m_selectedProfileInfo.StartPixelY;
                    this.m_profileLineUEC.EndPixelX = this.m_selectedProfileInfo.EndPixelX;
                    this.m_profileLineUEC.EndPixelY = this.m_selectedProfileInfo.EndPixelY;
                    this.m_profileLineUEC.StartWorldX = this.m_selectedProfileInfo.StartWorldX;
                    this.m_profileLineUEC.StartWorldY = this.m_selectedProfileInfo.StartWorldY;
                    this.m_profileLineUEC.EndWorldX = this.m_selectedProfileInfo.EndWorldX;
                    this.m_profileLineUEC.EndWorldY = this.m_selectedProfileInfo.EndWorldY;
                    this.m_lblProfileStartX.setText(Integer.toString((int)this.m_profileLineUEC.StartWorldX));
                    this.m_lblProfileStartY.setText(Integer.toString((int)this.m_profileLineUEC.StartWorldY));
                    this.m_lblProfileEndX.setText(Integer.toString((int)this.m_profileLineUEC.EndWorldX));
                    this.m_lblProfileEndY.setText(Integer.toString((int)this.m_profileLineUEC.EndWorldY));
                }
                this.loadMapProfile();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadModel() {
        try {
            if (this.m_selectedProfileInfo == null) {
                this.m_selectedProfileInfo = new SelectedProfileInfo();
            }
            this.m_selectedProfileInfo.StartPixelX = this.m_profileLineUEC.StartPixelX;
            this.m_selectedProfileInfo.StartPixelY = this.m_profileLineUEC.StartPixelY;
            this.m_selectedProfileInfo.EndPixelX = this.m_profileLineUEC.EndPixelX;
            this.m_selectedProfileInfo.EndPixelY = this.m_profileLineUEC.EndPixelY;
            this.m_selectedProfileInfo.StartWorldX = this.m_profileLineUEC.StartWorldX;
            this.m_selectedProfileInfo.StartWorldY = this.m_profileLineUEC.StartWorldY;
            this.m_selectedProfileInfo.EndWorldX = this.m_profileLineUEC.EndWorldX;
            this.m_selectedProfileInfo.EndWorldY = this.m_profileLineUEC.EndWorldY;
            this.m_profile = null;
            String name = this.m_modelCombo.getSelectedString();
            if (name == null) {
                return;
            }
            if (name.length() < 1) {
                return;
            }
            TomoEikonal3D model = new TomoEikonal3D(name);
            RefractionStaticsProject.singleton().setEikonal3D(model);
            this.handleNewModel();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected String newFileName(JTextField txt) {
        try {
            String name = txt.getText();
            if (name == null) {
                JOptionPane.showMessageDialog(null, "Please enter a name", "Cannot create model", 0);
                return null;
            }
            name = Tools_Strings.removeCrap(name, true);
            txt.setText(name);
            if (name.length() < 2) {
                JOptionPane.showMessageDialog(null, "The name must have at least two characters", "Cannot create model", 0);
                return null;
            }
            String path = RefractionStaticsProject.singleton().eikonal3DProjectsPath() + "/" + name;
            if (Tools_FileSystem.exists_path(path)) {
                JOptionPane.showMessageDialog(null, "Model with that name already exists", "Cannot create model", 0);
                return null;
            }
            if (name.equalsIgnoreCase("ShotRecStacks")) {
                JOptionPane.showMessageDialog(null, "Invalid name", "Cannot create model", 0);
                return null;
            }
            return name;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void smoothModel() {
        try {
            TomoEikonal3D model = RefractionStaticsProject.singleton().getEikonal3D();
            if (model == null) {
                return;
            }
            String name = this.newFileName(this.m_txtSmoothNewModelName);
            if (name == null) {
                return;
            }
            int h = Tools_Widget.extractInteger(this.m_txtSmoothHorz, 1, 1, 20);
            int v = Tools_Widget.extractInteger(this.m_txtSmoothVert, 0, 0, 5);
            this.setCursor(Cursor.getPredefinedCursor(3));
            model.smooth_external(h, v);
            History hist = model.getHistory();
            hist.addWithTime("Smoothed version created from model " + model.name());
            hist.add("Horizontal smooth radius = " + Integer.toString(h));
            hist.add("Vertical smooth radius = " + Integer.toString(v));
            model.save(name);
            this.reloadModelCombo();
            this.m_ignoreModelCombo = true;
            this.m_modelCombo.setPreferredSelected(model.name());
            this.m_ignoreModelCombo = false;
            this.handleNewModel();
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected void resampleModel() {
        try {
            TomoEikonal3D model = RefractionStaticsProject.singleton().getEikonal3D();
            if (model == null) {
                return;
            }
            String name = this.newFileName(this.m_txtResampleNewModelName);
            if (name == null) {
                return;
            }
            double h = Tools_Widget.extractDouble(this.m_txtResampleHorzSpacing, 50.0, 5.0, 1000.0);
            double v = Tools_Widget.extractDouble(this.m_txtResampleVertSpacing, 50.0, 5.0, 1000.0);
            double depth = Tools_Widget.extractDouble(this.m_txtResampleMaxDepth, 400.0, 4.0 * v, 8000.0);
            double angle = model.inlineAngle();
            double waterVelocity = model.waterVelocity();
            boolean forceMarine = model.forceMarineSurvey();
            TomoEikonal3D newModel = new TomoEikonal3D(angle, depth, h, v, true, forceMarine, waterVelocity);
            float[][][] slow = newModel.slowness();
            int nx = newModel.numX();
            int ny = newModel.numY();
            int nz = newModel.numZ();
            for (int ix = 0; ix < nx; ++ix) {
                for (int iy = 0; iy < ny; ++iy) {
                    for (int iz = 0; iz < nz; ++iz) {
                        newModel.setGridLocation(ix, iy, iz);
                        model.setWorldLocation(newModel.WorldX, newModel.WorldY, newModel.WorldZ, true, true);
                        slow[ix][iy][iz] = (float)model.SlownessAtWorld;
                    }
                }
            }
            newModel.save(name);
            History hist = newModel.getHistory();
            hist.addWithTime("Resampled version created from model " + model.name());
            hist.add("Horizontal node size = " + Double.toString(h));
            hist.add("Vertical node size = " + Double.toString(v));
            this.reloadModelCombo();
            this.m_ignoreModelCombo = true;
            this.m_modelCombo.setPreferredSelected(newModel.name());
            this.m_ignoreModelCombo = false;
            RefractionStaticsProject.singleton().setEikonal3D(newModel);
            this.handleNewModel();
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void createNewModel() {
        try {
            if (this.m_newDlg == null) {
                this.m_newDlg = new TomoLayerNewModelDialog(TomoLayerNewModelDialog.ModelType.Eikonal3D, TomoLayerNewModelDialog.InitialVelocitySource.Linear);
            }
            this.m_newDlg.showDialog();
            if (this.m_newDlg.OK) {
                this.reloadModelCombo();
                TomoEikonal3D model = RefractionStaticsProject.singleton().getEikonal3D();
                if (model != null) {
                    this.m_ignoreModelCombo = true;
                    this.m_modelCombo.setPreferredSelected(model.name());
                    this.m_ignoreModelCombo = false;
                }
                this.handleNewModel();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void computeV0() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            TomoEikonal3D model = p.getEikonal3D();
            if (model == null) {
                JOptionPane.showMessageDialog(null, "Tomo model not valid", "Cannot compute V0", 0);
                return;
            }
            int maxBranch = RefractionStaticsProject.delayTimeData().branchAssignment().maxBranch();
            if (maxBranch < 1) {
                JOptionPane.showMessageDialog(null, "Must assign branches first", "Cannot compute V0", 0);
                return;
            }
            double depth = Tools_Widget.extractDouble(this.m_txtWeatheringVelocityDepth, 100.0, 1.0, 1000.0);
            boolean updateZ = this.m_chkComputeRefractorElevation.isSelected();
            model.computeWeatheringVelocity((float)depth, updateZ);
            this.reloadHistory();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void computeStatics() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            TomoEikonal3D model = p.getEikonal3D();
            if (model == null) {
                return;
            }
            this.m_staticsColName = this.m_txtStaticsName.getText();
            this.m_staticsColName = Tools_Strings.removeCrap(this.m_staticsColName, true);
            if (this.m_staticsColName.length() < 2) {
                return;
            }
            String statColName = this.m_staticsColName;
            this.m_staticsColName = "STATICS_" + statColName;
            String datumIntColName = "DatumInt_" + statColName;
            String datumFinalColName = "DatumFinal_" + statColName;
            p.shotTable().column_append(this.m_staticsColName, DataType.Double);
            p.shotTable().column_append(datumIntColName, DataType.Double);
            p.shotTable().column_append(datumFinalColName, DataType.Double);
            p.receiverTable().column_append(this.m_staticsColName, DataType.Double);
            p.receiverTable().column_append(datumIntColName, DataType.Double);
            p.receiverTable().column_append(datumFinalColName, DataType.Double);
            if (this.m_radIntVel.isSelected()) {
                int indexKilled;
                int indexY;
                int indexX;
                Table_Abstract table;
                int iter;
                double datumVelocity = Tools_Widget.extractDouble(this.m_txtIntDatumVelocity, 4000.0, 100.0, 100000.0);
                int total = model.numX() * model.numY();
                InversePowerInterpolator interp = new InversePowerInterpolator(400.0, total);
                for (iter = 0; iter <= 1; ++iter) {
                    table = p.shotTable();
                    if (iter == 1) {
                        table = p.receiverTable();
                    }
                    indexX = table.column_indexOfColumn("Easting");
                    indexY = table.column_indexOfColumn("Northing");
                    indexKilled = table.column_indexOfColumn("Killed");
                    for (int n = 0; n < table.row_count(); ++n) {
                        if (table.getBool(n, indexKilled)) continue;
                        double x = table.getDouble(n, indexX);
                        double y = table.getDouble(n, indexY);
                        double z = model.getElevationAtVelocity(x, y, datumVelocity);
                        interp.add(x, y, z, 1.0);
                    }
                }
                for (iter = 0; iter <= 1; ++iter) {
                    table = p.shotTable();
                    if (iter == 1) {
                        table = p.receiverTable();
                    }
                    indexX = table.column_indexOfColumn("Easting");
                    indexY = table.column_indexOfColumn("Northing");
                    indexKilled = table.column_indexOfColumn("Killed");
                    int indexColIntDatum = table.column_indexOfColumn(datumIntColName);
                    for (int n = 0; n < table.row_count(); ++n) {
                        if (table.getBool(n, indexKilled)) continue;
                        double x = table.getDouble(n, indexX);
                        double y = table.getDouble(n, indexY);
                        double z = interp.getInverseSquare(x, y);
                        table.putDouble(n, indexColIntDatum, z);
                    }
                }
            }
            this.computeStatics(model.SourceHash, p.shotTable(), "ShotID", false);
            this.computeStatics(model.ReceiverHash, p.receiverTable(), "ReceiverID", true);
            if (this.m_radShiftZero.isSelected()) {
                Tools_RefractionStaticsProject.convertToZeroMean(this.m_staticsColName);
            }
            if (this.m_radShiftTie.isSelected()) {
                String column = this.m_comboShiftCol.getSelectedString();
                Tools_RefractionStaticsProject.tieColumnAverage(column, this.m_staticsColName, -9900.0, 9900.0);
            }
            RefractionStaticsProject.singleton().reloadAllData();
            this.reloadHistory();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void computeStatics(HashMap_Integers<TomoEikonal3D.Element> hash, Table_Abstract table, String idname, boolean updateHistory) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            TomoEikonal3D model = p.getEikonal3D();
            if (model == null) {
                return;
            }
            this.m_staticsColName = this.m_txtStaticsName.getText();
            this.m_staticsColName = Tools_Strings.removeCrap(this.m_staticsColName, true);
            if (this.m_staticsColName.length() < 2) {
                return;
            }
            String statColName = this.m_staticsColName;
            this.m_staticsColName = "STATICS_" + statColName;
            String datumIntColName = "DatumInt_" + statColName;
            String datumFinalColName = "DatumFinal_" + statColName;
            int colIntDatum = table.column_indexOfColumn(datumIntColName);
            double residualScalar = Tools_Widget.extractDouble(this.m_txtResidCorrMult, 1.0, -10.0, 10.0);
            boolean includeResidual = this.m_chkApplyResidual.isSelected();
            FinalDatumEnum finalDatum = FinalDatumEnum.Elevation;
            IntDatumEnum intDatum = IntDatumEnum.Elevation;
            if (this.m_radFinalCol.isSelected()) {
                finalDatum = FinalDatumEnum.Column;
            }
            if (this.m_radIntDepth.isSelected()) {
                intDatum = IntDatumEnum.Depth;
            }
            if (this.m_radIntVel.isSelected()) {
                intDatum = IntDatumEnum.Velocity;
            }
            if (this.m_radIntCol.isSelected()) {
                intDatum = IntDatumEnum.Column;
            }
            double datumVelocity = Tools_Widget.extractDouble(this.m_txtIntDatumVelocity, 4000.0, 100.0, 100000.0);
            String columnIntDatumName = this.m_comboIntCol.getSelectedString();
            String columnFinalDatumName = this.m_comboFinalCol.getSelectedString();
            double fixedIntElev = Tools_Widget.extractDouble(this.m_txtIntDatumElev, 0.0, -30000.0, 30000.0);
            double depth = Tools_Widget.extractDouble(this.m_txtIntDatumDepth, 100.0, 1.0, 30000.0);
            double finalDatumElevation = Tools_Widget.extractDouble(this.m_txtFinalDatumElev, 0.0, -30000.0, 30000.0);
            double repVel = Tools_Widget.extractDouble(this.m_txtRepVel, 1000.0, 100.0, 30000.0);
            int indexStatics = table.column_indexOfColumn(this.m_staticsColName);
            int indexDatInt = table.column_indexOfColumn(datumIntColName);
            int indexDatFin = table.column_indexOfColumn(datumFinalColName);
            int indexID = table.column_indexOfColumn(idname);
            int indexStackPick = table.column_indexOfColumn("Tomo3D_StackPickTime");
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexZ = table.column_indexOfColumn("Elevation");
            int indexD = -9999;
            if (table.column_exists("PointDepth")) {
                indexD = table.column_indexOfColumn("PointDepth");
            }
            int indexColIntDatum = table.column_indexOfColumn(columnIntDatumName);
            int indexColFinalDatum = table.column_indexOfColumn(columnFinalDatumName);
            for (int n = 0; n < table.row_count(); ++n) {
                double x = table.getDouble(n, indexX);
                double y = table.getDouble(n, indexY);
                double z = table.getDouble(n, indexZ);
                double d = 0.0;
                if (indexD >= 0) {
                    d = table.getDouble(n, indexD);
                }
                int id = table.getInt(n, indexID);
                double intDatumZ = z - 10.0;
                if (intDatum == IntDatumEnum.Elevation) {
                    intDatumZ = Math.min(z - 1.0, fixedIntElev);
                }
                if (intDatum == IntDatumEnum.Depth) {
                    intDatumZ = z - depth;
                }
                if (intDatum == IntDatumEnum.Column) {
                    double colDatum = table.getDouble(n, indexColIntDatum);
                    intDatumZ = Math.min(z - 1.0, colDatum);
                }
                if (finalDatum == FinalDatumEnum.Column) {
                    finalDatumElevation = table.getDouble(n, indexColFinalDatum);
                }
                if (intDatum == IntDatumEnum.Velocity) {
                    model.computeStatics_ComputeIntDatum(x, y, z - d, datumVelocity, finalDatumElevation, repVel);
                } else {
                    model.computeStatics(x, y, z - d, intDatumZ, finalDatumElevation, repVel);
                }
                double statics = model.Statics;
                if (includeResidual && hash.containsKey(id)) {
                    TomoEikonal3D.Element e = hash.get(id);
                    statics += residualScalar * e.Residual;
                }
                table.putDouble(n, indexStatics, statics);
                table.putDouble(n, indexDatInt, table.getDouble(n, indexDatInt));
                table.putDouble(n, indexDatFin, finalDatumElevation);
            }
            p.geometryDatabase().writeColumnContentsToDatabase(table, this.m_staticsColName);
            p.geometryDatabase().writeColumnContentsToDatabase(table, datumFinalColName);
            p.geometryDatabase().writeColumnContentsToDatabase(table, datumIntColName);
            if (updateHistory) {
                try {
                    model.getHistory().addWithTime("Compute statics:");
                    model.getHistory().add("Column name = " + this.m_staticsColName);
                    if (includeResidual) {
                        model.getHistory().add("Residual term included, scalar = " + Double.toString(residualScalar));
                    }
                    if (this.m_radShiftZero.isSelected()) {
                        model.getHistory().add("Converted to zero mean");
                    }
                    if (this.m_radShiftTie.isSelected()) {
                        model.getHistory().add("Statics tied to column " + this.m_comboShiftCol.getSelectedString());
                    }
                    if (intDatum == IntDatumEnum.Velocity) {
                        model.getHistory().add("Intermediate at velocity = " + Double.toString(datumVelocity));
                    }
                    if (intDatum == IntDatumEnum.Elevation) {
                        model.getHistory().add("Flat intermediate datum, elevation = " + Double.toString(fixedIntElev));
                    }
                    if (intDatum == IntDatumEnum.Depth) {
                        model.getHistory().add("Intermediate datum at depth = " + Double.toString(depth));
                    }
                    if (intDatum == IntDatumEnum.Column) {
                        model.getHistory().add("Intermediate datum at column = " + columnIntDatumName);
                    }
                    if (finalDatum == FinalDatumEnum.Elevation) {
                        model.getHistory().add("Final datum = " + Double.toString(finalDatumElevation));
                    }
                    if (finalDatum == FinalDatumEnum.Column) {
                        model.getHistory().add("Final datum set using column " + columnFinalDatumName);
                    }
                    model.getHistory().add("Replacment velocity = " + Double.toString(repVel));
                    model.getHistory().save();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void cutInside() {
        try {
            if (this.m_polygon == null) {
                return;
            }
            int res = JOptionPane.showConfirmDialog(null, "Okay to cut inside polygon and interpolate new velocities?", "Confirm delete", 2, 2, null);
            if (res != 0) {
                return;
            }
            TomoEikonal3D_Polygon p = new TomoEikonal3D_Polygon();
            try {
                if (SharedApplicationData.singleton().appFrame() != null) {
                    SharedApplicationData.singleton().appFrame().setCursor(Cursor.getPredefinedCursor(3));
                }
            }
            catch (Exception error) {
                error.printStackTrace();
            }
            p.work(this.m_polygon, RefractionStaticsProject.singleton().getEikonal3D());
            JOptionPane.showMessageDialog(null, "You must select \"Save model\" to save changes", " ", 1);
            this.m_smallMapWidget.reloadPlot();
            this.m_bigMapWidget.reloadPlot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        try {
            if (SharedApplicationData.singleton().appFrame() != null) {
                SharedApplicationData.singleton().appFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            int np;
            Action_Base action;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (!p.valid()) {
                return;
            }
            this.m_comboShiftCol.setEnabled(this.m_radShiftTie.isSelected());
            this.m_txtFinalDatumElev.setEnabled(this.m_radFinalElev.isSelected());
            this.m_comboFinalCol.setEnabled(this.m_radFinalCol.isSelected());
            this.m_txtIntDatumElev.setEnabled(this.m_radIntElev.isSelected());
            this.m_txtIntDatumDepth.setEnabled(this.m_radIntDepth.isSelected());
            this.m_txtIntDatumVelocity.setEnabled(this.m_radIntVel.isSelected());
            this.m_comboIntCol.setEnabled(this.m_radIntCol.isSelected());
            if (e.getSource() == this.m_btnSmoothModel) {
                this.smoothModel();
                return;
            }
            if (e.getSource() == this.m_btnResample) {
                this.resampleModel();
                return;
            }
            if (e.getSource() == this.m_btnSaveModel) {
                p.getEikonal3D().save(p.getEikonal3D().name());
                return;
            }
            if (e.getSource() == this.m_btnCutInside) {
                this.cutInside();
                return;
            }
            if (e.getSource() == this.m_btnClearPolygon) {
                this.m_smallMapWidget.Polygon = this.m_polygon = null;
                this.m_smallMapWidget.reloadPlot();
                this.m_bigMapWidget.Polygon = this.m_polygon;
                this.m_bigMapWidget.reloadPlot();
            }
            if (e.getSource() == this.m_btnSmooth) {
                this.smoothVel();
                return;
            }
            if (e.getSource() == this.m_btnCreateSynth) {
                this.createSynth();
                return;
            }
            if (e.getSource() == this.m_btnSetVel) {
                this.setSynthVel();
                return;
            }
            if (e.getSource() == this.m_btnRefreshInfo) {
                this.refreshModelInfo();
                return;
            }
            if (e.getSource() == this.m_btnStaticsReloadColumns) {
                ArrayList<String> cols = Tools_RefractionStaticsProject.getColumnList_Intersection();
                this.m_comboIntCol.setStringArray(cols);
                this.m_comboFinalCol.setStringArray(cols);
                this.m_comboShiftCol.setStringArray(cols);
                return;
            }
            if (this.m_btnSegyExport_Grid == e.getSource()) {
                if (p.getEikonal3D() == null) {
                    return;
                }
                Action_Eikonal3D_ExportSegy action2 = new Action_Eikonal3D_ExportSegy();
                action2.UseProjectGrid = true;
                action2.ExportVelocity = true;
                action2.TopDatum = Tools_Widget.extractDouble(this.m_txtSegyDatumTop, 2000.0, -10000.0, 30000.0);
                action2.BottomDatum = Tools_Widget.extractDouble(this.m_txtSegyDatumBottom, action2.TopDatum - 1000.0, action2.TopDatum - 50000.0, action2.TopDatum - 10.0);
                action2.Size = Tools_Widget.extractDouble(this.m_txtSegySampleSize, 50.0, 1.0, 1000.0);
                action2.FileName = this.m_segyFileWidget.getText();
                RefractionStaticsProject.singleton().executeSingleAction(action2);
                return;
            }
            if (this.m_btnSegyExport == e.getSource()) {
                if (p.getEikonal3D() == null) {
                    return;
                }
                Action_Eikonal3D_ExportSegy action3 = new Action_Eikonal3D_ExportSegy();
                action3.ExportVelocity = true;
                action3.TopDatum = Tools_Widget.extractDouble(this.m_txtSegyDatumTop, 2000.0, -10000.0, 30000.0);
                action3.BottomDatum = Tools_Widget.extractDouble(this.m_txtSegyDatumBottom, action3.TopDatum - 1000.0, action3.TopDatum - 50000.0, action3.TopDatum - 10.0);
                action3.Size = Tools_Widget.extractDouble(this.m_txtSegySampleSize, 50.0, 1.0, 1000.0);
                action3.FileName = this.m_segyFileWidget.getText();
                RefractionStaticsProject.singleton().executeSingleAction(action3);
                return;
            }
            if (this.m_btnSegyExportCount_Grid == e.getSource()) {
                if (p.getEikonal3D() == null) {
                    return;
                }
                Action_Eikonal3D_ExportSegy action4 = new Action_Eikonal3D_ExportSegy();
                action4.ExportCounts = true;
                action4.UseProjectGrid = true;
                action4.TopDatum = Tools_Widget.extractDouble(this.m_txtSegyDatumTop, 2000.0, -10000.0, 30000.0);
                action4.BottomDatum = Tools_Widget.extractDouble(this.m_txtSegyDatumBottom, action4.TopDatum - 1000.0, action4.TopDatum - 50000.0, action4.TopDatum - 10.0);
                action4.Size = Tools_Widget.extractDouble(this.m_txtSegySampleSize, 50.0, 1.0, 1000.0);
                action4.FileName = this.m_segyFileWidget.getText();
                RefractionStaticsProject.singleton().executeSingleAction(action4);
                return;
            }
            if (this.m_btnSegyExportCount == e.getSource()) {
                if (p.getEikonal3D() == null) {
                    return;
                }
                Action_Eikonal3D_ExportSegy action5 = new Action_Eikonal3D_ExportSegy();
                action5.ExportCounts = true;
                action5.TopDatum = Tools_Widget.extractDouble(this.m_txtSegyDatumTop, 2000.0, -10000.0, 30000.0);
                action5.BottomDatum = Tools_Widget.extractDouble(this.m_txtSegyDatumBottom, action5.TopDatum - 1000.0, action5.TopDatum - 50000.0, action5.TopDatum - 10.0);
                action5.Size = Tools_Widget.extractDouble(this.m_txtSegySampleSize, 50.0, 1.0, 1000.0);
                action5.FileName = this.m_segyFileWidget.getText();
                RefractionStaticsProject.singleton().executeSingleAction(action5);
                return;
            }
            if (e.getSource() == this.m_btnComboReloadTables) {
                this.reloadListOfTable();
                return;
            }
            if (e.getSource() == this.m_btnReloadHistory) {
                this.reloadHistory();
                return;
            }
            if (e.getSource() == this.m_btnSetWeatheringVelocity) {
                this.computeV0();
                return;
            }
            if (e.getSource() == this.m_btnStatics) {
                this.computeStatics();
                return;
            }
            if (e.getSource() == this.m_btnReload) {
                this.reloadModelCombo();
            }
            if (e.getSource() == this.m_btnCreateNew) {
                this.createNewModel();
            }
            if (e.getSource() == this.m_btnExportMPI) {
                if (p.getEikonal3D() == null) {
                    return;
                }
                this.exportMPI();
                return;
            }
            if (e.getSource() == this.m_btnUpdateThreads) {
                if (p.getEikonal3D() == null) {
                    return;
                }
                action = new Action_Eikonal_DiskBased();
                action.Uphole_LockShallow = this.m_chkApplyUphole.isSelected();
                if (action.Uphole_LockShallow) {
                    action.Uphole_Table = this.m_comboUpholeTable.getSelectedString();
                    if (p.importDatabase().tableExists(action.Uphole_Table)) {
                        action.Uphole_X = this.m_comboUpholeX.getSelectedString();
                        action.Uphole_Y = this.m_comboUpholeY.getSelectedString();
                        action.Uphole_Z = this.m_comboUpholeZ.getSelectedString();
                        action.Uphole_V = this.m_comboUpholeV.getSelectedString();
                    } else {
                        action.Uphole_LockShallow = false;
                    }
                }
                action.Decimation = Tools_Widget.extractInteger(this.m_txtDecimation, 1, 1, 20);
                action.ApplyDecimation = this.m_chkDecimatePick.isSelected();
                action.PickShift = Tools_Widget.extractDouble(this.m_txtPickShift, 0.0, -500.0, 500.0);
                action.ComputeHybridTimeShifts = this.m_chkHybridCompute.isSelected();
                action.HybridLMOVelocity = Tools_Widget.extractDouble(this.m_txtHybridVel, 2000.0, 500.0, 20000.0);
                action.HybridTimeShifts = Tools_Widget.extractDouble(this.m_txtHybridTimeShift, 200.0, 100.0, 20000.0);
                action.ApplyAzimuthLimits = this.m_chkApplyAzimuth.isSelected();
                action.AzimuthCenter = Tools_Widget.extractDouble(this.m_txtAzimuthCenter, 0.0, -180.0, 180.0) * Math.PI / 180.0;
                action.AzimuthRadius = Tools_Widget.extractDouble(this.m_txtAzimuthRadius, 0.0, 0.0, 90.0) * Math.PI / 180.0;
                action.Model = p.getEikonal3D();
                action.NumIter = Tools_Widget.extractInteger(this.m_txtNumIter, 10, 1, 100);
                action.SmoothRadius = Tools_Widget.extractInteger(this.m_txtSmoothRadius, 3, 0, 10);
                action.OffsetCorner = Tools_Widget.extractDouble(this.m_txtOffsetCorner, 1000.0, 10.0, 20000.0);
                action.MinOffset = Tools_Widget.extractDouble(this.m_txtMinOffset, 0.0, 0.0, 10000.0);
                action.MaxOffset = Tools_Widget.extractDouble(this.m_txtMaxOffset, action.MinOffset + 1000.0, action.MinOffset + 10.0, 30000.0);
                action.PickVersion = this.m_pickVersionCombo.getSelectedString();
                np = Runtime.getRuntime().availableProcessors();
                action.NumThreads = Tools_Widget.extractInteger(this.m_txtNumThreads, 2, 2, np);
                p.executeSingleAction(action);
            }
            if (e.getSource() == this.m_btnUpdateThreadsNC) {
                if (p.getEikonal3D() == null) {
                    return;
                }
                action = new Action_Eikonal3D_NewThreadModel_Disk();
                ((Action_Eikonal3D_NewThreadModel_Disk)action).Uphole_LockShallow = this.m_chkApplyUphole.isSelected();
                if (((Action_Eikonal3D_NewThreadModel_Disk)action).Uphole_LockShallow) {
                    ((Action_Eikonal3D_NewThreadModel_Disk)action).Uphole_Table = this.m_comboUpholeTable.getSelectedString();
                    if (p.importDatabase().tableExists(((Action_Eikonal3D_NewThreadModel_Disk)action).Uphole_Table)) {
                        ((Action_Eikonal3D_NewThreadModel_Disk)action).Uphole_X = this.m_comboUpholeX.getSelectedString();
                        ((Action_Eikonal3D_NewThreadModel_Disk)action).Uphole_Y = this.m_comboUpholeY.getSelectedString();
                        ((Action_Eikonal3D_NewThreadModel_Disk)action).Uphole_Z = this.m_comboUpholeZ.getSelectedString();
                        ((Action_Eikonal3D_NewThreadModel_Disk)action).Uphole_V = this.m_comboUpholeV.getSelectedString();
                    } else {
                        ((Action_Eikonal3D_NewThreadModel_Disk)action).Uphole_LockShallow = false;
                    }
                }
                ((Action_Eikonal3D_NewThreadModel_Disk)action).Decimation = Tools_Widget.extractInteger(this.m_txtDecimation, 1, 1, 20);
                ((Action_Eikonal3D_NewThreadModel_Disk)action).ApplyDecimation = this.m_chkDecimatePick.isSelected();
                ((Action_Eikonal3D_NewThreadModel_Disk)action).PickShift = Tools_Widget.extractDouble(this.m_txtPickShift, 0.0, -500.0, 500.0);
                ((Action_Eikonal3D_NewThreadModel_Disk)action).ComputeHybridTimeShifts = this.m_chkHybridCompute.isSelected();
                ((Action_Eikonal3D_NewThreadModel_Disk)action).HybridLMOVelocity = Tools_Widget.extractDouble(this.m_txtHybridVel, 2000.0, 500.0, 20000.0);
                ((Action_Eikonal3D_NewThreadModel_Disk)action).HybridTimeShifts = Tools_Widget.extractDouble(this.m_txtHybridTimeShift, 200.0, 100.0, 20000.0);
                ((Action_Eikonal3D_NewThreadModel_Disk)action).ApplyAzimuthLimits = this.m_chkApplyAzimuth.isSelected();
                ((Action_Eikonal3D_NewThreadModel_Disk)action).AzimuthCenter = Tools_Widget.extractDouble(this.m_txtAzimuthCenter, 0.0, -180.0, 180.0) * Math.PI / 180.0;
                ((Action_Eikonal3D_NewThreadModel_Disk)action).AzimuthRadius = Tools_Widget.extractDouble(this.m_txtAzimuthRadius, 0.0, 0.0, 90.0) * Math.PI / 180.0;
                ((Action_Eikonal3D_NewThreadModel_Disk)action).Model = p.getEikonal3D();
                ((Action_Eikonal3D_NewThreadModel_Disk)action).NumIter = Tools_Widget.extractInteger(this.m_txtNumIter, 10, 1, 100);
                ((Action_Eikonal3D_NewThreadModel_Disk)action).SmoothRadius = Tools_Widget.extractInteger(this.m_txtSmoothRadius, 3, 1, 10);
                ((Action_Eikonal3D_NewThreadModel_Disk)action).OffsetCorner = Tools_Widget.extractDouble(this.m_txtOffsetCorner, 1000.0, 10.0, 20000.0);
                ((Action_Eikonal3D_NewThreadModel_Disk)action).MinOffset = Tools_Widget.extractDouble(this.m_txtMinOffset, 0.0, 0.0, 10000.0);
                ((Action_Eikonal3D_NewThreadModel_Disk)action).MaxOffset = Tools_Widget.extractDouble(this.m_txtMaxOffset, ((Action_Eikonal3D_NewThreadModel_Disk)action).MinOffset + 1000.0, ((Action_Eikonal3D_NewThreadModel_Disk)action).MinOffset + 500.0, 30000.0);
                ((Action_Eikonal3D_NewThreadModel_Disk)action).PickVersion = this.m_pickVersionCombo.getSelectedString();
                np = Runtime.getRuntime().availableProcessors();
                ((Action_Eikonal3D_NewThreadModel_Disk)action).NumThreads = Tools_Widget.extractInteger(this.m_txtNumThreads, 2, 1, np);
                p.executeSingleAction(action);
            }
            if (e.getSource() == this.m_btnSetProfile) {
                MultiTextDialog dlg = new MultiTextDialog(null, "Manually set profile", "Start X: ", "Start Y: ", "End X: ", "End Y: ");
                dlg.showDialog("Set profile");
                if (!dlg.OK) {
                    return;
                }
                this.m_profileLineUEC.StartWorldX = dlg.getDouble(0, 0.0, 0.0, Double.MAX_VALUE);
                this.m_profileLineUEC.StartWorldY = dlg.getDouble(1, 0.0, 0.0, Double.MAX_VALUE);
                this.m_profileLineUEC.EndWorldX = dlg.getDouble(2, 0.0, 0.0, Double.MAX_VALUE);
                this.m_profileLineUEC.EndWorldY = dlg.getDouble(3, 0.0, 0.0, Double.MAX_VALUE);
                this.m_profileLineUEC.StartPixelX = this.m_smallMapWidget.CompositeWidget.getPixelX(this.m_profileLineUEC.StartWorldX);
                this.m_profileLineUEC.StartPixelY = this.m_smallMapWidget.CompositeWidget.getPixelY(this.m_profileLineUEC.StartWorldY);
                this.m_profileLineUEC.EndPixelX = this.m_smallMapWidget.CompositeWidget.getPixelX(this.m_profileLineUEC.EndWorldX);
                this.m_profileLineUEC.EndPixelY = this.m_smallMapWidget.CompositeWidget.getPixelY(this.m_profileLineUEC.EndWorldY);
                this.m_lblProfileStartX.setText(Double.toString(this.m_profileLineUEC.StartWorldX));
                this.m_lblProfileStartY.setText(Double.toString(this.m_profileLineUEC.StartWorldY));
                this.m_lblProfileEndX.setText(Double.toString(this.m_profileLineUEC.EndWorldX));
                this.m_lblProfileEndY.setText(Double.toString(this.m_profileLineUEC.EndWorldY));
                this.loadMapProfile();
                this.m_smallMapWidget.CompositeWidget.mainWidget().mooz();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void exportMPI() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            String path = this.m_txtMPIPath.getText();
            String fileName = path + "/tomo.data";
            TomoEikonal3D_XtGeoConnection.saveTomoEikonal3D(p.getEikonal3D(), fileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handlePopupMenuButton(PopupMenuButton button, String text) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.EikonalModelChanged) {
                this.reloadModelCombo();
                this.m_modelCombo.setSelectedItem(data);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadMapProfile() {
        try {
            this.m_profileDisplayWidget.clear();
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            TomoEikonal3D model = p.getEikonal3D();
            if (model == null) {
                return;
            }
            double x1 = this.m_profileLineUEC.StartWorldX;
            double y1 = this.m_profileLineUEC.StartWorldY;
            double x2 = this.m_profileLineUEC.EndWorldX;
            double y2 = this.m_profileLineUEC.EndWorldY;
            if (this.m_profileLineUEC.StartWorldX != 0.0 && this.m_profileLineUEC.StartWorldY != 0.0 && this.m_profileLineUEC.EndWorldX != 0.0 && this.m_profileLineUEC.EndWorldY != 0.0) {
                this.m_smallMapWidget.LineSegment.Valid = true;
                this.m_smallMapWidget.LineSegment.DrawSymbols = false;
                this.m_smallMapWidget.LineSegment.X1 = x1;
                this.m_smallMapWidget.LineSegment.Y1 = y1;
                this.m_smallMapWidget.LineSegment.X2 = x2;
                this.m_smallMapWidget.LineSegment.Y2 = y2;
                this.m_smallMapWidget.LineSegment.LineColor = Color.WHITE;
            }
            model.setWorldLocation(x1, y1, true, true);
            double z1 = model.InterpolatedElevation;
            model.setWorldLocation(x2, y2, true, true);
            double z2 = model.InterpolatedElevation;
            if (this.m_profile == null) {
                System.out.println("Recreate profile object");
                this.m_profile = model.createNewProfile();
            }
            model.populateProfile(this.m_profile, x1, y1, x2, y2);
            this.m_profile.fireShot((float)z1);
            this.m_profile.accuratePath_SetReceiver((float)z2, 1000.0f);
            this.m_profileDisplayWidget.mainWidget(0).addPaintable(this.m_profile, 1000);
            if (this.m_radWhichLowerPlot.getSelectedIndex() == 0) {
                this.m_profileDisplayWidget.mainWidget(1).addPaintable(this.m_profile, 1002);
            } else {
                this.m_profileDisplayWidget.mainWidget(1).addPaintable(this.m_profile, 1003);
            }
            this.m_profileDisplayWidget.setColorLabel(0, "Velocity");
            this.m_profileDisplayWidget.setColorLabel(1, "Node sampling");
            this.m_profileDisplayWidget.setTransform(Java2D_Transform.Technique.Normal);
            this.m_profileDisplayWidget.unzoom();
            this.m_profileDisplayWidget.initializeMouseoverPanel(this.m_profile, Java2D_UserEventConsumer_MouseoverInfo.ModelType.Tomo3D);
            this.m_smallMapWidget.CompositeWidget.mainWidget().repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_polygonUEH) {
                if (this.m_polygonUEH.Dragging) {
                    return;
                }
                if (!this.m_polygonUEH.Finished) {
                    return;
                }
                int num = this.m_polygonUEH.numPoints();
                if (this.m_polygonUEH.numPoints() < 3) {
                    return;
                }
                this.m_polygon = new Java2D_Polygon();
                this.m_polygon.FillColor = new Color(192, 192, 192, 192);
                this.m_polygon.X = new double[num];
                this.m_polygon.Y = new double[num];
                for (int n = 0; n < num; ++n) {
                    this.m_polygon.X[n] = this.m_polygonUEH.getX(n);
                    this.m_polygon.Y[n] = this.m_polygonUEH.getY(n);
                }
                this.m_smallMapWidget.Polygon = this.m_polygon;
                this.m_smallMapWidget.reloadPlot();
                this.m_bigMapWidget.Polygon = this.m_polygon;
                this.m_bigMapWidget.reloadPlot();
            }
            if (sender == this.m_comboUpholeTable) {
                this.reloadListOfColumns();
            }
            if (sender == this.m_profileLineUEC) {
                if (this.m_profileLineUEC.Dragging) {
                    this.loadMapProfile();
                } else {
                    System.out.println("handleGenericObjectListener m_profileLineUEC.Dragging == false");
                    this.m_smallMapWidget.CompositeWidget.mainWidget().mooz();
                    this.m_lblProfileStartX.setText(Integer.toString((int)this.m_profileLineUEC.StartWorldX));
                    this.m_lblProfileStartY.setText(Integer.toString((int)this.m_profileLineUEC.StartWorldY));
                    this.m_lblProfileEndX.setText(Integer.toString((int)this.m_profileLineUEC.EndWorldX));
                    this.m_lblProfileEndY.setText(Integer.toString((int)this.m_profileLineUEC.EndWorldY));
                }
            }
            if (sender == this.m_modelCombo) {
                if (this.m_ignoreModelCombo) {
                    return;
                }
                this.loadModel();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected class MapWidget
    extends LinearLayoutWidget
    implements ActionListener,
    ItemListener {
        public Java2D_SimpleComposite CompositeWidget;
        public JComboBox<String> ComboAttribute;
        public JComboBox<String> ComboElevation;
        public JTextField m_txtDepth;
        public JCheckBox m_chkShowShots;
        public JCheckBox m_chkShowReceivers;
        public JButton m_btnReload;
        public boolean m_ignoreCombo;
        public Java2D_Paintable_LineSegment LineSegment;
        public Java2D_Polygon Polygon;
        protected boolean m_usePolygon;
        public LinearLayoutWidget Bottom;

        public MapWidget(boolean tinyWidth, boolean usePolygon) {
            super(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.ComboAttribute = new JComboBox();
            this.ComboElevation = new JComboBox();
            this.m_txtDepth = new JTextField("0");
            this.m_chkShowShots = new JCheckBox("Show shots");
            this.m_chkShowReceivers = new JCheckBox("Show receivers");
            this.m_ignoreCombo = false;
            this.LineSegment = new Java2D_Paintable_LineSegment();
            this.m_usePolygon = false;
            try {
                this.m_usePolygon = usePolygon;
                LinearLayoutWidget top = this.createHorizontal(0, null, 0);
                top.addComponent(this.ComboAttribute, 0);
                top.addComponent(new JLabel("Elevation:"), 0);
                top.addComponent(this.ComboElevation, 2);
                top.addComponent(new JLabel("Depth:"), 0);
                top.addComponent(this.m_txtDepth, 2);
                this.ComboAttribute.addItem("Surface elevation");
                this.ComboAttribute.addItem("Velocity at fixed elevation");
                this.ComboAttribute.addItem("Statistical weight at elevation");
                this.ComboAttribute.addItem("Velocity at fixed depth");
                this.ComboAttribute.addItem("Node hit count at depth");
                this.ComboAttribute.addItem("Maximum valid depth");
                this.ComboAttribute.addItem("Minimum valid elevation");
                this.ComboAttribute.setSelectedIndex(0);
                this.ComboAttribute.addItemListener(this);
                this.ComboElevation.addItemListener(this);
                this.m_txtDepth.addActionListener(this);
                int index = this.ComboAttribute.getSelectedIndex();
                this.m_txtDepth.setEnabled(index == 3 || index == 4);
                this.ComboElevation.setEnabled(this.ComboAttribute.getSelectedIndex() == 1 || this.ComboAttribute.getSelectedIndex() == 2);
                this.Bottom = this.createHorizontal(0, null, 0);
                this.Bottom.addComponent(this.m_chkShowReceivers, 0);
                this.m_chkShowReceivers.addActionListener(this);
                this.Bottom.addComponent(this.m_chkShowShots, 0);
                this.m_chkShowShots.addActionListener(this);
                this.m_btnReload = this.Bottom.createButton("Reload plot", this, 0);
                this.Bottom.addStretch(10);
                Tools_FontChanger.changeSizeOfFont(top, -2, null, true);
                Tools_FontChanger.changeSizeOfFont(this.Bottom, -2, null, true);
                this.CompositeWidget = new Java2D_SimpleComposite(true);
                this.CompositeWidget.setAxesVisible(true, true);
                this.CompositeWidget.setScrollVisible(true, true);
                this.CompositeWidget.mainWidget().addZoomer();
                this.addComponent(this.CompositeWidget, 10);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void handleNewModel() {
            try {
                TomoEikonal3D model = RefractionStaticsProject.singleton().getEikonal3D();
                this.ComboElevation.removeAllItems();
                this.LineSegment.Valid = false;
                if (model == null) {
                    return;
                }
                for (int z = 0; z < model.numZ(); ++z) {
                    double elev = model.originZ() + (double)z * model.binSizeVert();
                    this.ComboElevation.addItem(Double.toString(elev));
                }
                this.ComboElevation.setSelectedIndex(0);
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        public void reloadPlot() {
            try {
                int index;
                TomoEikonal3D tomo = RefractionStaticsProject.singleton().getEikonal3D();
                Java2D_Widget w = this.CompositeWidget.mainWidget();
                w.clearPaintableList();
                if (tomo == null) {
                    w.mooz();
                    return;
                }
                Grid3D grid = null;
                if (this.ComboAttribute.getSelectedIndex() == 0) {
                    grid = tomo.getSurfaceGrid3D();
                }
                if (this.ComboAttribute.getSelectedIndex() == 1) {
                    index = this.ComboElevation.getSelectedIndex();
                    grid = tomo.getVelocityAtElevationGrid3D(index);
                }
                if (this.ComboAttribute.getSelectedIndex() == 2) {
                    index = this.ComboElevation.getSelectedIndex();
                    grid = tomo.getWeightAtElevationGrid3D(index);
                }
                if (this.ComboAttribute.getSelectedIndex() == 3) {
                    float depth = (float)Tools_Widget.extractDouble(this.m_txtDepth, 0.0, 0.0, 100000.0);
                    grid = tomo.getVelocityAtDepthGrid3D(depth);
                }
                if (this.ComboAttribute.getSelectedIndex() == 4) {
                    float depth = (float)Tools_Widget.extractDouble(this.m_txtDepth, 0.0, 0.0, 100000.0);
                    grid = tomo.getCountAtDepthGrid3D(depth);
                }
                if (this.ComboAttribute.getSelectedIndex() == 5) {
                    grid = tomo.getValidDepthGrid3D();
                }
                if (this.ComboAttribute.getSelectedIndex() == 6) {
                    grid = tomo.getMinValidElevationGrid3D();
                }
                if (grid != null) {
                    grid.ArrayDirty = true;
                    w.addPaintable(grid, 0);
                }
                if (this.m_chkShowShots.isSelected()) {
                    try {
                        w.addPaintable(Tools_RefractionStaticsProject.loadGeomPO("Shot"), 0);
                    }
                    catch (Exception error) {
                        error.printStackTrace();
                    }
                }
                if (this.m_chkShowReceivers.isSelected()) {
                    try {
                        w.addPaintable(Tools_RefractionStaticsProject.loadGeomPO("Receiver"), 0);
                    }
                    catch (Exception error) {
                        error.printStackTrace();
                    }
                }
                if (this.Polygon != null) {
                    w.addPaintable(this.Polygon, 0);
                }
                if (!this.m_usePolygon) {
                    w.addPaintable(this.LineSegment, 0);
                }
                w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
                w.mooz();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                if (this.m_ignoreCombo) {
                    return;
                }
                int index = this.ComboAttribute.getSelectedIndex();
                this.m_txtDepth.setEnabled(index == 3 || index == 4);
                this.ComboElevation.setEnabled(this.ComboAttribute.getSelectedIndex() == 1 || this.ComboAttribute.getSelectedIndex() == 2);
                if (e.getSource() == this.ComboAttribute) {
                    this.reloadPlot();
                }
                if (e.getSource() == this.ComboElevation) {
                    this.reloadPlot();
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.reloadPlot();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }
    }

    public class SelectedProfileInfo {
        protected int StartPixelX;
        protected int StartPixelY;
        protected int EndPixelX;
        protected int EndPixelY;
        protected double StartWorldX;
        protected double StartWorldY;
        protected double EndWorldX;
        protected double EndWorldY;
    }

    protected static enum FinalDatumEnum {
        Elevation,
        Column;

    }

    protected static enum IntDatumEnum {
        Depth,
        Elevation,
        Column,
        Velocity;

    }
}

