/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Refraction.RefractionStaticsProjectManagerWidget;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class SelectProjectDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected JButton m_btnOK = new JButton("Open selected project");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected Checkbox m_boxLoad = new Checkbox("Load saved tabs", false);
    protected RefractionStaticsProjectManagerWidget m_widget;
    protected boolean m_multi_select = false;
    public RadioPanel Radio;
    public boolean OK = false;
    public boolean loadSaved = false;
    public String ProjectName = "";
    public ArrayList<String> SelectedProjects = new ArrayList();

    public SelectProjectDialog(boolean showModeOptions, boolean multi_select) {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            this.m_widget = new RefractionStaticsProjectManagerWidget();
            this.m_multi_select = multi_select;
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            if (!this.m_multi_select) {
                bottom.addComponent(this.m_boxLoad, 0);
            }
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            bottom.addStretch(10);
            this.Radio = new RadioPanel(LinearLayoutWidget.Direction.Horizontal, null, "Open the project in normal view layout", "Select the view layout");
            if (showModeOptions) {
                bottom.addComponent(this.Radio, 0);
            }
            this.Radio.setSelectedIndex(0);
            if (this.m_multi_select) {
                JLabel lbl = new JLabel("Select one or more projects");
                lbl.setForeground(Color.red);
                Font f = lbl.getFont();
                lbl.setFont(new Font("Serif", 1, f.getSize() + 3));
                this.getContentPane().add((Component)lbl, "North");
                this.m_btnOK.setText("OK");
            }
            this.getContentPane().add((Component)this.m_widget, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setSize(1200, 500);
            if (this.m_multi_select) {
                this.setTitle("Select one or more projects");
            } else {
                this.setTitle("Select project");
            }
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                if (!this.m_widget.isProjectSelected()) {
                    JOptionPane.showMessageDialog(null, "Please select a project", "", 0);
                    return;
                }
                if (this.m_multi_select) {
                    this.SelectedProjects = this.m_widget.getProjectNames();
                } else {
                    HashMap<String, String> map = SharedApplicationData.singleton().LaunchCodes;
                    String name = this.m_widget.getProjectName();
                    map.put("ProjectName", name);
                    this.ProjectName = name;
                }
                this.OK = true;
                this.loadSaved = this.m_boxLoad.getState();
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

