/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ProjectNameSelectionWidget
extends GridLayoutWidget
implements DocumentListener {
    public ProjectType Type;
    protected boolean nameOK;
    protected GenericObjectListener m_listenerManager = new GenericObjectListener();
    protected JTextField m_nameTextField = new JTextField("");
    protected JLabel m_errorLabel = new JLabel("", 2);
    protected JLabel m_pathLabel = new JLabel("", 2);

    public ProjectNameSelectionWidget(int insets, ProjectType type) {
        super(insets, "Project name");
        try {
            this.Type = type;
            this.m_nameTextField.getDocument().addDocumentListener(this);
            int row = 0;
            this.addComponent(new JLabel("Project names may contain letters, numbers, '-' and '_'"), row, 1, 0.0, 10.0);
            this.addComponent(new JLabel("Name:"), ++row, 0, 0.0, 0.0);
            this.addComponent(this.m_nameTextField, row, 1, 0.0, 10.0);
            this.addComponent(new JLabel("Status:"), ++row, 0);
            this.addComponent(this.m_errorLabel, row, 1, 1.0, 10.0);
            this.addComponent(new JLabel("Project path: "), ++row, 0, 0.0, 0.0);
            this.addComponent(this.m_pathLabel, row, 1, 1.0, 10.0);
            Tools_FontChanger.changeSizeOfFont(this.m_pathLabel, -2);
            ++row;
            this.nameOK = this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setProjectName(String sName) {
        try {
            this.m_nameTextField.setText(sName);
            this.nameOK = this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public GenericObjectListener getListenerController() {
        return this.m_listenerManager;
    }

    public String name() {
        return this.m_nameTextField.getText();
    }

    public void setFileName(String name) {
        try {
            this.m_nameTextField.setText(name);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean checkName() {
        try {
            String path;
            String name = this.m_nameTextField.getText();
            this.m_errorLabel.setText("");
            if (name.length() < 3) {
                this.m_errorLabel.setForeground(Color.red);
                this.m_errorLabel.setText("Name must have at least 3 characters");
                return false;
            }
            if (!Tools_Strings.isAlphaNumeric(name, true, true, true)) {
                this.m_errorLabel.setForeground(Color.red);
                this.m_errorLabel.setText("Spaces and special characters other than '-' and '_' are not allowed");
                return false;
            }
            if (!Tools_Strings.startsWithLetterOrNumber(name)) {
                this.m_errorLabel.setForeground(Color.red);
                this.m_errorLabel.setText("Name must start with a letter or number");
                return false;
            }
            String topPath = "";
            if (this.Type == ProjectType.Statics) {
                topPath = SharedApplicationData.staticsProjectPath();
            } else if (this.Type == ProjectType.AVO) {
                topPath = SharedApplicationData.avoProjectPath();
            } else if (this.Type == ProjectType.Velocity) {
                topPath = SharedApplicationData.velocityProjectPath();
            } else if (this.Type == ProjectType.Geometry) {
                topPath = SharedApplicationData.geometryProjectPath();
            } else if (this.Type == ProjectType.Residual) {
                topPath = SharedApplicationData.residualProjectPath();
            }
            String path2 = path = topPath + "/" + name;
            if (this.Type == ProjectType.Statics) {
                path2 = path + ".xtref";
            } else if (this.Type == ProjectType.Residual) {
                path2 = path + ".xtrsd";
            }
            this.m_pathLabel.setText(path2);
            if (!Tools_FileSystem.exists_path(topPath)) {
                this.m_errorLabel.setForeground(Color.red);
                this.m_errorLabel.setText("Parent path does not exist");
                return false;
            }
            if (Tools_FileSystem.exists_path(path)) {
                this.m_errorLabel.setForeground(Color.red);
                this.m_errorLabel.setText("Project path already exists");
                return false;
            }
            if (Tools_FileSystem.exists_path(path2)) {
                this.m_errorLabel.setForeground(Color.red);
                this.m_errorLabel.setText("Project path already exists");
                return false;
            }
            this.m_errorLabel.setForeground(Color.blue);
            this.m_errorLabel.setText("Name looks okay");
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.m_errorLabel.setText("Exception thrown - check messages");
            return false;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            this.nameOK = this.checkName();
            this.m_listenerManager.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            this.nameOK = this.checkName();
            this.m_listenerManager.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        try {
            this.nameOK = this.checkName();
            this.m_listenerManager.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void disableWidget() {
        try {
            this.m_nameTextField.setEnabled(false);
            this.setEnabled(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void enableWidget() {
        try {
            this.m_nameTextField.setEnabled(true);
            this.setEnabled(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean nameOK() {
        return this.nameOK;
    }

    public static enum ProjectType {
        Statics,
        AVO,
        Volume,
        Velocity,
        Geometry,
        Residual;

    }
}

