/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TraceFrequencyWidget
extends LinearLayoutWidget {
    protected SpectrumPanel m_fullTracePanel = new SpectrumPanel();
    protected SpectrumPanel m_partialTracePanel = new SpectrumPanel();
    protected RadioPanel m_radPanel;
    protected EnsembleTrace m_trace;

    public boolean mouseMoves() {
        return this.m_radPanel.getSelectedIndex() == 1;
    }

    public boolean mouseClicks() {
        return this.m_radPanel.getSelectedIndex() == 2;
    }

    public void setTrace(EnsembleTrace trace) {
        try {
            this.m_trace = trace;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public TraceFrequencyWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            this.m_radPanel = new RadioPanel(LinearLayoutWidget.Direction.Vertical, "Mouse tracking mode", "Do not display trace spectrum", "Show spectrum on mouse moves", "Show spectrum on mouse left-click");
            this.addComponent(this.m_radPanel, 0);
            JLabel lbl = new JLabel("Spectrum for complete trace");
            Tools_FontChanger.changeSizeOfFont(lbl, 3);
            lbl.setForeground(Color.blue);
            this.addComponent(lbl, 0);
            this.addComponent(this.m_fullTracePanel, 10);
            lbl = new JLabel("Spectrum for part of trace trace");
            Tools_FontChanger.changeSizeOfFont(lbl, 3);
            lbl.setForeground(Color.blue);
            this.addComponent(lbl, 0);
            this.addComponent(this.m_partialTracePanel, 10);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected class SpectrumPanel
    extends JPanel {
        protected SpectrumPanel() {
        }
    }
}

