/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Shared.ParameterTreeWidgetManager;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;

public class TraceBackgroundWidget
extends LinearLayoutWidget
implements ActionListener {
    protected JCheckBox m_chkBranch = new JCheckBox("Branch colors");
    protected JCheckBox m_chk = new JCheckBox("Background color");
    protected JButton m_btnColor;
    protected Color m_color = new Color(255, 255, 210);
    protected ParameterTreeWidgetManager m_paramManager = new ParameterTreeWidgetManager();
    protected GenericObjectListener m_listener = new GenericObjectListener();

    public TraceBackgroundWidget(String label) {
        super(LinearLayoutWidget.Direction.Horizontal, 0, label);
        try {
            this.addComponent(this.m_chkBranch, 1);
            this.m_chkBranch.addActionListener(this);
            this.addComponent(this.m_chk, 1);
            this.m_chk.addActionListener(this);
            this.m_btnColor = this.createButton("   ", this, 10);
            this.m_btnColor.setBackground(this.m_color);
            this.m_btnColor.setBorderPainted(false);
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
            this.m_paramManager.addCheckBoxConnector("Back", this.m_chk, false);
            this.m_paramManager.addCheckBoxConnector("Branch", this.m_chkBranch, false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setParentParameterTree(ParameterTree parentTree) {
        try {
            this.m_paramManager.setTree(parentTree.ParameterTree_get("TraceColorOptions"));
            this.m_color = this.m_paramManager.tree().color_get("BackColor", new Color(255, 255, 200));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void saveParameters() {
        try {
            this.m_paramManager.saveParameters();
            if (this.m_paramManager.tree() == null) {
                return;
            }
            this.m_paramManager.tree().color_put("BackColor", this.m_color);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setBackground(Ensemble ensemble) {
        try {
            if (ensemble == null) {
                return;
            }
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                trace.PlotData.ShowBranch = this.m_chkBranch.isSelected();
            }
            boolean isShot = Tools_Ensemble.isShotEnsemble(ensemble) >= 0;
            boolean isRec = Tools_Ensemble.isReceiverEnsemble(ensemble) >= 0;
            ensemble.BackColor = this.m_color;
            boolean bl = ensemble.ColorBackground = (isShot || isRec) && this.m_chk.isSelected();
            if (isRec) {
                ensemble.BackColorTable = "Shot";
            }
            if (isShot) {
                ensemble.BackColorTable = "Receiver";
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Color c;
            if (e.getSource() == this.m_btnColor && (c = JColorChooser.showDialog(this, "Select background color", this.m_color)) != null) {
                this.m_color = c;
                this.m_btnColor.setBackground(this.m_color);
                this.m_listener.broadcast(this, null);
            }
            if (e.getSource() == this.m_chk) {
                this.m_listener.broadcast(this, null);
            }
            if (e.getSource() == this.m_chkBranch) {
                this.m_listener.broadcast(this, null);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

