/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Refraction.DelayTime.SolutionStacksWidget;

public class SolutionsStackWidget_General
extends SolutionStacksWidget
implements ISaveableFrame {
    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Refraction.Tomography.SolutionsStackWidget_General";
    }

    @Override
    public String TAB_LABEL() {
        return "General Shot/rec stacks";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "General shot/receiver stacks";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public SolutionsStackWidget_General() {
        super(3000);
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            project.confirmReceiverColumn_Double("SharedPickTime", 0.0);
            project.confirmShotColumn_Double("SharedPickTime", 0.0);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleShotPicksModified() {
        try {
            if (this.m_groupEnsemble.traceCount() < 1) {
                return;
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            project.confirmReceiverColumn_Double("SharedPickTime", 0.0);
            project.confirmShotColumn_Double("SharedPickTime", 0.0);
            int indexPick = this.m_groupEnsemble.dictionary().getEntryIndex("Trace", "FBP_User");
            int indexGP = this.m_groupEnsemble.dictionary().getEntryIndex("Shot", "SharedPickTime");
            HashMap_Integer map = project.shotMap();
            Table_Abstract table = project.shotTable();
            int columnStackPick = table.column_indexOfColumn("SharedPickTime");
            double factor = 0.01 * Tools_Widget.extractDouble(this.m_textPercentMod, 50.0, 5.0, 100.0);
            for (int n = 0; n < this.m_groupEnsemble.traceCount(); ++n) {
                EnsembleTrace trace = this.m_groupEnsemble.trace(n);
                int row = map.get(trace.StackTraceID);
                double pick = trace.header().getDouble(indexPick);
                double currentPick = trace.header().getDouble(indexGP);
                if (!(pick > -3000.0) || !(pick < 3000.0)) continue;
                pick = currentPick + pick * factor;
                table.putDouble(row, columnStackPick, pick);
                this.database().updateSingleRow_Double("Shot", "SharedPickTime", trace.StackTraceID, pick);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleReceiverPicksModified() {
        try {
            if (this.m_groupEnsemble.traceCount() < 1) {
                return;
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            project.confirmReceiverColumn_Double("SharedPickTime", 0.0);
            project.confirmShotColumn_Double("SharedPickTime", 0.0);
            int indexPick = this.m_groupEnsemble.dictionary().getEntryIndex("Trace", "FBP_User");
            int indexGP = this.m_groupEnsemble.dictionary().getEntryIndex("Receiver", "SharedPickTime");
            HashMap_Integer map = project.receiverMap();
            Table_Abstract table = project.receiverTable();
            int columnStackPick = table.column_indexOfColumn("SharedPickTime");
            double factor = 0.01 * Tools_Widget.extractDouble(this.m_textPercentMod, 50.0, 5.0, 100.0);
            for (int n = 0; n < this.m_groupEnsemble.traceCount(); ++n) {
                EnsembleTrace trace = this.m_groupEnsemble.trace(n);
                int row = map.get(trace.StackTraceID);
                double pick = trace.header().getDouble(indexPick);
                double currentPick = trace.header().getDouble(indexGP);
                if (!(pick > -3000.0) || !(pick < 3000.0)) continue;
                pick = currentPick + pick * factor;
                table.putDouble(row, columnStackPick, pick);
                this.database().updateSingleRow_Double("Receiver", "SharedPickTime", trace.StackTraceID, pick);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

