/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectedTraceOperationsDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    protected int m_recID;
    protected int m_shotID;
    protected int m_numSelected;
    protected int m_numVisible;
    protected Ensemble m_ensemble;
    protected JList<String> m_list = new JList();
    protected JButton m_btnOK = new JButton("Perform operation");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected JLabel m_lbl = new JLabel("", 0);
    protected RadioPanel m_radio;
    protected String m_optionFlipPolarity = "Flip the polarity";
    protected String m_optionKill = "Kill";
    protected JPanel m_mainPanel = new JPanel();
    protected CardLayout m_cardLayout = new CardLayout();
    protected JRadioButton m_radPolJustTraces = new JRadioButton("Flip the polarity of the traces");
    protected JRadioButton m_radPolRecs = new JRadioButton("Flip the polarity of receivers");
    protected JRadioButton m_radPolShots = new JRadioButton("Flip the polarity of the shots");
    protected ButtonGroup m_groupPol = new ButtonGroup();
    public int NumModified = 0;
    public int[] ModifiedIndex = new int[1000];

    public SelectedTraceOperationsDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            this.m_radio = new RadioPanel(LinearLayoutWidget.Direction.Vertical, " ", "Apply the selected operation only to the visible traces", "Apply the selected operation to all traces");
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_lbl.setForeground(Color.blue);
            middle.addComponent(this.m_lbl, 0);
            Tools_FontChanger.changeSizeOfFont(this.m_lbl, 2);
            middle.addComponent(this.m_radio, 0);
            DefaultListModel<String> model = new DefaultListModel<String>();
            model.addElement(this.m_optionFlipPolarity);
            model.addElement(this.m_optionKill);
            this.m_list.getSelectionModel().setSelectionMode(0);
            this.m_list.getSelectionModel().addListSelectionListener(this);
            this.m_list.setModel(model);
            middle.addComponent(new JScrollPane(this.m_list), 0);
            this.m_mainPanel.setLayout(this.m_cardLayout);
            this.m_mainPanel.add((Component)this.createPolarityPanel(), this.m_optionFlipPolarity);
            this.m_mainPanel.add((Component)new JPanel(), this.m_optionKill);
            this.m_list.setSelectedIndex(0);
            middle.addComponent(this.m_mainPanel, 10);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            bottom.addStretch(10);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setSize(this.getSize().width + 100, 100 + this.getSize().height);
            this.setTitle("Perform operation");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected JComponent createPolarityPanel() {
        try {
            LinearLayoutWidget p = LinearLayoutWidget.vert(3, "Polarity options");
            this.m_groupPol.add(this.m_radPolJustTraces);
            this.m_groupPol.add(this.m_radPolRecs);
            this.m_groupPol.add(this.m_radPolShots);
            p.addComponent(this.m_radPolJustTraces, 0);
            p.addComponent(this.m_radPolRecs, 0);
            p.addComponent(this.m_radPolShots, 0);
            this.m_radPolJustTraces.setSelected(true);
            this.m_radPolRecs.setEnabled(false);
            this.m_radPolShots.setEnabled(false);
            p.addStretch(4);
            return p;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void showDialog(Ensemble ensemble) {
        try {
            this.NumModified = 0;
            this.m_ensemble = ensemble;
            this.m_shotID = Tools_Ensemble.isShotEnsemble(ensemble);
            this.m_recID = Tools_Ensemble.isReceiverEnsemble(ensemble);
            this.m_numSelected = 0;
            this.m_numVisible = 0;
            for (int k = 0; k < this.m_ensemble.traceCount(); ++k) {
                if (!this.m_ensemble.trace((int)k).SelectedUsingControlPoints) continue;
                ++this.m_numSelected;
                if (!this.m_ensemble.trace((int)k).PlotData.Visible) continue;
                ++this.m_numVisible;
            }
            String prefix = "";
            this.m_radPolRecs.setEnabled(false);
            this.m_radPolShots.setEnabled(false);
            if (this.m_shotID >= 0) {
                if (this.m_radPolShots.isSelected()) {
                    this.m_radPolJustTraces.setSelected(true);
                }
                this.m_radPolShots.setEnabled(false);
                prefix = "Shot ensemble, ";
            }
            if (this.m_recID >= 0) {
                if (this.m_radPolRecs.isSelected()) {
                    this.m_radPolJustTraces.setSelected(true);
                }
                this.m_radPolRecs.setEnabled(false);
                prefix = "Receiver ensemble, ";
            }
            String label = String.format("%s %d traces selected (%d visible)", prefix, this.m_numSelected, this.m_numVisible);
            this.m_lbl.setText(label);
            this.m_radPolRecs.setEnabled(false);
            this.m_radPolShots.setEnabled(false);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            String method = this.m_list.getSelectedValue();
            this.m_cardLayout.show(this.m_mainPanel, method);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void kill() {
        try {
            long[] indices = this.getIndices(true);
            if (indices == null) {
                return;
            }
            RefractionStaticsProject.singleton().killTraces(indices);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected long[] getIndices(boolean kill) {
        try {
            this.NumModified = 0;
            if (this.ModifiedIndex.length < this.m_ensemble.traceCount()) {
                this.ModifiedIndex = new int[this.m_ensemble.traceCount() + 200];
            }
            long[] indices = null;
            int n = 0;
            if (!this.m_ensemble.dictionary().containsEntry("Trace", "TraceIndex")) {
                return null;
            }
            int headerIndex = this.m_ensemble.dictionary().getEntryIndex("Trace", "TraceIndex");
            int indexKilled = -9999;
            if (kill && this.m_ensemble.dictionary().containsEntry("Trace", "Killed")) {
                indexKilled = this.m_ensemble.dictionary().getEntryIndex("Trace", "Killed");
            }
            if (this.m_radio.getSelectedIndex() == 0) {
                indices = new long[this.m_numVisible];
                for (int k = 0; k < this.m_ensemble.traceCount(); ++k) {
                    if (!this.m_ensemble.trace((int)k).SelectedUsingControlPoints || !this.m_ensemble.trace((int)k).PlotData.Visible) continue;
                    indices[n] = this.m_ensemble.trace(k).header().getLong(headerIndex);
                    this.ModifiedIndex[this.NumModified] = k;
                    ++this.NumModified;
                    ++n;
                    if (indexKilled < 0) continue;
                    this.m_ensemble.trace((int)k).TraceKilled = true;
                    this.m_ensemble.trace(k).header().putInt(indexKilled, 1);
                }
            } else {
                indices = new long[this.m_numSelected];
                for (int k = 0; k < this.m_ensemble.traceCount(); ++k) {
                    if (!this.m_ensemble.trace((int)k).SelectedUsingControlPoints) continue;
                    indices[n] = this.m_ensemble.trace(k).header().getLong(headerIndex);
                    this.ModifiedIndex[this.NumModified] = k;
                    ++this.NumModified;
                    ++n;
                    if (indexKilled < 0) continue;
                    this.m_ensemble.trace((int)k).TraceKilled = true;
                    this.m_ensemble.trace(k).header().putInt(indexKilled, 1);
                }
            }
            return indices;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected void flipPolarity_Traces() {
        try {
            long[] indices = this.getIndices(false);
            if (indices == null) {
                return;
            }
            RefractionStaticsProject.singleton().flipTracePolarity(indices);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void flipPolarity_Shots() {
        try {
            long[] indices = this.getIndices(false);
            if (indices == null) {
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void flipPolarity_Recs() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                String method = this.m_list.getSelectedValue();
                if (method.equalsIgnoreCase(this.m_optionFlipPolarity)) {
                    if (this.m_radPolJustTraces.isSelected()) {
                        this.flipPolarity_Traces();
                    }
                    if (this.m_radPolRecs.isSelected()) {
                        this.flipPolarity_Recs();
                    }
                    if (this.m_radPolShots.isSelected()) {
                        this.flipPolarity_Shots();
                    }
                }
                if (method.equalsIgnoreCase(this.m_optionKill)) {
                    this.kill();
                }
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

