/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleGroupManager;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Ensemble.Tools_Picking;
import com.PecosLibrary.Math.LineFit;
import com.PecosLibrary.Refraction.MoveoutTrendData;
import com.PecosLibrary.Refraction.PickEvent;
import com.PecosLibrary.Refraction.PickerGizmo;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class PreviousPicksWidget
extends LinearLayoutWidget
implements ActionListener {
    protected EnsembleWorker_Sequence m_sequence;
    protected JRadioButton m_offButton = new JRadioButton("Off");
    protected JRadioButton m_pickButton = new JRadioButton("Pick next ensemble based on current picks");
    protected JRadioButton m_tickButton = new JRadioButton("Just add a tick mark based on current picks");
    protected JCheckBox m_overwriteCheck = new JCheckBox("Overwrite existing picks");
    protected JCheckBox m_newLogicCheck = new JCheckBox("Use new logic (shot plane only!)");
    protected ButtonGroup m_group = new ButtonGroup();
    protected JButton m_clearStatisticsButton = new JButton("Clear internal statistics");
    protected float[] m_traceData = new float[1000];
    protected Ensemble m_tempEnsemble = new Ensemble();
    protected EnsembleGroupManager m_groupManager = new EnsembleGroupManager();
    protected LineFit m_lineFit = new LineFit();
    protected double m_lineVelocity = 2000.0;
    protected double m_offsetBinSize = 500.0;
    protected ArrayList<OffsetBin> m_offsetBinList = new ArrayList();
    protected int m_maxOffsetBinIndex = 0;
    protected boolean m_feet = false;
    protected double m_averageVel = 3000.0;
    protected ArrayList<PriorPickData> m_pickData = new ArrayList();
    protected int m_numValidPicks = 0;
    protected HashMap_Integers<PriorPickData> m_recHash = new HashMap_Integers();
    protected boolean m_priorShotGather = false;

    public PreviousPicksWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            String s = "<HTML>Picks made on the current ensemble may be used to predict picks on the next. \n</HTML>";
            JLabel lbl = new JLabel(s);
            lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            this.addComponent(lbl, 0);
            LinearLayoutWidget sub = this.createVertical(0, null, 0);
            sub.setBorder(BorderFactory.createRaisedBevelBorder());
            sub.addComponent(this.m_offButton, 0);
            this.m_offButton.addActionListener(this);
            this.m_group.add(this.m_offButton);
            sub.createGapLabel(12);
            sub.addComponent(this.m_tickButton, 0);
            this.m_tickButton.addActionListener(this);
            this.m_group.add(this.m_tickButton);
            s = "<HTML>This option adds a magenta X at the predicted time. It does not snap to the nearest event</HTML>";
            sub.addComponent(new JLabel(s), 0);
            sub.createGapLabel(12);
            sub.addComponent(this.m_pickButton, 0);
            LinearLayoutWidget sub2 = sub.createHorizontal(3, null, 0);
            sub2.createGapLabel(20);
            sub2.addComponent(this.m_overwriteCheck, 10);
            this.m_overwriteCheck.setSelected(false);
            this.m_overwriteCheck.setEnabled(false);
            this.m_pickButton.addActionListener(this);
            this.m_group.add(this.m_pickButton);
            s = "<HTML>This option also adds a magenta X at the predicted time. It then uses this time to make a user pick.</HTML>";
            sub.addComponent(new JLabel(s), 0);
            this.createGapLabel(10);
            this.addComponent(this.m_clearStatisticsButton, 0);
            this.m_clearStatisticsButton.addActionListener(this);
            this.createGapLabel(20);
            this.addComponent(this.m_newLogicCheck, 0);
            this.m_offButton.setSelected(true);
            this.addStretch(10);
            this.m_feet = RefractionStaticsProject.singleton().units_feet();
            double maxOff = 1000.0;
            if (this.m_feet) {
                this.m_offsetBinSize = 1000.0;
                maxOff = 30000.0;
            } else {
                this.m_offsetBinSize = 250.0;
                maxOff = 10000.0;
            }
            int num = (int)(0.5 * maxOff / this.m_offsetBinSize);
            for (int n = 0; n < num; ++n) {
                this.m_offsetBinList.add(new OffsetBin());
            }
            this.m_maxOffsetBinIndex = this.m_offsetBinList.size() - 1;
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_clearStatisticsButton) {
                for (OffsetBin bin : this.m_offsetBinList) {
                    bin.SumVelocity = 0.0;
                    bin.Count = 1.0E-5;
                    bin.Velocity = 3000.0;
                }
            }
            this.m_overwriteCheck.setEnabled(this.m_pickButton.isSelected());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setSequence(EnsembleWorker_Sequence sequence) {
        this.m_sequence = sequence;
    }

    protected void prepPriorPicks(Ensemble ensemble) {
        try {
            this.m_lineFit.clear();
            this.m_recHash.clear();
            this.m_numValidPicks = 0;
            int shotID = Tools_Ensemble.isShotEnsemble(ensemble);
            this.m_priorShotGather = shotID >= 1;
            int indexOff = ensemble.dictionary().getEntryIndex_ReturnInvalid("Trace", "Offset");
            int indexPick = ensemble.dictionary().getEntryIndex_ReturnInvalid("Trace", "FBP_User");
            int indexShotID = ensemble.dictionary().getEntryIndex_ReturnInvalid("Trace", "ShotID");
            int indexRecID = ensemble.dictionary().getEntryIndex_ReturnInvalid("Trace", "ReceiverID");
            int indexShotX = ensemble.dictionary().getEntryIndex_ReturnInvalid("Shot", "Easting");
            int indexShotY = ensemble.dictionary().getEntryIndex_ReturnInvalid("Shot", "Northing");
            int indexRecX = ensemble.dictionary().getEntryIndex_ReturnInvalid("Receiver", "Easting");
            int indexRecY = ensemble.dictionary().getEntryIndex_ReturnInvalid("Receiver", "Northing");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                Column_Abstract header = ensemble.trace(n).header();
                double pick = header.getDouble(indexPick);
                double off = header.getDouble(indexOff);
                if (!(off > 1.0) || !(pick > 1.0)) continue;
                while (this.m_numValidPicks >= this.m_pickData.size()) {
                    this.m_pickData.add(new PriorPickData());
                }
                PriorPickData ppd = this.m_pickData.get(this.m_numValidPicks);
                ppd.Offset = off;
                ppd.Pick = pick;
                ppd.ReceiverX = header.getDouble(indexRecX);
                ppd.ReceiverY = header.getDouble(indexRecY);
                ppd.ShotX = header.getDouble(indexShotX);
                ppd.ShotY = header.getDouble(indexShotY);
                ppd.ReceiverID = header.getInt(indexRecID);
                ppd.ShotID = header.getInt(indexShotID);
                this.m_recHash.put(ppd, ppd.ReceiverID);
                this.m_lineFit.add(off, pick);
                ++this.m_numValidPicks;
            }
            this.m_lineFit.compute();
            this.m_lineVelocity = 5000.0;
            if (this.m_lineFit.valid()) {
                this.m_lineVelocity = 1000.0 / this.m_lineFit.A;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void updateMoveoutCurves() {
        try {
            for (int n = 0; n < this.m_numValidPicks; ++n) {
                PriorPickData ppd = this.m_pickData.get(n);
                double pick = ppd.Pick;
                double off = ppd.Offset;
                double vel = 1000.0 * off / pick;
                int binIndex = (int)(off / this.m_offsetBinSize);
                for (int b = binIndex - 2; b <= binIndex + 2; ++b) {
                    if (b < 0 || b > this.m_maxOffsetBinIndex) continue;
                    OffsetBin bin = this.m_offsetBinList.get(b);
                    bin.SumVelocity += vel;
                    bin.Count += 1.0;
                }
            }
            double sum = 0.0;
            double count = 1.0E-6;
            for (OffsetBin bin : this.m_offsetBinList) {
                if (!(bin.Count > 0.5)) continue;
                bin.Velocity = bin.SumVelocity / bin.Count;
                sum += bin.Velocity * bin.Count;
                count += bin.Count;
            }
            this.m_averageVel = sum / count;
            if (this.m_feet) {
                this.m_averageVel = Math.max(this.m_averageVel, 2000.0);
                this.m_averageVel = Math.min(this.m_averageVel, 20000.0);
            } else {
                this.m_averageVel = Math.max(this.m_averageVel, 700.0);
                this.m_averageVel = Math.min(this.m_averageVel, 7000.0);
            }
            for (OffsetBin bin : this.m_offsetBinList) {
                if (!(bin.Count < 0.5)) continue;
                bin.Velocity = this.m_averageVel;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setPriorEnsemble(Ensemble ensemble) {
        try {
            this.prepPriorPicks(ensemble);
            this.updateMoveoutCurves();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void makePreliminaryTicks(Ensemble ensemble) {
        try {
            MoveoutTrendData trend = RefractionStaticsProject.singleton().moveoutTrendData();
            boolean trendOkay = trend.numValidLocations(true) > 0;
            int indexOff = ensemble.dictionary().getEntryIndex_ReturnInvalid("Trace", "Offset");
            int indexPick = ensemble.dictionary().getEntryIndex_ReturnInvalid("Trace", "FBP_User");
            int indexShotID = ensemble.dictionary().getEntryIndex_ReturnInvalid("Trace", "ShotID");
            int indexRecID = ensemble.dictionary().getEntryIndex_ReturnInvalid("Trace", "ReceiverID");
            int indexShotX = ensemble.dictionary().getEntryIndex_ReturnInvalid("Shot", "Easting");
            int indexShotY = ensemble.dictionary().getEntryIndex_ReturnInvalid("Shot", "Northing");
            int indexRecX = ensemble.dictionary().getEntryIndex_ReturnInvalid("Receiver", "Easting");
            int indexRecY = ensemble.dictionary().getEntryIndex_ReturnInvalid("Receiver", "Northing");
            int indexPPP = ensemble.dictionary().addEntry("Trace", "FBP_PriorPick", DataType.Double);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                Column_Abstract header = ensemble.trace(n).header();
                int shotID = header.getInt(indexShotID);
                int recID = header.getInt(indexRecID);
                double off = header.getDouble(indexOff);
                double sx = header.getDouble(indexShotX);
                double sy = header.getDouble(indexShotY);
                double rx = header.getDouble(indexRecX);
                double ry = header.getDouble(indexRecY);
                double mx = 0.5 * (sx + rx);
                double my = 0.5 * (sy + ry);
                double vel = this.m_averageVel;
                if (trendOkay) {
                    vel = trend.getVelocity(mx, my, (float)off);
                }
                double predicted = -9999.0;
                for (int k = 0; k < this.m_numValidPicks && predicted < 0.0; ++k) {
                    PriorPickData ppd = this.m_pickData.get(k);
                    if (ppd.ShotID != shotID && ppd.ReceiverID != recID) continue;
                    predicted = ppd.Pick + 1000.0 * (off - ppd.Offset) / vel;
                }
                header.putDouble(indexPPP, predicted);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void makeShotTicks(Ensemble ensemble) {
        try {
            MoveoutTrendData trend = RefractionStaticsProject.singleton().moveoutTrendData();
            boolean trendOkay = trend.numValidLocations(true) > 0;
            int indexOff = ensemble.dictionary().getEntryIndex_ReturnInvalid("Trace", "Offset");
            int indexPick = ensemble.dictionary().getEntryIndex_ReturnInvalid("Trace", "FBP_User");
            int indexShotID = ensemble.dictionary().getEntryIndex_ReturnInvalid("Trace", "ShotID");
            int indexRecID = ensemble.dictionary().getEntryIndex_ReturnInvalid("Trace", "ReceiverID");
            int indexShotX = ensemble.dictionary().getEntryIndex_ReturnInvalid("Shot", "Easting");
            int indexShotY = ensemble.dictionary().getEntryIndex_ReturnInvalid("Shot", "Northing");
            int indexRecX = ensemble.dictionary().getEntryIndex_ReturnInvalid("Receiver", "Easting");
            int indexRecY = ensemble.dictionary().getEntryIndex_ReturnInvalid("Receiver", "Northing");
            int indexPPP = ensemble.dictionary().addEntry("Trace", "FBP_PriorPick", DataType.Double);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                Column_Abstract header = ensemble.trace(n).header();
                int shotID = header.getInt(indexShotID);
                int recID = header.getInt(indexRecID);
                double off = header.getDouble(indexOff);
                double predicted = -9999.0;
                if (this.m_recHash.containsKey(recID)) {
                    PriorPickData ppd = this.m_recHash.get(recID);
                    double offsetDiff = off - ppd.Offset;
                    double timeDiff = 1000.0 * offsetDiff / this.m_lineVelocity;
                    predicted = ppd.Pick + timeDiff;
                }
                header.putDouble(indexPPP, predicted);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void makeSecondaryTicks_ShotPlane(Ensemble ensemble) {
        try {
            this.m_groupManager.setParentEnsemble(ensemble);
            this.m_groupManager.prepareGroupsBasedOnInteger("Shot", "LineNumber");
            MoveoutTrendData trend = RefractionStaticsProject.singleton().moveoutTrendData();
            boolean trendOkay = trend.numValidLocations(true) > 0;
            int indexOff = ensemble.dictionary().getEntryIndex_ReturnInvalid("Trace", "Offset");
            int indexPick = ensemble.dictionary().getEntryIndex_ReturnInvalid("Trace", "FBP_User");
            int indexShotID = ensemble.dictionary().getEntryIndex_ReturnInvalid("Trace", "ShotID");
            int indexRecID = ensemble.dictionary().getEntryIndex_ReturnInvalid("Trace", "ReceiverID");
            int indexLine = ensemble.dictionary().getEntryIndex_ReturnInvalid("Shot", "LineNumber");
            int indexPoint = ensemble.dictionary().getEntryIndex_ReturnInvalid("Shot", "PointNumber");
            int indexShotX = ensemble.dictionary().getEntryIndex_ReturnInvalid("Shot", "Easting");
            int indexShotY = ensemble.dictionary().getEntryIndex_ReturnInvalid("Shot", "Northing");
            int indexRecX = ensemble.dictionary().getEntryIndex_ReturnInvalid("Receiver", "Easting");
            int indexRecY = ensemble.dictionary().getEntryIndex_ReturnInvalid("Receiver", "Northing");
            int indexPPP = ensemble.dictionary().addEntry("Trace", "FBP_PriorPick", DataType.Double);
            for (int group = 0; group < this.m_groupManager.GroupList.size(); ++group) {
                int n;
                Ensemble groupEnsemble = this.m_groupManager.GroupList.get((int)group).GroupEnsemble;
                int numValid = 0;
                for (n = 0; n < groupEnsemble.traceCount(); ++n) {
                    EnsembleTrace trace = groupEnsemble.trace(n);
                    Column_Abstract header = trace.header();
                    double tick = header.getDouble(indexPPP);
                    boolean bl = trace.Marker = tick > 0.0;
                    if (!trace.Marker) continue;
                    ++numValid;
                }
                if (numValid <= 0 || numValid >= groupEnsemble.traceCount()) continue;
                for (n = 0; n < groupEnsemble.traceCount(); ++n) {
                    Column_Abstract header = groupEnsemble.trace(n).header();
                    EnsembleTrace trace = groupEnsemble.trace(n);
                    if (trace.Marker) continue;
                    double sum = 0.0;
                    double sumWeight = 1.0E-70;
                    double off = header.getDouble(indexOff);
                    double sx = header.getDouble(indexShotX);
                    double sy = header.getDouble(indexShotY);
                    double rx = header.getDouble(indexRecX);
                    double ry = header.getDouble(indexRecY);
                    double mx = 0.5 * (sx + rx);
                    double my = 0.5 * (sy + ry);
                    double vel = this.m_averageVel;
                    if (trendOkay) {
                        vel = trend.getVelocity(mx, my, (float)off);
                    }
                    for (int k = 0; k < groupEnsemble.traceCount(); ++k) {
                        EnsembleTrace tt = groupEnsemble.trace(k);
                        Column_Abstract ht = tt.header();
                        double tick = ht.getDouble(indexPPP);
                        if (!tt.Marker) continue;
                        double off1 = ht.getDouble(indexOff);
                        double dx = rx - ht.getDouble(indexRecX);
                        double dy = ry - ht.getDouble(indexRecY);
                        double w = 1.0 / (1.0 + dx * dx + dy * dy);
                        double p = tick + 1000.0 * (off - off1) / vel;
                        sum += p * w;
                        sumWeight += w;
                    }
                    double pred = sum / sumWeight;
                    header.putDouble(indexPPP, pred);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void makeUserPicks(Ensemble e) {
        try {
            e.copyToOtherEnsemble(this.m_tempEnsemble);
            this.m_sequence.work(this.m_tempEnsemble);
            int indexPPP = this.m_tempEnsemble.dictionary().addEntry("Trace", "FBP_PriorPick", DataType.Double);
            int indexUser = this.m_tempEnsemble.dictionary().addEntry("Trace", "FBP_User", DataType.Double);
            boolean overwrite = this.m_overwriteCheck.isSelected();
            PickEvent pickEvent = PickerGizmo.singleton().pickEvent();
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (!project.valid()) {
                return;
            }
            ITraceTable table = project.traceTableWrapper().traceTable();
            if (!this.m_tempEnsemble.dictionary().containsEntry("Trace", "TraceIndex")) {
                return;
            }
            int tablePickIndex = table.column_indexOfColumn("FBP_User");
            int headerIndex = this.m_tempEnsemble.dictionary().getEntryIndex("Trace", "TraceIndex");
            for (int n = 0; n < this.m_tempEnsemble.traceCount(); ++n) {
                EnsembleTrace trace = this.m_tempEnsemble.trace(n);
                Column_Abstract header = trace.header();
                FloatArrayWrapper data = trace.data();
                float userPick = header.getFloat(indexUser);
                float priorPick = header.getFloat(indexPPP);
                boolean ok = priorPick > 0.0f;
                boolean bl = ok = ok && (userPick <= 0.0f || overwrite);
                if (!ok || data.length() <= 10) continue;
                if (this.m_traceData.length < data.length()) {
                    this.m_traceData = new float[data.length()];
                }
                data.copyToArray(this.m_traceData);
                double time0 = data.getFirstSampleCoord_Initial();
                int startSample = (int)(((double)priorPick - time0) / (double)data.getSampleInterval());
                double nearestSample = Tools_Picking.getNearestEvent(this.m_traceData, data.length(), pickEvent, startSample, false);
                if (!(nearestSample > 0.0)) continue;
                double pickTime = nearestSample * (double)data.getSampleInterval() + (double)data.getFirstSampleCoord_Initial();
                trace.header().putDouble(indexUser, pickTime);
                long rowInTable = trace.header().getLong(headerIndex);
                table.putFloat(rowInTable, tablePickIndex, (float)pickTime);
            }
            table.saveCurrentSection();
            int indexInputUser = e.dictionary().addEntry("Trace", "FBP_User", DataType.Double);
            for (int n = 0; n < this.m_tempEnsemble.traceCount(); ++n) {
                float pick = this.m_tempEnsemble.trace(n).header().getFloat(indexUser);
                e.trace(n).header().putFloat(indexInputUser, pick);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setCurrentEnsemble(Ensemble ensemble) {
        try {
            int indexPPP = ensemble.dictionary().addEntry("Trace", "FBP_PriorPick", DataType.Double);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                Column_Abstract header = ensemble.trace(n).header();
                header.putDouble(indexPPP, -9999.0);
            }
            if (this.m_offButton.isSelected()) {
                return;
            }
            if (this.m_numValidPicks < 1) {
                return;
            }
            int shotID = Tools_Ensemble.isShotEnsemble(ensemble);
            if (this.m_newLogicCheck.isSelected()) {
                if (shotID >= 0 && this.m_priorShotGather) {
                    this.makeShotTicks(ensemble);
                }
            } else {
                this.makePreliminaryTicks(ensemble);
                if (shotID >= 0) {
                    this.makeSecondaryTicks_ShotPlane(ensemble);
                }
            }
            if (this.m_tickButton.isSelected()) {
                return;
            }
            this.makeUserPicks(ensemble);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected class OffsetBin {
        public double SumVelocity = 0.0;
        public double Count = 1.0E-7;
        public double Velocity = 3000.0;

        protected OffsetBin() {
        }
    }

    protected class PriorPickData {
        public int ShotID;
        public int ReceiverID;
        public double ShotX;
        public double ShotY;
        public double ReceiverX;
        public double ReceiverY;
        public double Pick;
        public double Offset;

        protected PriorPickData() {
        }
    }
}

