/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.ITraceTableScannerMonitor;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.TraceTable.TraceTable_Scanner_SetValue;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Shared.PolygonUsageWidget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PickKillDialog
extends JDialog
implements ActionListener,
ItemListener,
ITraceTableScannerMonitor {
    protected ArrayList<FilterPanelEntry> m_filterList = new ArrayList();
    protected JButton m_btnOK = new JButton("Kill picks");
    protected JButton m_btnCancel = new JButton("Close");
    protected JRadioButton m_allRadio = new JRadioButton("Show all columns");
    protected JRadioButton m_fbpRadio = new JRadioButton("Just show FBP columns");
    protected ButtonGroup m_group = new ButtonGroup();
    protected ComboStringListWrapper m_combo = new ComboStringListWrapper();
    protected PolygonUsageWidget m_polygonWidget = new PolygonUsageWidget();
    protected JCheckBox m_killOutsideBranch = new JCheckBox("Only kill picks not assigned to a branch");
    protected JTextField m_txtMinOffset = new JTextField("0");
    protected JTextField m_txtMaxOffset = new JTextField("100000");
    protected JProgressBar m_progress = new JProgressBar();
    public boolean OK = false;
    protected boolean m_offsetRange;

    public PickKillDialog(boolean offsetRange) {
        try {
            LinearLayoutWidget sub;
            this.m_offsetRange = offsetRange;
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            GridLayoutWidget grid = middle.createGridLayoutWidget(3, "Select pick version", 0);
            grid.addSimple(0, new JLabel("Version"), this.m_combo);
            this.m_combo.setPreferredSelected("FBP_User");
            if (!this.m_offsetRange) {
                sub = middle.createVertical(3, "Column options", 0);
                this.m_group.add(this.m_fbpRadio);
                this.m_group.add(this.m_allRadio);
                this.m_fbpRadio.addActionListener(this);
                this.m_allRadio.addActionListener(this);
                sub.addComponent(this.m_fbpRadio, 0);
                sub.addComponent(this.m_allRadio, 0);
                this.m_fbpRadio.setSelected(true);
            }
            if (this.m_offsetRange) {
                grid = middle.createGridLayoutWidget(3, "Offset range options", 0);
                grid.addSimple(0, new JLabel("Minimum offset"), this.m_txtMinOffset);
                grid.addSimple(1, new JLabel("Maximum offset"), this.m_txtMaxOffset);
            }
            if (!this.m_offsetRange) {
                sub = middle.createVertical(3, "Branch options", 0);
                sub.addComponent(this.m_killOutsideBranch, 0);
                middle.addComponent(this.m_polygonWidget, 0);
                GridLayoutWidget filterGrid = middle.createGridLayoutWidget(2, "Column filter options", 0);
                int row = 0;
                JLabel lbl = new JLabel("Note: all selected filters must be valid before the pick is killed");
                lbl.setForeground(Color.blue);
                filterGrid.addComponent(lbl, row, 0, 1.0, 1.0, 1, 5);
                ++row;
                int colOn = 0;
                int colTable = 1;
                int colCol = 2;
                int colMin = 3;
                int colMax = 4;
                filterGrid.addComponent(new JLabel("On?"), row, colOn, 1.0, 1.0);
                filterGrid.addComponent(new JLabel("Table"), row, colTable, 1.0, 1.0);
                filterGrid.addComponent(new JLabel("Column"), row, colCol, 1.0, 21.0);
                filterGrid.addComponent(new JLabel("Minimum"), row, colMin, 1.0, 1.0);
                filterGrid.addComponent(new JLabel("Maximum"), row, colMax, 1.0, 1.0);
                ++row;
                for (int k = 0; k < 4; ++k) {
                    FilterPanelEntry panel = new FilterPanelEntry();
                    filterGrid.addComponent(panel.OnCheck, row, colOn, 1.0, 1.0);
                    filterGrid.addComponent(panel.TableCombo, row, colTable, 1.0, 1.0);
                    filterGrid.addComponent(panel.ColumnCombo, row, colCol, 1.0, 21.0);
                    filterGrid.addComponent(panel.MinText, row, colMin, 1.0, 1.0);
                    filterGrid.addComponent(panel.MaxText, row, colMax, 1.0, 1.0);
                    panel.TableCombo.addItemListener(this);
                    this.m_filterList.add(panel);
                    ++row;
                }
            }
            this.m_progress.setMaximum(1000);
            middle.addComponent(this.m_progress, 0);
            middle.addStretch(10);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            bottom.addStretch(10);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setSize(this.getSize().width + 300, this.getSize().height);
            this.setTitle("Kill picks");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setPercentDone(double percent) {
        try {
            percent = Math.max(percent, 0.0);
            percent = Math.min(percent, 99.99);
            this.m_progress.setValue((int)(10.0 * percent));
            this.m_progress.paintImmediately(0, 0, 500, 30);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setMessage(String message) {
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadFilterColumns() {
        try {
            ArrayList<String> recCols = this.database().listOfColumnNames("Receiver");
            ArrayList<String> shotCols = this.database().listOfColumnNames("Shot");
            ArrayList<String> traceCols = new ArrayList<String>();
            traceCols.add("Offset");
            for (FilterPanelEntry panel : this.m_filterList) {
                if (panel.TableCombo.getSelectedIndex() == 0) {
                    panel.ColumnCombo.setStringArray(shotCols);
                    continue;
                }
                if (panel.TableCombo.getSelectedIndex() == 1) {
                    panel.ColumnCombo.setStringArray(recCols);
                    continue;
                }
                panel.ColumnCombo.setStringArray(traceCols);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.reloadFilterColumns();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void loadColumns() {
        try {
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            ArrayList<String> cols = null;
            cols = this.m_fbpRadio.isSelected() ? table.columns("FBP_") : table.columns();
            this.m_combo.setStringArray(cols);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            this.OK = false;
            this.loadColumns();
            this.m_polygonWidget.updateChecks();
            this.reloadFilterColumns();
            this.m_progress.setValue(0);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean dataOK() {
        try {
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_allRadio || e.getSource() == this.m_fbpRadio) {
                this.loadColumns();
                return;
            }
            if (e.getSource() == this.m_btnOK) {
                boolean fixed;
                ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
                String col = this.m_combo.getSelectedString();
                boolean bl = fixed = col.equalsIgnoreCase("ShotID") || col.equalsIgnoreCase("ReceiverID") || col.equalsIgnoreCase("Inline") || col.equalsIgnoreCase("Crossline") || col.equalsIgnoreCase("FileID") || col.equalsIgnoreCase("IndexInFile");
                if (fixed) {
                    JOptionPane.showMessageDialog(null, "Cannot modify a required column", "Cannot copy column", 0);
                    return;
                }
                int res = JOptionPane.showConfirmDialog(this, "Okay to overwrite contents of " + col + "?", "Confirm pick kill", 2, 2, null);
                if (res != 0) {
                    return;
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                TraceTable_Scanner_SetValue killer = new TraceTable_Scanner_SetValue();
                killer.Value = -9999.0f;
                killer.ColumnIndex = table.column_indexOfColumn(col);
                killer.SetIfInsideOffsetRange = this.m_offsetRange;
                killer.MinimumOffset = Tools_Widget.extractDouble(this.m_txtMinOffset, 0.0, 0.0, 40000.0);
                killer.MaximumOffset = Tools_Widget.extractDouble(this.m_txtMaxOffset, 20000.0, 0.0, 40000.0);
                killer.CheckIfMidInsidePolygon = this.m_polygonWidget.midpointInside();
                killer.CheckIfRecInsidePolygon = this.m_polygonWidget.receiverInside();
                killer.CheckIfShotInsidePolygon = this.m_polygonWidget.shotInside();
                killer.RequireOutsideBranch = this.m_killOutsideBranch.isSelected();
                for (FilterPanelEntry panel : this.m_filterList) {
                    if (!panel.OnCheck.isSelected()) continue;
                    killer.addColumnSelector(panel.table(), panel.column(), panel.min(), panel.max());
                }
                killer.scan(table, this);
                this.setCursor(Cursor.getDefaultCursor());
                this.m_progress.setValue(0);
                this.OK = true;
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            this.setCursor(Cursor.getDefaultCursor());
            ExceptionMonitor.add(error);
        }
    }

    protected class FilterPanelEntry {
        public JCheckBox OnCheck = new JCheckBox("Apply");
        public JComboBox<String> TableCombo = new JComboBox();
        public ComboStringListWrapper ColumnCombo = new ComboStringListWrapper();
        public JTextField MinText = new JTextField("0");
        public JTextField MaxText = new JTextField("1000");

        public FilterPanelEntry() {
            this.TableCombo.addItem("Shot");
            this.TableCombo.addItem("Receiver");
            this.TableCombo.addItem("Trace");
            this.TableCombo.setSelectedIndex(0);
        }

        public double min() {
            return Tools_Widget.extractDouble(this.MinText, 0.0, -1.0E30, 1.0E30);
        }

        public double max() {
            return Tools_Widget.extractDouble(this.MaxText, 0.0, -1.0E30, 1.0E30);
        }

        public String column() {
            try {
                return this.ColumnCombo.getSelectedString();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return null;
            }
        }

        public String table() {
            if (this.TableCombo.getSelectedIndex() == 0) {
                return "Shot";
            }
            if (this.TableCombo.getSelectedIndex() == 1) {
                return "Receiver";
            }
            return "Trace";
        }
    }
}

