/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.ITraceTableScannerMonitor;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.TraceTable.TraceTable_Scanner_AsciiCoordExport;
import com.PecosLibrary.Data.TraceTable.TraceTable_Scanner_AsciiCoordImport;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.Picking.AddPickVersionDialog;
import com.PecosLibrary.Windows.Shared.FileWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;

public class PickImportWithCoordsDialog
extends JDialog
implements ActionListener,
ITraceTableScannerMonitor {
    protected JButton m_btnAddVersion = new JButton("Add pick version");
    protected JButton m_btnOK = new JButton("Import");
    protected JButton m_btnCancel = new JButton("Close");
    protected FileWidget m_fileWidget;
    protected ComboStringListWrapper m_pickCombo = new ComboStringListWrapper();
    protected JProgressBar m_progress = new JProgressBar();
    protected JLabel m_progressLabel = new JLabel(" ");
    public boolean OK = false;
    protected boolean m_export;
    protected boolean m_ascii;
    protected MethodIO m_method = MethodIO.Coords;
    protected ButtonGroup m_exclusionGroup = new ButtonGroup();
    protected JRadioButton m_radioIncludeAll = new JRadioButton("Export all picks");
    protected JRadioButton m_radioOverwriteDead = new JRadioButton("Export (-9999) for dead shots and receivers");
    protected JRadioButton m_radioExcludeAll = new JRadioButton("Do not export dead shots and receivers, or null picks");
    protected JCheckBox m_chkOverwriteValid = new JCheckBox("Overwrite valid (pick value > -9999) picks");
    protected HashMap_Integers<TraceTable_Scanner_AsciiCoordImport.ShotCoordData> m_map = new HashMap_Integers();
    protected HashMap_Integers<TraceTable_Scanner_AsciiCoordImport.ShotFFIDData> m_mapFFID = new HashMap_Integers();
    protected HashMap_Integers<TraceTable_Scanner_AsciiCoordImport.ShotLinePointData> m_mapCombined = new HashMap_Integers();
    protected HashMap_Integers<TraceTable_Scanner_AsciiCoordImport.ShotLinePointData> m_mapSeparate = new HashMap_Integers();
    protected AddPickVersionDialog m_pickAddDialog = new AddPickVersionDialog();

    public PickImportWithCoordsDialog(boolean export, MethodIO method, boolean ascii) {
        try {
            this.m_ascii = ascii;
            this.m_export = export;
            this.m_method = method;
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            LinearLayoutWidget sub = middle.createVertical(3, "Select pick column name", 0);
            sub.addComponent(this.m_pickCombo, 0);
            if (this.m_export) {
                this.m_fileWidget = this.m_ascii ? new FileWidget(false, false, 3, "ASCII file name", null) : new FileWidget(false, false, 3, "Binary file name", null);
                this.m_fileWidget.OpenFile = false;
                middle.addComponent(this.m_radioIncludeAll, 0);
                middle.addComponent(this.m_radioOverwriteDead, 0);
                middle.addComponent(this.m_radioExcludeAll, 0);
                this.m_exclusionGroup.add(this.m_radioIncludeAll);
                this.m_exclusionGroup.add(this.m_radioOverwriteDead);
                this.m_exclusionGroup.add(this.m_radioExcludeAll);
                this.m_radioIncludeAll.addActionListener(this);
                this.m_radioOverwriteDead.addActionListener(this);
                this.m_radioExcludeAll.addActionListener(this);
                this.m_radioIncludeAll.setSelected(true);
                this.m_btnOK.setText("Export");
                if (this.m_method == MethodIO.Coords) {
                    this.setTitle("Export picks using coordinates");
                }
                if (this.m_method == MethodIO.FFID) {
                    this.setTitle("Export picks using FFID/Channel");
                }
                if (this.m_method == MethodIO.FFIDPointNumber) {
                    this.setTitle("Export picks using FFID/Receiver PointNumber");
                }
                if (this.m_method == MethodIO.CombinedLinePoint) {
                    this.setTitle("Export picks using combined line/point");
                }
                if (this.m_method == MethodIO.LinePoint) {
                    this.setTitle("Export picks using separate line/point");
                }
            } else {
                this.m_fileWidget = new FileWidget(false, false, 3, "ASCII file name", null);
                middle.addComponent(this.m_chkOverwriteValid, 0);
                this.m_chkOverwriteValid.setSelected(true);
                if (this.m_method == MethodIO.Coords) {
                    this.setTitle("Import picks using coordinates");
                }
                if (this.m_method == MethodIO.FFID) {
                    this.setTitle("Import picks using FFID/Channel");
                }
                if (this.m_method == MethodIO.FFIDPointNumber) {
                    this.setTitle("Import picks using FFID/Receiver PointNumber");
                }
                if (this.m_method == MethodIO.CombinedLinePoint) {
                    this.setTitle("Import picks using combined line/point");
                }
                if (this.m_method == MethodIO.LinePoint) {
                    this.setTitle("Import picks using separate line/point");
                }
            }
            middle.addComponent(this.m_fileWidget, 0);
            this.m_progress.setMaximum(1000);
            middle.addComponent(this.m_progress, 0);
            this.m_progress.setStringPainted(true);
            middle.addComponent(this.m_progressLabel, 0);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            bottom.addStretch(10);
            bottom.addComponent(this.m_btnAddVersion, 0);
            this.m_btnAddVersion.addActionListener(this);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setSize(this.getSize().width + 100, this.getSize().height);
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setPercentDone(double percent) {
        try {
            percent = Math.max(percent, 0.0);
            percent = Math.min(percent, 99.99);
            this.m_progress.setValue((int)(10.0 * percent));
            int p = (int)percent;
            this.m_progress.setString(Integer.toString(p) + "%");
            this.m_progress.paintImmediately(0, 0, 500, 30);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setMessage(String message) {
    }

    protected void loadColumns() {
        try {
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            ArrayList<String> cols = table.columns("FBP_");
            this.m_pickCombo.setStringArray(cols);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            this.OK = false;
            this.loadColumns();
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean dataOK() {
        try {
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected boolean importDataCoords() {
        try {
            double sy;
            ArrayList<String> tokens;
            this.m_progressLabel.setText("Scanning binary file");
            this.m_progressLabel.paintImmediately(0, 0, 500, 20);
            this.m_map.clear();
            String pickCol = this.m_pickCombo.getSelectedString();
            int res = JOptionPane.showConfirmDialog(this, "Okay to overwrite contents of " + pickCol + "?", "Confirm copy", 2, 2, null);
            if (res != 0) {
                return false;
            }
            String fileName = this.m_fileWidget.getText();
            if (!Tools_FileSystem.exists_file(fileName)) {
                return false;
            }
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            boolean first = true;
            double scalar = 0.3333333333333333;
            if (RefractionStaticsProject.singleton().units_feet()) {
                scalar = 0.2;
            }
            while (line != null) {
                tokens = Tools_Strings.tokenizer(line);
                if (first) {
                    first = false;
                    if (tokens.size() != 5) {
                        JOptionPane.showMessageDialog(null, "ASCII file must have five columns", "Cannot import picks", 0);
                        br.close();
                        return false;
                    }
                }
                if (tokens.size() == 5) {
                    int isy;
                    double sx = Double.parseDouble(tokens.get(0));
                    int isx = (int)(0.5 + scalar * sx);
                    if (!this.m_map.containsKey(isx, isy = (int)(0.5 + scalar * (sy = Double.parseDouble((String)tokens.get(1)))))) {
                        this.m_map.put(new TraceTable_Scanner_AsciiCoordImport.ShotCoordData(isx, isy), isx, isy);
                    }
                    ++this.m_map.get((int)isx, (int)isy).Count;
                }
                line = br.readLine();
            }
            br.close();
            if (this.m_map.size() < 1) {
                JOptionPane.showMessageDialog(null, "No valid data found in ASCII file", "Cannot import picks", 0);
            }
            System.out.println("Finished first pass");
            for (TraceTable_Scanner_AsciiCoordImport.ShotCoordData sd : this.m_map.getValues()) {
                sd.allocate();
            }
            br = new BufferedReader(new FileReader(fileName));
            line = br.readLine();
            while (line != null) {
                tokens = Tools_Strings.tokenizer(line);
                if (tokens.size() == 5) {
                    double sx = Double.parseDouble(tokens.get(0));
                    sy = Double.parseDouble(tokens.get(1));
                    double rx = Double.parseDouble(tokens.get(2));
                    double ry = Double.parseDouble(tokens.get(3));
                    double pick = Double.parseDouble(tokens.get(4));
                    int isx = (int)(0.5 + scalar * sx);
                    int isy = (int)(0.5 + scalar * sy);
                    int irx = (int)(0.5 + scalar * rx);
                    int iry = (int)(0.5 + scalar * ry);
                    if (this.m_map.containsKey(isx, isy)) {
                        this.m_map.get(isx, isy).add(irx, iry, (float)pick);
                    }
                }
                line = br.readLine();
            }
            br.close();
            System.out.println("Finished second pass");
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            TraceTable_Scanner_AsciiCoordImport scanner = new TraceTable_Scanner_AsciiCoordImport((ITraceTableScannerMonitor)this, scalar, table, this.m_map, pickCol);
            scanner.OverwriteValidPicks = this.m_chkOverwriteValid.isSelected();
            scanner.scan(table, this);
            this.m_progressLabel.setText(" ");
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected boolean importDataFFID() {
        try {
            int chan;
            ArrayList<String> tokens;
            this.m_progressLabel.setText("Scanning binary file");
            this.m_progressLabel.paintImmediately(0, 0, 500, 20);
            this.m_mapFFID.clear();
            String pickCol = this.m_pickCombo.getSelectedString();
            int res = JOptionPane.showConfirmDialog(this, "Okay to overwrite contents of " + pickCol + "?", "Confirm copy", 2, 2, null);
            if (res != 0) {
                return false;
            }
            String fileName = this.m_fileWidget.getText();
            if (!Tools_FileSystem.exists_file(fileName)) {
                return false;
            }
            int maximumRowsPerPass = 20000000;
            boolean passNumber = false;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            boolean first = true;
            while (line != null) {
                tokens = Tools_Strings.tokenizer(line);
                if (first) {
                    first = false;
                    if (tokens.size() != 3) {
                        JOptionPane.showMessageDialog(null, "ASCII file must have three columns", "Cannot import picks", 0);
                        br.close();
                        return false;
                    }
                }
                if (tokens.size() == 3) {
                    int ffid = Integer.parseInt(tokens.get(0));
                    chan = Integer.parseInt((String)tokens.get(1));
                    if (!this.m_mapFFID.containsKey(ffid)) {
                        this.m_mapFFID.put(new TraceTable_Scanner_AsciiCoordImport.ShotFFIDData(ffid), ffid);
                    }
                    ++this.m_mapFFID.get((int)ffid).Count;
                }
                line = br.readLine();
            }
            br.close();
            if (this.m_mapFFID.size() < 1) {
                JOptionPane.showMessageDialog(null, "No valid data found in ASCII file", "Cannot import picks", 0);
            }
            System.out.println("Finished first pass");
            for (TraceTable_Scanner_AsciiCoordImport.ShotFFIDData sd : this.m_mapFFID.getValues()) {
                sd.allocate();
            }
            br = new BufferedReader(new FileReader(fileName));
            line = br.readLine();
            while (line != null) {
                tokens = Tools_Strings.tokenizer(line);
                if (tokens.size() == 3) {
                    int ffid = Integer.parseInt(tokens.get(0));
                    chan = Integer.parseInt(tokens.get(1));
                    double pick = Double.parseDouble(tokens.get(2));
                    if (this.m_mapFFID.containsKey(ffid)) {
                        this.m_mapFFID.get(ffid).add(chan, (float)pick);
                    }
                }
                line = br.readLine();
            }
            br.close();
            System.out.println("Finished second pass");
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            TraceTable_Scanner_AsciiCoordImport scanner = new TraceTable_Scanner_AsciiCoordImport((ITraceTableScannerMonitor)this, table, this.m_mapFFID, pickCol, false);
            scanner.OverwriteValidPicks = this.m_chkOverwriteValid.isSelected();
            scanner.scan(table, this);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected boolean importDataFFIDPointNumber() {
        try {
            int chan;
            ArrayList<String> tokens;
            this.m_progressLabel.setText("Scanning binary file");
            this.m_progressLabel.paintImmediately(0, 0, 500, 20);
            this.m_mapFFID.clear();
            String pickCol = this.m_pickCombo.getSelectedString();
            int res = JOptionPane.showConfirmDialog(this, "Okay to overwrite contents of " + pickCol + "?", "Confirm copy", 2, 2, null);
            if (res != 0) {
                return false;
            }
            String fileName = this.m_fileWidget.getText();
            if (!Tools_FileSystem.exists_file(fileName)) {
                return false;
            }
            int maximumRowsPerPass = 20000000;
            boolean passNumber = false;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            boolean first = true;
            while (line != null) {
                tokens = Tools_Strings.tokenizer(line);
                if (first) {
                    first = false;
                    if (tokens.size() != 3) {
                        JOptionPane.showMessageDialog(null, "ASCII file must have three columns", "Cannot import picks", 0);
                        br.close();
                        return false;
                    }
                }
                if (tokens.size() == 3) {
                    int ffid = Integer.parseInt(tokens.get(0));
                    chan = Integer.parseInt((String)tokens.get(1));
                    if (!this.m_mapFFID.containsKey(ffid)) {
                        this.m_mapFFID.put(new TraceTable_Scanner_AsciiCoordImport.ShotFFIDData(ffid), ffid);
                    }
                    ++this.m_mapFFID.get((int)ffid).Count;
                }
                line = br.readLine();
            }
            br.close();
            if (this.m_mapFFID.size() < 1) {
                JOptionPane.showMessageDialog(null, "No valid data found in ASCII file", "Cannot import picks", 0);
            }
            System.out.println("Finished first pass");
            for (TraceTable_Scanner_AsciiCoordImport.ShotFFIDData sd : this.m_mapFFID.getValues()) {
                sd.allocate();
            }
            br = new BufferedReader(new FileReader(fileName));
            line = br.readLine();
            while (line != null) {
                tokens = Tools_Strings.tokenizer(line);
                if (tokens.size() == 3) {
                    int ffid = Integer.parseInt(tokens.get(0));
                    chan = Integer.parseInt(tokens.get(1));
                    double pick = Double.parseDouble(tokens.get(2));
                    if (this.m_mapFFID.containsKey(ffid)) {
                        this.m_mapFFID.get(ffid).add(chan, (float)pick);
                    }
                }
                line = br.readLine();
            }
            br.close();
            System.out.println("Finished second pass");
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            TraceTable_Scanner_AsciiCoordImport scanner = new TraceTable_Scanner_AsciiCoordImport((ITraceTableScannerMonitor)this, table, this.m_mapFFID, pickCol, true);
            scanner.OverwriteValidPicks = this.m_chkOverwriteValid.isSelected();
            scanner.scan(table, this);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected boolean importDataCombinedLinePoint() {
        try {
            String shot;
            ArrayList<String> tokens;
            this.m_progressLabel.setText("Scanning binary file");
            this.m_progressLabel.paintImmediately(0, 0, 500, 20);
            this.m_mapCombined.clear();
            String pickCol = this.m_pickCombo.getSelectedString();
            int res = JOptionPane.showConfirmDialog(this, "Okay to overwrite contents of " + pickCol + "?", "Confirm copy", 2, 2, null);
            if (res != 0) {
                return false;
            }
            String fileName = this.m_fileWidget.getText();
            if (!Tools_FileSystem.exists_file(fileName)) {
                return false;
            }
            int maximumRowsPerPass = 20000000;
            boolean passNumber = false;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            boolean first = true;
            while (line != null) {
                tokens = Tools_Strings.tokenizer(line);
                if (first) {
                    first = false;
                    if (tokens.size() != 3) {
                        JOptionPane.showMessageDialog(null, "ASCII file must have three columns", "Cannot import picks", 0);
                        br.close();
                        return false;
                    }
                }
                if (tokens.size() == 3) {
                    int shotPoint;
                    shot = tokens.get(0);
                    int shotLine = Integer.parseInt(shot.substring(0, 4));
                    if (!this.m_mapCombined.containsKey(shotLine, shotPoint = Integer.parseInt(shot.substring(4, 8)))) {
                        this.m_mapCombined.put(new TraceTable_Scanner_AsciiCoordImport.ShotLinePointData(shotLine, shotPoint), shotLine, shotPoint);
                    }
                    ++this.m_mapCombined.get((int)shotLine, (int)shotPoint).Count;
                }
                line = br.readLine();
            }
            br.close();
            if (this.m_mapCombined.size() < 1) {
                JOptionPane.showMessageDialog(null, "No valid data found in ASCII file", "Cannot import picks", 0);
            }
            System.out.println("Finished first pass");
            for (TraceTable_Scanner_AsciiCoordImport.ShotLinePointData sd : this.m_mapCombined.getValues()) {
                sd.allocate();
            }
            br = new BufferedReader(new FileReader(fileName));
            line = br.readLine();
            while (line != null) {
                tokens = Tools_Strings.tokenizer(line);
                if (tokens.size() == 3) {
                    shot = tokens.get(0);
                    String rec = tokens.get(1);
                    double pick = Double.parseDouble(tokens.get(2));
                    int shotLine = Integer.parseInt(shot.substring(0, 4));
                    int shotPoint = Integer.parseInt(shot.substring(4, 8));
                    int recLine = Integer.parseInt(rec.substring(0, 4));
                    int recPoint = Integer.parseInt(rec.substring(4, 8));
                    if (this.m_mapCombined.containsKey(shotLine, shotPoint)) {
                        this.m_mapCombined.get(shotLine, shotPoint).add(recLine, recPoint, (float)pick);
                    }
                }
                line = br.readLine();
            }
            br.close();
            System.out.println("Finished second pass");
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            TraceTable_Scanner_AsciiCoordImport scanner = new TraceTable_Scanner_AsciiCoordImport(this, table, this.m_mapCombined, pickCol);
            scanner.OverwriteValidPicks = this.m_chkOverwriteValid.isSelected();
            scanner.scan(table, this);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected boolean importDataSeparateLinePoint() {
        try {
            int shotPoint;
            ArrayList<String> tokens;
            this.m_progressLabel.setText("Scanning binary file");
            this.m_progressLabel.paintImmediately(0, 0, 500, 20);
            this.m_mapSeparate.clear();
            String pickCol = this.m_pickCombo.getSelectedString();
            int res = JOptionPane.showConfirmDialog(this, "Okay to overwrite contents of " + pickCol + "?", "Confirm copy", 2, 2, null);
            if (res != 0) {
                return false;
            }
            String fileName = this.m_fileWidget.getText();
            if (!Tools_FileSystem.exists_file(fileName)) {
                return false;
            }
            int maximumRowsPerPass = 20000000;
            boolean passNumber = false;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            boolean first = true;
            while (line != null) {
                tokens = Tools_Strings.tokenizer(line);
                if (first) {
                    first = false;
                    if (tokens.size() != 5) {
                        JOptionPane.showMessageDialog(null, "ASCII file must have five columns", "Cannot import picks", 0);
                        br.close();
                        return false;
                    }
                }
                if (tokens.size() == 5) {
                    int shotLine = Integer.parseInt(tokens.get(0));
                    if (!this.m_mapSeparate.containsKey(shotLine, shotPoint = Integer.parseInt((String)tokens.get(1)))) {
                        this.m_mapSeparate.put(new TraceTable_Scanner_AsciiCoordImport.ShotLinePointData(shotLine, shotPoint), shotLine, shotPoint);
                    }
                    ++this.m_mapSeparate.get((int)shotLine, (int)shotPoint).Count;
                }
                line = br.readLine();
            }
            br.close();
            if (this.m_mapSeparate.size() < 1) {
                JOptionPane.showMessageDialog(null, "No valid data found in ASCII file", "Cannot import picks", 0);
            }
            System.out.println("Finished first pass");
            for (TraceTable_Scanner_AsciiCoordImport.ShotLinePointData sd : this.m_mapSeparate.getValues()) {
                sd.allocate();
            }
            br = new BufferedReader(new FileReader(fileName));
            line = br.readLine();
            while (line != null) {
                tokens = Tools_Strings.tokenizer(line);
                if (tokens.size() == 5) {
                    int shotLine = Integer.parseInt(tokens.get(0));
                    shotPoint = Integer.parseInt(tokens.get(1));
                    int recLine = Integer.parseInt(tokens.get(2));
                    int recPoint = Integer.parseInt(tokens.get(3));
                    double pick = Double.parseDouble(tokens.get(4));
                    if (this.m_mapSeparate.containsKey(shotLine, shotPoint)) {
                        this.m_mapSeparate.get(shotLine, shotPoint).add(recLine, recPoint, (float)pick);
                    }
                }
                line = br.readLine();
            }
            br.close();
            System.out.println("Finished second pass");
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            TraceTable_Scanner_AsciiCoordImport scanner = new TraceTable_Scanner_AsciiCoordImport(this, table, this.m_mapSeparate, pickCol);
            scanner.OverwriteValidPicks = this.m_chkOverwriteValid.isSelected();
            scanner.scan(table, this);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected boolean exportData() {
        try {
            String pickCol = this.m_pickCombo.getSelectedString();
            String fileName = this.m_fileWidget.getText();
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            boolean overwrite = false;
            boolean exclude = false;
            if (this.m_radioIncludeAll.isSelected()) {
                overwrite = false;
                exclude = false;
            }
            if (this.m_radioOverwriteDead.isSelected()) {
                overwrite = true;
                exclude = false;
            }
            if (this.m_radioExcludeAll.isSelected()) {
                overwrite = false;
                exclude = true;
            }
            if (this.m_ascii) {
                BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
                TraceTable_Scanner_AsciiCoordExport scanner = new TraceTable_Scanner_AsciiCoordExport(this, table, writer, pickCol, overwrite, exclude, this.m_method == MethodIO.Coords, this.m_method == MethodIO.FFID, this.m_method == MethodIO.FFIDPointNumber, this.m_method == MethodIO.CombinedLinePoint, this.m_method == MethodIO.LinePoint);
                scanner.scan(table, this);
                writer.close();
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnAddVersion) {
                this.m_pickAddDialog.showDialog();
                if (this.m_pickAddDialog.OK) {
                    Messenger.broadcast(Messenger.Message.PickColumnAdded, null, null);
                }
                return;
            }
            if (!this.m_export && e.getSource() == this.m_btnOK) {
                if (this.m_method == MethodIO.Coords && !this.importDataCoords()) {
                    return;
                }
                if (this.m_method == MethodIO.FFID && !this.importDataFFID()) {
                    return;
                }
                if (this.m_method == MethodIO.FFIDPointNumber && !this.importDataFFIDPointNumber()) {
                    return;
                }
                if (this.m_method == MethodIO.CombinedLinePoint && !this.importDataCombinedLinePoint()) {
                    return;
                }
                if (this.m_method == MethodIO.LinePoint && !this.importDataSeparateLinePoint()) {
                    return;
                }
                this.m_progress.setValue(0);
                this.OK = true;
                this.dispose();
                return;
            }
            if (this.m_export && e.getSource() == this.m_btnOK) {
                if (!this.exportData()) {
                    return;
                }
                this.m_progress.setValue(0);
                this.OK = true;
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            this.setCursor(Cursor.getDefaultCursor());
            ExceptionMonitor.add(error);
        }
    }

    public static enum MethodIO {
        Coords,
        FFID,
        FFIDPointNumber,
        CombinedLinePoint,
        LinePoint;

    }
}

