/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleFirstBreakPickPlotData;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import java.awt.Color;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.table.AbstractTableModel;

public class PickDisplayTableModel
extends AbstractTableModel {
    protected GenericObjectListener m_listenerManager = new GenericObjectListener();
    protected static PickDisplayTableModel m_singleton;
    public ArrayList<Entry> m_list = new ArrayList();
    protected int m_numInHeader = 0;

    public GenericObjectListener getListenerController() {
        return this.m_listenerManager;
    }

    private PickDisplayTableModel() {
        try {
            String path = SharedApplicationData.singleton().homeDirectory();
            String fileName = path + "/picks.desc";
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            int magic = file.readInt();
            if (magic != 9364) {
                file.close();
                return;
            }
            int version = file.readInt();
            if (version == 1000) {
                int num = file.readInt();
                for (int n = 0; n < num; ++n) {
                    Entry e = new Entry();
                    e.Column = file.readUTF();
                    e.SymbolSize = file.readInt();
                    e.Required = file.readBoolean();
                    e.Visible = file.readBoolean();
                    int r = file.readInt();
                    int g = file.readInt();
                    int b = file.readInt();
                    e.PickColor = new Color(r, g, b);
                    int sym = file.readInt();
                    e.Symbol = Java2D_PointSymbol.values()[sym];
                    this.m_list.add(e);
                }
            }
            file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static PickDisplayTableModel singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new PickDisplayTableModel();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void handleEnsemble(Ensemble ensemble) {
        try {
            if (ensemble == null) {
                return;
            }
            if (ensemble.traceCount() < 1) {
                return;
            }
            boolean dirty = false;
            for (int n = this.m_list.size() - 1; n >= 0; --n) {
                Entry e = this.m_list.get(n);
                if (ensemble.dictionary().containsEntry("Trace", e.Column)) continue;
                dirty = true;
            }
            ArrayList<String> list = ensemble.dictionary().getListOfColumnNames("Trace", "FBP_");
            for (String col : list) {
                boolean exists = false;
                for (Entry e : this.m_list) {
                    if (!col.equalsIgnoreCase(e.Column)) continue;
                    exists = true;
                    e.Required = ensemble.pickPlotData().isPickRequired(col);
                }
                if (exists) continue;
                Entry e = new Entry();
                e.Column = col;
                e.Required = ensemble.pickPlotData().isPickRequired(col);
                e.Symbol = Java2D_PointSymbol.FilledOval;
                e.InHeader = 0;
                if (col.equalsIgnoreCase("FBP_User")) {
                    e.PickColor = Color.CYAN;
                    e.Visible = true;
                } else if (col.equalsIgnoreCase("FBP_PriorPick")) {
                    e.PickColor = Color.MAGENTA;
                    e.Symbol = Java2D_PointSymbol.X;
                    e.SymbolSize = 9;
                    e.Visible = true;
                } else {
                    e.PickColor = Color.GREEN;
                    e.Visible = false;
                }
                this.m_list.add(e);
                dirty = true;
            }
            this.m_numInHeader = 0;
            for (int n = this.m_list.size() - 1; n >= 0; --n) {
                Entry e = this.m_list.get(n);
                if (ensemble.dictionary().containsEntry("Trace", e.Column)) continue;
                this.m_list.remove(n);
                dirty = true;
            }
            if (dirty) {
                this.save();
            }
            this.fireTableStructureChanged();
            this.fireTableDataChanged();
            EnsembleFirstBreakPickPlotData ppd = ensemble.pickPlotData();
            ppd.clear();
            for (Entry e : this.m_list) {
                if (!e.Required && !e.Visible) continue;
                ppd.add(e.Column, e.PickColor, e.SymbolSize, e.Symbol);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void save() {
        try {
            String path = SharedApplicationData.singleton().homeDirectory();
            String fileName = path + "/picks.desc";
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            int magic = 9364;
            int version = 1000;
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(this.m_list.size());
                for (Entry e : this.m_list) {
                    file.writeUTF(e.Column);
                    file.writeInt(e.SymbolSize);
                    file.writeBoolean(e.Required);
                    file.writeBoolean(e.Visible);
                    file.writeInt(e.PickColor.getRed());
                    file.writeInt(e.PickColor.getGreen());
                    file.writeInt(e.PickColor.getBlue());
                    file.writeInt(e.Symbol.ordinal());
                }
            }
            file.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column == 0) {
            return false;
        }
        return column != 4;
    }

    @Override
    public String getColumnName(int column) {
        try {
            if (column == 0) {
                return "Name";
            }
            if (column == 1) {
                return "Show";
            }
            if (column == 2) {
                return "Color";
            }
            if (column == 3) {
                return "Size";
            }
            if (column == 4) {
                return "Required";
            }
            return "Error";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }

    public Class getColumnClass(int column) {
        try {
            if (column == 2) {
                return Color.class;
            }
            if (column == 1) {
                return Boolean.class;
            }
            if (column == 4) {
                return Boolean.class;
            }
            return String.class;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return String.class;
        }
    }

    @Override
    public int getRowCount() {
        return this.m_list.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        try {
            if (value == null) {
                return;
            }
            Entry e = this.m_list.get(row);
            if (column == 2 && value instanceof Color) {
                e.PickColor = (Color)value;
            }
            if (column == 1 && value instanceof Boolean) {
                e.Visible = (Boolean)value;
            }
            if (column == 3) {
                e.SymbolSize = Integer.parseInt((String)value);
                e.SymbolSize = Math.max(5, e.SymbolSize);
                e.SymbolSize = Math.min(25, e.SymbolSize);
            }
            this.save();
            this.m_listenerManager.broadcast(this, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        try {
            Entry e = this.m_list.get(row);
            if (column == 0) {
                return e.Column;
            }
            if (column == 1) {
                return e.Visible;
            }
            if (column == 2) {
                return e.PickColor;
            }
            if (column == 3) {
                return Integer.toString(e.SymbolSize);
            }
            if (column == 4) {
                return e.Required;
            }
            return "error";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "error";
        }
    }

    public static class Entry {
        public String Column = "";
        public Color PickColor = Color.RED;
        public int SymbolSize = 9;
        public Java2D_PointSymbol Symbol = Java2D_PointSymbol.FilledOval;
        public boolean Required = false;
        public boolean Visible = false;
        public int InHeader = 0;
    }

    public class ColumnIndex {
        public static final int Column = 0;
        public static final int Visible = 1;
        public static final int Color = 2;
        public static final int Size = 3;
        public static final int Required = 4;
        public static final int Count = 5;
    }

    public static class Sorter_PickEntry
    implements Comparator<Entry> {
        @Override
        public int compare(Entry e1, Entry e2) {
            try {
                if (e1.InHeader < e2.InHeader) {
                    return -1;
                }
                if (e1.InHeader > e2.InHeader) {
                    return 1;
                }
                return 0;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return 0;
            }
        }
    }
}

