/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.ITraceTableScannerMonitor;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.TraceTable.TraceTable_Scanner_ColumnCopy;
import com.PecosLibrary.Data.TraceTable.TraceTable_Scanner_V0PlusKZ;
import com.PecosLibrary.Refraction.RefractionProjectSuggestions;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.Picking.AddPickVersionDialog;
import com.PecosLibrary.Windows.Shared.MultiTextDialog;
import com.PecosLibrary.Windows.Shared.PolygonUsageWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PickCopyDialog
extends JDialog
implements ActionListener,
ITraceTableScannerMonitor {
    protected JButton m_btnAddVersion = new JButton("Add pick version");
    protected JButton m_btnV0KZ;
    protected JButton m_btnOK = new JButton("Copy column");
    protected JButton m_btnCancel = new JButton("Close");
    protected JRadioButton m_allRadio = new JRadioButton("Show all columns");
    protected JRadioButton m_fbpRadio = new JRadioButton("Just show FBP (first break pick) columns");
    protected ButtonGroup m_group = new ButtonGroup();
    protected JCheckBox m_mustBeValidCheck = new JCheckBox("Only copy if the \"from\" pick is >= 0.0");
    protected JCheckBox m_overwriteCheck = new JCheckBox("Overwrite valid pick times");
    protected PolygonUsageWidget m_polygonWidget = new PolygonUsageWidget();
    protected JCheckBox m_chkShiftPicks = new JCheckBox("Shift the picks (not snapped to event!)");
    protected JTextField m_txtShift = new JTextField("0");
    protected JCheckBox m_justBranchCheck = new JCheckBox("Just copy traces assigned to a branch");
    protected JComboBox<String> m_branchCombo = new JComboBox();
    protected ComboStringListWrapper m_fromCombo = new ComboStringListWrapper();
    protected ComboStringListWrapper m_toCombo = new ComboStringListWrapper();
    protected JProgressBar m_progress = new JProgressBar();
    public boolean OK = false;
    protected ArrayList<Restriction> m_restrictions = new ArrayList();
    protected static PickCopyDialog m_singleton = null;
    protected ArrayList<String> m_shotColumns;
    protected ArrayList<String> m_recColumns;
    protected ArrayList<String> m_traceColumns;
    protected ArrayList<String> m_nullColumns = new ArrayList();
    MultiTextDialog m_dlg;
    protected AddPickVersionDialog m_pickAddDialog = new AddPickVersionDialog();
    protected boolean m_bUserPicksModified = false;

    public static PickCopyDialog singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new PickCopyDialog();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected PickCopyDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            GridLayoutWidget grid = middle.createGridLayoutWidget(3, "Select columns", 0);
            grid.addSimple(0, new JLabel("From column:"), this.m_fromCombo);
            grid.addSimple(1, new JLabel("To column:"), this.m_toCombo);
            this.m_fromCombo.setPreferredSelected("FBP_User");
            this.m_toCombo.setPreferredSelected("FBP_User");
            LinearLayoutWidget sub = middle.createVertical(3, "Column options", 0);
            this.m_group.add(this.m_fbpRadio);
            this.m_group.add(this.m_allRadio);
            this.m_fbpRadio.addActionListener(this);
            this.m_allRadio.addActionListener(this);
            sub.addComponent(this.m_fbpRadio, 0);
            sub.addComponent(this.m_allRadio, 0);
            this.m_fbpRadio.setSelected(true);
            sub = middle.createVertical(3, "Pick shift options", 0);
            sub.addComponent(this.m_chkShiftPicks, 0);
            sub.addHorzPair(new JLabel("Shift amount (ms)"), 0, this.m_txtShift, 9);
            sub = middle.createVertical(3, "Limitations", 0);
            sub.addComponent(this.m_mustBeValidCheck, 0);
            this.m_overwriteCheck.setSelected(true);
            sub.addComponent(this.m_overwriteCheck, 0);
            this.m_branchCombo.addItem("All branches");
            for (int b = 1; b < 10; ++b) {
                this.m_branchCombo.addItem(String.format("Branch %d", b));
            }
            this.m_branchCombo.setSelectedIndex(0);
            this.m_branchCombo.setEnabled(this.m_justBranchCheck.isSelected());
            sub.addHorzPair(this.m_justBranchCheck, 0, this.m_branchCombo, 10);
            this.m_justBranchCheck.addActionListener(this);
            middle.addComponent(this.createRestrictions(), 0);
            middle.addComponent(this.m_polygonWidget, 0);
            this.m_progress.setMaximum(1000);
            middle.addComponent(this.m_progress, 0);
            middle.addStretch(10);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            bottom.addStretch(10);
            bottom.addComponent(this.m_btnAddVersion, 0);
            this.m_btnAddVersion.addActionListener(this);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setSize(this.getSize().width + 100, this.getSize().height);
            this.setTitle("Copy pick columns");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public JComponent createRestrictions() {
        try {
            GridLayoutWidget grid = new GridLayoutWidget(0, "Additional restrictions");
            grid.addSimple(0, new JLabel("Table:"), new JLabel("Column:"), new JLabel("Minimum:"), new JLabel("Maximum:"));
            for (int n = 0; n < 4; ++n) {
                Restriction r = new Restriction();
                this.m_restrictions.add(r);
                grid.addSimple(n + 1, r.TableCombo, r.ColumnCombo, r.TextMin, r.TextMax);
            }
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    @Override
    public void setPercentDone(double percent) {
        try {
            percent = Math.max(percent, 0.0);
            percent = Math.min(percent, 99.99);
            this.m_progress.setValue((int)(10.0 * percent));
            this.m_progress.paintImmediately(0, 0, 500, 30);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setMessage(String message) {
    }

    protected void loadColumns() {
        try {
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            ArrayList<String> cols = null;
            cols = this.m_fbpRadio.isSelected() ? table.columns("FBP_") : table.columns();
            this.m_fromCombo.setStringArray(cols);
            this.m_toCombo.setStringArray(cols);
            this.m_shotColumns = RefractionStaticsProject.singleton().geometryDatabase().listOfColumnNames("Shot");
            this.m_recColumns = RefractionStaticsProject.singleton().geometryDatabase().listOfColumnNames("Receiver");
            this.m_traceColumns = table.columns();
            this.m_traceColumns.add(0, "Offset");
            for (Restriction r : this.m_restrictions) {
                r.reloadColumns();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog(String preferredFrom) {
        try {
            this.m_bUserPicksModified = false;
            this.OK = false;
            this.loadColumns();
            try {
                if (preferredFrom != null && preferredFrom.length() >= 1) {
                    this.m_fromCombo.setPreferredSelected(preferredFrom);
                }
            }
            catch (Exception errr) {
                errr.printStackTrace();
            }
            this.m_progress.setValue(0);
            this.m_polygonWidget.updateChecks();
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean dataOK() {
        try {
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected void v0kz() {
        try {
            int res = JOptionPane.showConfirmDialog(this, "This will overwrite user picks with synthetics!!!", "Confirm overwrite", 2, 2, null);
            if (res != 0) {
                return;
            }
            if (this.m_dlg == null) {
                this.m_dlg = new MultiTextDialog(null, "V0 + kz", "V0", "Depth", "Vel at depth");
            }
            this.m_dlg.showDialog();
            if (!this.m_dlg.OK) {
                return;
            }
            double v0 = this.m_dlg.getDouble(0, 3000.0, 500.0, 10000.0);
            double depth = this.m_dlg.getDouble(1, 500.0, 100.0, 2000.0);
            double v1 = this.m_dlg.getDouble(2, v0 + 100.0, v0 + 50.0, 30000.0);
            double k = (v1 - v0) / depth;
            TraceTable_Scanner_V0PlusKZ scanner = new TraceTable_Scanner_V0PlusKZ();
            scanner.K = k;
            scanner.V0 = v0;
            ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            scanner.scan(table, this);
            this.setCursor(Cursor.getDefaultCursor());
            this.m_progress.setValue(0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (e.getSource() == this.m_allRadio || e.getSource() == this.m_fbpRadio) {
                this.loadColumns();
                return;
            }
            if (e.getSource() == this.m_btnV0KZ) {
                this.v0kz();
                return;
            }
            if (e.getSource() == this.m_btnAddVersion) {
                if (project.traceTableWrapper().traceTable().needToExpandTableMemory(DataType.Float)) {
                    JOptionPane.showMessageDialog(null, "Unable to add column to trace table", "Cannot add pick version", 0);
                    return;
                }
                this.m_pickAddDialog.showDialog();
                if (this.m_pickAddDialog.OK) {
                    this.loadColumns();
                    Messenger.broadcast(Messenger.Message.PickColumnAdded, null, null);
                }
                return;
            }
            if (e.getSource() == this.m_justBranchCheck) {
                this.m_branchCombo.setEnabled(this.m_justBranchCheck.isSelected());
                return;
            }
            if (e.getSource() == this.m_btnOK) {
                boolean fixed;
                ITraceTable table = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
                String c1 = this.m_fromCombo.getSelectedString();
                String c2 = this.m_toCombo.getSelectedString();
                boolean bl = fixed = c2.equalsIgnoreCase("ShotID") || c2.equalsIgnoreCase("ReceiverID") || c2.equalsIgnoreCase("Inline") || c2.equalsIgnoreCase("Crossline") || c2.equalsIgnoreCase("FileID") || c2.equalsIgnoreCase("IndexInFile");
                if (fixed) {
                    JOptionPane.showMessageDialog(null, "Cannot modify a required column", "Cannot copy column", 0);
                    return;
                }
                int res = JOptionPane.showConfirmDialog(this, "Okay to overwrite contents of " + c2 + "?", "Confirm copy", 2, 2, null);
                if (res != 0) {
                    return;
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                int whichBranch = this.m_branchCombo.getSelectedIndex();
                float minimumRequiredFromValue = -1.0E30f;
                if (this.m_mustBeValidCheck.isSelected()) {
                    minimumRequiredFromValue = 0.0f;
                }
                TraceTable_Scanner_ColumnCopy copier = new TraceTable_Scanner_ColumnCopy(table, c1, c2, this.m_justBranchCheck.isSelected(), whichBranch, this.m_overwriteCheck.isSelected(), -1.0f, minimumRequiredFromValue);
                copier.ApplyShift = this.m_chkShiftPicks.isSelected();
                copier.Shift = (float)Tools_Widget.extractDouble(this.m_txtShift, 0.0, -20000.0, 20000.0);
                copier.CheckIfMidInsidePolygon = this.m_polygonWidget.midpointInside();
                copier.CheckIfRecInsidePolygon = this.m_polygonWidget.receiverInside();
                copier.CheckIfShotInsidePolygon = this.m_polygonWidget.shotInside();
                for (Restriction r : this.m_restrictions) {
                    double min = Tools_Widget.extractDouble(r.TextMin, 0.0, -1.0E20, 1.0E20);
                    double max = Tools_Widget.extractDouble(r.TextMax, 0.0, -1.0E20, 1.0E20);
                    double eps = 1.0E-8;
                    if (r.TableCombo.getSelectedIndex() == 1) {
                        copier.addRestriction("Trace", r.ColumnCombo.getSelectedString(), min - eps, max + eps);
                    }
                    if (r.TableCombo.getSelectedIndex() == 2) {
                        copier.addRestriction("Shot", r.ColumnCombo.getSelectedString(), min - eps, max + eps);
                    }
                    if (r.TableCombo.getSelectedIndex() != 3) continue;
                    copier.addRestriction("Receiver", r.ColumnCombo.getSelectedString(), min - eps, max + eps);
                }
                long start = System.currentTimeMillis();
                copier.scan(table, this);
                long total = System.currentTimeMillis() - start;
                double seconds = 0.001 * (double)total;
                double minutes = seconds / 60.0;
                double tracesPerMinute = (double)table.rowCount() / (1.0E-5 + minutes);
                double millionTracesPerMinute = tracesPerMinute * 1.0E-6;
                System.out.println("Pick copy, " + Double.toString(millionTracesPerMinute) + " million traces per minute");
                this.m_bUserPicksModified = c2.equalsIgnoreCase("FBP_User");
                this.setCursor(Cursor.getDefaultCursor());
                this.m_progress.setValue(0);
                JOptionPane.showMessageDialog(null, "Succesfully copied picks from " + c1 + " to " + c2, "Pick copy complete", 0);
                this.OK = true;
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                if (this.m_bUserPicksModified) {
                    RefractionProjectSuggestions.singleton().userPicksModified();
                }
                this.m_bUserPicksModified = false;
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            this.setCursor(Cursor.getDefaultCursor());
            ExceptionMonitor.add(error);
        }
    }

    protected class Restriction
    implements ItemListener {
        public JComboBox<String> TableCombo = new JComboBox();
        public ComboStringListWrapper ColumnCombo = new ComboStringListWrapper();
        public JTextField TextMin = new JTextField("0");
        public JTextField TextMax = new JTextField("0");

        public Restriction() {
            try {
                this.TableCombo.addItem("Not in use");
                this.TableCombo.addItem("Trace");
                this.TableCombo.addItem("Shot");
                this.TableCombo.addItem("Receiver");
                this.TableCombo.addItemListener(this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                this.reloadColumns();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void reloadColumns() {
            try {
                if (this.TableCombo.getSelectedIndex() == 0) {
                    this.ColumnCombo.setStringArray(PickCopyDialog.this.m_nullColumns);
                }
                if (this.TableCombo.getSelectedIndex() == 1) {
                    this.ColumnCombo.setStringArray(PickCopyDialog.this.m_traceColumns);
                }
                if (this.TableCombo.getSelectedIndex() == 2) {
                    this.ColumnCombo.setStringArray(PickCopyDialog.this.m_shotColumns);
                }
                if (this.TableCombo.getSelectedIndex() == 3) {
                    this.ColumnCombo.setStringArray(PickCopyDialog.this.m_recColumns);
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }
}

