/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Seismic.SeismicProfile;
import com.PecosLibrary.Windows.Refraction.Picking.AzimuthSelectorWidget;
import com.PecosLibrary.Windows.Stack.ProfileSelectorWidget;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class OffsetBinProfileNavigationWidget
extends LinearLayoutWidget
implements ActionListener,
ListSelectionListener,
GenericObjectListener.Listener,
Messenger.Listener {
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected JLabel m_profileLabel = new JLabel("No profile selected", 0);
    protected JTable m_table = new JTable();
    protected JProgressBar m_progress = new JProgressBar();
    protected AzimuthSelectorWidget m_azimuthSelectorWidget;
    protected SeismicProfile m_selectedProfile;
    protected int m_selectedRow = 0;

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public AzimuthSelectorWidget azimuthSelectorWidget() {
        return this.m_azimuthSelectorWidget;
    }

    public OffsetBinProfileNavigationWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            this.m_profileLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            this.addComponent(this.m_profileLabel, 0);
            this.m_azimuthSelectorWidget = new AzimuthSelectorWidget();
            LinearLayoutWidget sub = this.createVertical(0, "Binning progress", 0);
            sub.addComponent(this.m_progress, 0);
            this.addComponent(new JScrollPane(this.m_table), 10);
            this.m_table.setSelectionMode(0);
            this.m_table.getSelectionModel().addListSelectionListener(this);
            this.addComponent(this.m_azimuthSelectorWidget, 0);
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
            this.updateStuff();
            Messenger.singleton().addListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.OffsetBinSizeChanged) {
                this.bin();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void updateStuff() {
        try {
            if (this.m_selectedProfile != null) {
                this.m_table.setModel(this.m_selectedProfile.offsetGathers());
            } else {
                this.m_table.setModel(new DefaultTableModel());
            }
            this.m_selectedRow = 0;
            this.m_listener.broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void bin() {
        try {
            if (this.m_selectedProfile == null) {
                this.m_table.setModel(new DefaultTableModel());
                return;
            }
            int bin = RefractionStaticsProject.singleton().offsetBinSize();
            if (this.m_selectedProfile.needToCreateGathers(bin)) {
                this.m_selectedProfile.createOffsetGathers(bin, this.m_progress);
            }
            this.updateStuff();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == null) {
                return;
            }
            if (sender instanceof ProfileSelectorWidget) {
                ProfileSelectorWidget psw = (ProfileSelectorWidget)sender;
                this.m_selectedProfile = psw.selectedProfile();
                if (this.m_selectedProfile.version() < 1001) {
                    this.m_profileLabel.setText("Invalid profile, created with older version of Flatirons");
                    this.m_profileLabel.setForeground(Color.red);
                    this.m_selectedProfile = null;
                } else {
                    this.m_profileLabel.setText(this.m_selectedProfile.name());
                    this.m_profileLabel.setForeground(Color.blue);
                }
                this.bin();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void populateEnsemble(Ensemble ensemble, boolean emitSignal) {
        try {
            ensemble.clearTraces(false);
            if (this.m_selectedProfile == null) {
                if (emitSignal) {
                    this.m_listener.broadcast(this, null);
                }
                return;
            }
            if (!this.m_selectedProfile.offsetGathers().valid()) {
                if (emitSignal) {
                    this.m_listener.broadcast(this, null);
                }
                return;
            }
            this.m_selectedRow = Math.max(this.m_selectedRow, 0);
            this.m_selectedRow = Math.min(this.m_selectedRow, this.m_selectedProfile.offsetGathers().size() - 1);
            try {
                if (SharedApplicationData.singleton().appFrame() != null) {
                    SharedApplicationData.singleton().appFrame().setCursor(Cursor.getPredefinedCursor(3));
                }
            }
            catch (Exception error) {
                error.printStackTrace();
            }
            this.m_selectedProfile.offsetGathers().populateEnsemble(this.m_selectedRow, ensemble, false);
            RefractionStaticsProject.singleton().traceTableWrapper().traceTable().populateEnsembleUsingTraceIndex(ensemble);
            RefractionStaticsProject.singleton().prepGeometryHeaders(ensemble, true, true);
            RefractionStaticsProject.singleton().inputDataProcessor_Run(ensemble);
            try {
                if (SharedApplicationData.singleton().appFrame() != null) {
                    SharedApplicationData.singleton().appFrame().setCursor(Cursor.getDefaultCursor());
                }
            }
            catch (Exception error) {
                error.printStackTrace();
            }
            if (emitSignal) {
                this.m_listener.broadcast(this, null);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void goToPrev() {
        try {
            if (this.m_selectedProfile == null) {
                return;
            }
            --this.m_selectedRow;
            this.m_listener.broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void goToNext() {
        try {
            if (this.m_selectedProfile == null) {
                return;
            }
            ++this.m_selectedRow;
            this.m_listener.broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            if (e.getSource() == this.m_table.getSelectionModel()) {
                this.m_selectedRow = this.m_table.getSelectedRow();
                this.m_listener.broadcast(this, null);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

