/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Refraction.Picking.PickPlaneEnum;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Action_Sequence;
import com.PecosLibrary.Refraction.PickerGizmo;
import com.PecosLibrary.Refraction.RefractionProjectSuggestions;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Seismic.SeismicProfile;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Windows.ApplicationFrames.INumberedWidget;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_MainWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_VertStackedEnsembleDisplayWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_AxisLocker;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_SelectedEntries;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_KeyPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MouseMove;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MultiLineSegments;
import com.PecosLibrary.Windows.Refraction.Picking.EnsembleAxisSelectionWidget;
import com.PecosLibrary.Windows.Refraction.Picking.EnsembleVisibleTraceSelectionWidget;
import com.PecosLibrary.Windows.Refraction.Picking.PickDisplayWidget;
import com.PecosLibrary.Windows.Refraction.Picking.PickerBasemapWidget;
import com.PecosLibrary.Windows.Refraction.Picking.PickerGizmoWidget;
import com.PecosLibrary.Windows.Refraction.Picking.TraceBackgroundWidget;
import com.PecosLibrary.Windows.Shared.BitmapCardWidget;
import com.PecosLibrary.Windows.Shared.ParameterTreeWidgetManager;
import com.PecosLibrary.Windows.Shared.PopupMenuButton;
import com.PecosLibrary.Windows.Stack.ProfileSelectorWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BasicPickWidget_MultipleProfilePanel
extends JSplitPane
implements INumberedWidget,
ActionListener,
GenericObjectListener.Listener,
ItemListener,
PickerBasemapWidget.Listener,
Java2D_VertStackedEnsembleDisplayWidget.Listener,
Messenger.Listener,
PopupMenuButton.Listener,
Action_Sequence.Listener,
ISaveableFrame,
ListSelectionListener {
    protected Color[] m_colors = new Color[12];
    protected Color[] m_dotColor;
    protected Java2D_VertStackedEnsembleDisplayWidget m_widget;
    protected int m_maxPlots = 6;
    protected int m_numVisible = 3;
    protected ArrayList<PlotData> m_plotDataList = new ArrayList();
    protected Java2D_UserEventConsumer_KeyPressed m_keyBasemapUEC = new Java2D_UserEventConsumer_KeyPressed();
    protected JComboBox<String> m_comboNumPlots;
    protected JComboBox<String> m_comboNumHeaders;
    protected JComboBox<String> m_comboNumHeaderPlot;
    protected BitmapCardWidget m_bitmapCardWidget = new BitmapCardWidget();
    protected PickerBasemapWidget m_basemapWidget;
    protected Sequence_MainWidget m_workerWidget;
    protected PickDisplayWidget m_pickDisplayWidget;
    protected EnsembleVisibleTraceSelectionWidget m_visibleWidget;
    protected EnsembleAxisSelectionWidget m_axisWidget;
    protected ProfileSelectorWidget m_profileWidget;
    protected Java2D_EnsembleDisplayOptionsWidget m_wiggleOptionsWidget;
    protected TraceBackgroundWidget m_traceBackgroundWidget;
    protected EnsembleWorker_Sequence m_sequence;
    protected Java2D_AxisLocker m_axisLockerOffset;
    protected Java2D_AxisLocker m_axisLockerTime;
    protected PickerGizmoWidget m_pickerGizmoWidget;
    protected BitmapCardWidget m_rightBitmapCardWidget = new BitmapCardWidget();
    protected ParameterTree m_parameters = new ParameterTree();
    protected String m_paramFileName;
    protected ParameterTreeWidgetManager m_paramManager = new ParameterTreeWidgetManager();
    protected Timer m_timer = new Timer(5000, this);
    protected boolean m_ignoreEvent = false;
    protected JTabbedPane m_sequenceTabs = new JTabbedPane();
    protected int m_widgetNumber = 1;
    protected String m_autoPickColumnName = "";

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Refraction.Picking.BasicPickWidget_MultipleProfilePanel";
    }

    @Override
    public String TAB_LABEL() {
        return "MultiProfilePicker";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "MultiProfilePicker";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return false;
    }

    public BasicPickWidget_MultipleProfilePanel() {
        super(1);
        try {
            int n;
            try {
                int n2;
                this.m_colors[0] = new Color(255, 128, 128);
                this.m_colors[1] = new Color(128, 255, 128);
                this.m_colors[2] = new Color(128, 128, 255);
                this.m_colors[3] = new Color(255, 255, 128);
                this.m_colors[4] = new Color(255, 128, 255);
                this.m_colors[5] = new Color(128, 255, 255);
                for (n2 = 6; n2 < this.m_colors.length; ++n2) {
                    this.m_colors[n2] = this.m_colors[n2 % 6];
                }
                this.m_dotColor = new Color[this.m_colors.length];
                for (n2 = 0; n2 < this.m_colors.length; ++n2) {
                    Color c = this.m_colors[n2];
                    this.m_dotColor[n2] = new Color(c.getRed(), c.getGreen(), c.getBlue(), 128);
                }
            }
            catch (Exception ec) {
                ec.printStackTrace();
            }
            for (n = 0; n < this.m_maxPlots; ++n) {
                PlotData pd = new PlotData();
                pd.KeyUEC.addListener(this);
                pd.LeftClickUEC.addListener(this);
                pd.LineSegmentUEC.addListener(this);
                pd.MiddleClickUEC.addListener(this);
                pd.MouseMoveUEC.addListener(this);
                pd.RubberBandUEC.addListener(this);
                this.m_plotDataList.add(pd);
            }
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRightParent());
            this.m_profileWidget.setNumberOfProfiles(this.m_maxPlots);
            for (n = 0; n < this.m_maxPlots; ++n) {
                this.m_profileWidget.setProfileColor(n, this.m_colors[n]);
            }
            this.m_profileWidget.reloadPlot();
            this.setOneTouchExpandable(true);
            Messenger.singleton().addListener(this);
            PickerGizmo.singleton().listener().addListener(this);
            this.plotLayout();
            this.loadUEC();
            this.m_profileWidget.azimuthSelectorWidget().listener().addListener(this);
            this.m_timer.start();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected JComponent createRightParent() {
        try {
            JSplitPane splitter = new JSplitPane(1);
            splitter.setLeftComponent(this.createRightPlot());
            splitter.setRightComponent(this.createRightRight());
            splitter.setOneTouchExpandable(true);
            splitter.setResizeWeight(1.0);
            return splitter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightPlot() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_widget = new Java2D_VertStackedEnsembleDisplayWidget(this.m_maxPlots);
            this.m_widget.setVisibleCount(this.m_numVisible);
            this.m_widget.setHeaderPlotVisibleCount(0, 1);
            this.m_widget.setEnsembleDisplayOptionsWidget(this.m_wiggleOptionsWidget);
            main.addComponent(this.m_widget, 10);
            for (int n = 0; n < this.m_maxPlots; ++n) {
                this.m_widget.setTimeAxisColor(n, this.m_colors[n % 10]);
            }
            this.m_widget.addListener(this);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightRight() {
        try {
            this.m_rightBitmapCardWidget.setPreferredSize(new Dimension(200, 500));
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_axisLockerOffset = new Java2D_AxisLocker("Horizontal lock", "Lock axis ");
            this.m_axisLockerOffset.listener().addListener(this);
            this.m_axisLockerTime = new Java2D_AxisLocker("Time lock", "Lock axis ");
            this.m_axisLockerTime.listener().addListener(this);
            this.m_axisLockerTime.setRange(-400.0, 500.0);
            main.addComponent(this.m_axisLockerOffset, 0);
            main.addComponent(this.m_axisLockerTime, 0);
            main.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(main, -1, null, true);
            this.m_pickerGizmoWidget = new PickerGizmoWidget();
            this.m_rightBitmapCardWidget.addComponent(BitmapEnum.TaskList, main, "Axis locks ");
            this.m_rightBitmapCardWidget.addComponent(BitmapEnum.PickControl, this.m_pickerGizmoWidget, "Picker controls");
            return this.m_rightBitmapCardWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            if (this.m_ignoreEvent) {
                return;
            }
            this.m_ignoreEvent = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createBasemap() {
        try {
            LinearLayoutWidget baseMap = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_basemapWidget = new PickerBasemapWidget(this);
            baseMap.addComponent(this.m_basemapWidget, 10);
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Basemap, baseMap, "Basemap");
            this.m_keyBasemapUEC.addListener(this);
            this.m_basemapWidget.setKeyPressedUEC(this.m_keyBasemapUEC);
            return baseMap;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeft() {
        try {
            this.m_profileWidget = new ProfileSelectorWidget(true, this, this.m_maxPlots);
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Profile, this.m_profileWidget, "Profile selection");
            this.m_comboNumPlots = this.m_profileWidget.comboNumPlots();
            this.m_comboNumHeaders = this.m_profileWidget.comboNumHeaders();
            this.m_comboNumHeaderPlot = this.m_profileWidget.comboNumHeaderPlot();
            this.m_comboNumPlots.addItemListener(this);
            this.m_comboNumHeaders.addItemListener(this);
            this.m_comboNumHeaderPlot.addItemListener(this);
            this.createBasemap();
            this.m_workerWidget = new Sequence_MainWidget("MultiPicker", EnsembleWorker_Sequence.SequenceType.Interactive);
            this.m_sequence = this.m_workerWidget.sequence();
            this.m_sequence.addListener(this);
            this.m_sequenceTabs.addTab("Shared", this.m_workerWidget);
            for (int n = 0; n < this.m_maxPlots; ++n) {
                PlotData pd = this.m_plotDataList.get(n);
                pd.WorkerWidget = new Sequence_MainWidget("MultiPicker_" + Integer.toString(n + 1), EnsembleWorker_Sequence.SequenceType.Interactive);
                String s = "# " + Integer.toString(n + 1);
                this.m_sequenceTabs.addTab(s, pd.WorkerWidget);
                pd.Sequence = pd.WorkerWidget.sequence();
                pd.Sequence.addListener(this);
                JLabel lbl = new JLabel(s);
                lbl.setForeground(this.m_colors[n]);
                this.m_sequenceTabs.setTabComponentAt(n + 1, lbl);
            }
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Sequence, this.m_sequenceTabs, "Ensemble processing sequence");
            this.m_axisWidget = new EnsembleAxisSelectionWidget();
            this.m_axisWidget.listener().addListener(this);
            this.m_axisWidget.setPickPlane(PickPlaneEnum.Shot);
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Axis, this.m_axisWidget, "Horizontal axis selection");
            this.m_visibleWidget = new EnsembleVisibleTraceSelectionWidget(null);
            this.m_visibleWidget.listener().addListener(this);
            this.m_bitmapCardWidget.addComponent(BitmapEnum.VisibleTraces, this.m_visibleWidget, "Select visible traces");
            LinearLayoutWidget disp = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_traceBackgroundWidget = new TraceBackgroundWidget("Trace color");
            this.m_traceBackgroundWidget.listener().addListener(this);
            this.m_wiggleOptionsWidget = new Java2D_EnsembleDisplayOptionsWidget("Trace display options");
            this.m_wiggleOptionsWidget.listener().addListener(this);
            this.m_pickDisplayWidget = new PickDisplayWidget();
            this.m_pickDisplayWidget.getListenerController().addListener(this);
            disp.addComponent(this.m_wiggleOptionsWidget, 0);
            disp.addComponent(this.m_traceBackgroundWidget, 0);
            disp.addComponent(this.m_pickDisplayWidget, 10);
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Wiggle, disp, "Wiggle display options");
            return this.m_bitmapCardWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected void plotLayout() {
        try {
            this.m_numVisible = 1 + this.m_comboNumPlots.getSelectedIndex();
            this.m_widget.setVisibleCount(this.m_numVisible);
            int numTextHeaders = this.m_comboNumHeaders.getSelectedIndex();
            int numPlotHeaders = this.m_comboNumHeaderPlot.getSelectedIndex();
            for (int n = 0; n < this.m_numVisible; ++n) {
                this.m_widget.setHeaderPlotVisibleCount(n, numPlotHeaders);
                this.m_widget.HeaderTextRowCount = numTextHeaders;
            }
            this.m_widget.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void handleKeyUEC(Java2D_UserEventConsumer_KeyPressed keyUEC, int plotIndex) {
        try {
            PickerGizmo pg = PickerGizmo.singleton();
            boolean mapUEC = keyUEC == this.m_keyBasemapUEC;
            boolean plotUEC = plotIndex >= 0;
            PlotData pd = null;
            if (plotIndex >= 0) {
                pd = this.m_plotDataList.get(plotIndex);
            }
            if (keyUEC.EscapePressed) {
                if (plotUEC) {
                    PickerGizmo.broadcastControlClick(this, pd.ProcessedEnsemble, keyUEC.PixelX);
                }
                return;
            }
            if (pg.keyOff(keyUEC)) {
                return;
            }
            if (pg.keyPriorEnsemble(keyUEC)) {
                this.m_profileWidget.priorOffsetBin();
                return;
            }
            if (pg.keyNextEnsemble(keyUEC)) {
                this.m_profileWidget.nextOffsetBin();
                return;
            }
            if (pg.keyNextGroup(keyUEC)) {
                this.m_profileWidget.nextOffsetBin();
                return;
            }
            if (pg.keyPriorGroup(keyUEC)) {
                this.m_profileWidget.priorOffsetBin();
                return;
            }
            boolean lockedViewport = false;
            if (pg.keyGeomCorrection(keyUEC)) {
                this.m_basemapWidget.lockCurrentViewport();
                lockedViewport = true;
            }
            if (pd != null && pg.handleKey(keyUEC, pd.ProcessedEnsemble, pd.InputEnsemble, this.m_sequence, plotUEC, this.m_widget.transform(0), false)) {
                this.handlePicksModified(plotIndex, true, false);
            }
            if (lockedViewport) {
                this.m_basemapWidget.unlockCurrentViewport();
                this.m_basemapWidget.widget().mainWidget().repaint();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void handlePicksModified(int plotIndex, boolean emitMessage, boolean forceBranchModified) {
        try {
            PickerGizmo pg = PickerGizmo.singleton();
            PlotData pd = this.m_plotDataList.get(plotIndex);
            boolean repaintBasemap = false;
            boolean delayTimesModified = false;
            if (repaintBasemap) {
                this.m_basemapWidget.reloadDelayTimePlot();
            }
            if (emitMessage) {
                Messenger.broadcast(Messenger.Message.PicksChanged, this, pd.InputEnsemble);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepareAllWidgets() {
        try {
            for (int n = 0; n < this.m_numVisible - 1; ++n) {
                this.prepareWidget(n, PrepActionEnum.DoNothing);
            }
            this.prepareWidget(this.m_numVisible - 1, PrepActionEnum.Unzoom);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void handleProfileWidget() {
        try {
            int binIndex = this.m_profileWidget.getMultiPanelOffsetBinIndex();
            boolean twoBins = this.m_profileWidget.getMultiPanelLoadTwoOffsetBins();
            for (int n = 0; n < this.m_numVisible; ++n) {
                PlotData pd = this.m_plotDataList.get(n);
                pd.InputEnsemble.clearTraces(false);
                SeismicProfile profile = this.m_profileWidget.getMultiPanelProfile(n);
                if (profile != null) {
                    profile.offsetGathers().populateEnsemble(binIndex, pd.InputEnsemble, false, false);
                    if (twoBins) {
                        profile.offsetGathers().populateEnsemble(binIndex + 1, pd.InputEnsemble, false, false);
                    }
                    RefractionStaticsProject.singleton().traceTableWrapper().traceTable().populateEnsembleUsingTraceIndex(pd.InputEnsemble);
                    RefractionStaticsProject.singleton().prepGeometryHeaders(pd.InputEnsemble, true, true);
                    RefractionStaticsProject.singleton().inputDataProcessor_Run(pd.InputEnsemble);
                }
                if (n == this.m_numVisible - 1) {
                    this.processEnsemble(n, PrepActionEnum.Unzoom);
                    continue;
                }
                this.processEnsemble(n, PrepActionEnum.DoNothing);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            int n;
            if (sender == this.m_profileWidget.azimuthSelectorWidget()) {
                this.prepareAllWidgets();
                return;
            }
            if (sender == this.m_profileWidget) {
                this.handleProfileWidget();
                return;
            }
            PickerGizmo pg = PickerGizmo.singleton();
            pg.PickName = "FBP_User";
            for (n = 0; n < this.m_numVisible; ++n) {
                PlotData pd = this.m_plotDataList.get(n);
                if (pd.KeyUEC == sender) {
                    this.handleKeyUEC(pd.KeyUEC, n);
                    return;
                }
                if (sender == pd.LineSegmentUEC) {
                    if (pd.LineSegmentUEC.Dragging) {
                        return;
                    }
                    if (!pd.LineSegmentUEC.Finished) {
                        return;
                    }
                    if (pg.handleControlPoint(pd.LineSegmentUEC, pd.ProcessedEnsemble, pd.InputEnsemble)) {
                        this.handlePicksModified(n, true, false);
                    }
                    return;
                }
                if (sender == pd.RubberBandUEC) {
                    if (pd.RubberBandUEC.Dragging) {
                        return;
                    }
                    if (!pd.RubberBandUEC.Finished) {
                        return;
                    }
                    if (pg.handleRubberBand(pd.RubberBandUEC, pd.ProcessedEnsemble, pd.InputEnsemble)) {
                        this.handlePicksModified(n, true, false);
                    }
                    return;
                }
                if (sender != pd.Sequence || !pd.Sequence.MessageData.SequenceModified) continue;
                this.processEnsemble(n, PrepActionEnum.JustRepaint);
            }
            if (sender == PickerGizmo.singleton()) {
                this.loadUEC();
                return;
            }
            if (sender == this.m_keyBasemapUEC) {
                this.handleKeyUEC(this.m_keyBasemapUEC, -9999);
                return;
            }
            for (n = 0; n < this.m_maxPlots; ++n) {
            }
            if (sender == this.m_sequence) {
                if (this.m_sequence.MessageData.SequenceModified) {
                    for (n = 0; n < this.m_numVisible - 1; ++n) {
                        this.processEnsemble(n, PrepActionEnum.DoNothing);
                    }
                    this.processEnsemble(this.m_numVisible - 1, PrepActionEnum.JustRepaint);
                }
                if (this.m_sequence.MessageData.MessageFromWorker) {
                    // empty if block
                }
                return;
            }
            if (sender == this.m_axisWidget) {
                if (this.m_axisWidget.isUniformSpacing()) {
                    this.m_widget.setAxisTableColumn("Trace", "TempAxisValue");
                    this.m_widget.setAxisType(Java2D_EnsembleAxisEnum.TraceHeader);
                } else {
                    this.m_widget.setAxisTableColumn(this.m_axisWidget.getAxisTable(), this.m_axisWidget.getAxisColumn());
                    this.m_widget.setAxisType(Java2D_EnsembleAxisEnum.TraceHeader);
                }
                this.prepareAllWidgets();
                return;
            }
            if (sender == this.m_axisLockerOffset) {
                this.m_widget.setAxisLocked_X(this.m_axisLockerOffset.locked(), this.m_axisLockerOffset.min(), this.m_axisLockerOffset.max());
                return;
            }
            if (sender == this.m_axisLockerTime) {
                this.m_widget.setAxisLocked_Time(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
                return;
            }
            if (sender == this.m_visibleWidget) {
                this.prepareAllWidgets();
                return;
            }
            if (sender == this.m_traceBackgroundWidget) {
                this.prepareAllWidgets();
                return;
            }
            if (sender == this.m_wiggleOptionsWidget) {
                this.saveParameters();
                this.prepareAllWidgets();
                return;
            }
            if (sender == this.m_pickDisplayWidget) {
                this.saveParameters();
                this.prepareAllWidgets();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void finalize() {
        try {
            this.saveParameters();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public int getWidgetNumber() {
        return this.m_widgetNumber;
    }

    @Override
    public void setWidgetNumber(int number) {
        this.m_widgetNumber = number;
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            String pickerType = "MultiOffsetPanelPicker";
            String root = p.guiOptionsPath() + "/" + pickerType + Integer.toString(this.m_widgetNumber);
            this.m_paramFileName = root + "Options.xml";
            this.m_parameters.read(this.m_paramFileName);
            this.m_paramManager.addComboBoxConnector("PlotCount", this.m_comboNumPlots, 3);
            this.m_paramManager.addComboBoxConnector("NumHeaders", this.m_comboNumHeaders, 2);
            this.m_paramManager.addComboBoxConnector("NumHeaderPlots", this.m_comboNumHeaderPlot, 1);
            this.m_paramManager.setTree(this.m_parameters.ParameterTree_get("MainWindowOptions"));
            this.m_axisWidget.setParentParameterTree(this.m_parameters);
            this.m_wiggleOptionsWidget.setParentParameterTree(this.m_parameters);
            this.m_visibleWidget.setParentParameterTree(this.m_parameters);
            this.m_traceBackgroundWidget.setParentParameterTree(this.m_parameters);
            this.m_axisLockerOffset.setParentParameterTree(this.m_parameters, "OffsetLocker");
            this.m_axisLockerTime.setParentParameterTree(this.m_parameters, "TimeLocker");
            String sfn = root + ".SequenceXML";
            this.m_workerWidget.setFileName(sfn);
            for (int n = 0; n < this.m_maxPlots; ++n) {
                PlotData pd = this.m_plotDataList.get(n);
                String fn = root + "_" + Integer.toString(n + 1) + ".SequenceXML";
                pd.WorkerWidget.setFileName(fn);
            }
            this.m_widget.setAxisLocked_X(this.m_axisLockerOffset.locked(), this.m_axisLockerOffset.min(), this.m_axisLockerOffset.max());
            this.m_widget.setAxisLocked_Time(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
            this.m_widget.setParameterTree(this.m_parameters.ParameterTree_get("Display"));
            if (this.m_axisWidget.isUniformSpacing()) {
                this.m_widget.setAxisTableColumn("Trace", "TempAxisValue");
                this.m_widget.setAxisType(Java2D_EnsembleAxisEnum.TraceHeader);
            } else {
                this.m_widget.setAxisTableColumn(this.m_axisWidget.getAxisTable(), this.m_axisWidget.getAxisColumn());
                this.m_widget.setAxisType(Java2D_EnsembleAxisEnum.TraceHeader);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void saveParameters() {
        try {
            this.m_paramManager.saveParameters();
            this.m_axisWidget.saveParameters();
            this.m_wiggleOptionsWidget.saveParameters();
            this.m_axisLockerOffset.saveParameters();
            this.m_axisLockerTime.saveParameters();
            this.m_visibleWidget.saveParameters();
            this.m_traceBackgroundWidget.saveParameters();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleActionSequenceFinished(Action_Sequence sender) {
        try {
            if (this.m_autoPickColumnName == null) {
                return;
            }
            if (this.m_autoPickColumnName.isEmpty()) {
                return;
            }
            RefractionProjectSuggestions.singleton().autopickSuggestion(this.m_autoPickColumnName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handlePopupMenuButton(PopupMenuButton button, String text) {
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.OffsetBinSizeChanged) {
                // empty if block
            }
            if (message == Messenger.Message.PicksChanged) {
                PlotData pd;
                int n;
                Ensemble ensemble = (Ensemble)data;
                boolean modified = false;
                for (n = 0; n < this.m_maxPlots; ++n) {
                    pd = this.m_plotDataList.get(n);
                    int numMod = Tools_Ensemble.copyHeaderValue(ensemble, pd.InputEnsemble, "Trace", "FBP_User");
                    modified = modified || numMod > 0;
                }
                if (!modified) {
                    return;
                }
                for (n = 0; n < this.m_numVisible; ++n) {
                    pd = this.m_plotDataList.get(n);
                    if (n == this.m_numVisible - 1) {
                        this.processEnsemble(n, PrepActionEnum.JustRepaint);
                        continue;
                    }
                    this.processEnsemble(n, PrepActionEnum.DoNothing);
                }
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleEnsembleWidgetPaintEvent(Java2D_VertStackedEnsembleDisplayWidget widget, int widgetIndex, boolean imagePainted) {
        try {
            if (imagePainted && widgetIndex == 0) {
                Java2D_Paintable_SelectedEntries p = new Java2D_Paintable_SelectedEntries("Shot");
                for (int n = 0; n < this.m_numVisible; ++n) {
                    PlotData pd = this.m_plotDataList.get(n);
                    p.add(pd.ShotID, this.m_colors[n]);
                }
                this.m_basemapWidget.clearUnderlayList();
                this.m_basemapWidget.addUnderlay(p, -9999);
                this.m_basemapWidget.reloadPlot(false);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void prepareWidget(int index, PrepActionEnum action) {
        try {
            if (index < 0 || index >= this.m_numVisible) {
                return;
            }
            PlotData pd = this.m_plotDataList.get(index);
            if (SharedApplicationData.JobRunning) {
                return;
            }
            this.m_profileWidget.azimuthSelectorWidget().prepEnsemble(pd.ProcessedEnsemble, true);
            if (pd.ProcessedEnsemble != null) {
                this.m_pickDisplayWidget.prepEnsemble(pd.ProcessedEnsemble);
            }
            this.m_widget.setEnsemble(index, pd.ProcessedEnsemble);
            this.m_visibleWidget.setVisibleTraces(pd.ProcessedEnsemble);
            this.m_traceBackgroundWidget.setBackground(pd.ProcessedEnsemble);
            if (this.m_axisWidget.isUniformSpacing()) {
                this.m_axisWidget.sortEnsemble(pd.ProcessedEnsemble);
            }
            Tools_Ensemble.prepTempAxisValue(pd.ProcessedEnsemble);
            if (action == PrepActionEnum.Unzoom) {
                this.m_widget.clearAndLoadWigglePaintables();
                this.m_widget.unzoom();
                return;
            }
            if (action == PrepActionEnum.JustRepaint) {
                this.m_widget.forcePaintAll();
                return;
            }
            if (action != PrepActionEnum.DoNothing) return;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void processEnsemble(int index, PrepActionEnum action) {
        try {
            if (index < 0 || index >= this.m_numVisible) {
                return;
            }
            PlotData pd = this.m_plotDataList.get(index);
            if (SharedApplicationData.JobRunning) {
                return;
            }
            pd.InputEnsemble.resetAllKillFlags();
            pd.InputEnsemble.copyToOtherEnsemble(pd.InputEnsemble_Copy);
            pd.InputEnsemble_Copy.pickPlotData().clearRequiredList();
            if (pd.InputEnsemble_Copy.traceCount() > 0) {
                pd.ProcessedEnsemble = this.m_sequence.work(pd.InputEnsemble_Copy);
                pd.ProcessedEnsemble = pd.Sequence.work(pd.ProcessedEnsemble);
            }
            if (index == 0) {
                this.m_axisWidget.setEnsembleHeaderDictionary(pd.ProcessedEnsemble.dictionary());
                this.m_visibleWidget.setEnsembleHeaderDictionary(pd.ProcessedEnsemble.dictionary());
            }
            this.prepareWidget(index, action);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_timer) {
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.plotLayout();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleBasemap_ReceiverSelected(int id) {
    }

    @Override
    public void handleBasemap_ReceiverDrag(double x, double y) {
    }

    @Override
    public void handleBasemap_ReceiverDragFinish(double x, double y) {
    }

    @Override
    public void handleBasemap_ShotDrag(double x, double y) {
    }

    @Override
    public void handleBasemap_ShotDragFinish(double x, double y) {
    }

    @Override
    public void handleBasemap_ShotSelected(int id) {
    }

    @Override
    public void handleBasemap_ShotSelected(int id, int plotIndex) {
    }

    @Override
    public void handleBasemap_Bin3DSelected(int inline, int crossline) {
    }

    @Override
    public void handleBasemap_Bin2DSelected(int bin) {
    }

    @Override
    public void handleBasemap_SparseCMPSelected(Ensemble ensemble) {
    }

    protected void loadUEC() {
        try {
            this.m_widget.clearUserEventConsumerList();
            PickerGizmo pg = PickerGizmo.singleton();
            boolean needControlPoint = pg.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointAdd || pg.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointKill || pg.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointSelect;
            for (int n = 0; n < this.m_plotDataList.size(); ++n) {
                this.m_widget.clearUserEventConsumerList(n);
                PlotData pd = this.m_plotDataList.get(n);
                if (needControlPoint) {
                    this.m_widget.addEventConsumer(n, pd.LineSegmentUEC);
                } else {
                    this.m_widget.addEventConsumer(n, pd.LeftClickUEC);
                }
                this.m_widget.addEventConsumer(n, pd.RubberBandUEC);
                this.m_widget.addEventConsumer(n, pd.MiddleClickUEC);
                this.m_widget.addEventConsumer(n, pd.MouseMoveUEC);
                this.m_widget.addEventConsumer(n, pd.KeyUEC);
                this.m_widget.addZoomer();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected class PlotData {
        public int ShotID = -9999;
        public Ensemble InputEnsemble = new Ensemble();
        public Ensemble InputEnsemble_Copy = new Ensemble();
        public Ensemble ProcessedEnsemble = new Ensemble();
        public Java2D_UserEventConsumer_MultiLineSegments LineSegmentUEC = new Java2D_UserEventConsumer_MultiLineSegments();
        public Java2D_UserEventConsumer_MultiLineSegments RubberBandUEC = new Java2D_UserEventConsumer_MultiLineSegments(true);
        public Java2D_UserEventConsumer_KeyPressed KeyUEC = new Java2D_UserEventConsumer_KeyPressed();
        public Java2D_UserEventConsumer_ButtonPressed LeftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
        public Java2D_UserEventConsumer_MouseMove MouseMoveUEC = new Java2D_UserEventConsumer_MouseMove();
        public Java2D_UserEventConsumer_ButtonPressed MiddleClickUEC = new Java2D_UserEventConsumer_ButtonPressed(2);
        public Sequence_MainWidget WorkerWidget;
        public EnsembleWorker_Sequence Sequence;

        protected PlotData() {
        }
    }

    protected static enum PrepActionEnum {
        DoNothing,
        JustRepaint,
        Unzoom;

    }
}

