/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Picking;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Refraction.Picking.PickPlaneEnum;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Action_Sequence;
import com.PecosLibrary.Refraction.DelayTime.Tools_DelayTime;
import com.PecosLibrary.Refraction.DelayTime.Tools_DelayTime_Geometry;
import com.PecosLibrary.Refraction.PickerGizmo;
import com.PecosLibrary.Refraction.RefractionProjectSuggestions;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Windows.ApplicationFrames.INumberedWidget;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_MainWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_VertStackedEnsembleDisplayWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_AxisLocker;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_SelectedEntries;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_KeyPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MouseMove;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MultiLineSegments;
import com.PecosLibrary.Windows.Refraction.Database.UniqueColumnCombo;
import com.PecosLibrary.Windows.Refraction.Picking.EnsembleAxisSelectionWidget;
import com.PecosLibrary.Windows.Refraction.Picking.EnsembleVisibleTraceSelectionWidget;
import com.PecosLibrary.Windows.Refraction.Picking.NavigationWidget;
import com.PecosLibrary.Windows.Refraction.Picking.PickDisplayWidget;
import com.PecosLibrary.Windows.Refraction.Picking.PickerBasemapWidget;
import com.PecosLibrary.Windows.Refraction.Picking.PickerGizmoWidget;
import com.PecosLibrary.Windows.Refraction.Picking.TraceBackgroundWidget;
import com.PecosLibrary.Windows.Shared.BitmapCardWidget;
import com.PecosLibrary.Windows.Shared.ParameterTreeWidgetManager;
import com.PecosLibrary.Windows.Shared.PopupMenuButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.Timer;

public class BasicPickWidget_MultiplePanel
extends JSplitPane
implements INumberedWidget,
ActionListener,
GenericObjectListener.Listener,
ItemListener,
PickerBasemapWidget.Listener,
Java2D_VertStackedEnsembleDisplayWidget.Listener,
Messenger.Listener,
PopupMenuButton.Listener,
Action_Sequence.Listener,
ISaveableFrame {
    protected Color[] m_colors = new Color[12];
    protected Color[] m_dotColor;
    protected Java2D_VertStackedEnsembleDisplayWidget m_widget;
    protected int m_maxPlots = 6;
    protected int m_numVisible = 3;
    protected ArrayList<PlotData> m_plotDataList = new ArrayList();
    protected Java2D_UserEventConsumer_KeyPressed m_keyBasemapUEC = new Java2D_UserEventConsumer_KeyPressed();
    protected JComboBox<String> m_comboNumPlots;
    protected JComboBox<String> m_comboNumHeaders;
    protected JComboBox<String> m_comboNumHeaderPlot;
    protected UniqueColumnCombo[] m_uniqueColumnCombo;
    protected BitmapCardWidget m_bitmapCardWidget = new BitmapCardWidget();
    protected PickerBasemapWidget m_basemapWidget;
    protected Sequence_MainWidget m_workerWidget;
    protected PickDisplayWidget m_pickDisplayWidget;
    protected EnsembleVisibleTraceSelectionWidget m_visibleWidget;
    protected EnsembleAxisSelectionWidget m_axisWidget;
    protected NavigationWidget m_shotNavigationWidget;
    protected Java2D_EnsembleDisplayOptionsWidget m_wiggleOptionsWidget;
    protected TraceBackgroundWidget m_traceBackgroundWidget;
    protected EnsembleWorker_Sequence m_sequence;
    protected Java2D_AxisLocker m_axisLockerOffset;
    protected Java2D_AxisLocker m_axisLockerTime;
    protected PickerGizmoWidget m_pickerGizmoWidget;
    protected BitmapCardWidget m_rightBitmapCardWidget = new BitmapCardWidget();
    protected ParameterTree m_parameters = new ParameterTree();
    protected String m_paramFileName;
    protected ParameterTreeWidgetManager m_paramManager = new ParameterTreeWidgetManager();
    protected Timer m_timer = new Timer(5000, this);
    protected JTabbedPane m_sequenceTabs = new JTabbedPane();
    protected int m_widgetNumber = 1;
    protected String m_autoPickColumnName = "";

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Refraction.Picking.BasicPickWidget_MultiplePanel";
    }

    @Override
    public String TAB_LABEL() {
        return "MultiPicker";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "MultiPicker";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return false;
    }

    public BasicPickWidget_MultiplePanel() {
        super(1);
        try {
            try {
                int n;
                this.m_colors[0] = new Color(255, 128, 128);
                this.m_colors[1] = new Color(128, 255, 128);
                this.m_colors[2] = new Color(128, 128, 255);
                this.m_colors[3] = new Color(255, 255, 128);
                this.m_colors[4] = new Color(255, 128, 255);
                this.m_colors[5] = new Color(128, 255, 255);
                for (n = 6; n < this.m_colors.length; ++n) {
                    this.m_colors[n] = this.m_colors[n % 6];
                }
                this.m_dotColor = new Color[this.m_colors.length];
                for (n = 0; n < this.m_colors.length; ++n) {
                    Color c = this.m_colors[n];
                    this.m_dotColor[n] = new Color(c.getRed(), c.getGreen(), c.getBlue(), 128);
                }
            }
            catch (Exception ec) {
                ec.printStackTrace();
            }
            for (int n = 0; n < this.m_maxPlots; ++n) {
                PlotData pd = new PlotData();
                pd.KeyUEC.addListener(this);
                pd.LeftClickUEC.addListener(this);
                pd.LineSegmentUEC.addListener(this);
                pd.MiddleClickUEC.addListener(this);
                pd.MouseMoveUEC.addListener(this);
                pd.RubberBandUEC.addListener(this);
                this.m_plotDataList.add(pd);
            }
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRightParent());
            this.setOneTouchExpandable(true);
            Messenger.singleton().addListener(this);
            PickerGizmo.singleton().listener().addListener(this);
            this.plotLayout();
            this.loadUEC();
            this.m_timer.start();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected JComponent createRightParent() {
        try {
            JSplitPane splitter = new JSplitPane(1);
            splitter.setLeftComponent(this.createRightPlot());
            splitter.setRightComponent(this.createRightRight());
            splitter.setOneTouchExpandable(true);
            splitter.setResizeWeight(1.0);
            return splitter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightPlot() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_widget = new Java2D_VertStackedEnsembleDisplayWidget(this.m_maxPlots);
            this.m_widget.setVisibleCount(this.m_numVisible);
            this.m_widget.setHeaderPlotVisibleCount(0, 1);
            this.m_widget.setEnsembleDisplayOptionsWidget(this.m_wiggleOptionsWidget);
            main.addComponent(this.m_widget, 10);
            for (int n = 0; n < this.m_maxPlots; ++n) {
                this.m_widget.setTimeAxisColor(n, this.m_colors[n % 10]);
            }
            this.m_widget.addListener(this);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightRight() {
        try {
            this.m_rightBitmapCardWidget.setPreferredSize(new Dimension(200, 500));
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_axisLockerOffset = new Java2D_AxisLocker("Horizontal lock", "Lock axis ");
            this.m_axisLockerOffset.listener().addListener(this);
            this.m_axisLockerTime = new Java2D_AxisLocker("Time lock", "Lock axis ");
            this.m_axisLockerTime.listener().addListener(this);
            this.m_axisLockerTime.setRange(-400.0, 500.0);
            main.addComponent(this.m_axisLockerOffset, 0);
            main.addComponent(this.m_axisLockerTime, 0);
            main.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(main, -1, null, true);
            this.m_pickerGizmoWidget = new PickerGizmoWidget();
            this.m_rightBitmapCardWidget.addComponent(BitmapEnum.TaskList, main, "Axis locks ");
            this.m_rightBitmapCardWidget.addComponent(BitmapEnum.PickControl, this.m_pickerGizmoWidget, "Picker controls");
            return this.m_rightBitmapCardWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createBasemap() {
        try {
            int n;
            LinearLayoutWidget baseMap = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            LinearLayoutWidget top = baseMap.createHorizontal(3, null, 0);
            LinearLayoutWidget left = top.createVertical(0, null, 3);
            LinearLayoutWidget right = top.createVertical(0, "Shot selection", 10);
            this.m_comboNumPlots = new JComboBox();
            for (n = 1; n <= this.m_maxPlots; ++n) {
                this.m_comboNumPlots.addItem(Integer.toString(n));
            }
            this.m_comboNumPlots.setSelectedIndex(this.m_numVisible - 1);
            this.m_comboNumPlots.addItemListener(this);
            this.m_comboNumHeaders = new JComboBox();
            this.m_comboNumHeaders.addItem("None");
            for (n = 1; n < 5; ++n) {
                this.m_comboNumHeaders.addItem(Integer.toString(n));
            }
            this.m_comboNumHeaders.setSelectedIndex(1);
            this.m_comboNumHeaders.addItemListener(this);
            this.m_comboNumHeaderPlot = new JComboBox();
            this.m_comboNumHeaderPlot.addItem("None");
            for (n = 1; n <= 4; ++n) {
                this.m_comboNumHeaderPlot.addItem(String.format("%d", n));
            }
            this.m_comboNumHeaderPlot.setSelectedIndex(1);
            this.m_comboNumHeaderPlot.addItemListener(this);
            GridLayoutWidget headerGrid = new GridLayoutWidget(0, "Plot count, plot headers");
            headerGrid.addSimple(0, new JLabel("Number of plots"), this.m_comboNumPlots);
            headerGrid.addSimple(1, new JLabel("# text headers"), this.m_comboNumHeaders);
            headerGrid.addSimple(2, new JLabel("# plot headers"), this.m_comboNumHeaderPlot);
            left.addComponent(headerGrid, 0);
            left.addStretch(10);
            this.m_uniqueColumnCombo = new UniqueColumnCombo[this.m_maxPlots];
            for (int n2 = 0; n2 < this.m_maxPlots; ++n2) {
                this.m_uniqueColumnCombo[n2] = new UniqueColumnCombo();
                this.m_uniqueColumnCombo[n2].setTable(RefractionStaticsProject.singleton().shotTable());
                this.m_uniqueColumnCombo[n2].listener().addListener(this);
                this.m_uniqueColumnCombo[n2].setTextBackColor(this.m_colors[n2]);
                right.addComponent(this.m_uniqueColumnCombo[n2], 0);
            }
            Tools_FontChanger.changeSizeOfFont(top, -2, null, true);
            this.m_basemapWidget = new PickerBasemapWidget(this);
            baseMap.addComponent(this.m_basemapWidget, 10);
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Basemap, baseMap, "Basemap");
            this.m_keyBasemapUEC.addListener(this);
            this.m_basemapWidget.setKeyPressedUEC(this.m_keyBasemapUEC);
            return baseMap;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeft() {
        try {
            this.createBasemap();
            this.m_shotNavigationWidget = new NavigationWidget("Shot");
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Navigation, this.m_shotNavigationWidget, "Ensemble navigation sequence");
            this.m_shotNavigationWidget.listener().addListener(this);
            this.m_workerWidget = new Sequence_MainWidget("MultiPicker", EnsembleWorker_Sequence.SequenceType.Interactive);
            this.m_sequence = this.m_workerWidget.sequence();
            this.m_sequence.addListener(this);
            this.m_sequenceTabs.addTab("Shared", this.m_workerWidget);
            for (int n = 0; n < this.m_maxPlots; ++n) {
                PlotData pd = this.m_plotDataList.get(n);
                pd.WorkerWidget = new Sequence_MainWidget("MultiPicker_" + Integer.toString(n + 1), EnsembleWorker_Sequence.SequenceType.Interactive);
                String s = "# " + Integer.toString(n + 1);
                this.m_sequenceTabs.addTab(s, pd.WorkerWidget);
                pd.Sequence = pd.WorkerWidget.sequence();
                pd.Sequence.addListener(this);
                JLabel lbl = new JLabel(s);
                lbl.setForeground(this.m_colors[n]);
                this.m_sequenceTabs.setTabComponentAt(n + 1, lbl);
            }
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Sequence, this.m_sequenceTabs, "Ensemble processing sequence");
            this.m_axisWidget = new EnsembleAxisSelectionWidget();
            this.m_axisWidget.listener().addListener(this);
            this.m_axisWidget.setPickPlane(PickPlaneEnum.Shot);
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Axis, this.m_axisWidget, "Horizontal axis selection");
            this.m_visibleWidget = new EnsembleVisibleTraceSelectionWidget(null);
            this.m_visibleWidget.listener().addListener(this);
            this.m_bitmapCardWidget.addComponent(BitmapEnum.VisibleTraces, this.m_visibleWidget, "Select visible traces");
            LinearLayoutWidget disp = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_traceBackgroundWidget = new TraceBackgroundWidget("Trace color");
            this.m_traceBackgroundWidget.listener().addListener(this);
            this.m_wiggleOptionsWidget = new Java2D_EnsembleDisplayOptionsWidget("Trace display options");
            this.m_wiggleOptionsWidget.listener().addListener(this);
            this.m_pickDisplayWidget = new PickDisplayWidget();
            this.m_pickDisplayWidget.getListenerController().addListener(this);
            disp.addComponent(this.m_wiggleOptionsWidget, 0);
            disp.addComponent(this.m_traceBackgroundWidget, 0);
            disp.addComponent(this.m_pickDisplayWidget, 10);
            this.m_bitmapCardWidget.addComponent(BitmapEnum.Wiggle, disp, "Wiggle display options");
            return this.m_bitmapCardWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected void plotLayout() {
        try {
            this.m_numVisible = 1 + this.m_comboNumPlots.getSelectedIndex();
            this.m_widget.setVisibleCount(this.m_numVisible);
            int numTextHeaders = this.m_comboNumHeaders.getSelectedIndex();
            int numPlotHeaders = this.m_comboNumHeaderPlot.getSelectedIndex();
            for (int n = 0; n < this.m_numVisible; ++n) {
                this.m_widget.setHeaderPlotVisibleCount(n, numPlotHeaders);
                this.m_widget.HeaderTextRowCount = numTextHeaders;
            }
            this.m_widget.placeWidgets();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void handleKeyUEC(Java2D_UserEventConsumer_KeyPressed keyUEC, int plotIndex) {
        try {
            PickerGizmo pg = PickerGizmo.singleton();
            boolean mapUEC = keyUEC == this.m_keyBasemapUEC;
            boolean plotUEC = plotIndex >= 0;
            PlotData pd = null;
            if (plotIndex >= 0) {
                pd = this.m_plotDataList.get(plotIndex);
            }
            if (keyUEC.EscapePressed) {
                if (plotUEC) {
                    PickerGizmo.broadcastControlClick(this, pd.ProcessedEnsemble, keyUEC.PixelX);
                }
                return;
            }
            if (pg.keyOff(keyUEC)) {
                return;
            }
            if (pg.keyPriorEnsemble(keyUEC)) {
                this.priorEnsemble();
                return;
            }
            if (pg.keyNextEnsemble(keyUEC)) {
                this.nextEnsemble();
                return;
            }
            if (pg.keyNextGroup(keyUEC)) {
                this.nextEnsemble();
                return;
            }
            if (pg.keyPriorGroup(keyUEC)) {
                this.priorEnsemble();
                return;
            }
            boolean lockedViewport = false;
            if (pg.keyGeomCorrection(keyUEC)) {
                this.m_basemapWidget.lockCurrentViewport();
                lockedViewport = true;
            }
            if (pd != null && pg.handleKey(keyUEC, pd.ProcessedEnsemble, pd.InputEnsemble, this.m_sequence, plotUEC, this.m_widget.transform(0), false)) {
                this.handlePicksModified(plotIndex, true, false);
            }
            if (lockedViewport) {
                this.m_basemapWidget.unlockCurrentViewport();
                this.m_basemapWidget.widget().mainWidget().repaint();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void handlePicksModified(int plotIndex, boolean emitMessage, boolean forceBranchModified) {
        try {
            PickerGizmo pg = PickerGizmo.singleton();
            PlotData pd = this.m_plotDataList.get(plotIndex);
            boolean repaintBasemap = false;
            boolean delayTimesModified = false;
            if (pg.BranchPicksModified || forceBranchModified) {
                Tools_DelayTime_Geometry.singleton().computeGeometryCorrection(true, pd.InputEnsemble, "FBP_User");
                delayTimesModified = Tools_DelayTime.singleton().updateDelayTime_Shot(pd.InputEnsemble, true);
                pg.BranchPicksModified = false;
                repaintBasemap = true;
            }
            if (delayTimesModified && this.m_sequence.wasDelayTimeModelApplied()) {
                this.processEnsemble(plotIndex, PrepActionEnum.JustRepaint);
            } else {
                this.m_widget.forcePaintAll();
            }
            if (repaintBasemap) {
                this.m_basemapWidget.reloadDelayTimePlot();
            }
            if (emitMessage) {
                Messenger.broadcast(Messenger.Message.PicksChanged, this, pd.InputEnsemble);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void nextEnsemble() {
        try {
            this.m_shotNavigationWidget.goToNext(this.m_numVisible);
            this.loadAllShots();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void priorEnsemble() {
        try {
            this.m_shotNavigationWidget.goToPrevious(this.m_numVisible);
            this.loadAllShots();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void loadAllShots() {
        try {
            PrepActionEnum action = PrepActionEnum.DoNothing;
            for (int n = 0; n < this.m_numVisible; ++n) {
                int plotID = this.m_shotNavigationWidget.selected(n);
                if (n == this.m_numVisible - 1) {
                    action = PrepActionEnum.Unzoom;
                }
                this.loadShot(plotID, n, action);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepareAllWidgets() {
        try {
            for (int n = 0; n < this.m_numVisible - 1; ++n) {
                this.prepareWidget(n, PrepActionEnum.DoNothing);
            }
            this.prepareWidget(this.m_numVisible - 1, PrepActionEnum.Unzoom);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            int n;
            PickerGizmo pg = PickerGizmo.singleton();
            pg.PickName = "FBP_User";
            for (n = 0; n < this.m_numVisible; ++n) {
                PlotData pd = this.m_plotDataList.get(n);
                if (pd.KeyUEC == sender) {
                    this.handleKeyUEC(pd.KeyUEC, n);
                    return;
                }
                if (sender == pd.LineSegmentUEC) {
                    if (pd.LineSegmentUEC.Dragging) {
                        return;
                    }
                    if (!pd.LineSegmentUEC.Finished) {
                        return;
                    }
                    if (pg.handleControlPoint(pd.LineSegmentUEC, pd.ProcessedEnsemble, pd.InputEnsemble)) {
                        this.handlePicksModified(n, true, false);
                    }
                    return;
                }
                if (sender == pd.RubberBandUEC) {
                    if (pd.RubberBandUEC.Dragging) {
                        return;
                    }
                    if (!pd.RubberBandUEC.Finished) {
                        return;
                    }
                    if (pg.handleRubberBand(pd.RubberBandUEC, pd.ProcessedEnsemble, pd.InputEnsemble)) {
                        this.handlePicksModified(n, true, false);
                    }
                    return;
                }
                if (sender != pd.Sequence || !pd.Sequence.MessageData.SequenceModified) continue;
                this.processEnsemble(n, PrepActionEnum.JustRepaint);
            }
            if (this.m_shotNavigationWidget == sender) {
                this.loadAllShots();
                return;
            }
            if (sender == PickerGizmo.singleton()) {
                this.loadUEC();
                return;
            }
            if (sender == this.m_keyBasemapUEC) {
                this.handleKeyUEC(this.m_keyBasemapUEC, -9999);
                return;
            }
            for (n = 0; n < this.m_maxPlots; ++n) {
                if (sender != this.m_uniqueColumnCombo[n]) continue;
                this.loadShot(this.m_uniqueColumnCombo[n].getSelectedID(), n, PrepActionEnum.Unzoom);
                return;
            }
            if (sender == this.m_sequence) {
                if (this.m_sequence.MessageData.SequenceModified) {
                    for (n = 0; n < this.m_numVisible - 1; ++n) {
                        this.processEnsemble(n, PrepActionEnum.DoNothing);
                    }
                    this.processEnsemble(this.m_numVisible - 1, PrepActionEnum.JustRepaint);
                }
                if (this.m_sequence.MessageData.MessageFromWorker) {
                    // empty if block
                }
                return;
            }
            if (sender == this.m_axisWidget) {
                if (this.m_axisWidget.isUniformSpacing()) {
                    this.m_widget.setAxisType(Java2D_EnsembleAxisEnum.UniformSpacing);
                } else {
                    this.m_widget.setAxisTableColumn(this.m_axisWidget.getAxisTable(), this.m_axisWidget.getAxisColumn());
                    this.m_widget.setAxisType(Java2D_EnsembleAxisEnum.TraceHeader);
                }
                this.prepareAllWidgets();
                return;
            }
            if (sender == this.m_axisLockerOffset) {
                this.m_widget.setAxisLocked_X(this.m_axisLockerOffset.locked(), this.m_axisLockerOffset.min(), this.m_axisLockerOffset.max());
                return;
            }
            if (sender == this.m_axisLockerTime) {
                this.m_widget.setAxisLocked_Time(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
                return;
            }
            if (sender == this.m_visibleWidget) {
                this.prepareAllWidgets();
                return;
            }
            if (sender == this.m_traceBackgroundWidget) {
                this.prepareAllWidgets();
                return;
            }
            if (sender == this.m_wiggleOptionsWidget) {
                this.saveParameters();
                this.prepareAllWidgets();
                return;
            }
            if (sender == this.m_pickDisplayWidget) {
                this.saveParameters();
                this.prepareAllWidgets();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void finalize() {
        try {
            this.saveParameters();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public int getWidgetNumber() {
        return this.m_widgetNumber;
    }

    @Override
    public void setWidgetNumber(int number) {
        this.m_widgetNumber = number;
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            String pickerType = "MultiPicker";
            String root = p.guiOptionsPath() + "/" + pickerType + Integer.toString(this.m_widgetNumber);
            this.m_paramFileName = root + "Options.xml";
            this.m_parameters.read(this.m_paramFileName);
            this.m_paramManager.addComboBoxConnector("PlotCount", this.m_comboNumPlots, 3);
            this.m_paramManager.addComboBoxConnector("NumHeaders", this.m_comboNumHeaders, 2);
            this.m_paramManager.addComboBoxConnector("NumHeaderPlots", this.m_comboNumHeaderPlot, 1);
            this.m_paramManager.setTree(this.m_parameters.ParameterTree_get("MainWindowOptions"));
            this.m_axisWidget.setParentParameterTree(this.m_parameters);
            this.m_wiggleOptionsWidget.setParentParameterTree(this.m_parameters);
            this.m_visibleWidget.setParentParameterTree(this.m_parameters);
            this.m_traceBackgroundWidget.setParentParameterTree(this.m_parameters);
            this.m_axisLockerOffset.setParentParameterTree(this.m_parameters, "OffsetLocker");
            this.m_axisLockerTime.setParentParameterTree(this.m_parameters, "TimeLocker");
            String sfn = root + ".SequenceXML";
            this.m_workerWidget.setFileName(sfn);
            for (int n = 0; n < this.m_maxPlots; ++n) {
                PlotData pd = this.m_plotDataList.get(n);
                String fn = root + "_" + Integer.toString(n + 1) + ".SequenceXML";
                pd.WorkerWidget.setFileName(fn);
            }
            this.m_widget.setAxisLocked_X(this.m_axisLockerOffset.locked(), this.m_axisLockerOffset.min(), this.m_axisLockerOffset.max());
            this.m_widget.setAxisLocked_Time(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
            this.m_widget.setParameterTree(this.m_parameters.ParameterTree_get("Display"));
            if (this.m_axisWidget.isUniformSpacing()) {
                this.m_widget.setAxisType(Java2D_EnsembleAxisEnum.UniformSpacing);
            } else {
                this.m_widget.setAxisTableColumn(this.m_axisWidget.getAxisTable(), this.m_axisWidget.getAxisColumn());
                this.m_widget.setAxisType(Java2D_EnsembleAxisEnum.TraceHeader);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void saveParameters() {
        try {
            this.m_paramManager.saveParameters();
            this.m_axisWidget.saveParameters();
            this.m_wiggleOptionsWidget.saveParameters();
            this.m_axisLockerOffset.saveParameters();
            this.m_axisLockerTime.saveParameters();
            this.m_visibleWidget.saveParameters();
            this.m_traceBackgroundWidget.saveParameters();
            this.m_parameters.save(this.m_paramFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleActionSequenceFinished(Action_Sequence sender) {
        try {
            if (this.m_autoPickColumnName == null) {
                return;
            }
            if (this.m_autoPickColumnName.isEmpty()) {
                return;
            }
            RefractionProjectSuggestions.singleton().autopickSuggestion(this.m_autoPickColumnName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handlePopupMenuButton(PopupMenuButton button, String text) {
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
    }

    @Override
    public void handleEnsembleWidgetPaintEvent(Java2D_VertStackedEnsembleDisplayWidget widget, int widgetIndex, boolean imagePainted) {
        try {
            if (imagePainted && widgetIndex == 0) {
                Java2D_Paintable_SelectedEntries p = new Java2D_Paintable_SelectedEntries("Shot");
                for (int n = 0; n < this.m_numVisible; ++n) {
                    PlotData pd = this.m_plotDataList.get(n);
                    p.add(pd.ShotID, this.m_colors[n]);
                }
                this.m_basemapWidget.clearUnderlayList();
                this.m_basemapWidget.addUnderlay(p, -9999);
                this.m_basemapWidget.reloadPlot(false);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void prepareWidget(int index, PrepActionEnum action) {
        try {
            if (index < 0 || index >= this.m_numVisible) {
                return;
            }
            PlotData pd = this.m_plotDataList.get(index);
            if (SharedApplicationData.JobRunning) {
                return;
            }
            if (pd.ProcessedEnsemble != null) {
                this.m_pickDisplayWidget.prepEnsemble(pd.ProcessedEnsemble);
            }
            this.m_widget.setEnsemble(index, pd.ProcessedEnsemble);
            this.m_visibleWidget.setVisibleTraces(pd.ProcessedEnsemble);
            this.m_traceBackgroundWidget.setBackground(pd.ProcessedEnsemble);
            if (this.m_axisWidget.isUniformSpacing()) {
                this.m_axisWidget.sortEnsemble(pd.ProcessedEnsemble);
            }
            if (action == PrepActionEnum.Unzoom) {
                this.m_widget.clearAndLoadWigglePaintables();
                this.m_widget.unzoom();
                return;
            }
            if (action == PrepActionEnum.JustRepaint) {
                this.m_widget.forcePaintAll();
                return;
            }
            if (action != PrepActionEnum.DoNothing) return;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void processEnsemble(int index, PrepActionEnum action) {
        try {
            if (index < 0 || index >= this.m_numVisible) {
                return;
            }
            PlotData pd = this.m_plotDataList.get(index);
            if (SharedApplicationData.JobRunning) {
                return;
            }
            pd.InputEnsemble.resetAllKillFlags();
            pd.InputEnsemble.copyToOtherEnsemble(pd.InputEnsemble_Copy);
            pd.InputEnsemble_Copy.pickPlotData().clearRequiredList();
            if (pd.InputEnsemble_Copy.traceCount() > 0) {
                pd.ProcessedEnsemble = this.m_sequence.work(pd.InputEnsemble_Copy);
                pd.ProcessedEnsemble = pd.Sequence.work(pd.ProcessedEnsemble);
            }
            if (index == 0) {
                this.m_axisWidget.setEnsembleHeaderDictionary(pd.ProcessedEnsemble.dictionary());
                this.m_visibleWidget.setEnsembleHeaderDictionary(pd.ProcessedEnsemble.dictionary());
            }
            this.prepareWidget(index, action);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadShot(int id, int index, PrepActionEnum action) {
        try {
            if (index < 0 || index >= this.m_numVisible) {
                return;
            }
            PlotData pd = this.m_plotDataList.get(index);
            pd.ShotID = id;
            RefractionStaticsProject.singleton().ensemble_Shot(pd.InputEnsemble, id, true);
            Tools_DelayTime_Geometry.singleton().computeGeometryCorrection(true, pd.InputEnsemble, "FBP_User");
            this.processEnsemble(index, action);
            this.m_uniqueColumnCombo[index].setSelectedID(id);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_timer) {
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            this.plotLayout();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleBasemap_ReceiverSelected(int id) {
    }

    @Override
    public void handleBasemap_ReceiverDrag(double x, double y) {
    }

    @Override
    public void handleBasemap_ReceiverDragFinish(double x, double y) {
    }

    @Override
    public void handleBasemap_ShotDrag(double x, double y) {
    }

    @Override
    public void handleBasemap_ShotDragFinish(double x, double y) {
    }

    @Override
    public void handleBasemap_ShotSelected(int id) {
        try {
            this.m_shotNavigationWidget.setSelected(id);
            this.loadAllShots();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleBasemap_ShotSelected(int id, int plotIndex) {
        try {
            this.loadShot(id, plotIndex, PrepActionEnum.Unzoom);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleBasemap_Bin3DSelected(int inline, int crossline) {
    }

    @Override
    public void handleBasemap_Bin2DSelected(int bin) {
    }

    @Override
    public void handleBasemap_SparseCMPSelected(Ensemble ensemble) {
    }

    protected void loadUEC() {
        try {
            this.m_widget.clearUserEventConsumerList();
            PickerGizmo pg = PickerGizmo.singleton();
            boolean needControlPoint = pg.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointAdd || pg.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointKill || pg.LeftClickAction == PickerGizmo.LeftClickActionEnum.ControlPointSelect;
            for (int n = 0; n < this.m_plotDataList.size(); ++n) {
                this.m_widget.clearUserEventConsumerList(n);
                PlotData pd = this.m_plotDataList.get(n);
                if (needControlPoint) {
                    this.m_widget.addEventConsumer(n, pd.LineSegmentUEC);
                } else {
                    this.m_widget.addEventConsumer(n, pd.LeftClickUEC);
                }
                this.m_widget.addEventConsumer(n, pd.RubberBandUEC);
                this.m_widget.addEventConsumer(n, pd.MiddleClickUEC);
                this.m_widget.addEventConsumer(n, pd.MouseMoveUEC);
                this.m_widget.addEventConsumer(n, pd.KeyUEC);
                this.m_widget.addZoomer();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected class PlotData {
        public int ShotID = -9999;
        public Ensemble InputEnsemble = new Ensemble();
        public Ensemble InputEnsemble_Copy = new Ensemble();
        public Ensemble ProcessedEnsemble = new Ensemble();
        public Java2D_UserEventConsumer_MultiLineSegments LineSegmentUEC = new Java2D_UserEventConsumer_MultiLineSegments();
        public Java2D_UserEventConsumer_MultiLineSegments RubberBandUEC = new Java2D_UserEventConsumer_MultiLineSegments(true);
        public Java2D_UserEventConsumer_KeyPressed KeyUEC = new Java2D_UserEventConsumer_KeyPressed();
        public Java2D_UserEventConsumer_ButtonPressed LeftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
        public Java2D_UserEventConsumer_MouseMove MouseMoveUEC = new Java2D_UserEventConsumer_MouseMove();
        public Java2D_UserEventConsumer_ButtonPressed MiddleClickUEC = new Java2D_UserEventConsumer_ButtonPressed(2);
        public Sequence_MainWidget WorkerWidget;
        public EnsembleWorker_Sequence Sequence;

        protected PlotData() {
        }
    }

    protected static enum PrepActionEnum {
        DoNothing,
        JustRepaint,
        Unzoom;

    }
}

