/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.Seismic.SparseCmpGatherManager;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Math.IGrid2D_Conversion;
import com.PecosLibrary.Refraction.MoveoutTrendData;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_MainWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_VertStackedEnsembleDisplayWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_AxisLocker;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_PaintablePointArray;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_KeyPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MoveoutTrend;
import com.PecosLibrary.Windows.Refraction.LinearMoveoutTrend_DisplayWidget;
import com.PecosLibrary.Windows.Shared.BitmapCardWidget;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class LinearMoveoutTrendWidget_Traces
extends JSplitPane
implements ActionListener,
GenericObjectListener.Listener,
IParameterWidgetListener {
    protected Ensemble m_inputEnsemble = new Ensemble();
    protected Ensemble m_inputEnsemble_Copy = new Ensemble();
    protected Ensemble m_processedEnsemble = new Ensemble();
    protected JTabbedPane m_rightTabs = new JTabbedPane();
    protected JComboBox<String> m_radiusCombo = new JComboBox();
    protected Java2D_VertStackedEnsembleDisplayWidget m_widget;
    protected Java2D_EnsembleDisplayOptionsWidget m_wiggleOptionsWidget;
    protected Sequence_MainWidget m_workerWidget;
    protected EnsembleWorker_Sequence m_sequence;
    protected Java2D_AxisLocker m_axisLockerOffset;
    protected Java2D_AxisLocker m_axisLockerTime;
    protected Java2D_UserEventConsumer_MoveoutTrend m_moveoutUEC = new Java2D_UserEventConsumer_MoveoutTrend();
    protected MoveoutTrendData m_moveoutTrendData = new MoveoutTrendData();
    protected double m_worldX;
    protected double m_worldY;
    protected Java2D_SimpleComposite m_basemapWidget = new Java2D_SimpleComposite(false);
    protected JButton m_clearButton;
    protected Java2D_Paintable_Table m_shotPaintable = null;
    protected Java2D_Paintable_Table m_receiverPaintable = null;
    protected Java2D_UserEventConsumer_ButtonPressed m_leftClickUEC;
    protected Java2D_UserEventConsumer_KeyPressed m_mapKeyUEC;
    protected boolean m_testInteractiveModel;
    protected LinearLayoutWidget m_modelContainer;
    protected ScrollTable m_modelTable;
    protected ScrollTable m_pickTable;
    protected Java2D_SimpleComposite m_modelWidget = new Java2D_SimpleComposite(false);
    protected JRadioButton m_rad_sparse = new JRadioButton("Use precomputed sparse CMP gathers");
    protected JRadioButton m_rad_cmp = new JRadioButton("Use standard CMP gathers");
    protected JRadioButton m_rad_shot = new JRadioButton("Use shot gathers");
    protected ButtonGroup m_group = new ButtonGroup();
    protected JTextField m_txtModelDepth = new JTextField("500");
    protected JTextField m_txtModelSize = new JTextField("10");
    protected JTextField m_txtModelMaxOffset = new JTextField("5000");
    protected JButton m_btnRecomputeModel;
    protected SliderWidget m_lmoSlider;
    protected RadioPanel m_radMoveout;

    public LinearMoveoutTrendWidget_Traces(boolean testInteractiveModel) {
        super(1);
        try {
            this.m_testInteractiveModel = testInteractiveModel;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.m_moveoutTrendData.read(project.moveoutTrendFileName());
            this.m_moveoutUEC.TrendData = this.m_moveoutTrendData;
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRightParent());
            this.reloadShotRecData();
            this.reloadMapPlot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void save_csv(String filename) {
        try {
            this.m_moveoutTrendData.save_csv(filename);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void save_slb(String filename) {
        try {
            this.m_moveoutTrendData.save_slb(filename);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void copyCurrentToProject() {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.m_moveoutTrendData.save(project.moveoutTrendFileName());
            project.moveoutTrendData().read(project.moveoutTrendFileName());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createMapWidget() {
        try {
            SparseCmpGatherManager sparse = RefractionStaticsProject.singleton().sparseCmpGathers();
            LinearLayoutWidget mapWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            LinearLayoutWidget w = mapWidget.createVertical(3, "Select type of gather", 0);
            w.addComponent(this.m_rad_sparse, 0);
            w.addComponent(this.m_rad_cmp, 0);
            w.addComponent(this.m_rad_shot, 0);
            boolean sparse_ok = sparse.valid() && RefractionStaticsProject.singleton().dim3D();
            this.m_rad_sparse.setEnabled(sparse_ok);
            if (sparse_ok) {
                this.m_rad_sparse.setSelected(true);
            } else {
                this.m_rad_shot.setSelected(true);
            }
            this.m_rad_sparse.addActionListener(this);
            this.m_rad_cmp.addActionListener(this);
            this.m_rad_shot.addActionListener(this);
            this.m_group.add(this.m_rad_sparse);
            this.m_group.add(this.m_rad_cmp);
            this.m_group.add(this.m_rad_shot);
            LinearLayoutWidget temp = mapWidget.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, "Number of bins for standard CMP gather", 0);
            this.m_radiusCombo.addItem("1 bin");
            if (RefractionStaticsProject.singleton().dim3D()) {
                for (n = 1; n < 11; ++n) {
                    int num = 2 * n + 1;
                    String s = String.format("%d x %d bins", num, num);
                    this.m_radiusCombo.addItem(s);
                }
            } else {
                for (n = 1; n < 11; ++n) {
                    int num = 2 * n + 1;
                    String s = String.format("%d bins", num);
                    this.m_radiusCombo.addItem(s);
                }
            }
            this.m_radiusCombo.setSelectedIndex(1);
            temp.addComponent(this.m_radiusCombo, 10);
            mapWidget.createLabel("Left-click to add/select location", 2, 0);
            mapWidget.createLabel("Press \"r\" to remove nearest location", 2, 0);
            this.m_basemapWidget.setAxesVisible(false, false);
            this.m_basemapWidget.setColorScaleVisible(false);
            mapWidget.addComponent(this.m_basemapWidget, 10);
            LinearLayoutWidget bottom = mapWidget.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            this.m_clearButton = bottom.createButton("Remove all", this, 0);
            bottom.addStretch(10);
            this.m_leftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
            this.m_leftClickUEC.addListener(this);
            this.m_mapKeyUEC = new Java2D_UserEventConsumer_KeyPressed();
            this.m_mapKeyUEC.addListener(this);
            return mapWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createLeft() {
        try {
            this.m_workerWidget = new Sequence_MainWidget("LinearTrend", EnsembleWorker_Sequence.SequenceType.Interactive);
            this.m_sequence = this.m_workerWidget.sequence();
            this.m_sequence.addListener(this);
            this.m_wiggleOptionsWidget = new Java2D_EnsembleDisplayOptionsWidget(null);
            this.m_wiggleOptionsWidget.setFill(false, true);
            this.m_wiggleOptionsWidget.setClippingState(true);
            this.m_wiggleOptionsWidget.setNoOverlap();
            BitmapCardWidget bmc = new BitmapCardWidget();
            bmc.addComponent(BitmapEnum.Basemap, this.createMapWidget(), "Basemap");
            bmc.addComponent(BitmapEnum.Sequence, this.m_workerWidget, "Ensemble processing sequence");
            bmc.addComponent(BitmapEnum.Wiggle, this.m_wiggleOptionsWidget, "Wiggle display options");
            return bmc;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightParent() {
        try {
            JSplitPane splitter = new JSplitPane(1);
            if (this.m_testInteractiveModel) {
                splitter.setLeftComponent(this.createRightPlot_TestModel());
            } else {
                splitter.setLeftComponent(this.createRightPlot());
            }
            splitter.setRightComponent(this.createRightRight());
            splitter.setOneTouchExpandable(true);
            splitter.setResizeWeight(1.0);
            this.m_rightTabs.addTab("Seismic display", splitter);
            this.m_rightTabs.addTab("Velocity at offset", new LinearMoveoutTrend_DisplayWidget(this.m_moveoutTrendData, LinearMoveoutTrend_DisplayWidget.Display.Velocity));
            this.m_rightTabs.addTab("Time at offset", new LinearMoveoutTrend_DisplayWidget(this.m_moveoutTrendData, LinearMoveoutTrend_DisplayWidget.Display.Time));
            return this.m_rightTabs;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightPlot_TestModel() {
        try {
            JSplitPane splitter = new JSplitPane(1);
            splitter.setLeftComponent(this.createRightPlot());
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            LinearLayoutWidget top = main.createHorizontal(0, null, 0);
            GridLayoutWidget grid = top.createGridLayoutWidget(0, 5);
            int row = 0;
            grid.addSimple(row++, new JLabel("Maximum offset"), this.m_txtModelMaxOffset);
            grid.addSimple(row++, new JLabel("Model depth"), this.m_txtModelDepth);
            grid.addSimple(row++, new JLabel("Model grid size"), this.m_txtModelSize);
            LinearLayoutWidget topright = top.createVertical(0, null, 5);
            this.m_btnRecomputeModel = topright.createButton("Recompute model", this, 0);
            topright.addStretch(10);
            JTabbedPane tabs = new JTabbedPane();
            this.m_modelTable = new ScrollTable();
            this.m_pickTable = new ScrollTable();
            tabs.addTab("Plot", this.m_modelWidget);
            tabs.addTab("Model", this.m_modelTable);
            tabs.addTab("Picks", this.m_pickTable);
            main.addComponent(tabs, 10);
            splitter.setRightComponent(main);
            return splitter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightPlot() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            main.addComponent(this.createRightTopPlot(), 0);
            this.m_widget = new Java2D_VertStackedEnsembleDisplayWidget(1);
            this.m_widget.setAxisType(Java2D_EnsembleAxisEnum.TraceHeader);
            this.m_widget.setAxisTableColumn("Trace", "Offset");
            this.m_widget.setEnsembleDisplayOptionsWidget(this.m_wiggleOptionsWidget);
            main.addComponent(this.m_widget, 10);
            this.m_widget.addZoomer();
            this.m_widget.addEventConsumer(0, this.m_moveoutUEC);
            this.m_moveoutUEC.ForceIncreasingVelocity = true;
            this.m_moveoutUEC.addListener(this);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightTopPlot() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null);
            this.m_radMoveout = new RadioPanel(LinearLayoutWidget.Direction.Vertical, "Moveout options", "Do not apply moveout", "Apply linear moveout", "Moveout trend curves");
            this.m_radMoveout.listener().addListener(this);
            main.addComponent(this.m_radMoveout, 2);
            this.m_lmoSlider = new SliderWidget(this, null, "Linear moveout correction (if option selected)", 0, 3000.0, 1000.0, 22000.0);
            main.addComponent(this.m_lmoSlider, 3);
            if (!this.m_testInteractiveModel) {
                main.addStretch(4);
            }
            this.prepMoveoutOptions();
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightRight() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_axisLockerOffset = new Java2D_AxisLocker("Horizontal lock", "Lock axis ");
            this.m_axisLockerOffset.listener().addListener(this);
            this.m_axisLockerTime = new Java2D_AxisLocker("Time lock", "Lock axis ");
            this.m_axisLockerTime.listener().addListener(this);
            main.addComponent(this.m_axisLockerOffset, 0);
            main.addComponent(this.m_axisLockerTime, 0);
            main.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(main, -1, null, true);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void prepMoveoutOptions() {
        try {
            this.m_moveoutTrendData.ApplyLMO = this.m_radMoveout.getSelectedIndex() == 1;
            this.m_moveoutTrendData.ApplyTrendData = this.m_radMoveout.getSelectedIndex() == 2;
            this.m_moveoutTrendData.LmoVel = this.m_lmoSlider.getDoubleValue();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            if (sender == this.m_lmoSlider) {
                this.prepMoveoutOptions();
                this.processEnsemble(false);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadShotRecData() {
        try {
            this.m_shotPaintable = Tools_RefractionStaticsProject.loadGeomPO("Shot");
            this.m_receiverPaintable = Tools_RefractionStaticsProject.loadGeomPO("Receiver");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadMapPlot() {
        try {
            SparseCmpGatherManager sparse;
            Java2D_Widget w = this.m_basemapWidget.mainWidget();
            w.clearPaintableList();
            w.clearEventConsumerList();
            if (this.m_shotPaintable != null) {
                w.addPaintable(this.m_shotPaintable, -9999);
            }
            if (this.m_receiverPaintable != null) {
                w.addPaintable(this.m_receiverPaintable, -9999);
            }
            w.addPaintable(this.m_moveoutTrendData, MoveoutTrendData.PlotType.Map.ordinal());
            if (this.m_rad_sparse != null && this.m_rad_sparse.isSelected() && (sparse = RefractionStaticsProject.singleton().sparseCmpGathers()).size() > 0) {
                Java2D_PaintablePointArray pa = new Java2D_PaintablePointArray(sparse);
                w.addPaintable(pa, -9999);
            }
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
            w.clearEventConsumerList();
            w.addZoomer();
            w.addEventConsumer(this.m_leftClickUEC);
            w.addEventConsumer(this.m_mapKeyUEC);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnRecomputeModel) {
                this.recomputeTomoModel();
                return;
            }
            if (e.getSource() == this.m_clearButton) {
                this.m_moveoutTrendData.clear();
                this.m_inputEnsemble.clearTraces(true);
                this.processEnsemble(true);
                this.reloadMapPlot();
            }
            if (e.getSource() == this.m_rad_sparse || e.getSource() == this.m_rad_shot || e.getSource() == this.m_rad_cmp) {
                this.reloadMapPlot();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void reloadWiggle() {
        try {
            this.m_widget.setEnsemble(0, this.m_processedEnsemble);
            this.m_widget.setRangeExpander(0, true, 0.0, 0.0, true, 0.0, 0.0);
            this.m_widget.clearAndLoadWigglePaintables();
            this.m_widget.addPaintable(0, this.m_moveoutTrendData, MoveoutTrendData.PlotType.Branch.ordinal());
            this.m_widget.unzoom();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void processEnsemble(boolean unzoom) {
        try {
            if (this.m_inputEnsemble == null) {
                this.m_processedEnsemble = null;
            } else {
                this.m_inputEnsemble.copyToOtherEnsemble(this.m_inputEnsemble_Copy);
                this.m_processedEnsemble = this.m_sequence.work(this.m_inputEnsemble_Copy);
            }
            this.shiftTraces();
            if (unzoom) {
                this.reloadWiggle();
            } else {
                this.m_widget.forcePaintAll();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void shiftTraces() {
        try {
            if (this.m_radMoveout.getSelectedIndex() == 0) {
                return;
            }
            if (this.m_processedEnsemble == null) {
                return;
            }
            int indexOffset = this.m_processedEnsemble.dictionary().getEntryIndex("Trace", "Offset");
            int indexShotX = this.m_processedEnsemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexShotY = this.m_processedEnsemble.dictionary().getEntryIndex("Shot", "Northing");
            int indexRecX = this.m_processedEnsemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexRecY = this.m_processedEnsemble.dictionary().getEntryIndex("Receiver", "Northing");
            if (this.m_radMoveout.getSelectedIndex() == 1) {
                double lmoVel = this.m_lmoSlider.getDoubleValue();
                for (int t = 0; t < this.m_processedEnsemble.traceCount(); ++t) {
                    FloatArrayWrapper wrapper = this.m_processedEnsemble.trace(t).data();
                    double offset = this.m_processedEnsemble.trace(t).header().getDouble(indexOffset);
                    float shift = (float)(1000.0 * offset / lmoVel);
                    wrapper.addShiftToFirstSampleCoord(0.0f - shift);
                }
                return;
            }
            if (this.m_radMoveout.getSelectedIndex() == 2) {
                for (int t = 0; t < this.m_processedEnsemble.traceCount(); ++t) {
                    EnsembleTrace trace = this.m_processedEnsemble.trace(t);
                    FloatArrayWrapper wrapper = trace.data();
                    double offset = trace.header().getDouble(indexOffset);
                    double sx = trace.header().getDouble(indexShotX);
                    double sy = trace.header().getDouble(indexShotY);
                    double rx = trace.header().getDouble(indexRecX);
                    double ry = trace.header().getDouble(indexRecY);
                    double x = 0.5 * (sx + rx);
                    double y = 0.5 * (sy + ry);
                    float shift = this.m_moveoutTrendData.getTime(x, y, (float)offset, true);
                    wrapper.addShiftToFirstSampleCoord(0.0f - shift);
                }
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void recomputeTomoModel() {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_radMoveout) {
                this.prepMoveoutOptions();
                this.processEnsemble(true);
                return;
            }
            if (sender == this.m_moveoutUEC) {
                this.m_moveoutTrendData.setSelected(this.m_moveoutUEC.PointCount, this.m_moveoutUEC.Offset, this.m_moveoutUEC.Time);
                this.m_moveoutTrendData.interpolate();
                this.processEnsemble(false);
                this.recomputeTomoModel();
            }
            if (sender == this.m_axisLockerTime) {
                this.m_widget.setAxisLocked_Time(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
                return;
            }
            if (sender == this.m_axisLockerOffset) {
                this.m_widget.setAxisLocked_X(this.m_axisLockerOffset.locked(), this.m_axisLockerOffset.min(), this.m_axisLockerOffset.max());
                return;
            }
            if (sender == this.m_sequence) {
                if (this.m_sequence.MessageData.SequenceModified) {
                    this.processEnsemble(false);
                }
                return;
            }
            if (sender == this.m_mapKeyUEC) {
                if (this.m_mapKeyUEC.KeyCode == 82) {
                    this.m_moveoutTrendData.removeLocation(this.m_mapKeyUEC.PixelX, this.m_mapKeyUEC.PixelY);
                    this.reloadMapPlot();
                    this.m_basemapWidget.mainWidget().repaint();
                    if (this.m_moveoutTrendData.Selected == null) {
                        this.m_inputEnsemble.clearTraces(false);
                        this.processEnsemble(true);
                    }
                }
                return;
            }
            if (sender == this.m_leftClickUEC) {
                this.handleMapClick();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void handleMapClick() {
        try {
            this.m_worldX = this.m_leftClickUEC.WorldX;
            this.m_worldY = this.m_leftClickUEC.WorldY;
            if (this.m_rad_cmp.isSelected()) {
                this.m_moveoutTrendData.selectLocation(this.m_leftClickUEC.PixelX, this.m_leftClickUEC.PixelY, this.m_worldX, this.m_worldY);
                this.m_moveoutTrendData.interpolate();
                this.m_worldX = this.m_moveoutTrendData.Selected.X;
                this.m_worldY = this.m_moveoutTrendData.Selected.Y;
                if (RefractionStaticsProject.singleton().dim3D()) {
                    Grid3D_Conversion grid3D = RefractionStaticsProject.singleton().getGrid3D_Conversion();
                    grid3D.setWorldLocation(this.m_worldX, this.m_worldY);
                    int radius = this.m_radiusCombo.getSelectedIndex();
                    this.m_inputEnsemble.clearTraces(false);
                    RefractionStaticsProject.singleton().ensemble_Bin3D(this.m_inputEnsemble, grid3D.Inline, grid3D.Crossline, radius, true);
                } else {
                    IGrid2D_Conversion grid2D = RefractionStaticsProject.singleton().getGrid2D_Conversion();
                    int bin = grid2D.getBin(this.m_worldX, this.m_worldY);
                    int radius = this.m_radiusCombo.getSelectedIndex();
                    this.m_inputEnsemble.clearTraces(false);
                    RefractionStaticsProject.singleton().ensemble_Bin2D(this.m_inputEnsemble, bin, radius, true);
                }
            }
            if (this.m_rad_sparse.isSelected()) {
                SparseCmpGatherManager sparse = RefractionStaticsProject.singleton().sparseCmpGathers();
                sparse.selectNearestCMP(this.m_leftClickUEC.WorldX, this.m_leftClickUEC.WorldY, this.m_inputEnsemble);
                RefractionStaticsProject.singleton().prepGeometryHeaders(this.m_inputEnsemble, true, true);
                RefractionStaticsProject.singleton().inputDataProcessor_Run(this.m_inputEnsemble);
                this.m_moveoutTrendData.selectLocation_Coords(sparse.SelectedX, sparse.SelectedY, 100.0);
            }
            if (this.m_rad_shot.isSelected()) {
                this.m_moveoutTrendData.selectLocation(this.m_leftClickUEC.PixelX, this.m_leftClickUEC.PixelY, this.m_worldX, this.m_worldY);
                this.m_moveoutTrendData.interpolate();
                this.m_worldX = this.m_moveoutTrendData.Selected.X;
                this.m_worldY = this.m_moveoutTrendData.Selected.Y;
                this.m_inputEnsemble.clearTraces(true);
                RefractionStaticsProject.singleton().shotTable().selectNearestSpatialPoint(this.m_worldX, this.m_worldY);
                int sid = RefractionStaticsProject.singleton().shotTable().SelectedID;
                RefractionStaticsProject.singleton().ensemble_Shot(this.m_inputEnsemble, sid, true);
                RefractionStaticsProject.singleton().inputDataProcessor_Run(this.m_inputEnsemble);
            }
            this.processEnsemble(true);
            Java2D_Widget w = this.m_basemapWidget.mainWidget();
            w.forceImageRepaint();
            w.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void acceptInterp() {
        try {
            if (this.m_moveoutTrendData.InterpolatedValid && this.m_moveoutTrendData.Selected.Offset == null) {
                this.m_moveoutTrendData.setSelected(this.m_moveoutTrendData.m_interpOffset.length, this.m_moveoutTrendData.m_interpOffset, this.m_moveoutTrendData.m_interpTime);
                this.m_moveoutTrendData.interpolate();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

