/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Import.WizardSegy;

import com.PecosCore.Data.DataType;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Refraction.Import.WizardSegy.SegyWizardSharedData;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class Page_SegyWiz_Required
extends LinearLayoutWidget
implements ISimpleWizardPage,
GenericObjectListener.Listener {
    protected SegyWizardSharedData m_data;
    protected String m_table;
    protected CoordEntry m_easting = new CoordEntry();
    protected CoordEntry m_northing = new CoordEntry();
    protected ElevEntry m_elev = new ElevEntry();
    protected LabelEntry m_point = new LabelEntry("PointNumber");
    protected LabelEntry m_line = new LabelEntry("LineNumber");
    protected LabelEntry m_index = new LabelEntry("PointIndex");
    protected ArrayList<LabelEntry> m_labels = new ArrayList();
    protected JLabel m_label = new JLabel(" ");

    public Page_SegyWiz_Required(String table, SegyWizardSharedData data) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_data = data;
            this.m_table = table;
            Segy_Dictionary dict = this.m_data.Dictionary;
            String s = "<HTML>The easting, northing, and elevation entries almost always follow the SEG standard</HTML>";
            JLabel lbl = new JLabel(s);
            lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            this.addComponent(lbl, 0);
            GridLayoutWidget w = this.createGridLayoutWidget(0, "Elevation", 0);
            int row = 0;
            w.addComponent(new JLabel("Byte offset"), row, 1, 1.0, 8.0);
            w.addComponent(new JLabel("Data type"), row, 2, 1.0, 8.0);
            w.addComponent(new JLabel("Modification method"), row, 3, 1.0, 8.0);
            w.addComponent(new JLabel("Factor (if used)"), row, 4, 1.0, 8.0);
            w.addComponent(new JLabel("Elevation"), ++row, 0, 1.0, 1.0);
            w.addComponent(this.m_elev.OffsetText, row, 1, 1.0, 8.0);
            w.addComponent(this.m_elev.TypeCombo, row, 2, 1.0, 8.0);
            w.addComponent(this.m_elev.ModCombo, row, 3, 1.0, 8.0);
            w.addComponent(this.m_elev.FactorText, row, 4, 1.0, 8.0);
            w = this.createGridLayoutWidget(0, "Coordinates", 0);
            row = 0;
            w.addComponent(new JLabel("Byte offset"), row, 1, 1.0, 8.0);
            w.addComponent(new JLabel("Data type"), row, 2, 1.0, 8.0);
            w.addComponent(new JLabel("Modification method"), row, 3, 1.0, 8.0);
            w.addComponent(new JLabel("Factor (if used)"), row, 4, 1.0, 8.0);
            w.addComponent(new JLabel("Easting"), ++row, 0, 1.0, 1.0);
            w.addComponent(this.m_easting.OffsetText, row, 1, 1.0, 8.0);
            w.addComponent(this.m_easting.TypeCombo, row, 2, 1.0, 8.0);
            w.addComponent(this.m_easting.ModCombo, row, 3, 1.0, 8.0);
            w.addComponent(this.m_easting.FactorText, row, 4, 1.0, 8.0);
            w.addComponent(new JLabel("Northing"), ++row, 0, 1.0, 1.0);
            w.addComponent(this.m_northing.OffsetText, row, 1, 1.0, 8.0);
            w.addComponent(this.m_northing.TypeCombo, row, 2, 1.0, 8.0);
            w.addComponent(this.m_northing.ModCombo, row, 3, 1.0, 8.0);
            w.addComponent(this.m_northing.FactorText, row, 4, 1.0, 8.0);
            this.m_labels.add(this.m_line);
            this.m_labels.add(this.m_point);
            this.m_labels.add(this.m_index);
            this.createGapLabel(30);
            s = "<HTML>The PointNumber field is required. Default values may be used for the LineNumber and PointIndex fields. The \"Default value\" is only used if the value in the header is not valid</HTML>";
            lbl = new JLabel(s);
            lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            this.addComponent(lbl, 0);
            w = this.createGridLayoutWidget(0, "LineNumber, PointNumber, PointIndex", 0);
            row = 0;
            w.addComponent(new JLabel("Byte offset"), row, 1, 1.0, 8.0);
            w.addComponent(new JLabel("Data type"), row, 2, 1.0, 8.0);
            w.addComponent(new JLabel("Modification method"), row, 3, 1.0, 8.0);
            w.addComponent(new JLabel("Factor (if used)"), row, 4, 1.0, 8.0);
            w.addComponent(new JLabel("Valid"), row, 5, 1.0, 8.0);
            w.addComponent(new JLabel("Default value"), row, 6, 1.0, 8.0);
            ++row;
            for (LabelEntry e : this.m_labels) {
                w.addComponent(new JLabel(e.ColumnName), row, 0, 1.0, 8.0);
                w.addComponent(e.OffsetText, row, 1, 1.0, 8.0);
                w.addComponent(e.TypeCombo, row, 2, 1.0, 8.0);
                w.addComponent(e.ModCombo, row, 3, 1.0, 8.0);
                w.addComponent(e.FactorText, row, 4, 1.0, 8.0);
                w.addComponent(e.ValidCheck, row, 5, 1.0, 8.0);
                w.addComponent(e.DefaultText, row, 6, 1.0, 8.0);
                ++row;
            }
            this.addComponent(this.m_label, 0);
            this.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.okayToGoToNextPage();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void dialogJustOpened() {
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    @Override
    public boolean okayToGoToNextPage() {
        try {
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void leavingPage() {
        try {
            this.m_elev.getData();
            this.m_easting.getData();
            this.m_northing.getData();
            for (LabelEntry e : this.m_labels) {
                e.getData();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void activatePage() {
        try {
            this.okayToGoToNextPage();
            Segy_Dictionary dict = this.m_data.Dictionary;
            this.m_line.setHeader(dict.getEntry_Create(this.m_table, "LineNumber"));
            this.m_point.setHeader(dict.getEntry_Create(this.m_table, "PointNumber"));
            if (dict.hasEntry(this.m_table, "PointIndex")) {
                this.m_index.setHeader(dict.getEntry(this.m_table, "PointIndex"));
            } else {
                Segy_Dictionary.Entry entry = dict.addEntry(this.m_table, "PointIndex", DataType.Int, DataType.Int, 1, Segy_Dictionary.Modification.None, 1);
                entry.Valid = false;
                entry.DefaultValue = 1.0;
                this.m_index.setHeader(entry);
            }
            this.m_elev.setHeader(dict.getEntry_Create(this.m_table, "Elevation"));
            this.m_easting.setHeader(dict.getEntry_Create(this.m_table, "Easting"));
            this.m_northing.setHeader(dict.getEntry_Create(this.m_table, "Northing"));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected class CoordEntry {
        public Segy_Dictionary.Entry Header;
        public JTextField OffsetText = new JTextField("");
        public JComboBox<String> TypeCombo = new JComboBox();
        public JComboBox<String> ModCombo = new JComboBox();
        public JTextField FactorText = new JTextField("");

        public CoordEntry() {
            this.TypeCombo.addItem(DataType.Short.Description);
            this.TypeCombo.addItem(DataType.Int.Description);
            this.TypeCombo.addItem(DataType.Float.Description);
            this.ModCombo.addItem(Segy_Dictionary.Modification.CoordScalar.Description);
            this.ModCombo.addItem(Segy_Dictionary.Modification.FactorDivide.Description);
        }

        public void setHeader(Segy_Dictionary.Entry hdr) {
            this.Header = hdr;
            this.OffsetText.setText(Integer.toString(1 + hdr.FirstByte));
            this.FactorText.setText(Integer.toString(hdr.Factor));
            this.TypeCombo.setSelectedIndex(hdr.HeaderType.ordinal());
            if (hdr.ModMethod == Segy_Dictionary.Modification.CoordScalar) {
                this.ModCombo.setSelectedIndex(0);
            } else {
                this.ModCombo.setSelectedIndex(1);
            }
        }

        public void getData() {
            this.Header.FirstByte = Tools_Widget.extractInteger(this.OffsetText, 1, 1, 237) - 1;
            this.Header.Factor = Tools_Widget.extractInteger(this.FactorText, 0, -10000000, 10000000);
            this.Header.HeaderType = DataType.values()[this.TypeCombo.getSelectedIndex()];
            this.Header.ModMethod = this.ModCombo.getSelectedIndex() == 0 ? Segy_Dictionary.Modification.CoordScalar : Segy_Dictionary.Modification.FactorDivide;
        }
    }

    protected class ElevEntry {
        public Segy_Dictionary.Entry Header;
        public JTextField OffsetText = new JTextField("");
        public JComboBox<String> TypeCombo = new JComboBox();
        public JComboBox<String> ModCombo = new JComboBox();
        public JTextField FactorText = new JTextField("");

        public ElevEntry() {
            this.TypeCombo.addItem(DataType.Short.Description);
            this.TypeCombo.addItem(DataType.Int.Description);
            this.TypeCombo.addItem(DataType.Float.Description);
            this.ModCombo.addItem(Segy_Dictionary.Modification.ElevationScalar.Description);
            this.ModCombo.addItem(Segy_Dictionary.Modification.FactorDivide.Description);
        }

        public void setHeader(Segy_Dictionary.Entry hdr) {
            this.Header = hdr;
            this.OffsetText.setText(Integer.toString(1 + hdr.FirstByte));
            this.FactorText.setText(Integer.toString(hdr.Factor));
            this.TypeCombo.setSelectedIndex(hdr.HeaderType.ordinal());
            if (hdr.ModMethod == Segy_Dictionary.Modification.ElevationScalar) {
                this.ModCombo.setSelectedIndex(0);
            } else {
                this.ModCombo.setSelectedIndex(1);
            }
        }

        public void getData() {
            this.Header.FirstByte = Tools_Widget.extractInteger(this.OffsetText, 1, 1, 237) - 1;
            this.Header.Factor = Tools_Widget.extractInteger(this.FactorText, 0, -10000000, 10000000);
            this.Header.HeaderType = DataType.values()[this.TypeCombo.getSelectedIndex()];
            this.Header.ModMethod = this.ModCombo.getSelectedIndex() == 0 ? Segy_Dictionary.Modification.ElevationScalar : Segy_Dictionary.Modification.FactorDivide;
        }
    }

    protected class LabelEntry
    implements ActionListener {
        public Segy_Dictionary.Entry Header;
        public String ColumnName;
        public JTextField OffsetText = new JTextField("");
        public JComboBox<String> TypeCombo = new JComboBox();
        public JComboBox<String> ModCombo = new JComboBox();
        public JTextField FactorText = new JTextField("");
        public JCheckBox ValidCheck = new JCheckBox("Valid");
        public JTextField DefaultText = new JTextField("0");

        public LabelEntry(String columnName) {
            try {
                this.ColumnName = columnName;
                this.TypeCombo.addItem(DataType.Short.Description);
                this.TypeCombo.addItem(DataType.Int.Description);
                this.ModCombo.addItem(Segy_Dictionary.Modification.None.Description);
                this.ModCombo.addItem(Segy_Dictionary.Modification.FactorDivide.Description);
                this.ModCombo.addItem(Segy_Dictionary.Modification.FactorRemainder.Description);
                this.ValidCheck.addActionListener(this);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void setHeader(Segy_Dictionary.Entry hdr) {
            this.Header = hdr;
            this.OffsetText.setText(Integer.toString(1 + hdr.FirstByte));
            this.FactorText.setText(Integer.toString(hdr.Factor));
            if (hdr.HeaderType == DataType.Short) {
                this.TypeCombo.setSelectedIndex(0);
            } else {
                this.TypeCombo.setSelectedIndex(1);
            }
            if (hdr.ModMethod == Segy_Dictionary.Modification.None) {
                this.ModCombo.setSelectedIndex(0);
            }
            if (hdr.ModMethod == Segy_Dictionary.Modification.FactorDivide) {
                this.ModCombo.setSelectedIndex(1);
            }
            if (hdr.ModMethod == Segy_Dictionary.Modification.FactorRemainder) {
                this.ModCombo.setSelectedIndex(2);
            }
            if (this.ColumnName.equalsIgnoreCase("PointNumber")) {
                this.ValidCheck.setEnabled(false);
                this.ValidCheck.setSelected(true);
                this.DefaultText.setVisible(false);
            } else {
                this.ValidCheck.setEnabled(true);
                this.ValidCheck.setSelected(hdr.Valid);
                this.DefaultText.setVisible(!this.ValidCheck.isSelected());
                this.DefaultText.setText(Double.toString(hdr.DefaultValue));
            }
        }

        public void getData() {
            this.Header.FirstByte = Tools_Widget.extractInteger(this.OffsetText, 1, 1, 237) - 1;
            this.Header.Factor = Tools_Widget.extractInteger(this.FactorText, 0, -10000000, 10000000);
            this.Header.HeaderType = DataType.values()[this.TypeCombo.getSelectedIndex()];
            if (this.ModCombo.getSelectedIndex() == 0) {
                this.Header.ModMethod = Segy_Dictionary.Modification.None;
            }
            if (this.ModCombo.getSelectedIndex() == 1) {
                this.Header.ModMethod = Segy_Dictionary.Modification.FactorDivide;
            }
            if (this.ModCombo.getSelectedIndex() == 2) {
                this.Header.ModMethod = Segy_Dictionary.Modification.FactorRemainder;
            }
            this.Header.Valid = this.ValidCheck.isSelected();
            this.Header.DefaultValue = Tools_Widget.extractDouble(this.DefaultText, 0.0, -1.0E20, 1.0E20);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (e.getSource() == this.ValidCheck) {
                    this.DefaultText.setVisible(!this.ValidCheck.isSelected());
                    return;
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }
}

