/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Import.WizardSegy;

import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Refraction.Import.WizardSegy.SegyWizardSharedData;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class Page_SegyWiz_DictFileName
extends LinearLayoutWidget
implements ISimpleWizardPage,
ActionListener {
    protected SegyWizardSharedData m_data;
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected JTextField m_text = new JTextField("");
    protected JButton m_newButton;
    protected JButton m_openButton;
    protected JButton m_launchButton;
    protected JLabel m_launchLabel = new JLabel(" ");
    protected JLabel m_label = new JLabel(" ");

    public Page_SegyWiz_DictFileName(SegyWizardSharedData data) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_data = data;
            String s = "<HTML>The SEG-Y dictionary file you select on this page will edited on the following wizard pages. However, if you're confident that everything is set up correctly you may elect to click the \"Begin import now\" button.</HTML>";
            JLabel lbl = new JLabel(s);
            lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            this.addComponent(lbl, 0);
            this.createGapLabel(30);
            LinearLayoutWidget sub = this.createHorizontal(0, "SEG-Y dictionary file name:", 0);
            sub.addComponent(this.m_text, 10);
            this.m_text.setEditable(false);
            sub = this.createHorizontal(0, null, 0);
            this.m_openButton = sub.createButton("Open existing", this, 0);
            this.m_newButton = sub.createButton("Create a new dictionary", this, 0);
            sub.addStretch(10);
            this.addComponent(this.m_label, 0);
            this.createGapLabel(30);
            sub = this.createHorizontal(0, "Skip the rest of the wizard....", 0);
            this.m_launchButton = sub.createButton("Begin import now", this, 0);
            sub.addComponent(this.m_launchLabel, 10);
            this.addStretch(10);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void dialogJustOpened() {
    }

    @Override
    public GenericObjectListener listener() {
        return this.m_listener;
    }

    @Override
    public boolean okayToGoToNextPage() {
        try {
            this.m_launchButton.setEnabled(false);
            this.m_launchLabel.setText("");
            if (!this.m_data.Dictionary.isFileNameValid()) {
                this.m_label.setForeground(Color.red);
                this.m_label.setText("Select or create a SEG=Y dictionary file");
                return false;
            }
            this.m_label.setText(" ");
            if (this.m_data.Dictionary.isValidPreStack()) {
                this.m_launchButton.setEnabled(true);
                this.m_launchLabel.setForeground(Color.blue);
                this.m_launchLabel.setText("Appears to be a valid dictionary");
            } else {
                this.m_launchLabel.setForeground(Color.red);
                this.m_launchLabel.setText("Dictionary does not have required pre-stack info");
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void leavingPage() {
    }

    @Override
    public void activatePage() {
        try {
            this.okayToGoToNextPage();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_launchButton) {
                this.m_listener.broadcast(this, "FinishWizard");
                return;
            }
            if (e.getSource() == this.m_newButton) {
                String fileName = Tools_Chooser.getSaveFileName(Segy_Dictionary.FileSuffix);
                if (fileName == null) {
                    return;
                }
                this.m_data.Dictionary.removeAll();
                this.m_data.Dictionary.addDefaultEntries();
                this.m_data.Dictionary.setFileName(fileName);
                this.m_text.setText(fileName);
                this.okayToGoToNextPage();
                return;
            }
            if (e.getSource() == this.m_openButton) {
                FileNameExtensionFilter filter = new FileNameExtensionFilter(" Segy dictionary", Segy_Dictionary.FileSuffix);
                String fileName = Tools_Chooser.getFileName("Select Segy dictionary file", filter);
                if (fileName == null) {
                    return;
                }
                this.m_data.Dictionary.setOpenFileName(fileName);
                this.m_text.setText(this.m_data.Dictionary.getFileName());
                this.okayToGoToNextPage();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

