/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Import;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Import.Action_ImportGLI;
import com.PecosLibrary.Windows.Refraction.ProjectNameSelectionWidget;
import com.PecosLibrary.Windows.Shared.DimensionSelectionWidget;
import com.PecosLibrary.Windows.Shared.MultipleFileSelectionWidget;
import com.PecosLibrary.Windows.Shared.UnitsSelectionWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;

public class ImportGliDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected JButton m_btnOK = new JButton("Launch import");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected ProjectNameSelectionWidget m_nameWidget = new ProjectNameSelectionWidget(3, ProjectNameSelectionWidget.ProjectType.Statics);
    protected MultipleFileSelectionWidget m_filesWidget = new MultipleFileSelectionWidget("Select GLI file(s)");
    protected DimensionSelectionWidget m_dimWidget = new DimensionSelectionWidget(3, "Project dimension");
    protected UnitsSelectionWidget m_unitsWidget = new UnitsSelectionWidget(3);
    public Action_ImportGLI ActionGLI = null;

    public ImportGliDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            middle.addComponent(this.m_nameWidget, 0);
            LinearLayoutWidget stuff = middle.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null, 0);
            stuff.addComponent(this.m_dimWidget, 10);
            stuff.addComponent(this.m_unitsWidget, 10);
            middle.addComponent(this.m_filesWidget, 10);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            bottom.addStretch(10);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.setSize(650, 700);
            this.setTitle("Create a refraction project using GLI files");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
            this.dataOK();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            this.setVisible(true);
            this.requestFocus();
            this.dataOK();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean dataOK() {
        try {
            if (!this.m_nameWidget.checkName()) {
                return false;
            }
            return this.m_filesWidget.fileList().size() >= 1;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    public String projectName() {
        return this.m_nameWidget.name();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                if (!this.dataOK()) {
                    return;
                }
                this.ActionGLI = new Action_ImportGLI();
                String parentPath = SharedApplicationData.staticsProjectPath();
                this.ActionGLI.Hasher.string_put("ParentPath", parentPath);
                this.ActionGLI.Hasher.string_put("ProjectName", this.m_nameWidget.name());
                this.ActionGLI.Hasher.string_put("Dimension", this.m_dimWidget.dimension());
                this.ActionGLI.Hasher.string_put("Units", this.m_unitsWidget.units());
                this.ActionGLI.Hasher.stringList_put("FileList", this.m_filesWidget.fileList());
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.ActionGLI = null;
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

