/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.HybridGliDt;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.IComponentManager;
import com.PecosLibrary.Action.Refraction.HybridGliDt.Action_HybridGliDt_CreateModel;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.HybridGliDt.HybridGliWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class Menu_HybridGliDt
implements ActionListener {
    protected JMenu m_menu = new JMenu("HybridGLI");
    protected JMenuItem m_menuItem_About;
    protected JMenuItem m_menuItem_NewModel;
    protected JMenuItem m_menuItem_Widget;

    public Menu_HybridGliDt(JMenuBar menuBar) {
        try {
            menuBar.add(this.m_menu);
            this.m_menuItem_Widget = this.addMenuItem(this.m_menu, "Hybrid model viewer");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JMenuItem addMenuItem(JMenu menu, String text) {
        try {
            JMenuItem mi = new JMenuItem(text);
            menu.add(mi);
            mi.addActionListener(this);
            return mi;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            IComponentManager cm = SharedApplicationData.singleton().getComponentManager();
            if (e.getSource() == this.m_menuItem_Widget) {
                cm.showComponent(HybridGliWidget.class.getName(), "Hybrid", "Hybrid", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_NewModel) {
                this.newModel();
                return;
            }
            if (e.getSource() == this.m_menuItem_About) {
                this.aboutHybrid();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void newModel() {
        try {
            String name = JOptionPane.showInputDialog(null, "Name of the hybrid model", "Hybrid model ", -1);
            if (name == null) {
                return;
            }
            if (name.length() < 1) {
                return;
            }
            if ((name = Tools_Strings.removeSpace(name)).length() < 1) {
                return;
            }
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            String fullPath = p.hybridProjectsPath() + "/" + name;
            if (Tools_FileSystem.exists_path(fullPath)) {
                JOptionPane.showMessageDialog(null, "Hybrid model already exists", "Hybrid model already exists", 0);
                return;
            }
            Action_HybridGliDt_CreateModel action = new Action_HybridGliDt_CreateModel();
            action.Hasher.bool_put("UseDelayTimeAnis", false);
            action.Hasher.bool_put("ComputeAnis", false);
            action.Hasher.string_put("Name", name);
            p.executeSingleAction(action);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void aboutHybrid() {
        try {
            Object s = "<html>";
            s = (String)s + "Hybrid GLI requires a valid delay time solution.<br>";
            s = (String)s + "</html>";
            JOptionPane optionPane = new JOptionPane();
            optionPane.setMessage(s);
            optionPane.setMessageType(1);
            JDialog dialog = optionPane.createDialog(null, "About Hybrid GLI");
            dialog.setVisible(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

