/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.HybridGliDt;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.HybridGLI.HybridGliData;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class HybridStaticsWidget
extends LinearLayoutWidget
implements ItemListener,
ActionListener,
ISimpleWizardPage,
DocumentListener,
GenericObjectListener.Listener {
    protected JTextField m_txtName = new JTextField("HybridVersion1");
    protected JLabel m_messageLabel = new JLabel("");
    protected JCheckBox m_checkName = new JCheckBox("Overwrite existing statics values");
    protected Color m_darkYellow = new Color(150, 150, 0);
    protected String m_columnName = "";
    protected IntermediateDatumEnum m_intDatum = IntermediateDatumEnum.FixedElevation;
    protected JComboBox<String> m_comboIntMethod = new JComboBox();
    protected JPanel m_intMainPanel = new JPanel();
    protected CardLayout m_intCardLayout = new CardLayout();
    protected GridLayoutWidget m_intRefractorGrid;
    protected JCheckBox m_intRefractorSmoothCheck = new JCheckBox("Smooth refractor surface");
    protected JTextField m_intRefractorSmoothRadiusText = new JTextField("Only used if smoothing");
    protected JTextField m_intRefractorMoveDistanceText = new JTextField("Only used if smoothing");
    protected boolean m_hasNumbers = false;
    protected LinearLayoutWidget m_intFixedDepthWidget;
    protected JTextField m_intFixedDepthText = new JTextField("200");
    protected LinearLayoutWidget m_intFixedElevWidget;
    protected JTextField m_fintFxedElevText = new JTextField("1000");
    protected double Intermediate_SmoothRadius = 500.0;
    protected double Intermediate_DownwardDistance = 100.0;
    protected FinalDatumEnum m_finalDatum = FinalDatumEnum.FixedElevation;
    protected JComboBox<String> m_combo;
    protected JPanel m_mainPanel = new JPanel();
    protected CardLayout m_cardLayout = new CardLayout();
    protected JCheckBox m_zeroMeanCheck = new JCheckBox("Force final static field to be zero-mean");
    protected JTextField m_repVelText;
    protected LinearLayoutWidget m_fixedDepthWidget;
    protected JTextField m_fixedDepthText = new JTextField("200");
    protected LinearLayoutWidget m_fixedElevWidget;
    protected JTextField m_fixedElevText = new JTextField("1000");
    protected JTable m_rangeTable = new JTable();
    protected Table_SimpleModel m_rangeTableModel;
    protected JCheckBox m_chkResid = new JCheckBox("Add residual raypath correction");
    protected JButton m_btnStatics;

    public HybridStaticsWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            LinearLayoutWidget sub = this.createVertical(4, "Model ranges", 0);
            this.m_rangeTable.setShowGrid(true);
            this.m_rangeTable.setGridColor(Color.LIGHT_GRAY);
            this.m_rangeTableModel = new Table_SimpleModel(project.hybridGliData().getModelRangeTable());
            this.m_rangeTable.setModel(this.m_rangeTableModel);
            sub.addComponent(new JScrollPane(this.m_rangeTable), 11);
            sub.setMinimumSize(new Dimension(200, 170));
            sub = this.createVertical(0, "Name of the statics field", 0);
            sub.addComponent(this.m_txtName, 0);
            sub.addComponent(this.m_messageLabel, 0);
            sub.addComponent(this.m_checkName, 0);
            this.m_txtName.getDocument().addDocumentListener(this);
            this.m_checkName.setSelected(false);
            this.m_checkName.addActionListener(this);
            sub = this.createVertical(0, "Intermediate datum", 0);
            this.m_intMainPanel.setLayout(this.m_intCardLayout);
            this.m_intRefractorGrid = new GridLayoutWidget(0, null);
            this.m_intFixedDepthWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_intFixedElevWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_intFixedDepthText = this.m_intFixedDepthWidget.createSubTextField("Fixed depth (ft/m)", "200", null);
            this.m_intFixedDepthWidget.addStretch(10);
            this.m_fintFxedElevText = this.m_intFixedElevWidget.createSubTextField("Fixed Elevation (ft/m)", "0", null);
            this.m_intFixedElevWidget.addStretch(10);
            int row = 0;
            this.m_intRefractorGrid.addSimple(row++, new JLabel(" "), this.m_intRefractorSmoothCheck);
            this.m_intRefractorGrid.addSimple(row++, new JLabel("Smooth radius"), this.m_intRefractorSmoothRadiusText);
            this.m_intRefractorGrid.addSimple(row++, new JLabel("Downward shift"), this.m_intRefractorMoveDistanceText);
            this.m_intRefractorGrid.addComponent(new JLabel(""), row, 0, 5.0, 5.0);
            this.m_intRefractorSmoothCheck.setSelected(false);
            this.m_intRefractorSmoothCheck.addActionListener(this);
            this.m_intRefractorSmoothRadiusText.setEnabled(this.m_intRefractorSmoothCheck.isSelected());
            this.m_intRefractorMoveDistanceText.setEnabled(this.m_intRefractorSmoothCheck.isSelected());
            sub.addComponent(this.m_comboIntMethod, 10);
            for (IntermediateDatumEnum intermediateDatumEnum : IntermediateDatumEnum.values()) {
                this.m_comboIntMethod.addItem(intermediateDatumEnum.Description);
            }
            this.m_comboIntMethod.setSelectedIndex(0);
            this.m_comboIntMethod.addItemListener(this);
            this.m_intMainPanel.add((Component)new JPanel(), IntermediateDatumEnum.NotUsed.Description);
            this.m_intMainPanel.add((Component)this.m_intFixedElevWidget, IntermediateDatumEnum.FixedElevation.Description);
            this.m_intMainPanel.add((Component)this.m_intFixedDepthWidget, IntermediateDatumEnum.FixedDepth.Description);
            this.m_intMainPanel.add((Component)this.m_intRefractorGrid, IntermediateDatumEnum.RefractorSurface.Description);
            sub.addComponent(this.m_intMainPanel, 10);
            this.m_intCardLayout.show(this.m_intMainPanel, (String)this.m_comboIntMethod.getSelectedItem());
            sub.setMinimumSize(new Dimension(200, 180));
            sub = this.createVertical(0, "Final datum", 0);
            this.m_mainPanel.setLayout(this.m_cardLayout);
            this.m_fixedDepthWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_fixedElevWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_fixedDepthText = this.m_fixedDepthWidget.createSubTextField("Fixed depth (ft/m)", "200", null);
            this.m_fixedDepthWidget.addStretch(10);
            this.m_fixedElevText = this.m_fixedElevWidget.createSubTextField("Fixed Elevation (ft/m)", "0", null);
            this.m_fixedElevWidget.addStretch(10);
            this.m_repVelText = sub.createSubTextField("Replacement velocity", "1000", null);
            sub.addComponent(this.m_zeroMeanCheck, 0);
            this.m_combo = sub.createSubComboBox("Datum specification:", this);
            for (Enum enum_ : FinalDatumEnum.values()) {
                this.m_combo.addItem(((FinalDatumEnum)enum_).Description);
            }
            this.m_combo.setSelectedIndex(0);
            this.m_mainPanel.add((Component)new JPanel(), FinalDatumEnum.NotUsed.Description);
            this.m_mainPanel.add((Component)this.m_fixedElevWidget, FinalDatumEnum.FixedElevation.Description);
            this.m_mainPanel.add((Component)this.m_fixedDepthWidget, FinalDatumEnum.FixedDepth.Description);
            sub.addComponent(this.m_mainPanel, 10);
            this.m_cardLayout.show(this.m_mainPanel, (String)this.m_combo.getSelectedItem());
            this.createGapLabel(20);
            this.addComponent(this.m_chkResid, 0);
            this.createGapLabel(20);
            this.m_btnStatics = this.createButton("Compute static", this, 0);
            this.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
            HybridGliData model = RefractionStaticsProject.singleton().hybridGliData();
            model.listener().addListener(this);
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            HybridGliData model;
            String msg = null;
            if (data != null && data instanceof String) {
                msg = (String)data;
            }
            if (sender == (model = RefractionStaticsProject.singleton().hybridGliData()) && msg != null && msg.equalsIgnoreCase("ModelRangeTableModified")) {
                this.m_rangeTable.setModel(this.m_rangeTableModel);
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void dialogJustOpened() {
    }

    protected Grid3D getFinalDatumGrid() {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String method = this.m_combo.getSelectedItem().toString();
            if (method.equalsIgnoreCase(FinalDatumEnum.FixedElevation.Description)) {
                Grid3D grid = project.getEmptyGrid3D(200.0, 300.0, 300.0);
                float v = (float)Tools_Widget.extractDouble(this.m_fixedElevText, 0.0, -100000.0, 100000.0);
                grid.setValue(v);
                return grid;
            }
            return null;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected Grid3D getIntDatumGrid() {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String method = this.m_comboIntMethod.getSelectedItem().toString();
            if (method.equalsIgnoreCase(IntermediateDatumEnum.FixedElevation.Description)) {
                Grid3D grid = project.getEmptyGrid3D(200.0, 300.0, 300.0);
                float v = (float)Tools_Widget.extractDouble(this.m_fintFxedElevText, 0.0, -100000.0, 100000.0);
                grid.setValue(v);
                return grid;
            }
            return null;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void computeStatics() {
        try {
            if (!this.checkName()) {
                JOptionPane.showMessageDialog(null, "Column name not valid", "Cannot create statics", 0);
                return;
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            Grid3D finalDatumGrid = this.getFinalDatumGrid();
            Grid3D intDatumGrid = this.getIntDatumGrid();
            Grid3D v0Grid = project.hybridGliData().getGrid("WeatheringVelocity");
            Grid3D v1Grid = project.hybridGliData().getGrid("FirstRefractorVelocity");
            Grid3D z1Grid = project.hybridGliData().getGrid("FirstRefractorElevation");
            double vRep = Tools_Widget.extractDouble(this.m_repVelText, 8000.0, 1000.0, 25000.0);
            for (int t = 0; t <= 1; ++t) {
                Table_Abstract table = project.shotTable();
                int indexID = table.column_indexOfColumn("ShotID");
                Table_Abstract tableHybrid = project.hybridGliData().shotTable();
                HashMap_Integer hash = project.hybridGliData().shotHash();
                int colResid = tableHybrid.column_indexOfColumn("Residual");
                if (t == 1) {
                    table = project.receiverTable();
                    indexID = table.column_indexOfColumn("ReceiverID");
                    tableHybrid = project.hybridGliData().recTable();
                    hash = project.hybridGliData().recHash();
                    colResid = tableHybrid.column_indexOfColumn("Residual");
                }
                int indexX = table.column_indexOfColumn("Easting");
                int indexY = table.column_indexOfColumn("Northing");
                int indexZ = table.column_indexOfColumn("Elevation");
                int indexStatic = table.column_append(this.m_columnName, DataType.Double);
                int indexKilled = table.column_indexOfColumn("Killed");
                for (int row = 0; row < table.row_count(); ++row) {
                    int id;
                    if (table.getBool(row, indexKilled)) {
                        table.putDouble(row, indexStatic, -9999.0);
                        continue;
                    }
                    double x = table.getDouble(row, indexX);
                    double y = table.getDouble(row, indexY);
                    double z = table.getDouble(row, indexZ);
                    double z1 = z1Grid.getNearestValue(x, y);
                    double v1 = v1Grid.getNearestValue(x, y);
                    double v0 = v0Grid.getNearestValue(x, y);
                    double zInt = intDatumGrid.getNearestValue(x, y);
                    double zFinal = finalDatumGrid.getNearestValue(x, y);
                    double t2 = (zFinal - zInt) / vRep;
                    double t1 = 0.0;
                    if (zInt <= z1 && z >= z1) {
                        t1 = (z - z1) / v0 + (z1 - zInt) / v1;
                    }
                    if (zInt <= z1 && z <= z1) {
                        t1 = (z - zInt) / v1;
                    }
                    if (zInt >= z1 && z >= z1) {
                        t1 = (z - zInt) / v0;
                    }
                    double stat = 1000.0 * (t2 - t1);
                    if (this.m_chkResid.isSelected() && hash.containsKey(id = table.getInt(row, indexID))) {
                        int rowHybrid = hash.get(id);
                        double residual = tableHybrid.getDouble(rowHybrid, colResid);
                        double pathCorrection = 1.0;
                        if (v0 < v1) {
                            pathCorrection = Math.cos(v0 / v1);
                        }
                        stat -= pathCorrection * residual;
                    }
                    table.putDouble(row, indexStatic, stat);
                }
            }
            this.interpolateBad();
            if (this.m_zeroMeanCheck.isSelected()) {
                Tools_RefractionStaticsProject.convertToZeroMean(this.m_columnName);
            }
            project.geometryDatabase().writeColumnContentsToDatabase(project.receiverTable(), this.m_columnName);
            project.geometryDatabase().writeColumnContentsToDatabase(project.shotTable(), this.m_columnName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void interpolateBad() {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.setCursor(Cursor.getPredefinedCursor(3));
            Grid3D grid = project.getSmootherGrid();
            grid.interp_Prep();
            grid.interp_ZeroArrays();
            int num = 0;
            num += this.addToGrid(project.receiverTable(), grid);
            if ((num += this.addToGrid(project.shotTable(), grid)) < 1) {
                return;
            }
            grid.interp_Finish(5);
            this.getFromGrid(project.receiverTable(), grid);
            this.getFromGrid(project.shotTable(), grid);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getFromGrid(Table_Abstract table, Grid3D grid) {
        try {
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int index = table.column_indexOfColumn(this.m_columnName);
            for (int row = 0; row < table.row_count(); ++row) {
                double v = table.getDouble(row, index);
                if (!(v < -1000.0)) continue;
                double x = table.getDouble(row, indexX);
                double y = table.getDouble(row, indexY);
                float v1 = grid.getNearestValue(x, y);
                table.putDouble(row, index, v1);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected int addToGrid(Table_Abstract table, Grid3D grid) {
        try {
            int num = 0;
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int index = table.column_indexOfColumn(this.m_columnName);
            for (int row = 0; row < table.row_count(); ++row) {
                double v = table.getDouble(row, index);
                if (!(v >= -1000.0)) continue;
                double x = table.getDouble(row, indexX);
                double y = table.getDouble(row, indexY);
                grid.interp_Add(x, y, (float)v, 1.0f);
                ++num;
            }
            return num;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnStatics) {
                this.computeStatics();
                return;
            }
            if (e.getSource() == this.m_checkName) {
                this.checkName();
            }
            if (e.getSource() == this.m_intRefractorSmoothCheck) {
                if (this.m_hasNumbers) {
                    this.Intermediate_SmoothRadius = Tools_Widget.extractDouble(this.m_intRefractorSmoothRadiusText, 100.0, 1.0, 999999.0);
                    this.Intermediate_DownwardDistance = Tools_Widget.extractDouble(this.m_intRefractorMoveDistanceText, 0.0, -9999.0, 999999.0);
                }
                if (!this.m_intRefractorSmoothCheck.isSelected()) {
                    this.m_intRefractorSmoothRadiusText.setText("Only used if smoothing");
                    this.m_intRefractorMoveDistanceText.setText("Only used if smoothing");
                    this.m_hasNumbers = false;
                } else {
                    this.m_intRefractorSmoothRadiusText.setText(Double.toString(this.Intermediate_SmoothRadius));
                    this.m_intRefractorMoveDistanceText.setText(Double.toString(this.Intermediate_DownwardDistance));
                    this.m_hasNumbers = true;
                }
                this.m_intRefractorSmoothRadiusText.setEnabled(this.m_intRefractorSmoothCheck.isSelected());
                this.m_intRefractorMoveDistanceText.setEnabled(this.m_intRefractorSmoothCheck.isSelected());
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.m_combo) {
                this.m_cardLayout.show(this.m_mainPanel, (String)this.m_combo.getSelectedItem());
            }
            if (e.getSource() == this.m_comboIntMethod) {
                this.m_intCardLayout.show(this.m_intMainPanel, (String)this.m_comboIntMethod.getSelectedItem());
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    @Override
    public boolean okayToGoToNextPage() {
        return this.checkName();
    }

    @Override
    public void leavingPage() {
    }

    @Override
    public void activatePage() {
    }

    protected boolean checkName() {
        try {
            this.m_btnStatics.setEnabled(false);
            this.m_columnName = "";
            String name = this.m_txtName.getText();
            this.m_messageLabel.setText("");
            if (name.length() < 3) {
                this.m_messageLabel.setForeground(Color.red);
                this.m_messageLabel.setText("Name must have at least 3 characters");
                return false;
            }
            if (!Tools_Strings.isAlphaNumeric(name, true, false)) {
                this.m_messageLabel.setForeground(Color.red);
                this.m_messageLabel.setText("Spaces and special characters not allowed");
                return false;
            }
            String column = "STATICS_" + name;
            boolean exists = Tools_RefractionStaticsProject.columnExists(column, true, true);
            if (exists) {
                if (this.m_checkName.isSelected()) {
                    this.m_columnName = column;
                    this.m_messageLabel.setForeground(this.m_darkYellow);
                    this.m_messageLabel.setText(String.format("Statics values in %s will be overwritten", column));
                    this.m_btnStatics.setEnabled(true);
                    return true;
                }
                this.m_messageLabel.setForeground(Color.red);
                this.m_messageLabel.setText(String.format("Statics column %s already exists", column));
                return false;
            }
            this.m_columnName = column;
            this.m_messageLabel.setForeground(Color.blue);
            this.m_messageLabel.setText(String.format("Statics written to column %s", column));
            this.m_btnStatics.setEnabled(true);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        try {
            this.checkName();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected static enum IntermediateDatumEnum {
        FixedElevation("Intermediate datum at a constant elevation"),
        FixedDepth("Intermediate datum at a fixed depth below the surface"),
        RefractorSurface("Intermediate datum at a refractor surface"),
        NotUsed("Intermediate datum not used");

        public final String Description;

        private IntermediateDatumEnum(String s) {
            this.Description = s;
        }
    }

    protected static enum FinalDatumEnum {
        FixedElevation("Final datum at a constant elevation"),
        FixedDepth("Final datum at a fixed depth below the surface"),
        NotUsed("Final datum not used");

        public final String Description;

        private FinalDatumEnum(String s) {
            this.Description = s;
        }
    }
}

