/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.GLI;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;

public class GliNewModelLayerSelectionDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener,
IParameterWidgetListener,
ItemListener {
    protected boolean OK = false;
    protected JButton m_btnOK = new JButton("OK");
    protected JButton m_btnCancel = new JButton("Cancel");
    protected JComboBox m_layerCombo = new JComboBox();

    public GliNewModelLayerSelectionDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            for (int i = 1; i <= 10; ++i) {
                String indexString = Integer.toString(i);
                this.m_layerCombo.addItem(indexString);
            }
            int initialLayerCount = RefractionStaticsProject.singleton().gliNewModelLayerCount();
            this.m_layerCombo.setSelectedIndex(initialLayerCount - 1);
            LinearLayoutWidget middle = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            LinearLayoutWidget grid = middle.createVertical(3, "Please select the number of refractors in your GLI model", 0);
            grid.add(this.m_layerCombo);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            bottom.addStretch(10);
            this.getContentPane().add((Component)middle, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.setSize(350, 150);
            this.setTitle("GLI New Model Layer Selection");
            this.setLocationRelativeTo(null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void showDialog() {
        try {
            this.OK = false;
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                int layers = this.m_layerCombo.getSelectedIndex() + 1;
                int oldLayerCount = RefractionStaticsProject.singleton().gliNewModelLayerCount();
                if (oldLayerCount != layers) {
                    RefractionStaticsProject.singleton().gliInteractiveModel_PickCollection().clear();
                }
                RefractionStaticsProject.singleton().setGliNewModelLayerCount(layers);
                this.OK = true;
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender != this.m_layerCombo) return;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }
}

