/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.GLI;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.Seismic.SparseCmpGatherManager;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Math.Grid3D_Conversion;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Parameter.IParameterWidgetListener;
import com.PecosCore.Windows.Parameter.SliderWidget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.IGrid2D_Conversion;
import com.PecosLibrary.Refraction.GLI.GliInteractiveModel_PickCollection;
import com.PecosLibrary.Refraction.GLI.GliInteractiveModel_SingleLocation;
import com.PecosLibrary.Refraction.GLI.GliModel;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Tools.BitmapEnum;
import com.PecosLibrary.Windows.Ensemble.Sequence.Sequence_MainWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleAxisEnum;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_EnsembleDisplayOptionsWidget;
import com.PecosLibrary.Windows.Java2D.Ensemble.Java2D_VertStackedEnsembleDisplayWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_AxisLocker;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_PaintablePointArray;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_AxisLines;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_GliInteractiveModel;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_KeyPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Line;
import com.PecosLibrary.Windows.Shared.BitmapCardWidget;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class GliNewModelDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener,
IParameterWidgetListener,
ItemListener {
    public boolean OK = false;
    protected Java2D_SimpleComposite m_widget;
    protected RadioPanel m_radioMethod;
    protected ComboStringListWrapper m_versionCombo = new ComboStringListWrapper();
    protected JLabel m_lblStatusVersion = new JLabel("okay");
    protected JLabel m_lblStatus = new JLabel("");
    protected JLabel m_lblNumInline = new JLabel("", 4);
    protected JLabel m_lblNumCrossline = new JLabel("", 4);
    protected JLabel m_lblNumZ = new JLabel("", 4);
    protected JLabel m_lblMemory = new JLabel("", 4);
    protected JLabel m_lblLayer = new JLabel("", 4);
    protected JTextField m_txtAngle = new JTextField("0");
    protected JTextField m_txtElevationSize = new JTextField("300");
    protected JTextField m_txtVelocitySize = new JTextField("500");
    protected JTextField m_txtName = new JTextField("");
    protected JTextField m_txtMaxOffset = new JTextField("10000");
    protected JButton m_btnCreateGli;
    protected JButton m_btnCancel;
    protected JButton m_clearButton;
    protected JCheckBox m_checkUseSparseGathers;
    protected JComboBox<String> m_radiusCombo = new JComboBox();
    protected Java2D_UserEventConsumer_Line m_lineUEC = new Java2D_UserEventConsumer_Line();
    protected Java2D_UserEventConsumer_GliInteractiveModel m_gliModelUEC = new Java2D_UserEventConsumer_GliInteractiveModel();
    protected Java2D_UserEventConsumer_ButtonPressed m_leftClickUEC;
    protected Java2D_UserEventConsumer_KeyPressed m_mapKeyUEC;
    protected Java2D_AxisLocker m_axisLockerTime;
    protected Java2D_AxisLocker m_axisLockerDepth;
    protected Java2D_AxisLocker m_axisLockerVelocity;
    protected SliderWidget m_lmoSlider;
    protected Java2D_VertStackedEnsembleDisplayWidget m_wiggleWidget;
    protected Java2D_EnsembleDisplayOptionsWidget m_wiggleOptionsWidget;
    protected Sequence_MainWidget m_workerWidget;
    protected EnsembleWorker_Sequence m_sequence;
    protected Java2D_SimpleComposite m_basemapWidget = new Java2D_SimpleComposite(false);
    protected Java2D_SimpleComposite m_modelWidget = new Java2D_SimpleComposite(false);
    protected Java2D_Paintable_Table m_shotPainTable = null;
    protected Java2D_Paintable_Table m_receiverPainTable = null;
    protected double m_worldX;
    protected double m_worldY;
    protected double m_worldZ;
    protected Ensemble m_inputEnsemble = new Ensemble();
    protected Ensemble m_inputEnsembleCopy = new Ensemble();
    protected Ensemble m_processedEnsemble = new Ensemble();
    protected GliInteractiveModel_SingleLocation m_gliModel = new GliInteractiveModel_SingleLocation();
    protected GliInteractiveModel_SingleLocation m_hack = null;
    protected boolean m_debug;
    protected boolean m_versionOkay = false;

    public GliNewModelDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            this.m_gliModel.Permanent = false;
            JSplitPane splitter = new JSplitPane(1);
            splitter.setLeftComponent(this.createLeft());
            splitter.setRightComponent(this.createRightParent());
            this.reloadShotRecData();
            this.reloadMapPlot();
            this.getContentPane().add((Component)splitter, "Center");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.setSize(950, 750);
            this.setTitle("Create new GLI model");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadVersions() {
        try {
            ArrayList<String> versionList = RefractionStaticsProject.singleton().versionList();
            this.m_versionCombo.setStringArray(versionList);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void showDialog() {
        try {
            this.OK = false;
            this.reload();
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected JComponent createLeft() {
        try {
            this.m_workerWidget = new Sequence_MainWidget("LinearTrend", EnsembleWorker_Sequence.SequenceType.Interactive);
            this.m_sequence = this.m_workerWidget.sequence();
            this.m_sequence.addListener(this);
            LinearLayoutWidget mainDisplay = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_wiggleOptionsWidget = new Java2D_EnsembleDisplayOptionsWidget(null);
            this.m_wiggleOptionsWidget.setFill(false, true);
            this.m_wiggleOptionsWidget.setClippingState(true);
            this.m_wiggleOptionsWidget.setNoOverlap();
            mainDisplay.addComponent(this.m_wiggleOptionsWidget, 0);
            mainDisplay.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(mainDisplay, -2, null, true);
            BitmapCardWidget bitmapCardWidget = new BitmapCardWidget();
            bitmapCardWidget.addComponent(BitmapEnum.Basemap, this.createMapWidget(), "Basemap");
            bitmapCardWidget.addComponent(BitmapEnum.Sequence, this.m_workerWidget, "Ensemble processing sequence");
            bitmapCardWidget.addComponent(BitmapEnum.Wiggle, mainDisplay, "Wiggle display options");
            return bitmapCardWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRightParent() {
        try {
            JSplitPane splitter = new JSplitPane(1);
            splitter.setLeftComponent(this.createWiggleComponent());
            splitter.setRightComponent(this.createModelComponent());
            return splitter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createWiggleComponent() {
        try {
            LinearLayoutWidget topLevel = LinearLayoutWidget.vert(0, null);
            LinearLayoutWidget topBar = topLevel.createHorizontal(0, null, 0);
            this.m_axisLockerTime = new Java2D_AxisLocker("Lock time", "Lock axis ");
            this.m_axisLockerTime.listener().addListener(this);
            topBar.addComponent(this.m_axisLockerTime, 2);
            this.m_lmoSlider = new SliderWidget(this, "Apply linear moveout", "Linear moveout correction", 0, 3000.0, 1000.0, 22000.0);
            topBar.addComponent(this.m_lmoSlider, 3);
            this.m_wiggleWidget = new Java2D_VertStackedEnsembleDisplayWidget(1);
            this.m_wiggleWidget.setHeaderPlotVisibleCount(0, 0);
            this.m_wiggleWidget.HeaderTextRowCount = 0;
            this.m_wiggleWidget.setAxisType(Java2D_EnsembleAxisEnum.TraceHeader);
            this.m_wiggleWidget.setAxisTableColumn("Trace", "Offset");
            this.m_wiggleWidget.setEnsembleDisplayOptionsWidget(this.m_wiggleOptionsWidget);
            topLevel.addComponent(this.m_lblStatus, 0);
            topLevel.addComponent(this.m_wiggleWidget, 10);
            this.m_wiggleWidget.addZoomer();
            this.m_wiggleWidget.addEventConsumer(0, this.m_gliModelUEC);
            this.m_gliModelUEC.addListener(this);
            return topLevel;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createModelComponent() {
        try {
            LinearLayoutWidget topLevel = LinearLayoutWidget.vert(0, null);
            LinearLayoutWidget topbar = topLevel.createHorizontal(0, null, 0);
            this.m_axisLockerDepth = new Java2D_AxisLocker("Lock depth", "Lock axis ");
            this.m_axisLockerDepth.listener().addListener(this);
            topbar.addComponent(this.m_axisLockerDepth, 2);
            this.m_axisLockerVelocity = new Java2D_AxisLocker("Lock velocity", "Lock axis ");
            this.m_axisLockerVelocity.listener().addListener(this);
            topbar.addComponent(this.m_axisLockerVelocity, 2);
            this.m_modelWidget.setColorScaleVisible(false);
            topLevel.addComponent(this.m_modelWidget, 10);
            return topLevel;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createMapWidget() {
        try {
            LinearLayoutWidget mapWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_checkUseSparseGathers = new JCheckBox("Use precomputed CMP gathers");
            if (RefractionStaticsProject.singleton().dim3D()) {
                LinearLayoutWidget widget = mapWidget.createVertical(3, "Sparse CMP gathers", 0);
                widget.addComponent(this.m_checkUseSparseGathers, 0);
                widget.createLabel("Sparse CMP gathers computed under the Sort menu", 0, 0);
                SparseCmpGatherManager cmpManager = RefractionStaticsProject.singleton().sparseCmpGathers();
                this.m_checkUseSparseGathers.setSelected(cmpManager.valid());
                this.m_checkUseSparseGathers.setEnabled(cmpManager.valid());
                this.m_checkUseSparseGathers.addActionListener(this);
            } else {
                this.m_checkUseSparseGathers.setSelected(false);
                this.m_checkUseSparseGathers.setEnabled(false);
            }
            this.m_btnCreateGli = new JButton("Create new GLI model");
            this.m_btnCreateGli.addActionListener(this);
            this.m_txtMaxOffset.addActionListener(this);
            this.m_txtName.addActionListener(this);
            GridLayoutWidget grid = mapWidget.createGridLayoutWidget(0, "Model, Offset", 0);
            grid.addSimple(0, new JLabel("Model name"), this.m_txtName);
            grid.addSimple(1, new JLabel("Max offset"), this.m_txtMaxOffset);
            grid.addSimple(2, new JLabel(" "), this.m_btnCreateGli);
            LinearLayoutWidget binWidget = mapWidget.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, "Number of bins", 0);
            this.m_radiusCombo.addItem("1 bin");
            if (RefractionStaticsProject.singleton().dim3D()) {
                for (i = 1; i < 11; ++i) {
                    int num = 2 * i + 1;
                    String entry = String.format("%d x %d bins", num, num);
                    this.m_radiusCombo.addItem(entry);
                }
            } else {
                for (i = 1; i < 11; ++i) {
                    int num = 2 * i + 1;
                    String entry = String.format("%d bins", num);
                    this.m_radiusCombo.addItem(entry);
                }
            }
            this.m_radiusCombo.setSelectedIndex(1);
            binWidget.addComponent(this.m_radiusCombo, 10);
            mapWidget.createLabel("Left-click to add/select location", 2, 0);
            mapWidget.createLabel("Press \"r\" to remove nearest location", 2, 0);
            this.m_basemapWidget.setAxesVisible(false, false);
            this.m_basemapWidget.setColorScaleVisible(true);
            mapWidget.addComponent(this.m_basemapWidget, 10);
            LinearLayoutWidget bottom = mapWidget.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null, 0);
            this.m_clearButton = bottom.createButton("Remove all", this, 0);
            bottom.addStretch(10);
            this.m_leftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
            this.m_leftClickUEC.addListener(this);
            this.m_mapKeyUEC = new Java2D_UserEventConsumer_KeyPressed();
            this.m_mapKeyUEC.addListener(this);
            return mapWidget;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected Java2D_Paintable_Table createPT(String tableName, String colX, String colY) {
        try {
            Java2D_Paintable_Table painter = new Java2D_Paintable_Table();
            String colID = tableName + "ID";
            String query = String.format("SELECT  %s, %s, %s FROM %s WHERE KILLED = FALSE", colX, colY, colID, tableName);
            Table_Abstract table = this.database().extractTableDataUsingQuery(tableName, query, Pecos.MaxQueryRowCount);
            painter.setTable(table);
            painter.UseColorScale = false;
            painter.FixedColor = Color.BLACK;
            painter.Symbol = Java2D_PointSymbol.Plus;
            painter.DrawMoveVectors = false;
            painter.Size_UsePixel = true;
            painter.Size_Pixel = 3;
            painter.setAxisX(colX);
            painter.setAxisY(colY);
            return painter;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected boolean nameOkay() {
        try {
            String name = this.m_txtName.getText();
            if (name == null) {
                JOptionPane.showMessageDialog(null, "Please enter a name", "Cannot create model", 0);
                return false;
            }
            name = Tools_Strings.removeCrap(name, true);
            this.m_txtName.setText(name);
            if (name.length() < 2) {
                JOptionPane.showMessageDialog(null, "The name must have at least two characters", "Cannot create model", 0);
                return false;
            }
            String path = "";
            if (Tools_FileSystem.exists_path(path)) {
                JOptionPane.showMessageDialog(null, "Model with that name already exists", "Cannot create model", 0);
                return false;
            }
            if (name.equalsIgnoreCase("ShotRecStacks")) {
                JOptionPane.showMessageDialog(null, "Invalid name", "Cannot create model", 0);
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected void createNew() {
        try {
            if (!this.nameOkay()) {
                return;
            }
            String name = this.m_txtName.getText();
            GliModel gliModel = new GliModel();
            gliModel.prepInteractiveModel(name);
            RefractionStaticsProject.singleton().setGliModel(gliModel);
            this.dispose();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected boolean marineTableOkay(Table_Abstract tbl) {
        try {
            if (!tbl.column_exists("WaterDepth")) {
                return false;
            }
            return tbl.column_exists("PointDepth");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected boolean checkMarineOkay() {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            Table_Abstract shotTable = project.shotTable();
            Table_Abstract recTable = project.receiverTable();
            return this.marineTableOkay(shotTable) && this.marineTableOkay(recTable);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected void reload() {
        try {
            this.reloadMapPlot();
            this.reloadWiggle();
            this.reloadModelPlot(false, false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void reloadMapPlot() {
        try {
            SparseCmpGatherManager sparse;
            Java2D_Widget widget = this.m_basemapWidget.mainWidget();
            widget.clearPaintableList();
            widget.clearEventConsumerList();
            if (this.m_shotPainTable != null) {
                widget.addPaintable(this.m_shotPainTable, -9999);
            }
            if (this.m_receiverPainTable != null) {
                widget.addPaintable(this.m_receiverPainTable, -9999);
            }
            if (this.m_checkUseSparseGathers != null && this.m_checkUseSparseGathers.isSelected() && (sparse = RefractionStaticsProject.singleton().sparseCmpGathers()).size() > 0) {
                Java2D_PaintablePointArray array = new Java2D_PaintablePointArray(sparse);
                widget.addPaintable(array, -9999);
            }
            GliInteractiveModel_PickCollection pickCollection = RefractionStaticsProject.singleton().gliInteractiveModel_PickCollection();
            widget.addPaintable(pickCollection, -9999);
            widget.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            widget.mooz();
            widget.clearEventConsumerList();
            widget.addZoomer();
            widget.addEventConsumer(this.m_leftClickUEC);
            widget.addEventConsumer(this.m_mapKeyUEC);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadModelPlot(boolean loadTemp, boolean reloadCurrent) {
        try {
            GliInteractiveModel_PickCollection pickCollection = RefractionStaticsProject.singleton().gliInteractiveModel_PickCollection();
            Java2D_Widget widget = this.m_modelWidget.mainWidget();
            this.m_modelWidget.setHorizontalTitle("Velocity");
            this.m_modelWidget.setVerticalTitle("Depth");
            Java2D_Paintable_AxisLines lines = new Java2D_Paintable_AxisLines();
            lines.DrawHorizontalLines = true;
            lines.DrawVerticalLines = true;
            widget.clearPaintableList();
            widget.addPaintable(lines, 2000);
            if (reloadCurrent || this.m_hack != pickCollection.current()) {
                this.m_hack = pickCollection.current();
                if (this.m_debug) {
                    boolean bl = false;
                }
                if (this.m_hack != null) {
                    this.m_hack.computeGliModel(this.m_debug);
                    if (this.m_hack.modelValid()) {
                        this.m_hack.LineColor = Color.RED;
                    }
                }
            }
            if (this.m_hack != null) {
                widget.addPaintable(this.m_hack, 2001);
            }
            if (loadTemp) {
                this.m_gliModelUEC.prepGliModel(this.m_gliModel, true);
                this.m_gliModel.computeGliModel(this.m_debug);
                if (this.m_gliModel.modelValid()) {
                    widget.addPaintable(this.m_gliModel, 2000);
                }
            }
            widget.transform().setTechnique(Java2D_Transform.Technique.Inverted);
            widget.mooz();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void handleMapClick() {
        try {
            this.m_worldX = this.m_leftClickUEC.WorldX;
            this.m_worldY = this.m_leftClickUEC.WorldY;
            if (!this.m_checkUseSparseGathers.isSelected()) {
                if (RefractionStaticsProject.singleton().dim3D()) {
                    Grid3D_Conversion grid3D = RefractionStaticsProject.singleton().getGrid3D_Conversion();
                    grid3D.setWorldLocation(this.m_leftClickUEC.WorldX, this.m_leftClickUEC.WorldY);
                    int radius = this.m_radiusCombo.getSelectedIndex();
                    this.m_inputEnsemble.clearTraces(false);
                    RefractionStaticsProject.singleton().ensemble_Bin3D(this.m_inputEnsemble, grid3D.Inline, grid3D.Crossline, radius, true);
                } else {
                    IGrid2D_Conversion grid2D = RefractionStaticsProject.singleton().getGrid2D_Conversion();
                    int bin = grid2D.getBin(this.m_leftClickUEC.WorldX, this.m_leftClickUEC.WorldY);
                    int radius = this.m_radiusCombo.getSelectedIndex();
                    this.m_worldX = grid2D.getX(bin);
                    this.m_worldY = grid2D.getY(bin);
                    this.m_inputEnsemble.clearTraces(false);
                    RefractionStaticsProject.singleton().ensemble_Bin2D(this.m_inputEnsemble, bin, radius, true);
                }
            } else {
                SparseCmpGatherManager sparse = RefractionStaticsProject.singleton().sparseCmpGathers();
                sparse.selectNearestCMP(this.m_leftClickUEC.WorldX, this.m_leftClickUEC.WorldY, this.m_inputEnsemble);
                this.m_worldX = sparse.SelectedX;
                this.m_worldY = sparse.SelectedY;
                RefractionStaticsProject.singleton().prepGeometryHeaders(this.m_inputEnsemble, true, true);
                RefractionStaticsProject.singleton().inputDataProcessor_Run(this.m_inputEnsemble);
            }
            GliInteractiveModel_PickCollection pickCollection = RefractionStaticsProject.singleton().gliInteractiveModel_PickCollection();
            double minDistance = 300.0;
            if (RefractionStaticsProject.singleton().units_feet()) {
                minDistance = 1000.0;
            }
            this.m_worldZ = this.getElevation(this.m_worldX, this.m_worldY);
            boolean pause = false;
            pickCollection.setCurrent(this.m_worldX, this.m_worldY, this.m_worldZ, minDistance);
            pause = false;
            if (pickCollection.current() != null) {
                pickCollection.current().ApplyLMO = this.m_lmoSlider.isCheckSelected();
                pickCollection.current().VelocityLMO = this.m_lmoSlider.getDoubleValue();
            }
            this.processEnsemble(true);
            Java2D_Widget widget = this.m_basemapWidget.mainWidget();
            widget.forceImageRepaint();
            widget.repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected double getElevation(double x, double y) {
        try {
            double weight;
            double dSq;
            double dy;
            double dx;
            double sum1 = 0.0;
            double sum2 = 1.0E-50;
            Table_Abstract shotTable = RefractionStaticsProject.singleton().shotTable();
            Table_Abstract receiverTable = RefractionStaticsProject.singleton().receiverTable();
            int indexShotX = shotTable.column_indexOfColumn("Easting");
            int indexShotY = shotTable.column_indexOfColumn("Northing");
            int indexShotZ = shotTable.column_indexOfColumn("Elevation");
            int indexReceiverX = receiverTable.column_indexOfColumn("Easting");
            int indexReceiverY = receiverTable.column_indexOfColumn("Northing");
            int indexReceiverZ = receiverTable.column_indexOfColumn("Elevation");
            int indexShotKilled = shotTable.column_indexOfColumn("Killed");
            int indexReceiverKilled = receiverTable.column_indexOfColumn("Killed");
            for (int shot = 0; shot < shotTable.row_count(); ++shot) {
                boolean shotKilled = shotTable.getBool(shot, indexShotKilled);
                if (shotKilled) continue;
                double shotX = shotTable.getDouble(shot, indexShotX);
                double shotY = shotTable.getDouble(shot, indexShotY);
                double shotZ = shotTable.getDouble(shot, indexShotZ);
                dx = x - shotX;
                dy = y - shotY;
                dSq = dx * dx + dy * dy;
                weight = 1.0 / (1.0 + dSq * dSq);
                sum1 += weight * shotZ;
                sum2 += weight;
            }
            for (int receiver = 0; receiver < receiverTable.row_count(); ++receiver) {
                boolean receiverKilled = receiverTable.getBool(receiver, indexReceiverKilled);
                if (receiverKilled) continue;
                double receiverX = receiverTable.getDouble(receiver, indexReceiverX);
                double receiverY = receiverTable.getDouble(receiver, indexReceiverY);
                double receiverZ = receiverTable.getDouble(receiver, indexReceiverZ);
                dx = x - receiverX;
                dy = y - receiverY;
                dSq = dx * dx + dy * dy;
                weight = 1.0 / (1.0 + dSq * dSq);
                sum1 += weight * receiverZ;
                sum2 += weight;
            }
            return sum1 / sum2;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0;
        }
    }

    protected void processEnsemble(boolean mooz) {
        try {
            if (this.m_inputEnsemble == null) {
                this.m_processedEnsemble = null;
            } else {
                this.m_inputEnsemble.copyToOtherEnsemble(this.m_inputEnsembleCopy);
                this.m_processedEnsemble = this.m_sequence.work(this.m_inputEnsembleCopy);
            }
            this.shiftTraces();
            if (mooz) {
                this.reloadWiggle();
            } else {
                this.m_wiggleWidget.forcePaintAll();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void shiftTraces() {
        try {
            if (this.m_processedEnsemble == null) {
                return;
            }
            if (!this.m_processedEnsemble.dictionary().containsEntry("Trace", "Offset")) {
                return;
            }
            int indexOffset = this.m_processedEnsemble.dictionary().getEntryIndex("Trace", "Offset");
            if (this.m_lmoSlider.isCheckSelected()) {
                double vel = this.m_lmoSlider.getDoubleValue();
                for (int t = 0; t < this.m_processedEnsemble.traceCount(); ++t) {
                    FloatArrayWrapper wrapper = this.m_processedEnsemble.trace(t).data();
                    double offset = this.m_processedEnsemble.trace(t).header().getDouble(indexOffset);
                    float shift = (float)(1000.0 * (offset / vel));
                    wrapper.addShiftToFirstSampleCoord(0.0f - shift);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadWiggle() {
        try {
            double maxOffset = Tools_Widget.extractDouble(this.m_txtMaxOffset, 2000.0, 10.0, 22000.0);
            this.m_wiggleWidget.setAxisLocked_X(true, 0.0, maxOffset);
            this.m_wiggleWidget.setEnsemble(0, this.m_processedEnsemble);
            this.m_wiggleWidget.setRangeExpander(0, true, 0.0, 0.0, true, 0.0, 0.0);
            this.m_wiggleWidget.clearAndLoadWigglePaintables();
            GliInteractiveModel_PickCollection pickCollection = RefractionStaticsProject.singleton().gliInteractiveModel_PickCollection();
            if (pickCollection.current() != null) {
                pickCollection.current().computeGliModel(this.m_debug);
                this.m_wiggleWidget.addPaintable(0, pickCollection.current(), 1000);
            }
            this.m_wiggleWidget.unzoom();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadShotRecData() {
        try {
            this.m_shotPainTable = Tools_RefractionStaticsProject.loadGeomPO("Shot", "Elevation");
            this.m_receiverPainTable = Tools_RefractionStaticsProject.loadGeomPO("Receiver", "Elevation");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            GliInteractiveModel_PickCollection pickCollection = RefractionStaticsProject.singleton().gliInteractiveModel_PickCollection();
            if (sender == this.m_gliModelUEC) {
                this.m_lblStatus.setText(" ");
                this.m_debug = false;
                if (this.m_gliModelUEC.IsMouseMoveEvent) {
                    if (!this.m_gliModelUEC.currentValid()) {
                        this.m_lblStatus.setForeground(Color.RED);
                        this.m_lblStatus.setText(this.m_gliModelUEC.reasonNotValid());
                    } else {
                        this.m_lblStatus.setForeground(Color.BLUE);
                        String s = String.format("Current velocity = %d", (int)this.m_gliModelUEC.currentVelocity());
                        this.m_lblStatus.setText(s);
                    }
                    this.reloadModelPlot(true, false);
                }
                if (this.m_gliModelUEC.IsFinalClickEvent) {
                    this.m_debug = true;
                    if (pickCollection.current() != null) {
                        this.m_gliModelUEC.prepGliModel(pickCollection.current(), false);
                        this.m_gliModelUEC.handleImageJustPainted();
                        pickCollection.save();
                    }
                    this.reloadModelPlot(false, true);
                    this.reloadWiggle();
                }
            }
            if (sender == this.m_versionCombo) {
                return;
            }
            if (sender == this.m_lineUEC) {
                double angle = 180.0 * this.m_lineUEC.Azimuth / Math.PI;
                this.m_txtAngle.setText(Double.toString(angle));
                this.reload();
            }
            if (sender == this.m_axisLockerDepth) {
                this.m_modelWidget.mainWidget().transform().setAxisLockedY(this.m_axisLockerDepth.locked(), this.m_axisLockerDepth.min(), this.m_axisLockerDepth.max());
                this.m_modelWidget.mainWidget().mooz();
                return;
            }
            if (sender == this.m_axisLockerVelocity) {
                this.m_modelWidget.mainWidget().transform().setAxisLockedX(this.m_axisLockerVelocity.locked(), this.m_axisLockerVelocity.min(), this.m_axisLockerVelocity.max());
                this.m_modelWidget.mainWidget().mooz();
                return;
            }
            if (sender == this.m_axisLockerTime) {
                this.m_wiggleWidget.setAxisLocked_Time(this.m_axisLockerTime.locked(), this.m_axisLockerTime.min(), this.m_axisLockerTime.max());
                return;
            }
            if (sender == this.m_sequence) {
                if (this.m_sequence.MessageData.SequenceModified) {
                    this.processEnsemble(false);
                }
                return;
            }
            if (sender == this.m_mapKeyUEC && this.m_mapKeyUEC.KeyCode == 82) {
                this.reloadMapPlot();
                this.m_basemapWidget.mainWidget().repaint();
            }
            if (sender == this.m_leftClickUEC) {
                this.handleMapClick();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
    }

    @Override
    public void handleParameterWidgetChanged(Object sender) {
        try {
            if (sender == this.m_lmoSlider) {
                this.m_gliModelUEC.ApplyLMO = this.m_lmoSlider.isCheckSelected();
                this.m_gliModelUEC.VelocityLMO = this.m_lmoSlider.getDoubleValue();
                GliInteractiveModel_PickCollection pickCollection = RefractionStaticsProject.singleton().gliInteractiveModel_PickCollection();
                if (pickCollection.current() != null) {
                    pickCollection.current().ApplyLMO = this.m_lmoSlider.isCheckSelected();
                    pickCollection.current().VelocityLMO = this.m_lmoSlider.getDoubleValue();
                }
                this.processEnsemble(false);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_txtAngle) {
                this.reload();
                return;
            }
            if (e.getSource() == this.m_txtElevationSize) {
                this.reload();
                return;
            }
            if (e.getSource() == this.m_txtVelocitySize) {
                this.reload();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
            if (e.getSource() == this.m_btnCreateGli) {
                this.createNew();
                return;
            }
            if (e.getSource() == this.m_clearButton) {
                GliInteractiveModel_PickCollection pickCollection = RefractionStaticsProject.singleton().gliInteractiveModel_PickCollection();
                pickCollection.clear();
                this.m_inputEnsemble.clearTraces(true);
                this.processEnsemble(true);
                this.reloadMapPlot();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

