/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.DelayTime.UpholeCorrection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;

public class UpholeCorrectionDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected RefractionStaticsProject m_project;
    protected RadioPanel m_radioUphole;
    protected JButton m_btnOK = new JButton("Okay");
    protected JButton m_btnCancel = new JButton("Cancel");
    public boolean OK = false;

    public UpholeCorrectionDialog() {
        try {
            this.m_project = RefractionStaticsProject.singleton();
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            this.m_radioUphole = new RadioPanel(LinearLayoutWidget.Direction.Vertical, "Uphole correction method", UpholeCorrection.Method.values()[0].Description, UpholeCorrection.Method.values()[1].Description, UpholeCorrection.Method.values()[2].Description);
            main.addComponent(this.m_radioUphole, 0);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setTitle("Advanced delay time analysis options");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            this.OK = false;
            try {
                UpholeCorrection.Method method = this.m_project.getUpholeCorrectionMethod();
                int upholeIndex = UpholeCorrection.getIndexFromMethod(method);
                this.m_radioUphole.setSelectedIndex(upholeIndex);
            }
            catch (Exception method) {
                // empty catch block
            }
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                int index = this.m_radioUphole.getSelectedIndex();
                UpholeCorrection.Method method = UpholeCorrection.getMethodFromIndex(index);
                this.m_project.setUpholeCorrectionMethod(method);
                this.OK = true;
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

