/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Refraction.DelayTime.SolutionStacksWidget;

public class SolutionStacksWidget_DelayTime
extends SolutionStacksWidget
implements ISaveableFrame {
    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Refraction.DelayTime.SolutionStacksWidget_DelayTime";
    }

    @Override
    public String TAB_LABEL() {
        return "DT Shot/rec stacks";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "Delay time picker";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public SolutionStacksWidget_DelayTime() {
        super(1000);
    }

    @Override
    public void handleShotPicksModified() {
        try {
            if (this.m_groupEnsemble.traceCount() < 1) {
                return;
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String colNameDT = Pecos.getColNameDT(this.m_stackBranch);
            int indexID = this.m_groupEnsemble.dictionary().getEntryIndex("Shot", "ID");
            int indexPick = this.m_groupEnsemble.dictionary().getEntryIndex("Trace", "FBP_User");
            int indexDT = this.m_groupEnsemble.dictionary().getEntryIndex("Shot", "DelayTime");
            HashMap_Integer map = project.shotMap();
            Table_Abstract table = project.shotTable();
            double frac = 0.01 * Tools_Widget.extractDouble(this.m_textPercentMod, 50.0, 10.0, 100.0);
            int colDT = table.column_indexOfColumn(colNameDT);
            for (int n = 0; n < this.m_groupEnsemble.traceCount(); ++n) {
                EnsembleTrace trace = this.m_groupEnsemble.trace(n);
                int row = map.get(trace.StackTraceID);
                double shift = trace.header().getDouble(indexPick);
                double currentDT = trace.header().getDouble(indexDT);
                if (!(shift > -300.0) || !(shift < 300.0)) continue;
                double newDT = currentDT + frac * shift;
                newDT = Math.max(newDT, 0.0);
                table.putDouble(row, colDT, newDT);
                this.database().updateSingleRow_Double("Shot", colNameDT, trace.StackTraceID, newDT);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleReceiverPicksModified() {
        try {
            if (this.m_groupEnsemble.traceCount() < 1) {
                return;
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String colNameDT = Pecos.getColNameDT(this.m_stackBranch);
            int indexID = this.m_groupEnsemble.dictionary().getEntryIndex("Receiver", "ID");
            int indexPick = this.m_groupEnsemble.dictionary().getEntryIndex("Trace", "FBP_User");
            int indexDT = this.m_groupEnsemble.dictionary().getEntryIndex("Receiver", "DelayTime");
            double frac = 0.01 * Tools_Widget.extractDouble(this.m_textPercentMod, 50.0, 10.0, 100.0);
            HashMap_Integer map = project.receiverMap();
            Table_Abstract table = project.receiverTable();
            int colDT = table.column_indexOfColumn(colNameDT);
            for (int n = 0; n < this.m_groupEnsemble.traceCount(); ++n) {
                EnsembleTrace trace = this.m_groupEnsemble.trace(n);
                int row = map.get(trace.StackTraceID);
                double shift = trace.header().getDouble(indexPick);
                double currentDT = trace.header().getDouble(indexDT);
                if (!(shift > -300.0) || !(shift < 300.0)) continue;
                double newDT = currentDT + frac * shift;
                newDT = Math.max(newDT, 0.0);
                table.putDouble(row, colDT, newDT);
                this.database().updateSingleRow_Double("Receiver", colNameDT, trace.StackTraceID, newDT);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

