/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Data.History;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class RefractorVelocityAssignmentDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected JButton m_btnCancel = new JButton("Close");
    protected ArrayList<JButton> m_listButtons = new ArrayList();
    protected ArrayList<JTextField> m_listText = new ArrayList();

    public RefractorVelocityAssignmentDialog() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            int maxBranch = project.delayTimeData().branchAssignment().maxBranch();
            GridLayoutWidget grid = new GridLayoutWidget(3);
            int row = 0;
            for (int b = 1; b <= maxBranch; ++b) {
                String lbl = String.format("Refractor %d", b);
                JTextField txt = new JTextField("2000.00");
                JButton btn = new JButton("Apply");
                btn.addActionListener(this);
                this.m_listButtons.add(btn);
                this.m_listText.add(txt);
                grid.addComponent(new JLabel(lbl), row, 0, 1.0, 0.0);
                grid.addComponent(txt, row, 1, 1.0, 2.0);
                grid.addComponent(btn, row, 2, 1.0, 0.0);
                ++row;
            }
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addStretch(10);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)grid, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setSize(this.getSize().width + 100, this.getSize().height);
            this.setTitle("Refractor velocity assignment");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            for (int n = 0; n < this.m_listButtons.size(); ++n) {
                if (e.getSource() != this.m_listButtons.get(n)) continue;
                double vel = Tools_Widget.extractDouble(this.m_listText.get(n), 2000.0, 10.0, 50000.0);
                String colName = Pecos.getColNameVel(n + 1);
                String sql = String.format("UPDATE SHOT SET %s = %f", colName, vel);
                project.geometryDatabase().executeUpdateStatement(sql);
                sql = String.format("UPDATE RECEIVER SET %s = %f", colName, vel);
                project.geometryDatabase().executeUpdateStatement(sql);
                project.reloadAllData();
                History hist = project.getDelayTimeData().getHistory();
                hist.addWithTime("Refractor velocity set to constant");
                hist.add(colName + " = " + Double.toString(vel));
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

