/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MouseMove;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MultiLineSegments;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.InteractiveModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.LayerDataType;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelData;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayer;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelProfileLine;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ModelMapWidget
extends LinearLayoutWidget
implements ActionListener,
ItemListener,
KeyListener,
GenericObjectListener.Listener {
    protected MapMouseMode m_mouseMode = MapMouseMode.Polygon;
    public Java2D_SimpleComposite CompositeWidget;
    ArrayList<ModelData> _modelDataList = new ArrayList();
    public JComboBox<String> ComboAttribute = new JComboBox();
    JCheckBox m_cbPlotVelocityAtElevation = new JCheckBox("Velocity at Elevation");
    JLabel m_lblElevation = new JLabel("Elevation :");
    JTextField m_txtElevation = new JTextField("0");
    public JCheckBox m_chkShowShots = new JCheckBox("Show shots");
    public JCheckBox m_chkShowReceivers = new JCheckBox("Show receivers");
    public JButton m_btnReload;
    public boolean m_ignoreCombo = false;
    protected Java2D_UserEventConsumer_MouseMove m_mouseMoveUEC;
    protected Java2D_UserEventConsumer_MultiLineSegments m_polygonUEC;
    InteractiveModel _model;
    ArrayList<ModelProfileLine> _profiles;

    public ModelMapWidget(boolean tinyWidth, boolean bEnablePolygonDefinition) {
        super(LinearLayoutWidget.Direction.Vertical, 0, null);
        try {
            LinearLayoutWidget top = this.createHorizontal(0, null, 0);
            top.addComponent(this.ComboAttribute, 0);
            top.addComponent(this.m_cbPlotVelocityAtElevation, 0);
            top.addComponent(this.m_lblElevation, 0);
            top.addComponent(this.m_txtElevation, 10);
            this.ComboAttribute.addItemListener(this);
            this.m_cbPlotVelocityAtElevation.addItemListener(this);
            this.m_txtElevation.addActionListener(this);
            LinearLayoutWidget bottom = this.createHorizontal(0, null, 0);
            bottom.addComponent(this.m_chkShowReceivers, 0);
            this.m_chkShowReceivers.setSelected(true);
            this.m_chkShowReceivers.addActionListener(this);
            bottom.addComponent(this.m_chkShowShots, 0);
            this.m_chkShowShots.setSelected(true);
            this.m_chkShowShots.addActionListener(this);
            this.m_btnReload = bottom.createButton("Reload plot", this, 0);
            bottom.addStretch(10);
            Tools_FontChanger.changeSizeOfFont(top, -2, null, true);
            Tools_FontChanger.changeSizeOfFont(bottom, -2, null, true);
            this.CompositeWidget = new Java2D_SimpleComposite(true);
            this.CompositeWidget.setAxesVisible(true, true);
            this.CompositeWidget.setScrollVisible(true, true);
            this.addComponent(this.CompositeWidget, 10);
            if (bEnablePolygonDefinition) {
                this.m_polygonUEC = new Java2D_UserEventConsumer_MultiLineSegments();
                this.m_polygonUEC.addListener(this);
                this.m_polygonUEC.DefiningPolygon = true;
                this.CompositeWidget.mainWidget().addEventConsumer(this.m_polygonUEC);
            }
            this.m_mouseMoveUEC = new Java2D_UserEventConsumer_MouseMove();
            this.m_mouseMoveUEC.addListener(this);
            this.CompositeWidget.mainWidget().addEventConsumer(this.m_mouseMoveUEC);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setProfileLines(ArrayList<ModelProfileLine> profiles) {
        try {
            this._profiles = profiles;
            this.reloadPlot();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setModel(InteractiveModel model) {
        try {
            this.m_ignoreCombo = true;
            this._model = model;
            this._profiles = null;
            this._modelDataList.clear();
            this.ComboAttribute.removeAllItems();
            this.ComboAttribute.addItem("Surface Elevation");
            int nLayers = this._model.getLayerCount();
            for (int iLayer = 0; iLayer < nLayers; ++iLayer) {
                ModelLayer layer = this._model.getLayer(iLayer);
                for (LayerDataType dt : layer.getValidLayerDataTypes()) {
                    ModelData md = layer.getModelData(dt);
                    String sDescription = layer.getLayerName() + " : " + dt.toString();
                    this.ComboAttribute.addItem(sDescription);
                    this._modelDataList.add(md);
                }
            }
            ArrayList<String> staticsVersions = this._model.getStaticsVersions();
            for (int iVersion = 0; iVersion < staticsVersions.size(); ++iVersion) {
                String sVersion = staticsVersions.get(iVersion);
                this.ComboAttribute.addItem(sVersion);
            }
            this.m_ignoreCombo = false;
            this.ComboAttribute.setSelectedIndex(0);
            this.reloadPlot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadPlot() {
        try {
            Java2D_Widget w = this.CompositeWidget.mainWidget();
            w.clearPaintableList();
            if (this._model == null) {
                w.mooz();
                return;
            }
            Boolean bIsStaticsValue = false;
            Boolean bIsSurfaceElevation = false;
            int iSelected = this.ComboAttribute.getSelectedIndex();
            if (iSelected < 0) {
                return;
            }
            String sColumnName = "";
            if (this.ComboAttribute.getItemAt(iSelected).toString().equals("Surface Elevation")) {
                bIsSurfaceElevation = true;
                sColumnName = "Elevation";
            }
            if (iSelected >= this._modelDataList.size() + 1) {
                bIsStaticsValue = true;
            }
            if (bIsStaticsValue.booleanValue()) {
                sColumnName = this.ComboAttribute.getItemAt(iSelected).toString();
            } else if (!bIsSurfaceElevation.booleanValue()) {
                ModelData data = this._modelDataList.get(iSelected - 1);
                ModelLayer layer = data.getLayer();
                sColumnName = this._model.getColumnName(layer.getLayerIndex(), data.getLayerDataType());
            }
            boolean bUseElevation = this.m_cbPlotVelocityAtElevation.isSelected();
            double dElevation = Double.parseDouble(this.m_txtElevation.getText());
            if (this.m_chkShowShots.isSelected()) {
                try {
                    w.addPaintable(this._model.loadGeomPO("Shot", sColumnName, dElevation, bUseElevation), 0);
                }
                catch (Exception error) {
                    error.printStackTrace();
                }
            }
            if (this.m_chkShowReceivers.isSelected()) {
                try {
                    w.addPaintable(this._model.loadGeomPO("Receiver", sColumnName, dElevation, bUseElevation), 0);
                }
                catch (Exception error) {
                    error.printStackTrace();
                }
            }
            if (this._profiles != null) {
                for (int i = 0; i < this._profiles.size(); ++i) {
                    ModelProfileLine profile = this._profiles.get(i);
                    w.addPaintable(profile, ModelProfileLine.PlotLine);
                }
            }
            Java2D_Polygon p = RefractionStaticsProject.singleton().polygon();
            w.addPaintable(p, -9999);
            w.transform().setTechnique(Java2D_Transform.Technique.Basemap);
            w.mooz();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (this.m_ignoreCombo) {
                return;
            }
            if (e.getSource() == this.ComboAttribute) {
                this.reloadPlot();
            }
            if (e.getSource() == this.m_cbPlotVelocityAtElevation) {
                this.ComboAttribute.setEnabled(!this.m_cbPlotVelocityAtElevation.isSelected());
                this.reloadPlot();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.reloadPlot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    void handleMouseMoveUEC() {
        try {
            double dist;
            double y;
            double dy;
            double dx;
            double x;
            int i;
            double mouseX = this.m_mouseMoveUEC.WorldX;
            double mouseY = this.m_mouseMoveUEC.WorldY;
            double dMinDistance = Double.MAX_VALUE;
            Table_Abstract shotTable = this._model.getSourceTable();
            Table_Abstract recTable = this._model.getReceiverTable();
            int nShots = shotTable.row_count();
            int nRecs = recTable.row_count();
            Boolean bShotIsClosest = true;
            int iClosestIndex = -1;
            int iX = shotTable.column_indexOfColumn("Easting");
            int iY = shotTable.column_indexOfColumn("Northing");
            if (this.m_chkShowShots.isSelected()) {
                for (i = 0; i < nShots; ++i) {
                    x = shotTable.getDouble(i, iX);
                    dx = x - mouseX;
                    dist = dx * dx + (dy = (y = shotTable.getDouble(i, iY)) - mouseY) * dy;
                    if (!(dist < dMinDistance)) continue;
                    dMinDistance = dist;
                    bShotIsClosest = true;
                    iClosestIndex = i;
                }
            }
            iX = recTable.column_indexOfColumn("Easting");
            iY = recTable.column_indexOfColumn("Northing");
            if (this.m_chkShowReceivers.isSelected()) {
                for (i = 0; i < nRecs; ++i) {
                    x = recTable.getDouble(i, iX);
                    dx = x - mouseX;
                    dist = dx * dx + (dy = (y = recTable.getDouble(i, iY)) - mouseY) * dy;
                    if (!(dist < dMinDistance)) continue;
                    dMinDistance = dist;
                    bShotIsClosest = false;
                    iClosestIndex = i;
                }
            }
            if (iClosestIndex >= 0) {
                this._model.setSelectedItem(iClosestIndex, bShotIsClosest);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_polygonUEC) {
                if (this.m_polygonUEC.Dragging) {
                    return;
                }
                if (!this.m_polygonUEC.Finished) {
                    return;
                }
                int num = this.m_polygonUEC.numPoints();
                if (this.m_polygonUEC.numPoints() < 3) {
                    return;
                }
                Java2D_Polygon p = RefractionStaticsProject.singleton().polygon();
                p.X = new double[num];
                p.Y = new double[num];
                for (int n = 0; n < num; ++n) {
                    p.X[n] = this.m_polygonUEC.getX(n);
                    p.Y[n] = this.m_polygonUEC.getY(n);
                }
                RefractionStaticsProject.singleton().savePolygon();
                Messenger.broadcast(Messenger.Message.ProjectPolygonModified, sender, null);
            }
            if (sender == this.m_mouseMoveUEC) {
                this.handleMouseMoveUEC();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    protected static enum MapMouseMode {
        Polygon("Define project polygon"),
        Shot("Select shot "),
        Receiver("Select receiver"),
        Midpoint("Select midpoint");

        public final String Description;

        private MapMouseMode(String desc) {
            this.Description = desc;
        }
    }
}

