/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.LayerDataSource;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.LayerDataType;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelData;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelDataSource;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImportedAsciiDataSourcePanel
extends JPanel
implements ItemListener,
ActionListener {
    ArrayList<String> _tableNames;
    LinearLayoutWidget _topWidget;
    JComboBox _cmbTable;
    JComboBox _cmbX;
    JComboBox _cmbY;
    JComboBox _cmbValue;
    JButton _btnImport;
    ModelLayer _layer;
    LayerDataType _layerDataType;
    JLabel _lblIsValid;
    Boolean _bIsValid = false;

    public ImportedAsciiDataSourcePanel(ModelLayer layer, LayerDataType layerDataType) {
        try {
            this.setLayout(new BorderLayout());
            this._layer = layer;
            this._layerDataType = layerDataType;
            Dimension d = new Dimension(20, 80);
            IDatabaseConnection database = RefractionStaticsProject.singleton().importDatabase();
            this._tableNames = database.getTableNames();
            this._topWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null);
            this._cmbTable = this._topWidget.createSubComboBox("Table", this);
            this._cmbX = this._topWidget.createSubComboBox("X", this);
            this._cmbY = this._topWidget.createSubComboBox("Y", this);
            this._cmbValue = this._topWidget.createSubComboBox(this._layerDataType.toString(), this);
            this._lblIsValid = this._topWidget.createLabel("Empty", 0, 1);
            Font font = new Font("Courier", 1, 14);
            this._lblIsValid.setFont(font);
            this.setDataValid(false);
            this._btnImport = this._topWidget.createButton("Import", this, 2);
            for (int i = 0; i < this._tableNames.size(); ++i) {
                String sTable = this._tableNames.get(i);
                this._cmbTable.addItem(sTable);
            }
            if (this._cmbTable.getItemCount() > 0) {
                this._cmbTable.setSelectedIndex(0);
            }
            this.add((Component)this._topWidget, "North");
            ModelData md = this._layer.getModelData(this._layerDataType);
            ModelDataSource mds = md.getModelDataSource();
            String sLastX = this._layer.getModel().getLastAsciiImportXColumn();
            String sLastY = this._layer.getModel().getLastAsciiImportYColumn();
            String sLastTable = this._layer.getModel().getLastAsciiImportTable();
            this.setComboBoxValue(this._cmbTable, sLastTable);
            this.setComboBoxValue(this._cmbX, sLastX);
            this.setComboBoxValue(this._cmbY, sLastY);
            this.setModelDataSource(mds);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void setDataValid(Boolean bValid) {
        try {
            this._bIsValid = bValid;
            if (bValid.booleanValue()) {
                this._lblIsValid.setText("Filled");
                this._lblIsValid.setForeground(Color.BLUE);
            } else {
                this._lblIsValid.setText("Empty");
                this._lblIsValid.setForeground(Color.RED);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void setComboBoxValue(JComboBox cb, String sValue) {
        try {
            int iSelectedIndex = -1;
            for (int i = 0; i < cb.getItemCount(); ++i) {
                String sItem = cb.getItemAt(i).toString();
                if (!sItem.equals(sValue)) continue;
                iSelectedIndex = i;
            }
            if (iSelectedIndex >= 0) {
                cb.setSelectedIndex(iSelectedIndex);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public ModelDataSource getModelDatasource() {
        ModelDataSource mds = null;
        try {
            mds = new ModelDataSource();
            mds.IsValid = this._bIsValid;
            mds.DataSourceType = LayerDataSource.AsciiTable;
            if (this._cmbTable.getSelectedItem() != null) {
                mds.Table = this._cmbTable.getSelectedItem().toString();
            }
            if (this._cmbX.getSelectedItem() != null) {
                mds.ColumnX = this._cmbX.getSelectedItem().toString();
            }
            if (this._cmbY.getSelectedItem() != null) {
                mds.ColumnY = this._cmbY.getSelectedItem().toString();
            }
            if (this._cmbValue.getSelectedItem() != null) {
                mds.ColumnValue = this._cmbValue.getSelectedItem().toString();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return mds;
    }

    public void setModelDataSource(ModelDataSource md) {
        try {
            IDatabaseConnection database = RefractionStaticsProject.singleton().importDatabase();
            if (md.Table.length() > 0 && database.tableExists(md.Table)) {
                this.setTable(md.Table);
                this.setComboBoxValue(this._cmbX, md.ColumnX);
                this.setComboBoxValue(this._cmbY, md.ColumnY);
                this.setComboBoxValue(this._cmbValue, md.ColumnValue);
            }
            ModelData data = this._layer.getModelData(this._layerDataType);
            this.setDataValid(data.getIsDataLoadDataValid());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void setTable(String sName) {
        try {
            this._cmbX.removeAllItems();
            this._cmbY.removeAllItems();
            this._cmbValue.removeAllItems();
            IDatabaseConnection database = RefractionStaticsProject.singleton().importDatabase();
            if (database.tableExists(sName)) {
                ArrayList<String> columns = database.listOfColumnNames(sName);
                for (int i = 0; i < columns.size(); ++i) {
                    String sColumnName = columns.get(i);
                    this._cmbX.addItem(sColumnName);
                    this._cmbY.addItem(sColumnName);
                    this._cmbValue.addItem(sColumnName);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this._cmbTable) {
                String sTable = this._cmbTable.getSelectedItem().toString();
                this.setTable(sTable);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    Boolean importData(Boolean bSrc, ModelData data) {
        try {
            int nGeometryRows;
            Table_Abstract geometryTable;
            int iRow;
            int nMaxImportRows = 50000000;
            String sXColumn = this._cmbX.getSelectedItem().toString();
            String sYColumn = this._cmbY.getSelectedItem().toString();
            String sValueColumn = this._cmbValue.getSelectedItem().toString();
            String sImportTableName = this._cmbTable.getSelectedItem().toString();
            IDatabaseConnection database = RefractionStaticsProject.singleton().importDatabase();
            String sql = "select * from " + sImportTableName;
            Table_Abstract importTable = database.extractTableDataUsingQuery(sImportTableName, sql, nMaxImportRows);
            int nImportRows = importTable.row_count();
            int iImportColumnX = importTable.column_indexOfColumn(sXColumn);
            int iImportColumnY = importTable.column_indexOfColumn(sYColumn);
            int iImportColumnZ = importTable.column_indexOfColumn(sValueColumn);
            Grid3D smoothGrid = RefractionStaticsProject.singleton().units_feet() ? RefractionStaticsProject.singleton().getEmptyGrid3D(300.0, 600.0, 600.0) : RefractionStaticsProject.singleton().getEmptyGrid3D(100.0, 200.0, 600.0);
            smoothGrid.interp_Prep();
            smoothGrid.interp_ZeroArrays();
            for (iRow = 0; iRow < nImportRows; ++iRow) {
                double x = importTable.getDouble(iRow, iImportColumnX);
                double y = importTable.getDouble(iRow, iImportColumnY);
                double z = importTable.getDouble(iRow, iImportColumnZ);
                smoothGrid.interp_Add(x, y, (float)z, 1.0f);
            }
            smoothGrid.interp_Finish(3);
            if (bSrc.booleanValue()) {
                geometryTable = RefractionStaticsProject.singleton().shotTable();
                values = data.getDataLoadSourceValues();
                nGeometryRows = geometryTable.row_count();
            } else {
                geometryTable = RefractionStaticsProject.singleton().receiverTable();
                values = data.getDataLoadReceiverValues();
                nGeometryRows = geometryTable.row_count();
            }
            int iGeometryColumnX = geometryTable.column_indexOfColumn("Easting");
            int iGeometryColumnY = geometryTable.column_indexOfColumn("Northing");
            for (iRow = 0; iRow < nGeometryRows; ++iRow) {
                double dValue;
                double dGeometryX = geometryTable.getDouble(iRow, iGeometryColumnX);
                double dGeometryY = geometryTable.getDouble(iRow, iGeometryColumnY);
                values[iRow] = dValue = (double)smoothGrid.getNearestValue(dGeometryX, dGeometryY);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    void importData() {
        try {
            String sXColumn = this._cmbX.getSelectedItem().toString();
            String sYColumn = this._cmbY.getSelectedItem().toString();
            String sValueColumn = this._cmbValue.getSelectedItem().toString();
            String sImportTableName = this._cmbTable.getSelectedItem().toString();
            this._layer.getModel().setLastAsciiImportXColumn(sXColumn);
            this._layer.getModel().setLastAsciiImportYColumn(sYColumn);
            this._layer.getModel().setLastAsciiImportTable(sImportTableName);
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            IDatabaseConnection db = project.geometryDatabase();
            ModelData data = this._layer.getModelData(this._layerDataType);
            Boolean bSrcOk = this.importData(true, data);
            Boolean bRecOk = this.importData(false, data);
            if (bSrcOk.booleanValue() && bRecOk.booleanValue()) {
                data.setIsDataLoadDataValid(true);
            } else {
                data.setIsDataLoadDataValid(false);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this._btnImport) {
                this.importData();
                ModelData data = this._layer.getModelData(this._layerDataType);
                Boolean bIsValid = data.getIsDataLoadDataValid();
                this.setDataValid(bIsValid);
                ModelDataSource mds = this.getModelDatasource();
                this._layer.getModelData(this._layerDataType).setModelDataSource(mds);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

