/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.InteractiveModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.LayerDataType;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelData;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelDataSource;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ImportFromEquationSourcePanel
extends JPanel
implements ItemListener,
ActionListener {
    ModelLayer _layer;
    LayerDataType _layerDataType;
    LinearLayoutWidget _topWidget;
    Boolean _bIsValid = false;
    JButton _btnImport;
    JLabel _lblIsValid;
    JLabel _lblValue;
    JTextField _txtValue;
    JCheckBox _cbAddUpperLayerValue;

    public ImportFromEquationSourcePanel(ModelLayer layer, LayerDataType layerDataType, Boolean bShowAllColumns) {
        try {
            Dimension d = new Dimension(20, 60);
            this._layer = layer;
            this._layerDataType = layerDataType;
            this.setLayout(new BorderLayout());
            this._topWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 4, null);
            this._lblValue = this._topWidget.createLabel("Value : ", 0, 0);
            this._lblValue.setMinimumSize(d);
            this._lblValue.setMaximumSize(d);
            this._txtValue = this._topWidget.createTextField("0", this, 1);
            this._txtValue.setText("0");
            this._txtValue.setMinimumSize(d);
            this._txtValue.setMaximumSize(d);
            this._cbAddUpperLayerValue = this._topWidget.createCheckBox("Add Upper Layer Value", 0, this);
            this._cbAddUpperLayerValue.setMinimumSize(d);
            this._cbAddUpperLayerValue.setMaximumSize(d);
            this._lblIsValid = this._topWidget.createLabel("Empty", 0, 1);
            this._lblIsValid.setMinimumSize(d);
            this._lblIsValid.setMaximumSize(d);
            Font font = new Font("Courier", 1, 14);
            this._lblIsValid.setFont(font);
            this.setDataValid(false);
            this._btnImport = this._topWidget.createButton("Import", this, 0);
            this._btnImport.setMinimumSize(d);
            this._btnImport.setMaximumSize(d);
            this.add((Component)this._topWidget, "North");
            ModelData md = this._layer.getModelData(this._layerDataType);
            ModelDataSource mds = md.getModelDataSource();
            this.setModelDataSource(mds);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    Boolean containsString(ArrayList<String> list, String sValue) {
        int nValues = list.size();
        for (int i = 0; i < nValues; ++i) {
            String s = list.get(i);
            if (!s.equals(sValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    void setDataValid(Boolean bValid) {
        try {
            this._bIsValid = bValid;
            if (bValid.booleanValue()) {
                this._lblIsValid.setText("Filled");
                this._lblIsValid.setForeground(Color.BLUE);
            } else {
                this._lblIsValid.setText("Empty");
                this._lblIsValid.setForeground(Color.RED);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public ModelDataSource getModelDatasource() {
        ModelDataSource mds = null;
        try {
            mds = new ModelDataSource();
            mds.IsValid = this._bIsValid;
            mds.ConstantValue = this._txtValue.getText();
            mds.AddUpperLayerValue = this._cbAddUpperLayerValue.isSelected();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return mds;
    }

    public void setModelDataSource(ModelDataSource mds) {
        try {
            ModelData data = this._layer.getModelData(this._layerDataType);
            this._txtValue.setText(mds.ConstantValue);
            this.setDataValid(data.getIsDataLoadDataValid());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    Boolean importData(Boolean bSrc, ModelData data) {
        try {
            Table_Abstract table;
            double dConstantValue = Double.parseDouble(this._txtValue.getText());
            if (bSrc.booleanValue()) {
                table = RefractionStaticsProject.singleton().shotTable();
                dataArray = data.getDataLoadSourceValues();
            } else {
                table = RefractionStaticsProject.singleton().receiverTable();
                dataArray = data.getDataLoadReceiverValues();
            }
            boolean bAddUpperLayerValue = this._cbAddUpperLayerValue.isSelected();
            int nRows = table.row_count();
            if (bAddUpperLayerValue) {
                ModelLayer layer = data.getLayer();
                int iLayerIndex = layer.getLayerIndex();
                InteractiveModel model = layer.getModel();
                int iUpperLayer = iLayerIndex - 1;
                if (iUpperLayer < 0) {
                    return false;
                }
                ModelLayer upperLayer = model.getLayer(iUpperLayer);
                if (!upperLayer.getIsFilled().booleanValue()) {
                    return false;
                }
                ModelData upperLayerModelData = upperLayer.getModelData(this._layerDataType);
                double[] upperLayerValues = null;
                upperLayerValues = bSrc != false ? upperLayerModelData.getDataLoadSourceValues() : upperLayerModelData.getDataLoadReceiverValues();
                if (upperLayerValues == null) {
                    return false;
                }
                for (int iRow = 0; iRow < nRows; ++iRow) {
                    double dUpperValue = upperLayerValues[iRow];
                    dataArray[iRow] = dConstantValue + dUpperValue;
                }
            } else {
                for (int iRow = 0; iRow < nRows; ++iRow) {
                    dataArray[iRow] = dConstantValue;
                }
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    void importData() {
        try {
            ModelData data = this._layer.getModelData(this._layerDataType);
            Boolean bSrcOk = this.importData(true, data);
            Boolean bRecOk = this.importData(false, data);
            if (bSrcOk.booleanValue() && bRecOk.booleanValue()) {
                data.setIsDataLoadDataValid(true);
            } else {
                data.setIsDataLoadDataValid(false);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this._btnImport) {
                this.importData();
                ModelData data = this._layer.getModelData(this._layerDataType);
                this.setDataValid(data.getIsDataLoadDataValid());
                ModelDataSource mds = this.getModelDatasource();
                this._layer.getModelData(this._layerDataType).setModelDataSource(mds);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

