/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.LayerDataSource;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.LayerDataType;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelData;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelDataSource;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImportFromDelayTimeModelDataSourcePanel
extends JPanel
implements ItemListener,
ActionListener {
    ModelLayer _layer;
    LayerDataType _layerDataType;
    LinearLayoutWidget _topWidget;
    JComboBox _cmbColumn;
    JCheckBox _cbAllColumns;
    Boolean _bIsValid = false;
    JButton _btnImport;
    JLabel _lblIsValid;

    public ImportFromDelayTimeModelDataSourcePanel(ModelLayer layer, LayerDataType layerDataType, Boolean bShowAllColumns) {
        try {
            this._layer = layer;
            this._layerDataType = layerDataType;
            this.setLayout(new BorderLayout());
            this._topWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null);
            this._cmbColumn = this._topWidget.createSubComboBox("Column", this);
            this._cbAllColumns = this._topWidget.createCheckBox("Show All Columns", 0, this);
            this._lblIsValid = this._topWidget.createLabel("Empty", 0, 1);
            Font font = new Font("Courier", 1, 14);
            this._lblIsValid.setFont(font);
            this.setDataValid(false);
            this._btnImport = this._topWidget.createButton("Import", this, 2);
            this._cbAllColumns.setSelected(bShowAllColumns);
            Dimension minSize = new Dimension(300, 30);
            this._cmbColumn.setMinimumSize(minSize);
            this._cmbColumn.setMaximumSize(minSize);
            this.add((Component)this._topWidget, "North");
            this.fillColumns();
            ModelData md = this._layer.getModelData(this._layerDataType);
            ModelDataSource mds = md.getModelDataSource();
            this.setModelDataSource(mds);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    Boolean containsString(ArrayList<String> list, String sValue) {
        int nValues = list.size();
        for (int i = 0; i < nValues; ++i) {
            String s = list.get(i);
            if (!s.equals(sValue)) continue;
            return true;
        }
        return false;
    }

    ArrayList<String> getCommonList(ArrayList<String> list1, ArrayList<String> list2) {
        ArrayList<String> list = new ArrayList<String>();
        int nValues = list1.size();
        for (int i = 0; i < nValues; ++i) {
            String s = list1.get(i);
            if (!this.containsString(list2, s).booleanValue()) continue;
            list.add(s);
        }
        return list;
    }

    void setComboBoxValue(JComboBox cb, String sValue) {
        try {
            int iSelectedIndex = -1;
            for (int i = 0; i < cb.getItemCount(); ++i) {
                String sItem = cb.getItemAt(i).toString();
                if (!sItem.equals(sValue)) continue;
                iSelectedIndex = i;
            }
            if (iSelectedIndex >= 0) {
                cb.setSelectedIndex(iSelectedIndex);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void fillColumns() {
        try {
            Object objOld = this._cmbColumn.getSelectedItem();
            Table_Abstract recTable = RefractionStaticsProject.singleton().receiverTable();
            Table_Abstract srcTable = RefractionStaticsProject.singleton().shotTable();
            ArrayList<String> srcColumns = srcTable.column_listOfNames();
            ArrayList<String> recColumns = recTable.column_listOfNames();
            ArrayList<String> commonColumns = this.getCommonList(srcColumns, recColumns);
            this._cmbColumn.removeAllItems();
            if (this._cbAllColumns.isSelected()) {
                int nColumns = commonColumns.size();
                for (int i = 0; i < nColumns; ++i) {
                    String s = commonColumns.get(i);
                    this._cmbColumn.addItem(s);
                }
            } else {
                int maxBranch = RefractionStaticsProject.delayTimeData().branchAssignment().maxBranch();
                if (this._layerDataType == LayerDataType.Elevation) {
                    for (int b = 1; b <= maxBranch; ++b) {
                        String sVal = "DTA_ELEVATION_" + Integer.toString(b);
                        if (!this.containsString(commonColumns, sVal).booleanValue()) continue;
                        this._cmbColumn.addItem(sVal);
                    }
                } else if (this._layerDataType == LayerDataType.Velocity) {
                    for (int b = 0; b <= maxBranch; ++b) {
                        String sVal = "DTA_VELOCITY_" + Integer.toString(b);
                        if (!this.containsString(commonColumns, sVal).booleanValue()) continue;
                        this._cmbColumn.addItem(sVal);
                    }
                } else if (this._layerDataType == LayerDataType.DelayTime) {
                    for (int b = 1; b <= maxBranch; ++b) {
                        String sVal = "DTA_DELAYTIME_" + Integer.toString(b);
                        if (!this.containsString(commonColumns, sVal).booleanValue()) continue;
                        this._cmbColumn.addItem(sVal);
                    }
                }
            }
            if (objOld != null) {
                this.setComboBoxValue(this._cmbColumn, objOld.toString());
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this._cbAllColumns) {
                this.fillColumns();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    Boolean importData(Boolean bSrc, ModelData data, String sSelectedColumn) {
        try {
            Table_Abstract table;
            if (bSrc.booleanValue()) {
                table = RefractionStaticsProject.singleton().shotTable();
                dataArray = data.getDataLoadSourceValues();
            } else {
                table = RefractionStaticsProject.singleton().receiverTable();
                dataArray = data.getDataLoadReceiverValues();
            }
            int nRows = table.row_count();
            int iColumn = table.column_indexOfColumn(sSelectedColumn);
            for (int iRow = 0; iRow < nRows; ++iRow) {
                double dValue;
                dataArray[iRow] = dValue = table.getDouble(iRow, iColumn);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    void importData(ModelLayer layer, LayerDataType dt, String sColumn) {
        try {
            ModelData data = layer.getModelData(dt);
            Boolean bSrcOk = this.importData(true, data, sColumn);
            Boolean bRecOk = this.importData(false, data, sColumn);
            if (bSrcOk.booleanValue() && bRecOk.booleanValue()) {
                data.setIsDataLoadDataValid(true);
            } else {
                data.setIsDataLoadDataValid(false);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void setDataValid(Boolean bValid) {
        try {
            this._bIsValid = bValid;
            if (bValid.booleanValue()) {
                this._lblIsValid.setText("Filled");
                this._lblIsValid.setForeground(Color.BLUE);
            } else {
                this._lblIsValid.setText("Empty");
                this._lblIsValid.setForeground(Color.RED);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setModelDataSource(ModelDataSource mds) {
        try {
            ModelData data = this._layer.getModelData(this._layerDataType);
            this.setDataValid(data.getIsDataLoadDataValid());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public ModelDataSource getModelDatasource() {
        ModelDataSource mds = null;
        try {
            mds = new ModelDataSource();
            mds.IsValid = this._bIsValid;
            mds.DataSourceType = this._cbAllColumns.isSelected() ? LayerDataSource.Database : LayerDataSource.DelayTimeModel;
            String sSelectedColumn = "";
            if (this._cmbColumn.getSelectedItem() != null) {
                sSelectedColumn = this._cmbColumn.getSelectedItem().toString();
            }
            mds.ColumnValue = sSelectedColumn;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return mds;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this._btnImport) {
                if (this._cmbColumn.getSelectedItem() == null) {
                    return;
                }
                String sSelectedColumn = this._cmbColumn.getSelectedItem().toString();
                this.importData(this._layer, this._layerDataType, sSelectedColumn);
                ModelData data = this._layer.getModelData(this._layerDataType);
                this.setDataValid(data.getIsDataLoadDataValid());
                ModelDataSource mds = this.getModelDatasource();
                this._layer.getModelData(this._layerDataType).setModelDataSource(mds);
                if (this._layerDataType == LayerDataType.DelayTime) {
                    int nLayers = this._layer.getModel().getLayerCount();
                    int iLayerIndex = this._layer.getLayerIndex();
                    Table_Abstract recTable = RefractionStaticsProject.singleton().receiverTable();
                    Table_Abstract srcTable = RefractionStaticsProject.singleton().shotTable();
                    ArrayList<String> srcColumns = srcTable.column_listOfNames();
                    ArrayList<String> recColumns = recTable.column_listOfNames();
                    String sRefractorVelocityColumn = sSelectedColumn.replace("DTA_DELAYTIME_", "DTA_VELOCITY_");
                    if (this.containsString(srcColumns, sRefractorVelocityColumn).booleanValue() && this.containsString(recColumns, sRefractorVelocityColumn).booleanValue()) {
                        ModelLayer lowerLayer = this._layer.getModel().getLayer(iLayerIndex + 1);
                        this.importData(lowerLayer, LayerDataType.Velocity, sRefractorVelocityColumn);
                        ModelDataSource mdsVel = new ModelDataSource();
                        mdsVel.ColumnValue = sRefractorVelocityColumn;
                        mdsVel.IsValid = true;
                        mdsVel.DataSourceType = LayerDataSource.DelayTimeModel;
                        lowerLayer.getModelData(LayerDataType.Velocity).setModelDataSource(mds);
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

