/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.InteractiveModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.LayerDataType;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelData;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ExportModelDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener,
ItemListener {
    InteractiveModel _model;
    LinearLayoutWidget _bottomWidget;
    LinearLayoutWidget _topWidget;
    JLabel _labelExport;
    public JComboBox<String> ComboAttribute = new JComboBox();
    JLabel _lblOutputColumnName;
    JTextField _txtOutputColumn;
    JButton _btnOk;
    JButton _btnCancel;
    boolean _bDialogResult = false;
    boolean m_ignoreCombo = false;
    ArrayList<ModelData> _modelDataList = new ArrayList();

    public ExportModelDialog(InteractiveModel model) {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.setSize(800, 600);
            this.setLocationRelativeTo(null);
            this.setTitle("Export to Main database");
            this._topWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null);
            this._labelExport = this._topWidget.createLabel("Export : ", 0, 0);
            this._topWidget.addComponent(this.ComboAttribute, 0);
            this.ComboAttribute.addItemListener(this);
            this._lblOutputColumnName = this._topWidget.createLabel("Output Column : ", 0, 0);
            this._txtOutputColumn = this._topWidget.createTextField("", this, 2);
            this._bottomWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null);
            this._btnOk = this._bottomWidget.createButton("Ok", this, 3);
            this._btnCancel = this._bottomWidget.createButton("Cancel", this, 3);
            this.getContentPane().add((Component)this._bottomWidget, "South");
            this.getContentPane().add((Component)this._topWidget, "North");
            this.setInteractiveModel(model);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public String getExportColumnName() {
        return this._txtOutputColumn.getText();
    }

    public void setInteractiveModel(InteractiveModel model) {
        try {
            this.m_ignoreCombo = true;
            this._model = model;
            this._modelDataList.clear();
            this.ComboAttribute.removeAllItems();
            int nLayers = this._model.getLayerCount();
            for (int iLayer = 0; iLayer < nLayers; ++iLayer) {
                ModelLayer layer = this._model.getLayer(iLayer);
                for (LayerDataType dt : layer.getValidLayerDataTypes()) {
                    ModelData md = layer.getModelData(dt);
                    String sDescription = layer.getLayerName() + " : " + dt.toString();
                    this.ComboAttribute.addItem(sDescription);
                    this._modelDataList.add(md);
                }
            }
            ArrayList<String> staticsVersions = this._model.getStaticsVersions();
            for (int iVersion = 0; iVersion < staticsVersions.size(); ++iVersion) {
                String sVersion = staticsVersions.get(iVersion);
                this.ComboAttribute.addItem(sVersion);
            }
            this.m_ignoreCombo = false;
            this.ComboAttribute.setSelectedIndex(1);
            this.ComboAttribute.setSelectedIndex(0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void showDialog() {
        try {
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Boolean getDialogResult() {
        return this._bDialogResult;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this._btnOk) {
                this._bDialogResult = true;
                this.dispose();
            }
            if (e.getSource() == this._btnCancel) {
                this._bDialogResult = false;
                this.dispose();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public String getModelColumnName() {
        try {
            if (this._model == null) {
                return "";
            }
            Boolean bIsStaticsValue = false;
            Boolean bIsSurfaceElevation = false;
            int iSelected = this.ComboAttribute.getSelectedIndex();
            if (iSelected < 0) {
                return "";
            }
            String sColumnName = "";
            if (iSelected >= this._modelDataList.size()) {
                bIsStaticsValue = true;
            }
            if (bIsStaticsValue.booleanValue()) {
                sColumnName = this.ComboAttribute.getItemAt(iSelected).toString();
            } else if (!bIsSurfaceElevation.booleanValue()) {
                ModelData data = this._modelDataList.get(iSelected);
                ModelLayer layer = data.getLayer();
                sColumnName = this._model.getColumnName(layer.getLayerIndex(), data.getLayerDataType());
            }
            return sColumnName;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return "";
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.ComboAttribute) {
                if (this.m_ignoreCombo) {
                    return;
                }
                String sColumn = this.getModelColumnName();
                this._txtOutputColumn.setText(sColumn);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

