/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard;

import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.DeleteModelLayer;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.InteractiveModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.LoadDataDialog;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class ButtonEditor
extends DefaultCellEditor {
    protected JButton button = new JButton();
    private String label;
    private boolean isPushed;
    private Object _cellObject;

    public ButtonEditor(JCheckBox checkBox) {
        super(checkBox);
        this.button.setOpaque(true);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonEditor.this.fireEditingStopped();
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (isSelected) {
            this.button.setForeground(table.getSelectionForeground());
            this.button.setBackground(table.getSelectionBackground());
        } else {
            this.button.setForeground(table.getForeground());
            this.button.setBackground(table.getBackground());
        }
        this.label = value == null ? "" : value.toString();
        this.button.setText(this.label);
        this.isPushed = true;
        this._cellObject = value;
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.isPushed) {
            if (this._cellObject instanceof ModelLayer) {
                ModelLayer layer = (ModelLayer)this._cellObject;
                LoadDataDialog dlg = new LoadDataDialog(layer);
                dlg.showDialog();
                layer.sendPropertyChangedEvent("LayerData");
            } else if (this._cellObject instanceof DeleteModelLayer) {
                DeleteModelLayer dml = (DeleteModelLayer)this._cellObject;
                ModelLayer layer = dml.getLayer();
                InteractiveModel model = layer.getModel();
                model.removeLayersAfterBaseLayer();
            } else {
                JOptionPane.showMessageDialog(this.button, this.label + ": Invalid Layer");
            }
        }
        this.isPushed = false;
        return new String(this.label);
    }

    @Override
    public boolean stopCellEditing() {
        this.isPushed = false;
        return super.stopCellEditing();
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }
}

