/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.IComponentManager;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeModel_ModInfo;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeModel_StaticsInfo;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.ASCII.AsciiImportWidget;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Line;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ExportModelDialog;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.IPropertyChangedListener;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.InteractiveModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.InteractiveModel_StaticsInfo;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.LayerDataType;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelBuilderDialog;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelData;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelDataViewModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelLayer;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelMapWidget;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelProfileLine;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModelTreeModel;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.ModifyDataDialog;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.Page_IMB_Static_Final;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.Page_IMB_Static_Intermediate;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.Page_IMB_Static_Name;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.Page_IMB_Static_Shift;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.SelectModelDialog;
import com.PecosLibrary.Windows.Refraction.DelayTime.ModelWizard.StackedComposites;
import com.PecosLibrary.Windows.Wizard.SimpleWizardDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;

public class LayerModelWidget
extends JSplitPane
implements ISaveableFrame,
ActionListener,
Messenger.Listener,
GenericObjectListener.Listener,
ItemListener,
ChangeListener,
MouseListener,
IPropertyChangedListener {
    InteractiveModel_StaticsInfo m_staticsInfo;
    SimpleWizardDialog m_staticsDialog;
    protected Java2D_SimpleComposite m_widget;
    protected Java2D_SimpleComposite m_widgetProfile;
    protected JTree m_tree;
    protected ModelMapWidget m_smallMapWidget = new ModelMapWidget(true, false);
    protected ModelMapWidget m_bigMapWidget = new ModelMapWidget(false, true);
    protected Java2D_UserEventConsumer_Line m_profileLineUEC = new Java2D_UserEventConsumer_Line();
    protected StackedComposites m_stackedComposites = new StackedComposites(3);
    InteractiveModel _model;
    ModelTreeModel _modelTreeModel;
    protected JButton m_btnCreateNew;
    protected ComboStringListWrapper m_modelCombo = new ComboStringListWrapper();
    protected boolean m_ignoreModelCombo = true;
    JScrollPane m_treeScrollPane;
    JButton m_btnImportASCII;
    JButton m_btnCalculateStatics;
    JButton m_btnExport;
    JButton m_btnClearPolygon;
    protected JButton m_btnStatics;
    protected ButtonGroup m_intGroup = new ButtonGroup();
    protected JRadioButton m_radIntElev = new JRadioButton("Fixed elevation");
    protected JRadioButton m_radIntDepth = new JRadioButton("Fixed depth");
    protected JRadioButton m_radIntVel = new JRadioButton("Fixed velocity");
    protected JLabel m_lblStaticsResult = new JLabel(" ");
    protected JTextField m_txtStaticsName = new JTextField("Tomo3D");
    protected JTextField m_txtIntDatumDepth = new JTextField("400");
    protected JTextField m_txtIntDatumVelocity = new JTextField("5000");
    protected JTextField m_txtIntDatumElev = new JTextField("-200");
    protected JTextField m_txtFinalDatumElev = new JTextField("2000");
    protected JTextField m_txtRepVel = new JTextField("10000");
    protected JCheckBox m_chkZeroMean = new JCheckBox("Force statics to be zero mean");
    protected JCheckBox m_chkApplyResidual = new JCheckBox("Apply residual correction");
    protected JTextField m_txtResidCorrMult = new JTextField("1");
    protected JCheckBox m_chkStackPick = new JCheckBox("Apply stack pick correction");
    protected JTextField m_txtStackPickMult = new JTextField("0.5");
    protected JRadioButton m_squareRadio = new JRadioButton("Inverse square");
    protected JRadioButton m_fourthRadio = new JRadioButton("Inverse fourth");
    protected ButtonGroup m_interpGroup = new ButtonGroup();
    protected JTextField m_interpRadiusText = new JTextField("100");
    protected int m_maxVisible = 4;
    protected int m_nextIndex = 0;
    protected JComboBox<String> m_cmbNumVisible = new JComboBox();
    protected JCheckBox m_chkHorzLines = new JCheckBox("Show horizontal grid lines");

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Refraction.DelayTime.LayerModelWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "IMW";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "IMBW";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return false;
    }

    public LayerModelWidget() {
        super(1);
        try {
            this.setRightComponent(this.createRight());
            this.setLeftComponent(this.createLeft());
            Messenger.singleton().addListener(this);
            this.reloadModelCombo();
            this.loadModel();
            this.m_stackedComposites.setNumVisible(this.m_cmbNumVisible.getSelectedIndex() + 1);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void importColumnDelimited() throws Exception {
        try {
            IComponentManager cm = SharedApplicationData.singleton().getComponentManager();
            cm.showComponent(AsciiImportWidget.class.getName(), "ASCII", "ASCII import", false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadModel() {
        try {
            String name = this.m_modelCombo.getSelectedString();
            if (name == null) {
                return;
            }
            if (name.length() < 1) {
                return;
            }
            InteractiveModel model = new InteractiveModel(name);
            this.setModel(model);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadAllMapProfiles() {
        try {
            int nProfiles = this.m_stackedComposites.ProfileList.size();
            double radius = Tools_Widget.extractDouble(this.m_interpRadiusText, 100.0, 1.0, 10000.0);
            for (int i = 0; i < nProfiles; ++i) {
                ModelProfileLine pl = this.m_stackedComposites.ProfileList.get(i);
                pl.createProfile(this._model, pl.X1, pl.Y1, pl.X2, pl.Y2, this.m_fourthRadio.isSelected(), radius);
                this.m_stackedComposites.PlotList.get(i).mainWidget().mooz();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void loadMapProfile() {
        try {
            while (this.m_nextIndex < 0) {
                ++this.m_nextIndex;
            }
            if (this.m_nextIndex > this.m_cmbNumVisible.getSelectedIndex()) {
                this.m_nextIndex = 0;
            }
            ModelProfileLine pl = this.m_stackedComposites.ProfileList.get(this.m_nextIndex);
            double radius = Tools_Widget.extractDouble(this.m_interpRadiusText, 100.0, 1.0, 10000.0);
            pl.createProfile(this._model, this.m_profileLineUEC.StartWorldX, this.m_profileLineUEC.StartWorldY, this.m_profileLineUEC.EndWorldX, this.m_profileLineUEC.EndWorldY, this.m_fourthRadio.isSelected(), radius);
            this.m_stackedComposites.PlotList.get(this.m_nextIndex).mainWidget().mooz();
            this.updateSmallMapSliceLines();
            ++this.m_nextIndex;
            this.m_smallMapWidget.CompositeWidget.mainWidget().repaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_modelCombo) {
                if (this.m_ignoreModelCombo) {
                    return;
                }
                this.loadModel();
            }
            if (sender == this.m_profileLineUEC) {
                if (this.m_profileLineUEC.Dragging) {
                    return;
                }
                if (this.m_profileLineUEC.TinyLine) {
                    return;
                }
                this.loadMapProfile();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    void openExistingModel() {
        try {
            SelectModelDialog dialog = new SelectModelDialog(null, "Select Model");
            String sModel = SharedApplicationData.singleton().SharedString;
            if (InteractiveModel.doesModelExist(sModel).booleanValue()) {
                InteractiveModel model = new InteractiveModel(sModel);
                this.setModel(model);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void setModel(InteractiveModel model) {
        try {
            if (model == this._model) {
                return;
            }
            if (this._model != null) {
                this._model.close();
            }
            this.m_staticsDialog = null;
            this.m_staticsInfo = null;
            this._model = model;
            this._modelTreeModel = new ModelTreeModel(this._model);
            this._model.setSelectedItem(0, true);
            this._model.addPropertyChangedListener(this);
            this.m_tree.setModel(this._modelTreeModel);
            this.m_smallMapWidget.setModel(model);
            this.m_bigMapWidget.setModel(model);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void createNewModel() {
        try {
            ModelBuilderDialog modelDialog = new ModelBuilderDialog();
            modelDialog.showDialog();
            if (modelDialog.getDialogResult().booleanValue()) {
                InteractiveModel model = new InteractiveModel(modelDialog.getModelName());
                this.reloadModelCombo();
                this.m_ignoreModelCombo = true;
                this.m_modelCombo.setPreferredSelected(model.getModelName());
                this.m_ignoreModelCombo = false;
                this.setModel(model);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    protected void updateSmallMapSliceLines() {
        try {
            ArrayList<ModelProfileLine> profiles = new ArrayList<ModelProfileLine>();
            for (int n = 0; n <= this.m_cmbNumVisible.getSelectedIndex(); ++n) {
                ModelProfileLine profile = this.m_stackedComposites.ProfileList.get(n);
                profiles.add(profile);
            }
            this.m_smallMapWidget.setProfileLines(profiles);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.m_cmbNumVisible) {
                this.m_nextIndex = 0;
                this.m_stackedComposites.setNumVisible(this.m_cmbNumVisible.getSelectedIndex() + 1);
                this.updateSmallMapSliceLines();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.ProjectPolygonModified) {
                this.m_smallMapWidget.reloadPlot();
                this.m_bigMapWidget.reloadPlot();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.m_btnCreateNew == e.getSource()) {
                this.createNewModel();
                return;
            }
            if (e.getSource() == this.m_btnImportASCII) {
                this.importColumnDelimited();
            }
            if (e.getSource() == this.m_btnCalculateStatics) {
                this.computeStatics();
            }
            if (e.getSource() == this.m_btnClearPolygon) {
                RefractionStaticsProject.singleton().polygon().clear();
                RefractionStaticsProject.singleton().savePolygon();
                Messenger.broadcast(Messenger.Message.ProjectPolygonModified, this, null);
            }
            if (e.getSource() == this.m_chkHorzLines) {
                this.m_stackedComposites.setLinesVisible(this.m_chkHorzLines.isSelected());
            }
            if (e.getSource() == this.m_btnExport) {
                ExportModelDialog dlg = new ExportModelDialog(this._model);
                dlg.showDialog();
                if (dlg.getDialogResult().booleanValue()) {
                    String sModelColumnName = dlg.getModelColumnName();
                    String sExportColumnName = dlg.getExportColumnName();
                    this._model.writeColumnToRefractionProject(sModelColumnName, sExportColumnName);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createLeft() {
        try {
            JTabbedPane topTabs = new JTabbedPane();
            topTabs.addTab("Model", this.createModelTab());
            topTabs.addTab("Profile", this.createProfileTab());
            return topTabs;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected JComponent createRight() {
        try {
            JTabbedPane topTabs = new JTabbedPane();
            topTabs.addTab("Map view", this.m_bigMapWidget);
            this.m_bigMapWidget.CompositeWidget.mainWidget().addZoomer();
            boolean row = false;
            this.m_stackedComposites = new StackedComposites(4);
            topTabs.addTab("Profile", this.m_stackedComposites);
            return topTabs;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected JComponent createStaticsTab() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            this.m_intGroup.add(this.m_radIntElev);
            this.m_intGroup.add(this.m_radIntDepth);
            this.m_intGroup.add(this.m_radIntVel);
            this.m_radIntElev.setSelected(true);
            this.m_radIntElev.addActionListener(this);
            this.m_radIntDepth.addActionListener(this);
            this.m_radIntVel.addActionListener(this);
            GridLayoutWidget grid = main.createGridLayoutWidget(3, "Intermediate datum options", 0);
            int row = 0;
            grid.addSimple(row++, this.m_radIntElev, this.m_txtIntDatumElev);
            grid.addSimple(row++, this.m_radIntDepth, this.m_txtIntDatumDepth);
            grid.addSimple(row++, this.m_radIntVel, this.m_txtIntDatumVelocity);
            this.m_txtIntDatumElev.setEnabled(this.m_radIntElev.isSelected());
            this.m_txtIntDatumDepth.setEnabled(this.m_radIntDepth.isSelected());
            this.m_txtIntDatumVelocity.setEnabled(this.m_radIntVel.isSelected());
            grid = main.createGridLayoutWidget(0, "Final datum options", 0);
            row = 0;
            grid.addSimple(row++, new JLabel("Final datum"), this.m_txtFinalDatumElev);
            grid.addSimple(row++, new JLabel("Replacement velocity"), this.m_txtRepVel);
            String s = "<HTML><font color=\"blue\">Residual terms are computed during batch update </font></HTML>";
            LinearLayoutWidget res = main.createVertical(0, "Residual correction options", 0);
            res.addComponent(new JLabel(s, 0), 0);
            res.addComponent(this.m_chkApplyResidual, 0);
            this.m_chkApplyResidual.setSelected(true);
            res.addHorzPair(new JLabel("Residual multiplier"), 0, this.m_txtResidCorrMult, 10);
            s = "<HTML><font color=\"blue\">Stack picks are made in the tomo stacks display</font></HTML>";
            LinearLayoutWidget stackPickWidget = main.createVertical(0, "Residual correction options", 0);
            stackPickWidget.addComponent(new JLabel(s, 0), 0);
            stackPickWidget.addComponent(this.m_chkStackPick, 0);
            this.m_chkStackPick.setSelected(false);
            stackPickWidget.addHorzPair(new JLabel("Stack pick multiplier"), 0, this.m_txtStackPickMult, 10);
            main.addHorzPair(new JLabel("Statics name"), 0, this.m_txtStaticsName, 10);
            main.addComponent(this.m_chkZeroMean, 0);
            this.m_btnStatics = main.createButton("Compute statics", this, 0);
            main.addComponent(this.m_lblStaticsResult, 0);
            main.addStretch(10);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createProfileTab() {
        try {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            LinearLayoutWidget w = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            for (int n = 1; n <= this.m_maxVisible; ++n) {
                String s = Integer.toString(n) + " plots visible";
                this.m_cmbNumVisible.addItem(s);
            }
            this.m_cmbNumVisible.setSelectedIndex(2);
            this.m_cmbNumVisible.addItemListener(this);
            w.addComponent(this.m_cmbNumVisible, 0);
            w.addComponent(this.m_chkHorzLines, 0);
            this.m_chkHorzLines.setSelected(true);
            this.m_chkHorzLines.addActionListener(this);
            GridLayoutWidget grid = w.createGridLayoutWidget(3, "Interpolation options", 0);
            int row = 0;
            grid.addSimple(row++, this.m_squareRadio, this.m_fourthRadio);
            grid.addSimple(row++, new JLabel("Interpolation radius"), this.m_interpRadiusText);
            this.m_interpGroup.add(this.m_squareRadio);
            this.m_interpGroup.add(this.m_fourthRadio);
            this.m_fourthRadio.setSelected(true);
            Tools_FontChanger.changeSizeOfFont(w, -2, null, true);
            panel.add((Component)w, "North");
            return panel;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createModelTab() {
        try {
            JSplitPane split = new JSplitPane(0);
            LinearLayoutWidget main = LinearLayoutWidget.vert(0, null);
            LinearLayoutWidget sub = main.createHorizontal(0, "Select model", 0);
            sub.addComponent(this.m_modelCombo, 10);
            this.m_modelCombo.listener().addListener(this);
            this.m_btnCreateNew = sub.createButton("New model", this, 0);
            LinearLayoutWidget buttons = LinearLayoutWidget.horz(0, null);
            this.m_btnImportASCII = buttons.createButton("Import ASCII", this, 1);
            this.m_btnCalculateStatics = buttons.createButton("Statics", this, 1);
            this.m_btnExport = buttons.createButton("Export", this, 1);
            this.m_btnClearPolygon = buttons.createButton("Clear Polygon", this, 0);
            main.addComponent(buttons, 0);
            JLabel lbl = new JLabel("Left-click and drag on map to display profiles", 2);
            lbl.setForeground(Color.blue);
            lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            main.addComponent(lbl, 0);
            JLabel lbl2 = new JLabel("Left-click on tree to modify Elevation or Velocity", 2);
            lbl2.setForeground(Color.blue);
            lbl2.setBorder(BorderFactory.createRaisedBevelBorder());
            main.addComponent(lbl2, 0);
            InteractiveModel emptyModel = new InteractiveModel();
            ModelTreeModel emptyModelTree = new ModelTreeModel(emptyModel);
            this.m_tree = new JTree();
            this.m_tree.setModel(emptyModelTree);
            this.m_tree.addMouseListener(this);
            this.m_treeScrollPane = new JScrollPane(this.m_tree);
            main.addComponent(this.m_treeScrollPane, 10);
            split.setTopComponent(main);
            split.setBottomComponent(this.m_smallMapWidget);
            split.setOneTouchExpandable(true);
            split.setDividerLocation(0.5);
            this.m_smallMapWidget.CompositeWidget.mainWidget().addZoomer();
            this.m_smallMapWidget.CompositeWidget.mainWidget().addEventConsumer(this.m_profileLineUEC);
            this.m_profileLineUEC.addListener(this);
            return split;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadModelCombo() {
        try {
            this.m_ignoreModelCombo = true;
            ArrayList<String> models = InteractiveModel.getModelNames();
            this.m_modelCombo.setStringArray(models);
            this.m_ignoreModelCombo = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void computeStatics() {
        try {
            if (this.m_staticsDialog == null) {
                this.m_staticsInfo = new InteractiveModel_StaticsInfo(this._model);
                ArrayList<SimpleWizardDialog.Page> pageList = new ArrayList<SimpleWizardDialog.Page>();
                Page_IMB_Static_Name page1 = new Page_IMB_Static_Name(this.m_staticsInfo);
                Page_IMB_Static_Intermediate page2 = new Page_IMB_Static_Intermediate(this.m_staticsInfo);
                Page_IMB_Static_Final page3 = new Page_IMB_Static_Final(this.m_staticsInfo);
                Page_IMB_Static_Shift page4 = new Page_IMB_Static_Shift(this.m_staticsInfo);
                pageList.add(new SimpleWizardDialog.Page(page1, "Name of statics column", "name"));
                pageList.add(new SimpleWizardDialog.Page(page2, "Intermediate datum", "method"));
                pageList.add(new SimpleWizardDialog.Page(page3, "Final datum", "followup"));
                pageList.add(new SimpleWizardDialog.Page(page4, "Optional bulk time shift", "shift"));
                this.m_staticsDialog = new SimpleWizardDialog(pageList, "Statics computation", 600, 550);
            } else {
                this.m_staticsInfo.reloadElevationTable();
                this.m_staticsInfo.reloadVelocityTable();
            }
            this.m_staticsDialog.showDialog();
            if (this.m_staticsDialog.Finish) {
                this.m_staticsInfo.computeStatics();
                this.m_bigMapWidget.setModel(this._model);
                this.m_smallMapWidget.setModel(this._model);
                this._model.writeColumnToRefractionProject(this.m_staticsInfo.ColumnName, this.m_staticsInfo.ColumnName);
                RefractionStaticsProject.singleton().getDelayTimeData().getHistory().addWithTime("Compute statics IMB: " + this.m_staticsInfo.ColumnName);
                RefractionStaticsProject.singleton().getDelayTimeData().getHistory().add(this.m_staticsInfo.getIntermediateDatumDescription());
                RefractionStaticsProject.singleton().getDelayTimeData().getHistory().add(this.m_staticsInfo.getFinalDatumDescription());
                RefractionStaticsProject.singleton().getDelayTimeData().getHistory().add(this.m_staticsInfo.getReplacementVelocityDescription());
                if (this.m_staticsInfo.ShiftMethod == DelayTimeModel_StaticsInfo.FinalShiftMethod.ZeroMean) {
                    RefractionStaticsProject.singleton().getDelayTimeData().getHistory().add("STATICS FORCED TO BE ZERO-MEAN");
                }
                if (this.m_staticsInfo.ShiftMethod == DelayTimeModel_StaticsInfo.FinalShiftMethod.TieToAnother) {
                    RefractionStaticsProject.singleton().getDelayTimeData().getHistory().add("STATICS TIED TO " + this.m_staticsInfo.TieStaticsColumn);
                }
                RefractionStaticsProject.singleton().getDelayTimeData().getHistory().save();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            Point p = e.getLocationOnScreen();
            p = e.getPoint();
            ModelData md = null;
            TreePath path = this.m_tree.getClosestPathForLocation(p.x, p.y);
            Object node = path.getLastPathComponent();
            if (node != null) {
                if (node instanceof ModelData) {
                    md = (ModelData)node;
                }
                if (node instanceof ModelDataViewModel) {
                    ModelDataViewModel mdvm = (ModelDataViewModel)node;
                    md = mdvm.getModelData();
                }
                if (md != null && (md.getLayerDataType() == LayerDataType.Elevation || md.getLayerDataType() == LayerDataType.Velocity)) {
                    ModifyDataDialog dlg = new ModifyDataDialog(md, this._model);
                    dlg.showDialog();
                    if (dlg.getDialogResult().booleanValue()) {
                        double dMinimumThickness = dlg.getMinimumThickness();
                        ModelLayer layer = md.getLayer();
                        DelayTimeModel_ModInfo modInfo = dlg.getModInfo();
                        this._model.performRequestedMods(modInfo, layer, md, dMinimumThickness);
                        this.m_bigMapWidget.CompositeWidget.repaint();
                        this.m_smallMapWidget.CompositeWidget.repaint();
                        this.reloadAllMapProfiles();
                        this._model.writeModelToDatabase(this._model.getModelName(), true);
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void handlePropertyChanged(Object sender, String sProperty) {
        try {
            this.m_tree.setModel(this._modelTreeModel);
            int nRows = this.m_tree.getRowCount();
            for (int iRow = 0; iRow < nRows; ++iRow) {
                this.m_tree.expandRow(iRow);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

