/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.DelayTime.BranchAssignment;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeData;
import com.PecosLibrary.Refraction.DelayTime.UpholeCorrection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class GriddedDelayTimeOptionsDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected RefractionStaticsProject m_project;
    protected DelayTimeData m_delayTimeData;
    protected BranchAssignment m_branchAssignment;
    protected JTextField m_txtVelocitySmoothRadius = new JTextField("1000");
    protected JTextField m_txtVelocityMaxPercentVariation = new JTextField("30");
    protected JCheckBox m_chkGridAnis = new JCheckBox("Compute delay time anisotropy term");
    protected JTextField m_txtRangeCompression = new JTextField("1.1");
    protected JCheckBox m_chkRangeCompression = new JCheckBox("Apply velocity range compression (RECOMMENDED)");
    protected RadioPanel m_radioUphole;
    protected RadioPanel m_radioInterpolation;
    protected JButton m_btnOK = new JButton("Okay");
    protected JButton m_btnCancel = new JButton("Cancel");
    public boolean OK = false;

    public boolean applyRangeCompression() {
        return this.m_chkRangeCompression.isSelected();
    }

    public double rangeCompression() {
        return Tools_Widget.extractDouble(this.m_txtRangeCompression, 2.0, 1.0, 100.0);
    }

    public double velSmoothRadius() {
        return Tools_Widget.extractDouble(this.m_txtVelocitySmoothRadius, 1000.0, 1.0, 20000.0);
    }

    public double velMaxPercentVariation() {
        return Tools_Widget.extractDouble(this.m_txtVelocityMaxPercentVariation, 30.0, 1.0, 100.0);
    }

    public UpholeCorrection.Method upholeMethod() {
        if (this.m_radioUphole.getSelectedIndex() == 1) {
            return UpholeCorrection.Method.JustUseUpholeTime;
        }
        if (this.m_radioUphole.getSelectedIndex() == 2) {
            return UpholeCorrection.Method.None;
        }
        return UpholeCorrection.Method.SoftwareDeterminesBest;
    }

    public boolean interpolateUsingInverseSquare() {
        try {
            return this.m_radioInterpolation.getSelectedIndex() == 1;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public GriddedDelayTimeOptionsDialog() {
        try {
            this.m_project = RefractionStaticsProject.singleton();
            this.m_delayTimeData = this.m_project.getDelayTimeData();
            this.m_branchAssignment = this.m_delayTimeData.branchAssignment();
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget tab1 = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            JLabel lbl = new JLabel("NOTE: Gridded analysis is much slower than standard analysis");
            tab1.addComponent(lbl, 0);
            lbl.setForeground(Color.red);
            tab1.addComponent(new JLabel("   "), 0);
            GridLayoutWidget gv = tab1.createGridLayoutWidget(0, "Velocity constraints", 0);
            int row = 0;
            gv.addSimple(row++, new JLabel("Refractor velocity smoothing radius"), this.m_txtVelocitySmoothRadius);
            gv.addSimple(row++, new JLabel("Maximum velocity variation (percent)"), this.m_txtVelocityMaxPercentVariation);
            gv.addSimple(row++, new JLabel(""), this.m_chkRangeCompression);
            gv.addSimple(row++, new JLabel("Compression scalar ( >= 1)"), this.m_txtRangeCompression);
            this.m_chkRangeCompression.setSelected(true);
            this.m_radioUphole = new RadioPanel(LinearLayoutWidget.Direction.Vertical, "Uphole correction method", UpholeCorrection.Method.values()[0].Description, UpholeCorrection.Method.values()[1].Description, UpholeCorrection.Method.values()[2].Description);
            tab1.addComponent(this.m_radioUphole, 0);
            this.m_radioInterpolation = new RadioPanel(LinearLayoutWidget.Direction.Vertical, "Interpolation method for low fold shots and receivers", "Use a sparse grid based approach", "Use inverse square approach - may be very slow");
            tab1.addComponent(this.m_radioInterpolation, 0);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)tab1, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setTitle("Delay time analysis options");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            this.OK = false;
            UpholeCorrection.Method method = this.m_project.getUpholeCorrectionMethod();
            int upholeIndex = UpholeCorrection.getIndexFromMethod(method);
            this.m_radioUphole.setSelectedIndex(upholeIndex);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                int index = this.m_radioUphole.getSelectedIndex();
                UpholeCorrection.Method method = UpholeCorrection.getMethodFromIndex(index);
                this.m_project.setUpholeCorrectionMethod(method);
                this.OK = true;
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

