/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Data.Column_Int;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Refraction.Picking.PickPlaneEnum;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.DelayTime.Tools_DelayTime;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.DelayTime.GeometryErrorDisplayWidget;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class GeometryCorrectionWidget
extends LinearLayoutWidget
implements ActionListener,
GenericObjectListener.Listener,
Messenger.Listener {
    protected GeometryErrorDisplayWidget m_widget;
    protected JButton m_applyButton;
    protected JButton m_openDraggerButton;
    protected JLabel m_distanceLabel = new JLabel("", 0);
    protected Ensemble m_ensemble;
    protected PickPlaneEnum m_pickPlane;
    protected JTextField m_txtCutoff = new JTextField("20");
    protected JButton m_btnKillPicks;
    protected JCheckBox m_chkUpdateBranch = new JCheckBox("Update branch");
    protected GenericObjectListener m_listener = new GenericObjectListener();

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public GeometryCorrectionWidget() {
        super(LinearLayoutWidget.Direction.Horizontal, 0, null);
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.m_widget = new GeometryErrorDisplayWidget();
            this.m_widget.listener().addListener(this);
            this.addComponent(this.m_widget, 10);
            LinearLayoutWidget sub = this.createVertical(4, null, 0);
            sub.addComponent(this.m_distanceLabel, 0);
            this.m_distanceLabel.setForeground(Color.blue);
            this.m_distanceLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            this.m_applyButton = sub.createButton("Move to suggested location", this, 0);
            this.m_openDraggerButton = sub.createButton("Open dragger dialog", this, 0);
            LinearLayoutWidget sub1 = sub.createVertical(0, null, 0);
            sub1.setBorder(BorderFactory.createRaisedBevelBorder());
            this.m_btnKillPicks = sub1.createButton("Kill bad picks ", this, 0);
            sub1.addHorzPair(new JLabel("Cutoff (ms)"), 0, this.m_txtCutoff, 9);
            sub.addStretch(10);
            String help = "<html>Left-click to delete pick<br>Press ESC to select trace</html>";
            sub.createLabel(help, 2, 0);
            sub.addStretch(10);
            sub1 = sub.createVertical(0, null, 0);
            sub1.addComponent(new JLabel("Update branch assignment during"), 0);
            sub1.addComponent(new JLabel("geometry update iterations"), 0);
            sub1.addComponent(this.m_chkUpdateBranch, 0);
            this.m_chkUpdateBranch.addActionListener(this);
            this.m_chkUpdateBranch.setSelected(p.UpdateBranchDuringGeomCorr);
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
            Messenger.singleton().addListener(this);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.UpdateBranchOptionChanged) {
                RefractionStaticsProject p = RefractionStaticsProject.singleton();
                this.m_chkUpdateBranch.setSelected(p.UpdateBranchDuringGeomCorr);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_widget) {
                this.m_listener.broadcast(this, null);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setPickPlane(PickPlaneEnum pp) {
        this.m_pickPlane = pp;
        this.m_widget.setPickPlane(pp);
        this.repaint();
    }

    public void setEnsemble(Ensemble ensemble) {
        try {
            this.m_ensemble = ensemble;
            this.m_widget.setEnsemble(ensemble);
            if (this.m_ensemble != null) {
                Ensemble.PredictedCoordinates pred = this.m_ensemble.predictedCoordinates();
                double dist = Math.sqrt(1.0E-6 + pred.ShiftX * pred.ShiftX + pred.ShiftY * pred.ShiftY);
                double az = 180.0 * Math.atan2(pred.ShiftY, pred.ShiftX) / 3.1416;
                this.m_distanceLabel.setText("Predicted error: " + Integer.toString((int)(0.5 + dist)) + " (ft/m) ");
            } else {
                this.m_distanceLabel.setText(" ");
            }
            this.repaint();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void killPicks() {
        try {
            if (this.m_ensemble == null) {
                return;
            }
            Column_Int kills = new Column_Int();
            float cutoff = (float)Tools_Widget.extractDouble(this.m_txtCutoff, 20.0, 5.0, 500.0);
            int indexPick = this.m_ensemble.dictionary().getEntryIndex("Trace", "FBP_User");
            int indexIndex = this.m_ensemble.dictionary().getEntryIndex("Trace", "TraceIndex");
            int numKilled = 0;
            Tools_DelayTime.singleton().computeCurrentPickErrors(this.m_ensemble);
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                EnsembleTrace.DelayTimePickError errorData = this.m_ensemble.trace(n).delayTimePickErrorData();
                if (errorData.Branch < 1 || !(errorData.PickError > cutoff)) continue;
                this.m_ensemble.trace(n).header().putFloat(indexPick, -9999.0f);
                long traceIndex = this.m_ensemble.trace(n).header().getLong(indexIndex);
                kills.putLong(numKilled++, traceIndex);
            }
            if (numKilled > 0) {
                RefractionStaticsProject p = RefractionStaticsProject.singleton();
                int colPick = p.traceTableWrapper().traceTable().column_indexOfColumn("FBP_User");
                if (numKilled >= 2) {
                    kills.sort(numKilled);
                }
                for (int n = 0; n < numKilled; ++n) {
                    long traceIndex = kills.getLong(n);
                    p.traceTableWrapper().traceTable().putFloat(traceIndex, colPick, -9999.0f);
                }
                p.traceTableWrapper().traceTable().saveCurrentSection();
                this.m_listener.broadcast(this, null);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (e.getSource() == this.m_chkUpdateBranch) {
                project.UpdateBranchDuringGeomCorr = this.m_chkUpdateBranch.isSelected();
                Messenger.broadcast(Messenger.Message.UpdateBranchOptionChanged, this, null);
                return;
            }
            if (e.getSource() == this.m_btnKillPicks) {
                this.killPicks();
                return;
            }
            if (e.getSource() == this.m_openDraggerButton) {
                int shotID = Tools_Ensemble.isShotEnsemble(this.m_ensemble);
                int recID = Tools_Ensemble.isReceiverEnsemble(this.m_ensemble);
                if (shotID >= 1) {
                    project.dragShot(this.m_ensemble, shotID);
                }
                if (recID >= 1) {
                    project.dragReceiver(this.m_ensemble, recID);
                }
                return;
            }
            if (e.getSource() == this.m_applyButton) {
                Ensemble.PredictedCoordinates pred = this.m_ensemble.predictedCoordinates();
                double newX = pred.CurrentX + pred.ShiftX;
                double newY = pred.CurrentY + pred.ShiftY;
                int shotID = Tools_Ensemble.isShotEnsemble(this.m_ensemble);
                int recID = Tools_Ensemble.isReceiverEnsemble(this.m_ensemble);
                if (recID >= 1) {
                    project.moveReceiver(recID, newX, newY);
                    return;
                }
                if (shotID >= 1) {
                    project.moveShot(shotID, newX, newY);
                    return;
                }
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

