/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Data.TraceTable.ITraceTableScannerMonitor;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.TraceTable.TraceTable_ComputeEnergyV0;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class EstimateWeatheringUsingEnergyDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener,
ITraceTableScannerMonitor {
    protected RefractionStaticsProject m_project;
    protected ComboStringListWrapper m_combo = new ComboStringListWrapper();
    protected JProgressBar m_progress = new JProgressBar();
    protected JTextField m_maxOffsetText = new JTextField("160");
    protected JTextField m_gridSizeText = new JTextField("500");
    protected JTextField m_colNameText = new JTextField("EnergyV0");
    protected JTextField m_v0Text = new JTextField("3000");
    protected JTextField m_stdText = new JTextField("500");
    protected JButton m_btnOK = new JButton("Compute");
    protected JButton m_btnCancel = new JButton("Cancel");
    public boolean OK = false;

    public EstimateWeatheringUsingEnergyDialog() {
        try {
            this.m_project = RefractionStaticsProject.singleton();
            this.getContentPane().setLayout(new BorderLayout());
            GridLayoutWidget grid = new GridLayoutWidget(3, null);
            int row = 0;
            grid.addSimple(row++, new JLabel("Energy column name"), this.m_combo);
            grid.addSimple(row++, new JLabel("Maximum offset"), this.m_maxOffsetText);
            grid.addSimple(row++, new JLabel("Analysis grid size"), this.m_gridSizeText);
            grid.addSimple(row++, new JLabel("Output column name"), this.m_colNameText);
            grid.addSimple(row++, new JLabel("Mean weather velocity"), this.m_v0Text);
            grid.addSimple(row++, new JLabel("Velocity deviation"), this.m_stdText);
            ArrayList<String> pickVersion = this.m_project.traceTableWrapper().traceTable().columns();
            this.m_combo.setStringArray(pickVersion);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addComponent(this.m_progress, 10);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)grid, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setTitle("Weathering velocity estimation using energy window");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setPercentDone(double percent) {
        try {
            percent = Math.max(percent, 0.0);
            percent = Math.min(percent, 99.99);
            this.m_progress.setValue((int)(10.0 * percent));
            this.m_progress.paintImmediately(0, 0, 500, 30);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setMessage(String message) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    protected void compute() {
        try {
            double gridSize = Tools_Widget.extractDouble(this.m_gridSizeText, 500.0, 100.0, 2000.0);
            double maxOffset = Tools_Widget.extractDouble(this.m_maxOffsetText, 140.0, 1.0, 5000.0);
            double meanv0 = Tools_Widget.extractDouble(this.m_v0Text, 3000.0, 300.0, 19000.0);
            double stdv0 = Tools_Widget.extractDouble(this.m_stdText, 100.0, 1.0, 2000.0);
            String colName = this.m_colNameText.getText();
            String energyName = this.m_combo.getSelectedString();
            TraceTable_ComputeEnergyV0 computer = new TraceTable_ComputeEnergyV0(this.m_project.traceTableWrapper().traceTable(), energyName, colName, maxOffset, gridSize, this.m_project.getEmptyGrid3D(gridSize, gridSize, gridSize));
            computer.scan(this.m_project.traceTableWrapper().traceTable(), this, true);
            Grid3D grid = computer.grid();
            double minv0 = meanv0 - 2.0 * stdv0;
            double maxv0 = meanv0 + 2.0 * stdv0;
            float mean = grid.average();
            float std = grid.AverageDistance;
            float[][] data = grid.data();
            for (int i = 0; i < grid.numInline(); ++i) {
                for (int c = 0; c < grid.numCrossline(); ++c) {
                    float junk = data[i][c];
                    float diff = junk - mean;
                    double v0 = meanv0 + stdv0 * (double)diff / (double)std;
                    v0 = Math.min(v0, maxv0);
                    v0 = Math.max(v0, minv0);
                    data[i][c] = (float)v0;
                }
            }
            computer.copyToTables();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnOK) {
                this.compute();
                this.OK = true;
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

