/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.History;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Action.Refraction.DelayTime.Action_DelayTime_SegyModelExport;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeAnisotropy;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeData;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeModel;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeModel_ModInfo;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeModel_StaticsInfo;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorHistogramWidget;
import com.PecosLibrary.Windows.Java2D.Java2D_PointSymbol_ComboBox;
import com.PecosLibrary.Windows.Java2D.Java2D_SimpleComposite;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import com.PecosLibrary.Windows.Java2D.Java2D_Widget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_DelayTimeAnisotropy;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_Table;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_ButtonPressed;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_Line;
import com.PecosLibrary.Windows.Java2D.UserEventHandler.Java2D_UserEventConsumer_MultiLineSegments;
import com.PecosLibrary.Windows.Refraction.DelayTime.Wizard.Page_Followup;
import com.PecosLibrary.Windows.Refraction.DelayTime.Wizard.Page_ModMethod;
import com.PecosLibrary.Windows.Refraction.DelayTime.Wizard.Page_SelectAttribute;
import com.PecosLibrary.Windows.Refraction.DelayTime.Wizard.Page_Static_ComputationMethod;
import com.PecosLibrary.Windows.Refraction.DelayTime.Wizard.Page_Static_Final;
import com.PecosLibrary.Windows.Refraction.DelayTime.Wizard.Page_Static_Intermediate;
import com.PecosLibrary.Windows.Refraction.DelayTime.Wizard.Page_Static_Name;
import com.PecosLibrary.Windows.Refraction.DelayTime.Wizard.Page_Static_Shift;
import com.PecosLibrary.Windows.Refraction.ElevationStaticsDialog;
import com.PecosLibrary.Windows.Shared.MultiTextDialog;
import com.PecosLibrary.Windows.Shared.PopupMenuButton;
import com.PecosLibrary.Windows.Wizard.SimpleWizardDialog;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DelayTimeModelWidget
extends JTabbedPane
implements ActionListener,
Messenger.Listener,
PopupMenuButton.Listener,
GenericObjectListener.Listener,
ItemListener,
ChangeListener,
ISaveableFrame,
Java2D_Widget.Listener {
    protected RefractionStaticsProject m_project;
    protected DelayTimeData m_delayTimeData;
    protected PopupMenuButton m_shortcutsButton;
    protected String m_strShortcutV0 = "Set weathering velocity to a constant";
    protected String m_strShortcutPercent = "Set weathering velocity to a percent of the refractor velocity";
    protected String m_strShortcutFlat = "Set the refractor elevation to a constant";
    protected PopupMenuButton m_recomputeButton;
    protected String m_strRecomputeElevations = "Recompute refractor elevations using current weathering velocity";
    protected String m_strRecomputeV0 = "Recompute weathering velocity using current refractor elevation";
    protected JButton m_modButton;
    protected JButton m_staticsButton;
    protected JButton m_staticsElevButton;
    protected JLabel m_messageLabel = new JLabel("");
    protected JCheckBox m_chkDisplayAsGrid = new JCheckBox("Interpolate display to grid");
    protected DefaultListModel<String> m_historyListModel = new DefaultListModel();
    protected JList<String> m_historyList = new JList();
    protected JButton m_btnReloadHist;
    protected JLabel m_histFileNameLabel = new JLabel("");
    protected JButton m_btnSegyExport;
    protected String m_anisStrV0;
    protected JButton m_reloadColumnsButton;
    protected JButton m_reloadPlotButton;
    protected JButton m_clearPolygonButton;
    protected Java2D_SimpleComposite m_widget;
    protected Java2D_ColorHistogramWidget m_colorHistogram = new Java2D_ColorHistogramWidget(this);
    protected JRadioButton m_radDatabase = new JRadioButton("Database column");
    protected JRadioButton m_radThickness = new JRadioButton("Layer thickness");
    protected ButtonGroup m_group = new ButtonGroup();
    protected JLabel m_lblPlotStatus = new JLabel(" ");
    protected JComboBox<String> m_layerCombo = new JComboBox();
    protected JCheckBox m_displayShotCheck = new JCheckBox("Display shot");
    protected JCheckBox m_displayRecCheck = new JCheckBox("Display receiver");
    protected ComboStringListWrapper m_colorCombo = new ComboStringListWrapper();
    protected Java2D_PointSymbol_ComboBox m_comboShotSymbol = new Java2D_PointSymbol_ComboBox();
    protected Java2D_PointSymbol_ComboBox m_comboRecSymbol = new Java2D_PointSymbol_ComboBox();
    protected JTextField m_txtSize = new JTextField("5");
    protected JCheckBox m_displayDtAnisCheck = new JCheckBox("Display delay time anisotropy");
    protected JComboBox<String> m_dtAnisCombo = new JComboBox();
    protected JComboBox<String> m_dtAnisStickCombo = new JComboBox();
    protected JComboBox<String> m_mouseCombo = new JComboBox();
    protected MouseMode m_mouseMode = MouseMode.Shot;
    protected Java2D_UserEventConsumer_ButtonPressed m_leftClickUEC;
    protected Java2D_UserEventConsumer_Line m_lineUEC;
    protected Java2D_UserEventConsumer_MultiLineSegments m_polygonUEC;
    protected SimpleWizardDialog m_staticsDialog = null;
    protected DelayTimeModel_StaticsInfo m_staticsInfo;
    protected SimpleWizardDialog m_modelDialog;
    protected DelayTimeModel_ModInfo m_modInfo;
    protected Page_SelectAttribute m_page1;
    protected Page_ModMethod m_page2;
    protected Page_Followup m_page3;
    protected MultiTextDialog m_shortCutFlatDialog;
    protected MultiTextDialog m_shortCutPercentDialog;
    protected MultiTextDialog m_shortCutDialog;

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.Refraction.DelayTime.DelayTimeModelWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "Model";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "Delay time model";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return true;
    }

    public DelayTimeModelWidget() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            this.m_project = RefractionStaticsProject.singleton();
            this.m_delayTimeData = RefractionStaticsProject.delayTimeData();
            main.addComponent(this.createTop(), 0);
            main.addComponent(this.createRight(), 10);
            this.addTab("Model viewing and editing", main);
            LinearLayoutWidget hist = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            LinearLayoutWidget top = hist.createHorizontal(3, null, 0);
            this.m_btnReloadHist = top.createButton("Reload history", this, 0);
            top.addComponent(this.m_histFileNameLabel, 10);
            hist.addComponent(new JScrollPane(this.m_historyList), 10);
            this.addTab("Model history", hist);
            if (!SharedApplicationData.ProcessWizardMode) {
                if (this.m_delayTimeData.branchAssignment().maxBranch() < 1) {
                    JOptionPane.showMessageDialog(null, "Delay time analysis must be completed before a model can be built", "Cannot build model", 0);
                } else if (!Tools_RefractionStaticsProject.columnExists(Pecos.getColNameVel(0), true, true)) {
                    JOptionPane.showMessageDialog(null, "Must define an initial weathering velocity field. \nSelect a velocity which is roughly half the first refractor velocity", " ", 1);
                }
            }
            this.reloadColumns();
            this.reloadPlot();
            this.reloadMouse();
            this.reloadHistory();
            Messenger.singleton().addListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createTop() {
        try {
            LinearLayoutWidget top = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, null);
            this.m_modButton = top.createButton("Modify model", this, 0);
            this.m_recomputeButton = new PopupMenuButton(null, "Recompute...", this);
            top.addComponent(this.m_recomputeButton, 0);
            this.m_recomputeButton.addOption(this.m_strRecomputeElevations);
            this.m_recomputeButton.addOption(this.m_strRecomputeV0);
            if (!SharedApplicationData.ProcessWizardMode) {
                this.m_staticsButton = top.createButton("Compute statics", this, 0);
                this.m_staticsElevButton = top.createButton("Compute elevation statics", this, 0);
            }
            this.m_shortcutsButton = new PopupMenuButton(null, "Shortcuts...", this);
            top.addComponent(this.m_shortcutsButton, 0);
            this.m_shortcutsButton.addOption(this.m_strShortcutV0);
            this.m_shortcutsButton.addOption(this.m_strShortcutPercent);
            this.m_shortcutsButton.addOption(this.m_strShortcutFlat);
            this.m_shortcutsButton.setForeground(Color.red);
            this.m_btnSegyExport = top.createButton("SEGY export", this, 0);
            top.addComponent(this.m_messageLabel, 10);
            return top;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRight() {
        try {
            return this.createRightMap();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleJava2DWidgetPaintEvent(Java2D_Widget widget, boolean imagePainted) {
        try {
            if (widget == this.m_widget.mainWidget()) {
                this.m_colorHistogram.setColorArrayWrapper(this.m_widget.getColorArrayWrapper());
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createRightMap() {
        try {
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            this.m_widget = new Java2D_SimpleComposite(true);
            this.m_widget.setScrollVisible(true, true);
            this.m_widget.setAllowRangeLocking(true);
            this.m_widget.mainWidget().addListener(this);
            main.addComponent(this.m_widget, 10);
            LinearLayoutWidget right = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null, 0);
            LinearLayoutWidget topbtns = right.createHorizontal(0, null, 0);
            this.m_reloadColumnsButton = topbtns.createButton("Reload columns", this, 0);
            this.m_reloadPlotButton = topbtns.createButton("Reload plot", this, 0);
            this.m_clearPolygonButton = topbtns.createButton("Clear polygon", this, 0);
            topbtns.addStretch(2);
            this.m_layerCombo.addItem("Weathering thickness");
            this.m_layerCombo.addItem("First refractor thickness");
            this.m_layerCombo.addItem("Second refractor thickness");
            this.m_layerCombo.addItem("Third refractor thickness");
            this.m_layerCombo.addItem("Fourth refractor thickness");
            this.m_layerCombo.setSelectedIndex(0);
            this.m_layerCombo.addItemListener(this);
            GridLayoutWidget grid = right.createGridLayoutWidget(0, "Select plot type", 0);
            int row = 0;
            grid.addSimple(row++, this.m_radDatabase, this.m_colorCombo);
            grid.addSimple(row++, this.m_radThickness, this.m_layerCombo);
            grid.addSimple(row++, new JLabel(" "), this.m_lblPlotStatus);
            this.m_radDatabase.setSelected(true);
            this.m_radDatabase.addActionListener(this);
            this.m_group.add(this.m_radDatabase);
            this.m_radThickness.addActionListener(this);
            this.m_group.add(this.m_radThickness);
            this.m_colorCombo.setEnabled(this.m_radDatabase.isSelected());
            this.m_layerCombo.setEnabled(this.m_radThickness.isSelected());
            this.m_displayRecCheck.setSelected(true);
            this.m_displayShotCheck.setSelected(true);
            this.m_comboShotSymbol.addItemListener(this);
            this.m_comboRecSymbol.addItemListener(this);
            this.m_txtSize.addActionListener(this);
            this.m_comboShotSymbol.setSelectedSymbol(Java2D_PointSymbol.FilledSquare);
            this.m_comboRecSymbol.setSelectedSymbol(Java2D_PointSymbol.FilledSquare);
            this.m_colorCombo.setPreferredSelected("Elevation");
            this.m_colorCombo.listener().addListener(this);
            this.m_displayRecCheck.addActionListener(this);
            this.m_displayShotCheck.addActionListener(this);
            grid = right.createGridLayoutWidget(0, "Plot options", 0);
            row = 0;
            grid.addSimple(row++, this.m_displayShotCheck, this.m_displayRecCheck);
            grid.addSimple(row++, new JLabel("Shot symbol"), this.m_comboShotSymbol);
            grid.addSimple(row++, new JLabel("Receiver symbol"), this.m_comboRecSymbol);
            grid.addSimple(row++, new JLabel("Symbol size (pix)"), this.m_txtSize);
            this.m_leftClickUEC = new Java2D_UserEventConsumer_ButtonPressed(1);
            this.m_leftClickUEC.addListener(this);
            this.m_polygonUEC = new Java2D_UserEventConsumer_MultiLineSegments();
            this.m_polygonUEC.addListener(this);
            this.m_polygonUEC.DefiningPolygon = true;
            LinearLayoutWidget sub2 = right.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, "Grid display", 0);
            sub2.addComponent(this.m_chkDisplayAsGrid, 0);
            this.m_chkDisplayAsGrid.addActionListener(this);
            sub2 = right.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, "Mouse mode", 0);
            sub2.addComponent(this.m_mouseCombo, 0);
            for (MouseMode m : MouseMode.values()) {
                this.m_mouseCombo.addItem(m.Description);
            }
            this.m_mouseCombo.addItemListener(this);
            this.m_mouseCombo.setSelectedIndex(0);
            sub2 = right.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, "Delay time anisotropy overlay", 0);
            sub2.addComponent(this.m_displayDtAnisCheck, 0);
            this.m_displayDtAnisCheck.addActionListener(this);
            sub2.addComponent(this.m_dtAnisCombo, 0);
            this.m_dtAnisCombo.addItem("First refractor anisotropy");
            this.m_dtAnisCombo.addItem("Second refractor anisotropy");
            this.m_dtAnisCombo.addItem("Third refractor anisotropy");
            this.m_dtAnisCombo.addItem("Fourth refractor anisotropy");
            this.m_dtAnisCombo.addItemListener(this);
            this.m_dtAnisCombo.setSelectedIndex(0);
            for (int n = 1; n < 20; ++n) {
                this.m_dtAnisStickCombo.addItem(Integer.toString(1 + 2 * n));
            }
            this.m_dtAnisStickCombo.setSelectedIndex(3);
            sub2.addHorzPair(new JLabel("Max stick length"), 0, this.m_dtAnisStickCombo, 10);
            this.m_dtAnisStickCombo.addItemListener(this);
            right.addComponent(this.m_colorHistogram, 10);
            Tools_FontChanger.changeSizeOfFont(right, -2, null, true);
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_colorCombo) {
                this.reloadPlot();
                return;
            }
            if (sender == this.m_leftClickUEC) {
                if (this.m_mouseMode == MouseMode.Shot) {
                    Tools_RefractionStaticsProject.selectNearestShot(this.m_leftClickUEC.WorldX, this.m_leftClickUEC.WorldY);
                }
                if (this.m_mouseMode == MouseMode.Receiver) {
                    Tools_RefractionStaticsProject.selectNearestReceiver(this.m_leftClickUEC.WorldX, this.m_leftClickUEC.WorldY);
                }
                return;
            }
            if (sender == this.m_polygonUEC) {
                if (this.m_polygonUEC.Dragging) {
                    return;
                }
                if (!this.m_polygonUEC.Finished) {
                    return;
                }
                int num = this.m_polygonUEC.numPoints();
                if (this.m_polygonUEC.numPoints() < 3) {
                    return;
                }
                Java2D_Polygon p = RefractionStaticsProject.singleton().polygon();
                p.X = new double[num];
                p.Y = new double[num];
                for (int n = 0; n < num; ++n) {
                    p.X[n] = this.m_polygonUEC.getX(n);
                    p.Y[n] = this.m_polygonUEC.getY(n);
                }
                RefractionStaticsProject.singleton().savePolygon();
                Messenger.broadcast(Messenger.Message.ProjectPolygonModified, sender, null);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadThickness() {
        try {
            double z2;
            double z1;
            int n;
            int indexBottom;
            int indexTop;
            int indexThick;
            Table_Abstract table;
            String query;
            Java2D_Paintable_Table painter;
            this.m_lblPlotStatus.setText("  ");
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            boolean showGrid = this.m_chkDisplayAsGrid.isSelected();
            this.m_widget.mainWidget().addPaintable(p.polygon(), -9999);
            String colorColumn = this.m_colorCombo.getSelectedString();
            Grid3D grid = null;
            if (showGrid) {
                grid = p.getEmptyGrid3D();
                grid.interp_Prep();
                grid.interp_SetSprayRadius(3);
            }
            int layer = this.m_layerCombo.getSelectedIndex();
            String colNameTop = "Elevation";
            if (layer >= 1) {
                colNameTop = Pecos.getColNameElev(layer);
            }
            String colNameBottom = Pecos.getColNameElev(layer + 1);
            if (!p.shotTable().column_exists(colNameTop) || !p.receiverTable().column_exists(colNameTop)) {
                this.m_lblPlotStatus.setText("INVALID LAYER");
                this.m_lblPlotStatus.setForeground(Color.red);
                return;
            }
            if (!p.shotTable().column_exists(colNameBottom) || !p.receiverTable().column_exists(colNameBottom)) {
                this.m_lblPlotStatus.setText("INVALID LAYER");
                this.m_lblPlotStatus.setForeground(Color.red);
                return;
            }
            int size = Tools_Widget.extractInteger(this.m_txtSize, 5, 1, 500);
            Java2D_Paintable_Table shotPainter = null;
            Java2D_Paintable_Table recPainter = null;
            if (this.m_displayShotCheck.isSelected() || showGrid) {
                this.m_widget.setColorTitle(this.m_layerCombo.getSelectedItem().toString());
                painter = new Java2D_Paintable_Table();
                query = String.format("SELECT Easting, Northing, Killed, %s, %s, %s FROM %s WHERE KILLED = FALSE", colNameBottom, colNameTop, "ShotID", "Shot");
                table = this.database().extractTableDataUsingQuery("Shot", query, Pecos.MaxQueryRowCount);
                indexThick = table.column_append("Thickness", DataType.Double);
                indexTop = table.column_indexOfColumn(colNameTop);
                indexBottom = table.column_indexOfColumn(colNameBottom);
                for (n = 0; n < table.row_count(); ++n) {
                    z1 = table.getDouble(n, indexTop);
                    z2 = table.getDouble(n, indexBottom);
                    table.putDouble(n, indexThick, z1 - z2);
                }
                painter.setTable(table);
                painter.setAxisC("Thickness");
                painter.UseColorScale = true;
                painter.Size_Pixel = size;
                painter.Symbol = this.m_comboShotSymbol.selectedSymbol();
                painter.setAxisX("Easting");
                painter.setAxisY("Northing");
                if (grid != null) {
                    Tools_RefractionStaticsProject.addTableToGrid(grid, "Thickness", table);
                    painter.UseColorScale = false;
                    shotPainter = painter;
                } else {
                    this.m_widget.mainWidget().addPaintable(painter, -9999);
                }
            }
            if (this.m_displayRecCheck.isSelected() || showGrid) {
                this.m_widget.setColorTitle(this.m_layerCombo.getSelectedItem().toString());
                painter = new Java2D_Paintable_Table();
                query = String.format("SELECT Easting, Northing, Killed, %s, %s, %s FROM %s WHERE KILLED = FALSE", colNameBottom, colNameTop, "ReceiverID", "Receiver");
                table = this.database().extractTableDataUsingQuery("Receiver", query, Pecos.MaxQueryRowCount);
                indexThick = table.column_append("Thickness", DataType.Double);
                indexTop = table.column_indexOfColumn(colNameTop);
                indexBottom = table.column_indexOfColumn(colNameBottom);
                for (n = 0; n < table.row_count(); ++n) {
                    z1 = table.getDouble(n, indexTop);
                    z2 = table.getDouble(n, indexBottom);
                    table.putDouble(n, indexThick, z1 - z2);
                }
                painter.setTable(table);
                painter.setAxisC("Thickness");
                painter.UseColorScale = true;
                painter.Size_Pixel = size;
                painter.Symbol = this.m_comboRecSymbol.selectedSymbol();
                painter.setAxisX("Easting");
                painter.setAxisY("Northing");
                if (grid != null) {
                    Tools_RefractionStaticsProject.addTableToGrid(grid, "Thickness", table);
                    painter.UseColorScale = false;
                    recPainter = painter;
                } else {
                    this.m_widget.mainWidget().addPaintable(painter, -9999);
                }
            }
            if (grid != null) {
                grid.interp_Finish(2);
                grid.smooth(2);
                this.m_widget.mainWidget().addPaintable(grid, -9999);
                if (this.m_displayShotCheck.isSelected() && shotPainter != null) {
                    this.m_widget.mainWidget().addPaintable(shotPainter, -9999);
                }
                if (this.m_displayRecCheck.isSelected() && recPainter != null) {
                    this.m_widget.mainWidget().addPaintable(recPainter, -9999);
                }
                grid.interp_Free();
            }
            this.loadAnisSticks();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadShotRecPlot() {
        try {
            String query;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            boolean showGrid = this.m_chkDisplayAsGrid.isSelected();
            this.m_widget.mainWidget().addPaintable(p.polygon(), -9999);
            String colorColumn = this.m_colorCombo.getSelectedString();
            if (showGrid) {
                Grid3D grid = p.getEmptyGrid3D();
                grid.interp_SetSprayRadius(3);
                Tools_RefractionStaticsProject.interpolateGrid(grid, colorColumn, 3);
                grid.smooth(2);
                this.m_widget.mainWidget().addPaintable(grid, -9999);
                double x = 2182500.0;
                double y = 720000.0;
                double z = grid.getNearestValue(x, y);
                System.out.println("z = " + Double.toString(z));
                x = 2188000.0;
                y = 718500.0;
                z = grid.getNearestValue(x, y);
                System.out.println("z = " + Double.toString(z));
                x = 2193000.0;
                y = 718700.0;
                z = grid.getNearestValue(x, y);
                System.out.println("z = " + Double.toString(z));
                x = 2188300.0;
                y = 714400.0;
                z = grid.getNearestValue(x, y);
                System.out.println("z = " + Double.toString(z));
                x = 2188600.0;
                y = 714450.0;
                z = grid.getNearestValue(x, y);
                System.out.println("z = " + Double.toString(z));
                x = 2192600.0;
                y = 714100.0;
                z = grid.getNearestValue(x, y);
                System.out.println("z = " + Double.toString(z));
                x = 218300.0;
                y = 707300.0;
                z = grid.getNearestValue(x, y);
                System.out.println("z = " + Double.toString(z));
                x = 2183000.0;
                y = 707300.0;
                z = grid.getNearestValue(x, y);
                System.out.println("z = " + Double.toString(z));
                x = 2188400.0;
                y = 707100.0;
                z = grid.getNearestValue(x, y);
                System.out.println("z = " + Double.toString(z));
                x = 2192000.0;
                y = 707000.0;
                z = grid.getNearestValue(x, y);
                System.out.println("z = " + Double.toString(z));
            }
            this.m_widget.setColorTitle("");
            int size = Tools_Widget.extractInteger(this.m_txtSize, 5, 3, 21);
            if (p.shotTable().column_exists(colorColumn) && this.m_displayShotCheck.isSelected()) {
                this.m_widget.setColorTitle(colorColumn);
                Java2D_Paintable_Table painter = new Java2D_Paintable_Table();
                query = String.format("SELECT Easting, Northing, %s, %s FROM %s WHERE KILLED = FALSE", colorColumn, "ShotID", "Shot");
                Table_Abstract table = this.database().extractTableDataUsingQuery("Shot", query, Pecos.MaxQueryRowCount);
                painter.setTable(table);
                painter.setAxisC(colorColumn);
                painter.UseColorScale = !showGrid;
                painter.Size_Pixel = size;
                painter.Symbol = this.m_comboShotSymbol.selectedSymbol();
                painter.setAxisX("Easting");
                painter.setAxisY("Northing");
                this.m_widget.mainWidget().addPaintable(painter, -9999);
            } else if (this.m_displayShotCheck.isSelected()) {
                this.m_widget.mainWidget().addPaintable(Tools_RefractionStaticsProject.loadGeomPO("Shot"), -9999);
            }
            if (p.receiverTable().column_exists(colorColumn) && this.m_displayRecCheck.isSelected()) {
                Java2D_Paintable_Table painter = new Java2D_Paintable_Table();
                query = String.format("SELECT Easting, Northing, %s, %s FROM %s WHERE KILLED = FALSE", colorColumn, "ReceiverID", "Receiver");
                Table_Abstract table = this.database().extractTableDataUsingQuery("Receiver", query, Pecos.MaxQueryRowCount);
                painter.setTable(table);
                painter.setAxisC(colorColumn);
                painter.UseColorScale = !showGrid;
                painter.Size_Pixel = size;
                painter.Symbol = this.m_comboRecSymbol.selectedSymbol();
                painter.setAxisX("Easting");
                painter.setAxisY("Northing");
                this.m_widget.mainWidget().addPaintable(painter, -9999);
            } else if (this.m_displayRecCheck.isSelected()) {
                this.m_widget.mainWidget().addPaintable(Tools_RefractionStaticsProject.loadGeomPO("Receiver"), -9999);
            }
            this.loadAnisSticks();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void loadAnisSticks() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            Java2D_Paintable_DelayTimeAnisotropy anisShot = null;
            Object anisRec = null;
            double maxAnisMag = 0.5;
            int refractor = 1 + this.m_dtAnisCombo.getSelectedIndex();
            String colNameAnisAz = Pecos.getColNameDtAnisAz(refractor);
            String colNameAnisMag = Pecos.getColNameDtAnisMag(refractor);
            if (this.m_displayShotCheck.isSelected() && p.shotTable().column_exists(colNameAnisAz) && p.shotTable().column_exists(colNameAnisMag) && this.m_displayDtAnisCheck.isSelected()) {
                String query = String.format("SELECT Easting, Northing, %s, %s FROM SHOT WHERE KILLED = FALSE", colNameAnisAz, colNameAnisMag);
                Table_Abstract table = this.database().extractTableDataUsingQuery("Shot", query, Pecos.MaxQueryRowCount);
                anisShot = new Java2D_Paintable_DelayTimeAnisotropy();
                anisShot.setTable(table, colNameAnisAz, colNameAnisMag);
                if (anisShot.valid()) {
                    maxAnisMag = Math.max(maxAnisMag, anisShot.MaxMagnitude);
                }
            }
            double stickLength = 1 + 2 * this.m_dtAnisStickCombo.getSelectedIndex();
            double stickScalar = stickLength / maxAnisMag;
            if (anisShot != null && anisShot.valid()) {
                anisShot.StickScalar = stickScalar;
                this.m_widget.mainWidget().addPaintable(anisShot, -9999);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadMouse() {
        try {
            Java2D_Widget w = this.m_widget.mainWidget();
            w.clearEventConsumerList();
            w.addZoomer();
            MouseMode[] arr = MouseMode.values();
            this.m_mouseMode = arr[this.m_mouseCombo.getSelectedIndex()];
            if (this.m_mouseMode == MouseMode.Shot || this.m_mouseMode == MouseMode.Receiver) {
                w.addEventConsumer(this.m_leftClickUEC);
            }
            if (this.m_mouseMode == MouseMode.Polygon) {
                w.addEventConsumer(this.m_polygonUEC);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadPlot() {
        try {
            this.m_widget.mainWidget().clearPaintableList();
            if (this.m_radDatabase.isSelected()) {
                this.reloadShotRecPlot();
            } else {
                this.reloadThickness();
            }
            this.m_widget.mainWidget().transform().setTechnique(Java2D_Transform.Technique.Basemap);
            this.m_widget.mainWidget().mooz();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handlePopupMenuButton(PopupMenuButton button, String text) {
        try {
            if (text.equalsIgnoreCase(this.m_strShortcutV0)) {
                this.shortcut();
                return;
            }
            if (text.equalsIgnoreCase(this.m_strShortcutPercent)) {
                this.shortcut_percent();
                return;
            }
            if (text.equalsIgnoreCase(this.m_strShortcutFlat)) {
                this.shortcut_flat();
                return;
            }
            if (text.equalsIgnoreCase(this.m_strRecomputeElevations)) {
                this.recomputeElev();
                return;
            }
            if (text.equalsIgnoreCase(this.m_strRecomputeV0)) {
                this.recomputeV0();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void computeAnisV0() {
        try {
            if (!Tools_RefractionStaticsProject.columnExists(Pecos.getColNameVel(0), true, true)) {
                JOptionPane.showMessageDialog(null, "Must define an initial weathering velocity field. \nSelect a velocity which is roughly half the first refractor velocity", " ", 1);
                return;
            }
            JOptionPane.showMessageDialog(null, "This process must be re-executed whenever any other model parameters are modified!", " ", 2);
            DelayTimeAnisotropy.computeV0();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.m_comboRecSymbol || e.getSource() == this.m_comboRecSymbol) {
                this.reloadPlot();
                return;
            }
            if (e.getSource() == this.m_mouseCombo) {
                this.reloadMouse();
                return;
            }
            this.reloadPlot();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void reloadColumns() {
        try {
            ArrayList<String> recColList = this.database().listOfColumnNames("Receiver");
            ArrayList<String> shotColList = this.database().listOfColumnNames("Shot");
            for (String s : shotColList) {
                boolean ok = false;
                for (String s2 : recColList) {
                    ok = ok || s2.equalsIgnoreCase(s);
                }
                if (ok) continue;
                recColList.add(s);
            }
            Collections.sort(recColList);
            this.m_colorCombo.setStringArray(recColList);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.ColumnsModified || message == Messenger.Message.ProjectVersionChanged) {
                this.reloadColumns();
                this.reloadPlot();
            }
            if (message == Messenger.Message.ProjectPolygonModified) {
                this.reloadPlot();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void recomputeV0() {
        try {
            if (!Tools_RefractionStaticsProject.columnExists(Pecos.getColNameVel(0), true, true)) {
                JOptionPane.showMessageDialog(null, "Must define the weathering velocity field first", " ", 1);
                return;
            }
            DelayTimeModel.singleton().computeWeatheringVelocity(this.m_project.receiverTable(), 1);
            DelayTimeModel.singleton().computeWeatheringVelocity(this.m_project.shotTable(), 1);
            DelayTimeModel.singleton().computeRefractorElevations(this.m_project.receiverTable());
            DelayTimeModel.singleton().computeRefractorElevations(this.m_project.shotTable());
            this.reloadPlot();
            this.m_delayTimeData.getHistory().addWithTime("Recompute weathering velocity");
            this.m_delayTimeData.getHistory().save();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void recomputeElev() {
        try {
            if (!Tools_RefractionStaticsProject.columnExists(Pecos.getColNameVel(0), true, true)) {
                JOptionPane.showMessageDialog(null, "Must define the weathering velocity field first", " ", 1);
                return;
            }
            DelayTimeModel.singleton().computeRefractorElevations(this.m_project.receiverTable());
            DelayTimeModel.singleton().computeRefractorElevations(this.m_project.shotTable());
            this.reloadPlot();
            this.m_delayTimeData.getHistory().addWithTime("Recompute refractor elevations");
            this.m_delayTimeData.getHistory().save();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void computeElevStatics() {
        try {
            ElevationStaticsDialog dlg = new ElevationStaticsDialog();
            this.reloadHistory();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void computeStatics() {
        try {
            if (!Tools_RefractionStaticsProject.columnExists(Pecos.getColNameVel(0), true, true)) {
                JOptionPane.showMessageDialog(null, "Must define the weathering velocity field first", " ", 1);
                return;
            }
            if (this.m_staticsDialog == null) {
                this.m_staticsInfo = new DelayTimeModel_StaticsInfo();
                ArrayList<SimpleWizardDialog.Page> pageList = new ArrayList<SimpleWizardDialog.Page>();
                Page_Static_Name page1 = new Page_Static_Name(this.m_staticsInfo);
                Page_Static_Intermediate page2 = new Page_Static_Intermediate(this.m_staticsInfo);
                Page_Static_Final page3 = new Page_Static_Final(this.m_staticsInfo);
                Page_Static_ComputationMethod page4 = new Page_Static_ComputationMethod(this.m_staticsInfo);
                Page_Static_Shift page5 = new Page_Static_Shift(this.m_staticsInfo);
                pageList.add(new SimpleWizardDialog.Page(page1, "Name of statics column", "name"));
                pageList.add(new SimpleWizardDialog.Page(page2, "Intermediate datum", "method"));
                pageList.add(new SimpleWizardDialog.Page(page3, "Final datum", "followup"));
                pageList.add(new SimpleWizardDialog.Page(page4, "Statics computation method", "compmethod"));
                pageList.add(new SimpleWizardDialog.Page(page5, "Optional bulk time shift", "shift"));
                this.m_staticsDialog = new SimpleWizardDialog(pageList, "Statics computation", 600, 550);
            } else {
                this.m_staticsInfo.reloadElevationTable();
                this.m_staticsInfo.reloadVelocityTable();
            }
            this.m_staticsDialog.showDialog();
            if (this.m_staticsDialog.Finish) {
                this.m_staticsInfo.computeStatics();
            }
            if (!this.m_staticsDialog.Finish) {
                return;
            }
            this.reloadColumns();
            this.reloadPlot();
            this.m_delayTimeData.getHistory().addWithTime("Compute statics: " + this.m_staticsInfo.ColumnName);
            this.m_delayTimeData.getHistory().add(this.m_staticsInfo.getIntermediateDatumDescription());
            this.m_delayTimeData.getHistory().add(this.m_staticsInfo.getFinalDatumDescription());
            this.m_delayTimeData.getHistory().add(this.m_staticsInfo.getReplacementVelocityDescription());
            if (this.m_staticsInfo.ShiftMethod == DelayTimeModel_StaticsInfo.FinalShiftMethod.ZeroMean) {
                this.m_delayTimeData.getHistory().add("STATICS FORCED TO BE ZERO-MEAN");
            }
            if (this.m_staticsInfo.ShiftMethod == DelayTimeModel_StaticsInfo.FinalShiftMethod.TieToAnother) {
                this.m_delayTimeData.getHistory().add("STATICS TIED TO " + this.m_staticsInfo.TieStaticsColumn);
            }
            this.m_delayTimeData.getHistory().save();
            this.reloadHistory();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void modModel() {
        try {
            if (this.m_delayTimeData.branchAssignment().maxBranch() < 1) {
                JOptionPane.showMessageDialog(null, "Delay time analysis must be completed before a model can be built", "Cannot build model", 0);
                return;
            }
            if (this.m_modelDialog == null) {
                this.m_modInfo = new DelayTimeModel_ModInfo();
                ArrayList<SimpleWizardDialog.Page> pageList = new ArrayList<SimpleWizardDialog.Page>();
                this.m_page1 = new Page_SelectAttribute(this.m_modInfo);
                this.m_page2 = new Page_ModMethod(this.m_modInfo);
                this.m_page3 = new Page_Followup(this.m_modInfo);
                pageList.add(new SimpleWizardDialog.Page(this.m_page1, "Select attribute", "attribute"));
                pageList.add(new SimpleWizardDialog.Page(this.m_page2, "Modification method", "method"));
                pageList.add(new SimpleWizardDialog.Page(this.m_page3, "Followup modifications", "followup"));
                this.m_modelDialog = new SimpleWizardDialog(pageList, "Model modification", 600, 400);
            } else {
                this.m_modInfo.reloadInitialData();
            }
            this.m_page1.tryToSelectVisibleColumn(this.m_colorCombo.getSelectedString());
            this.m_modelDialog.showDialog();
            if (!this.m_modelDialog.Finish) {
                return;
            }
            DelayTimeModel.singleton().performRequestedMods(this.m_modInfo);
            this.reloadPlot();
            this.reloadColumns();
            this.m_delayTimeData.getHistory().addWithTime("Modify model");
            this.m_delayTimeData.getHistory().add("Modify attribute: " + this.m_modInfo.Description);
            this.m_delayTimeData.getHistory().add("Modification method: " + this.m_modInfo.getModDesc());
            this.m_delayTimeData.getHistory().add(this.m_modInfo.FollowDescription);
            this.m_delayTimeData.getHistory().save();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void reloadHistory() {
        try {
            this.m_historyListModel.clear();
            RefractionStaticsProject.singleton();
            History h = RefractionStaticsProject.delayTimeData().getHistory();
            h.fillDefaultListModel(this.m_historyListModel);
            this.m_historyList.setModel(this.m_historyListModel);
            this.m_histFileNameLabel.setText(h.getFileName());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void shortcut_flat() {
        try {
            try {
                ClassLoader cl = ClassLoader.getSystemClassLoader();
                Field f = ClassLoader.class.getDeclaredField("classes");
                f.setAccessible(true);
                Vector classes = (Vector)f.get(cl);
                System.out.println("classes.size = " + classes.size());
            }
            catch (Exception error) {
                error.printStackTrace();
            }
            String paramFile = this.m_project.guiOptionsPath() + "/FlatShortCut.xml";
            ParameterTree tree = new ParameterTree();
            tree.read(paramFile);
            if (this.m_shortCutFlatDialog == null) {
                this.m_shortCutFlatDialog = new MultiTextDialog(null, "Model parameters", "Refractor elevation:");
            }
            this.m_shortCutFlatDialog.setText(0, tree.string_get("Z", "0"));
            this.m_shortCutFlatDialog.showDialog("Apply");
            if (!this.m_shortCutFlatDialog.OK) {
                return;
            }
            double z = this.m_shortCutFlatDialog.getDouble(0, 0.0, -100000.0, 100000.0);
            tree.double_put("Z", z);
            tree.save(paramFile);
            DelayTimeModel_ModInfo modInfoZ1 = new DelayTimeModel_ModInfo();
            modInfoZ1.ModifyElevation = true;
            modInfoZ1.Refractor = 1;
            modInfoZ1.ModificationMethod = modInfoZ1.Mod_Constant;
            modInfoZ1.ConstantValue = z;
            modInfoZ1.Follow = DelayTimeModel_ModInfo.FollowupOptions.ModifyWeathering;
            DelayTimeModel.singleton().performRequestedMods(modInfoZ1);
            this.reloadPlot();
            this.reloadColumns();
            History hist = this.m_delayTimeData.getHistory();
            hist.addWithTime("Set refractor elevation");
            hist.add(String.format("Elevation = %f", Float.valueOf((float)z)));
            hist.save();
            this.reloadHistory();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void shortcut_percent() {
        try {
            try {
                ClassLoader cl = ClassLoader.getSystemClassLoader();
                Field f = ClassLoader.class.getDeclaredField("classes");
                f.setAccessible(true);
                Vector classes = (Vector)f.get(cl);
                System.out.println("classes.size = " + classes.size());
            }
            catch (Exception error) {
                error.printStackTrace();
            }
            String paramFile = this.m_project.guiOptionsPath() + "/ModelPercentShortCut.xml";
            ParameterTree tree = new ParameterTree();
            tree.read(paramFile);
            if (this.m_shortCutPercentDialog == null) {
                this.m_shortCutPercentDialog = new MultiTextDialog(null, "Model parameters", "Percent of the underlying refractor velocity:", "Refractor smoothing radius");
            }
            this.m_shortCutPercentDialog.setText(0, tree.string_get("Percent", "60"));
            this.m_shortCutPercentDialog.setText(1, tree.string_get("RAD", "1000"));
            this.m_shortCutPercentDialog.showDialog("Apply");
            if (!this.m_shortCutPercentDialog.OK) {
                return;
            }
            double percent = this.m_shortCutPercentDialog.getDouble(0, 60.0, 10.0, 90.0);
            double rad = this.m_shortCutPercentDialog.getDouble(1, 1000.0, 100.0, 10000.0);
            tree.double_put("Percent", percent);
            tree.double_put("RAD", rad);
            tree.save(paramFile);
            DelayTimeModel_ModInfo modInfoV0 = new DelayTimeModel_ModInfo();
            modInfoV0.ModifyVelocity = true;
            modInfoV0.Refractor = 0;
            modInfoV0.Percent = percent;
            modInfoV0.ModificationMethod = modInfoV0.Mod_Percent;
            modInfoV0.Follow = DelayTimeModel_ModInfo.FollowupOptions.ModifyElevations;
            DelayTimeModel.singleton().performRequestedMods(modInfoV0);
            DelayTimeModel_ModInfo modInfoZ1 = new DelayTimeModel_ModInfo();
            modInfoZ1.ModifyElevation = true;
            modInfoZ1.Refractor = 1;
            modInfoZ1.SmoothRadius = rad;
            modInfoZ1.ModificationMethod = modInfoZ1.Mod_GridSmooth;
            modInfoZ1.Follow = DelayTimeModel_ModInfo.FollowupOptions.ModifyWeathering;
            DelayTimeModel.singleton().performRequestedMods(modInfoZ1);
            this.reloadPlot();
            this.reloadColumns();
            History hist = this.m_delayTimeData.getHistory();
            hist.addWithTime("Set weathering velocity (percent method) and smooth refractor using shortcut");
            hist.add(String.format("Percent = %f", Float.valueOf((float)percent)));
            hist.add(String.format("Smoothing radius = %f", Float.valueOf((float)rad)));
            hist.save();
            this.reloadHistory();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void shortcut() {
        try {
            try {
                ClassLoader cl = ClassLoader.getSystemClassLoader();
                Field f = ClassLoader.class.getDeclaredField("classes");
                f.setAccessible(true);
                Vector classes = (Vector)f.get(cl);
                System.out.println("classes.size = " + classes.size());
            }
            catch (Exception cl) {
                // empty catch block
            }
            String paramFile = this.m_project.guiOptionsPath() + "/ModelShortCut.xml";
            ParameterTree tree = new ParameterTree();
            tree.read(paramFile);
            if (this.m_shortCutDialog == null) {
                this.m_shortCutDialog = new MultiTextDialog(null, "Model parameters", "First define the weathering velocity:", "Refractor smoothing radius");
            }
            this.m_shortCutDialog.setText(0, tree.string_get("V0", "3000"));
            this.m_shortCutDialog.setText(1, tree.string_get("RAD", "1000"));
            this.m_shortCutDialog.showDialog("Apply");
            if (!this.m_shortCutDialog.OK) {
                return;
            }
            double v0 = this.m_shortCutDialog.getDouble(0, 3000.0, 500.0, 20000.0);
            double rad = this.m_shortCutDialog.getDouble(1, 1000.0, 100.0, 10000.0);
            tree.double_put("V0", v0);
            tree.double_put("RAD", rad);
            tree.save(paramFile);
            DelayTimeModel_ModInfo modInfoV0 = new DelayTimeModel_ModInfo();
            modInfoV0.ModifyVelocity = true;
            modInfoV0.Refractor = 0;
            modInfoV0.ConstantValue = v0;
            modInfoV0.ModificationMethod = modInfoV0.Mod_Constant;
            modInfoV0.Follow = DelayTimeModel_ModInfo.FollowupOptions.ModifyElevations;
            DelayTimeModel.singleton().performRequestedMods(modInfoV0);
            DelayTimeModel_ModInfo modInfoZ1 = new DelayTimeModel_ModInfo();
            modInfoZ1.ModifyElevation = true;
            modInfoZ1.Refractor = 1;
            modInfoZ1.SmoothRadius = rad;
            modInfoZ1.ModificationMethod = modInfoZ1.Mod_GridSmooth;
            modInfoZ1.Follow = DelayTimeModel_ModInfo.FollowupOptions.ModifyWeathering;
            DelayTimeModel.singleton().performRequestedMods(modInfoZ1);
            this.reloadPlot();
            this.reloadColumns();
            History hist = this.m_delayTimeData.getHistory();
            hist.addWithTime("Set weathering velocity and smooth refractor using shortcut");
            hist.add(String.format("Weathering velocity = %f", Float.valueOf((float)v0)));
            hist.add(String.format("Smoothing radius = %f", Float.valueOf((float)rad)));
            hist.save();
            this.reloadHistory();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void interpBranchV0() {
        try {
            DelayTimeModel.singleton().setBranchInterpolatedV0(this.m_project.receiverTable());
            DelayTimeModel.singleton().setBranchInterpolatedV0(this.m_project.shotTable());
            DelayTimeModel.singleton().computeRefractorElevations(this.m_project.receiverTable());
            DelayTimeModel.singleton().computeRefractorElevations(this.m_project.shotTable());
            this.reloadPlot();
            this.m_delayTimeData.getHistory().addWithTime("Weathering velocity set using branch offsets/times");
            this.m_delayTimeData.getHistory().save();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.m_btnSegyExport == e.getSource()) {
                Action_DelayTime_SegyModelExport action = new Action_DelayTime_SegyModelExport();
                RefractionStaticsProject.singleton().executeSingleAction(action);
                return;
            }
            this.m_colorCombo.setEnabled(this.m_radDatabase.isSelected());
            this.m_layerCombo.setEnabled(this.m_radThickness.isSelected());
            if (this.m_btnReloadHist == e.getSource()) {
                this.reloadHistory();
                return;
            }
            if (e.getSource() == this.m_clearPolygonButton) {
                RefractionStaticsProject.singleton().polygon().clear();
                RefractionStaticsProject.singleton().savePolygon();
                Messenger.broadcast(Messenger.Message.ProjectPolygonModified, this, null);
                return;
            }
            if (e.getSource() == this.m_staticsButton) {
                this.computeStatics();
                return;
            }
            if (e.getSource() == this.m_staticsElevButton) {
                this.computeElevStatics();
                return;
            }
            if (e.getSource() == this.m_chkDisplayAsGrid) {
                this.reloadPlot();
                return;
            }
            if (e.getSource() == this.m_modButton) {
                this.modModel();
                return;
            }
            if (e.getSource() == this.m_txtSize) {
                this.reloadPlot();
                return;
            }
            if (e.getSource() == this.m_radDatabase) {
                this.reloadPlot();
                return;
            }
            if (e.getSource() == this.m_reloadPlotButton) {
                this.reloadPlot();
                return;
            }
            if (e.getSource() == this.m_radThickness) {
                this.reloadPlot();
                return;
            }
            if (e.getSource() == this.m_reloadColumnsButton) {
                this.reloadColumns();
                this.reloadPlot();
                return;
            }
            if (e.getSource() == this.m_displayRecCheck || e.getSource() == this.m_displayShotCheck || e.getSource() == this.m_displayDtAnisCheck) {
                this.reloadPlot();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected static enum MouseMode {
        Polygon("Define project polygon"),
        Shot("Select shot "),
        Receiver("Select receiver");

        public final String Description;

        private MouseMode(String desc) {
            this.Description = desc;
        }
    }
}

