/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import java.awt.Color;
import java.util.ArrayList;

public class BranchColors {
    protected ArrayList<Color> m_solidColor = new ArrayList();
    protected ArrayList<Color> m_fadeColor = new ArrayList();
    protected static BranchColors m_singleton = null;

    protected BranchColors() {
        try {
            this.addColor(200, 200, 200);
            this.addColor(0, 0, 166);
            this.addColor(0, 166, 0);
            this.addColor(166, 0, 0);
            this.addColor(255, 0, 255);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void addColor(int r, int g, int b) {
        try {
            this.m_solidColor.add(new Color(r, g, b));
            this.m_fadeColor.add(new Color(r, g, b, 40));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static BranchColors singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new BranchColors();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected Color getFadeColor(int branch) {
        if (branch >= 0 && branch < this.m_fadeColor.size()) {
            return this.m_fadeColor.get(branch);
        }
        return Color.LIGHT_GRAY;
    }

    public static Color fadeColor(int branch) {
        return BranchColors.singleton().getFadeColor(branch);
    }

    protected Color getSolidColor(int branch) {
        if (branch >= 0 && branch < this.m_solidColor.size()) {
            return this.m_solidColor.get(branch);
        }
        return Color.LIGHT_GRAY;
    }

    public static Color solidColor(int branch) {
        return BranchColors.singleton().getSolidColor(branch);
    }
}

