/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.DelayTime;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.DelayTime.BranchAssignment;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeData;
import com.PecosLibrary.Refraction.DelayTime.UpholeCorrection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Shared.RadioPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class AdvancedDelayTimeOptionsDialog
extends JDialog
implements ActionListener,
GenericObjectListener.Listener {
    protected RefractionStaticsProject m_project;
    protected DelayTimeData m_delayTimeData;
    protected BranchAssignment m_branchAssignment;
    protected JTextField m_txtVelocitySmoothRadius = new JTextField("1000");
    protected JTextField m_txtVelocityMaxPercentVariation = new JTextField("30");
    protected int m_num_lim = 6;
    protected ArrayList<JCheckBox> m_list_chk_apply_lim = new ArrayList();
    protected ArrayList<JTextField> m_list_le_lim_min = new ArrayList();
    protected ArrayList<JTextField> m_list_le_lim_max = new ArrayList();
    protected JCheckBox m_chkAnis = new JCheckBox("Compute delay time anisotropy term");
    protected JTextField m_txtAnisMaxAmp = new JTextField("12");
    protected JTextField m_anisGridSize = new JTextField("1000");
    protected JTextField m_txtRangeCompression = new JTextField("1.5");
    protected JCheckBox m_chkRangeCompression = new JCheckBox("Apply velocity range compression");
    protected JCheckBox m_chkGeometryAnalysis = new JCheckBox("Perform geometry error analysis");
    protected JCheckBox m_chkEnsureNoBias = new JCheckBox("Ensure no DC bias between shot and receiver delay times");
    protected JTextField m_txtMinValidFold = new JTextField("3");
    protected JCheckBox m_chkForceTheSame = new JCheckBox("Bin the shot and receiver delay times");
    protected JTextField m_txtNearbyDistance = new JTextField("30");
    protected RadioPanel m_radioUphole;
    protected RadioPanel m_radioInterpolation;
    protected JRadioButton m_radUserErrorWeight = new JRadioButton("User-defined error weight corner");
    protected JRadioButton m_radProgramErrorWeight = new JRadioButton("Program selects error weight corner");
    protected ButtonGroup m_groupError = new ButtonGroup();
    protected JTextField m_txtErrorWeightCorner = new JTextField("200");
    protected JCheckBox m_chkAllowUpdateShotDT = new JCheckBox("Update shot delay times");
    protected JCheckBox m_chkAllowUpdateRecDT = new JCheckBox("Update receiver delay times");
    protected JCheckBox m_chkAllowUpdateVel = new JCheckBox("Refractor velocities");
    protected JButton m_btnOK = new JButton("Okay");
    protected JButton m_btnCancel = new JButton("Cancel");
    public boolean OK = false;

    public boolean applyRangeCompression() {
        return this.m_chkRangeCompression.isSelected();
    }

    public double rangeCompression() {
        return Tools_Widget.extractDouble(this.m_txtRangeCompression, 2.0, 1.0, 100.0);
    }

    public boolean apply_velocity_limits(int branch) {
        int index = branch - 1;
        index = Math.max(0, index);
        index = Math.min(this.m_num_lim - 1, index);
        return this.m_list_chk_apply_lim.get(index).isSelected();
    }

    public double vel_min(int branch) {
        int index = branch - 1;
        index = Math.max(0, index);
        index = Math.min(this.m_num_lim - 1, index);
        return Tools_Widget.extractDouble(this.m_list_le_lim_min.get(index), 1000.0, 10.0, 30000.0);
    }

    public double vel_max(int branch) {
        int index = branch - 1;
        index = Math.max(0, index);
        index = Math.min(this.m_num_lim - 1, index);
        return Tools_Widget.extractDouble(this.m_list_le_lim_max.get(index), 1000.0, 10.0, 30000.0);
    }

    public Hashtable<Integer, Boolean> hash_vel_lim_apply() {
        Hashtable<Integer, Boolean> h = new Hashtable<Integer, Boolean>();
        for (int n = 0; n < this.m_num_lim; ++n) {
            h.put(n + 1, this.m_list_chk_apply_lim.get(n).isSelected());
        }
        return h;
    }

    public Hashtable<Integer, Double> hash_vel_lim_min() {
        Hashtable<Integer, Double> h = new Hashtable<Integer, Double>();
        for (int n = 0; n < this.m_num_lim; ++n) {
            h.put(n + 1, this.vel_min(n + 1));
        }
        return h;
    }

    public Hashtable<Integer, Double> hash_vel_lim_max() {
        Hashtable<Integer, Double> h = new Hashtable<Integer, Double>();
        for (int n = 0; n < this.m_num_lim; ++n) {
            h.put(n + 1, this.vel_max(n + 1));
        }
        return h;
    }

    public boolean performGeometryAnalysis() {
        return this.m_chkGeometryAnalysis.isSelected();
    }

    public boolean allowUpdateShot() {
        return this.m_chkAllowUpdateShotDT.isSelected();
    }

    public boolean allowUpdateVel() {
        return this.m_chkAllowUpdateVel.isSelected();
    }

    public boolean allowUpdateRec() {
        return this.m_chkAllowUpdateRecDT.isSelected();
    }

    public boolean userSelectedErrorCorner() {
        return this.m_radUserErrorWeight.isSelected();
    }

    public double userErrorCorner() {
        return Tools_Widget.extractDouble(this.m_txtErrorWeightCorner, 20.0, 1.0, 1000.0);
    }

    public boolean forceTheSame() {
        return this.m_chkForceTheSame.isSelected();
    }

    public double nearbyDistance() {
        return Tools_Widget.extractDouble(this.m_txtNearbyDistance, 30.0, 5.0, 1000.0);
    }

    public boolean ensureNoBias() {
        return this.m_chkEnsureNoBias.isSelected();
    }

    public double velSmoothRadius() {
        return Tools_Widget.extractDouble(this.m_txtVelocitySmoothRadius, 1000.0, 1.0, 20000.0);
    }

    public double velMaxPercentVariation() {
        return Tools_Widget.extractDouble(this.m_txtVelocityMaxPercentVariation, 30.0, 1.0, 100.0);
    }

    public double anisGridSize() {
        return Tools_Widget.extractDouble(this.m_anisGridSize, 1000.0, 100.0, 8000.0);
    }

    public double anisMaxAmp() {
        return Tools_Widget.extractDouble(this.m_txtAnisMaxAmp, 0.0, 0.0, 500.0);
    }

    public boolean computeAnisotropy() {
        return this.m_chkAnis.isSelected();
    }

    public UpholeCorrection.Method upholeMethod() {
        if (this.m_radioUphole.getSelectedIndex() == 1) {
            return UpholeCorrection.Method.JustUseUpholeTime;
        }
        if (this.m_radioUphole.getSelectedIndex() == 2) {
            return UpholeCorrection.Method.None;
        }
        return UpholeCorrection.Method.SoftwareDeterminesBest;
    }

    public boolean interpolateUsingInverseSquare() {
        try {
            return this.m_radioInterpolation.getSelectedIndex() == 1;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public AdvancedDelayTimeOptionsDialog(boolean showDelayTimeOptions, boolean showVelocityOptions, boolean showAnisOptions) {
        try {
            JTabbedPane tabs = new JTabbedPane();
            this.m_project = RefractionStaticsProject.singleton();
            this.m_delayTimeData = this.m_project.getDelayTimeData();
            this.m_branchAssignment = this.m_delayTimeData.branchAssignment();
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget tab1 = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            GridLayoutWidget gv = tab1.createGridLayoutWidget(0, "Velocity constraints", 0);
            int row = 0;
            gv.addSimple(row++, new JLabel("Refractor velocity smoothing radius"), this.m_txtVelocitySmoothRadius);
            gv.addSimple(row++, new JLabel("Maximum velocity variation (percent)"), this.m_txtVelocityMaxPercentVariation);
            gv.addSimple(row++, new JLabel(""), this.m_chkRangeCompression);
            gv.addSimple(row++, new JLabel("Compression scalar ( >= 1)"), this.m_txtRangeCompression);
            gv = tab1.createGridLayoutWidget(0, "Refractor velocity limits", 0);
            gv.createLabel("Minimum velocity", 0, 1);
            gv.createLabel("Maximum velocity", 0, 2);
            row = 1;
            for (int n = 0; n < this.m_num_lim; ++n) {
                String s = "Apply limits to refractor " + String.valueOf(n + 1);
                JCheckBox chk = new JCheckBox(s);
                JTextField txt1 = new JTextField("1000");
                JTextField txt2 = new JTextField("25000");
                this.m_list_chk_apply_lim.add(chk);
                this.m_list_le_lim_min.add(txt1);
                this.m_list_le_lim_max.add(txt2);
                gv.addComponent(chk, row, 0);
                gv.addComponent(txt1, row, 1);
                gv.addComponent(txt2, row, 2);
                ++row;
            }
            gv = tab1.createGridLayoutWidget(0, "Geometry error analysis", 0);
            row = 0;
            gv.addComponent(this.m_chkGeometryAnalysis, row++, 0);
            this.m_chkGeometryAnalysis.setSelected(true);
            tab1.addStretch(10);
            tabs.addTab("Velocity and geometry update options", tab1);
            LinearLayoutWidget tab2 = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
            LinearLayoutWidget suba = tab2.createVertical(0, "Update permissions", 0);
            suba.addComponent(this.m_chkAllowUpdateShotDT, 0);
            suba.addComponent(this.m_chkAllowUpdateRecDT, 0);
            suba.addComponent(this.m_chkAllowUpdateVel, 0);
            this.m_chkAllowUpdateShotDT.setSelected(true);
            this.m_chkAllowUpdateRecDT.setSelected(true);
            this.m_chkAllowUpdateVel.setSelected(true);
            GridLayoutWidget ga = tab2.createGridLayoutWidget(0, "Delay time anisotropy options", 0);
            ga.addSimple(0, new JLabel(""), this.m_chkAnis);
            ga.addSimple(1, new JLabel("Maximum allowed anisotropy (ms)"), this.m_txtAnisMaxAmp);
            ga.addSimple(2, new JLabel("Analysis grid size (ft/m)"), this.m_anisGridSize);
            tab2.addComponent(this.m_chkEnsureNoBias, 0);
            this.m_chkEnsureNoBias.setSelected(true);
            this.m_radioUphole = new RadioPanel(LinearLayoutWidget.Direction.Vertical, "Uphole correction method", UpholeCorrection.Method.values()[0].Description, UpholeCorrection.Method.values()[1].Description, UpholeCorrection.Method.values()[2].Description);
            tab2.addComponent(this.m_radioUphole, 0);
            this.m_radioInterpolation = new RadioPanel(LinearLayoutWidget.Direction.Vertical, "Interpolation method for low fold shots and receivers", "Use a sparse grid based approach", "Use inverse square approach - may be very slow");
            tab2.addComponent(this.m_radioInterpolation, 0);
            JLabel lbl = new JLabel("<html>Shots and receivers with less than the minimum vald fold will <br> have their delay times interpolated from their neighbors </html>");
            LinearLayoutWidget lay = tab2.createVertical(0, "Minimum valid fold", 0);
            lay.addComponent(lbl, 0);
            lay.addHorzPair(new JLabel("Minimum valid branch pick fold"), 0, this.m_txtMinValidFold, 8);
            lbl = new JLabel("<html>Force nearby shots and receivers to have the same delay times by binning</html>");
            lay = tab2.createVertical(0, "Bin nearby delay times", 0);
            lay.addComponent(this.m_chkForceTheSame, 0);
            lay.addComponent(lbl, 0);
            lay.addHorzPair(new JLabel("Binning size"), 0, this.m_txtNearbyDistance, 8);
            LinearLayoutWidget err = tab2.createVertical(0, "Error weighting corner", 0);
            err.addComponent(this.m_radProgramErrorWeight, 0);
            err.addComponent(this.m_radUserErrorWeight, 0);
            err.addHorzPair(new JLabel("Error corner (milliseconds)"), 0, this.m_txtErrorWeightCorner, 5);
            this.m_groupError.add(this.m_radUserErrorWeight);
            this.m_groupError.add(this.m_radProgramErrorWeight);
            this.m_radProgramErrorWeight.setSelected(true);
            this.m_radProgramErrorWeight.addActionListener(this);
            this.m_radUserErrorWeight.addActionListener(this);
            this.m_txtErrorWeightCorner.setEnabled(this.m_radUserErrorWeight.isSelected());
            tab2.addStretch(10);
            tabs.addTab("Delay time options", tab2);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addComponent(this.m_btnOK, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnOK.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)tabs, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(1);
            this.pack();
            this.setTitle("Delay time analysis options");
            this.setLocationRelativeTo(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void showDialog() {
        try {
            this.OK = false;
            UpholeCorrection.Method method = this.m_project.getUpholeCorrectionMethod();
            int upholeIndex = UpholeCorrection.getIndexFromMethod(method);
            this.m_radioUphole.setSelectedIndex(upholeIndex);
            this.m_txtMinValidFold.setText(Integer.toString(this.m_project.getMinimumValidBranchPickFold()));
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.m_txtErrorWeightCorner.setEnabled(this.m_radUserErrorWeight.isSelected());
            if (e.getSource() == this.m_btnOK) {
                int index = this.m_radioUphole.getSelectedIndex();
                UpholeCorrection.Method method = UpholeCorrection.getMethodFromIndex(index);
                this.m_project.setUpholeCorrectionMethod(method);
                int mp = Tools_Widget.extractInteger(this.m_txtMinValidFold, 4, 1, 11);
                this.m_project.putMinimumValidBranchPickFold(mp);
                this.OK = true;
                this.dispose();
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

