/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Database;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class UniqueColumnCombo
extends LinearLayoutWidget
implements ItemListener,
ActionListener {
    protected JComboBox<String> m_combo = new JComboBox();
    protected JTextField m_txt = new JTextField();
    protected JButton m_btnLoad;
    protected boolean m_ignore = true;
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected Table_Abstract m_table;
    protected String m_colNameID;
    protected boolean m_colNameValid = false;
    protected boolean m_usingID = false;
    protected int m_selectedID = 1000;
    protected HashMap_Integer m_mapValueID = new HashMap_Integer();
    protected HashMap_Integer m_mapKeyID = new HashMap_Integer();
    protected int m_maxKey = Integer.MIN_VALUE;
    protected int m_minKey = Integer.MAX_VALUE;
    protected int m_maxID = Integer.MIN_VALUE;
    protected int m_minID = Integer.MAX_VALUE;
    protected HashMap<String, String> m_preferredColumn = new HashMap();
    protected HashMap<String, Integer> m_preferredID = new HashMap();

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public UniqueColumnCombo() {
        super(LinearLayoutWidget.Direction.Horizontal, 0, null);
        try {
            this.m_combo.addItemListener(this);
            this.m_combo.setEditable(false);
            this.m_txt.addActionListener(this);
            this.addComponent(this.m_combo, 10);
            this.addComponent(this.m_txt, 10);
            this.m_btnLoad = this.createButton("Load", this, 10);
            this.m_txt.setPreferredSize(new Dimension(100, this.m_txt.getSize().height));
            this.m_txt.setMinimumSize(new Dimension(100, this.m_txt.getSize().height));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setTextBackColor(Color c) {
        try {
            this.m_txt.setBackground(c);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prepHash() {
        try {
            this.m_mapValueID = new HashMap_Integer();
            this.m_mapKeyID = new HashMap_Integer();
            this.m_maxKey = Integer.MIN_VALUE;
            this.m_minKey = Integer.MAX_VALUE;
            this.m_maxID = Integer.MIN_VALUE;
            this.m_minID = Integer.MAX_VALUE;
            String sel = (String)this.m_combo.getSelectedItem();
            this.m_preferredColumn.put(this.m_table.name(), sel);
            this.m_usingID = sel.equalsIgnoreCase(this.m_colNameID);
            int indexID = this.m_table.column_indexOfColumn(this.m_colNameID);
            int indexKey = this.m_table.column_indexOfColumn(sel);
            for (int r = 0; r < this.m_table.row_count(); ++r) {
                int id = this.m_table.getInt(r, indexID);
                int key = this.m_table.getInt(r, indexKey);
                this.m_maxID = Math.max(this.m_maxID, id);
                this.m_minID = Math.min(this.m_minID, id);
                this.m_maxKey = Math.max(this.m_maxKey, key);
                this.m_minKey = Math.min(this.m_minKey, key);
                this.m_mapValueID.put(key, id);
                this.m_mapKeyID.put(id, key);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void getID() {
        try {
            if (this.m_mapKeyID.size() < 1) {
                return;
            }
            int key = Tools_Widget.extractInteger(this.m_txt, 0, -2000000000, 2000000000);
            key = Math.max(key, this.m_minKey);
            if (!this.m_mapValueID.containsKey(key = Math.min(key, this.m_maxKey))) {
                int maxerr = 100000000;
                for (int inc = 1; inc < maxerr; ++inc) {
                    if (this.m_mapValueID.containsKey(key + inc)) {
                        key += inc;
                        inc = maxerr;
                    }
                    if (!this.m_mapValueID.containsKey(key - inc)) continue;
                    key -= inc;
                    inc = maxerr;
                }
            }
            this.setSelectedID(this.m_mapValueID.get(key));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int getSelectedID() {
        try {
            this.getID();
            return this.m_selectedID;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 1000;
        }
    }

    public void setSelectedID(int id) {
        try {
            if (this.m_mapKeyID.containsKey(id)) {
                this.m_selectedID = id;
                this.m_preferredID.put(this.m_table.name(), new Integer(id));
                int val = this.m_mapKeyID.get(id);
                this.m_txt.setText(Integer.toString(val));
                return;
            }
            this.m_txt.setText("Bad ID");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setTable(Table_Abstract table) {
        try {
            this.setStringArray(new ArrayList<String>());
            this.setEnabled(false);
            this.m_btnLoad.setEnabled(false);
            this.m_combo.setEnabled(false);
            this.m_txt.setEnabled(false);
            this.m_table = table;
            if (table == null) {
                this.m_ignore = true;
                this.m_combo.removeAllItems();
                this.m_txt.setText("");
                return;
            }
            if (this.m_table.column_count() < 1) {
                return;
            }
            this.m_btnLoad.setEnabled(true);
            this.m_combo.setEnabled(true);
            this.m_txt.setEnabled(true);
            this.m_colNameID = this.m_table.name() + "ID";
            this.m_colNameValid = false;
            boolean what = false;
            ArrayList<String> cols = new ArrayList<String>();
            for (int c = 0; c < this.m_table.column_count(); ++c) {
                String col = this.m_table.column_name(c);
                int index = this.m_table.column_indexOfColumn(col);
                if (index != c) {
                    what = true;
                }
                HashMap_Integer map = new HashMap_Integer();
                boolean okay = true;
                for (int r = 0; okay && r < this.m_table.row_count(); ++r) {
                    int v = this.m_table.getInt(r, c);
                    if (map.containsKey(v)) {
                        okay = false;
                        continue;
                    }
                    map.put(v, v);
                }
                if (!okay) continue;
                cols.add(col);
                this.m_colNameValid = this.m_colNameValid || this.m_colNameID.equalsIgnoreCase(col);
            }
            Collections.sort(cols);
            this.setStringArray(cols);
            if (this.m_preferredColumn.containsKey(this.m_table.name())) {
                this.setPreferredSelected(this.m_preferredColumn.get(this.m_table.name()));
            } else {
                this.setPreferredSelected(this.m_colNameID);
            }
            this.prepHash();
            if (this.m_preferredID.containsKey(this.m_table.name())) {
                this.setSelectedID(this.m_preferredID.get(this.m_table.name()));
            } else {
                this.setSelectedID(1000);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void setPreferredSelected(String pref) {
        try {
            if (this.m_combo.getItemCount() < 1) {
                return;
            }
            this.m_ignore = true;
            for (int n = 0; n < this.m_combo.getItemCount(); ++n) {
                String s = this.m_combo.getItemAt(n);
                if (!s.equalsIgnoreCase(pref)) continue;
                this.m_combo.setSelectedIndex(n);
                this.m_ignore = false;
                return;
            }
            this.m_ignore = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void setStringArray(ArrayList<String> list) {
        try {
            this.m_ignore = true;
            this.m_combo.removeAllItems();
            if (list == null) {
                return;
            }
            if (list.size() < 1) {
                return;
            }
            int selIndex = -1;
            for (int n = 0; n < list.size(); ++n) {
                String s = list.get(n);
                this.m_combo.addItem(s);
            }
            this.m_ignore = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getID();
            this.m_listener.broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (this.m_ignore) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            if (this.m_combo.getItemCount() < 1) {
                return;
            }
            this.prepHash();
            this.setSelectedID(this.m_selectedID);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

