/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Database;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.PolygonUsage;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class SmoothValueUsingPolygonDialog
extends JDialog
implements GenericObjectListener.Listener,
ActionListener {
    protected RefractionStaticsProject m_project;
    protected JButton m_btnCancel = new JButton("Close");
    protected JButton m_btnInterpolate = new JButton("Smooth value inside polygon");
    protected JCheckBox m_shotCheck = new JCheckBox("Modify the shot table");
    protected JCheckBox m_recCheck = new JCheckBox("Modify the receiver table");
    protected JCheckBox m_extrapolateCheck = new JCheckBox("Extrapolate outside the polygon");
    protected JCheckBox m_useShotCheck = new JCheckBox("Use the shot table");
    protected JCheckBox m_useRecCheck = new JCheckBox("Use the receiver table");
    protected ComboStringListWrapper m_combo = new ComboStringListWrapper();
    protected JTextField m_radiusText = new JTextField("500");
    protected JLabel m_label = new JLabel("ll");
    protected double[] m_x = null;
    protected double[] m_y = null;
    protected double[] m_v = null;
    protected int m_count = 0;

    public SmoothValueUsingPolygonDialog() {
        try {
            this.m_project = RefractionStaticsProject.singleton();
            this.getContentPane().setLayout(new BorderLayout());
            LinearLayoutWidget main = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, null);
            LinearLayoutWidget sub = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Modify which column", 0);
            sub.addComponent(this.m_combo, 0);
            sub.addComponent(this.m_label, 0);
            this.m_combo.listener().addListener(this);
            this.m_combo.setPreferredSelected("Elevation");
            LinearLayoutWidget linearLayoutWidget = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Smoothing radius (inverse square smoother)", 0);
            GridLayoutWidget grid = linearLayoutWidget.createGridLayoutWidget(3, 0);
            grid.addSimple(0, new JLabel("Smoothing radius"), this.m_radiusText);
            main.addComponent(this.m_extrapolateCheck, 0);
            sub = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Modify which tables", 0);
            sub.addComponent(this.m_shotCheck, 0);
            sub.addComponent(this.m_recCheck, 0);
            this.m_shotCheck.addActionListener(this);
            this.m_shotCheck.setSelected(true);
            this.m_recCheck.addActionListener(this);
            this.m_recCheck.setSelected(true);
            sub = main.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 3, "Use these tables to compute smoothed values", 0);
            sub.addComponent(this.m_useShotCheck, 0);
            sub.addComponent(this.m_useRecCheck, 0);
            this.m_useShotCheck.addActionListener(this);
            this.m_useShotCheck.setSelected(true);
            this.m_useRecCheck.addActionListener(this);
            this.m_useRecCheck.setSelected(true);
            LinearLayoutWidget bottom = new LinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 3, null);
            bottom.addStretch(10);
            bottom.addComponent(this.m_btnInterpolate, 0);
            bottom.addComponent(this.m_btnCancel, 0);
            bottom.addStretch(10);
            this.m_btnInterpolate.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bottom, "South");
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.setDefaultCloseOperation(2);
            this.pack();
            this.reloadColumns();
            this.setTitle("Set value inside polygon");
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.requestFocus();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void reloadColumns() {
        try {
            boolean rec = this.m_recCheck.isSelected();
            boolean shot = this.m_shotCheck.isSelected();
            ArrayList<String> colList = null;
            if (shot && !rec) {
                colList = this.database().listOfColumnNames("Shot");
            }
            if (!shot && rec) {
                colList = this.database().listOfColumnNames("Receiver");
            }
            if (shot && rec) {
                colList = this.database().listOfColumnNames("Receiver", "Shot");
            }
            this.m_combo.setEnabled(colList != null);
            if (colList != null) {
                this.m_combo.setStringArray(colList);
            }
            this.checkSelected();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void modifyInsidePolygon() {
        try {
            int n;
            boolean okay;
            if (!this.checkSelected()) {
                return;
            }
            String col = this.m_combo.getSelectedString();
            Table_Abstract shotTable = this.m_project.shotTable();
            boolean shotOkay = this.m_useShotCheck.isSelected() && shotTable.column_exists(col);
            Table_Abstract recTable = this.m_project.receiverTable();
            boolean recOkay = this.m_useRecCheck.isSelected() && recTable.column_exists(col);
            boolean bl = okay = shotOkay || recOkay;
            if (!okay) {
                JOptionPane.showMessageDialog(null, "Select use shot or use receiver", "Cannot smooth", 0);
                return;
            }
            this.m_x = new double[recTable.row_count() + shotTable.row_count()];
            this.m_y = new double[recTable.row_count() + shotTable.row_count()];
            this.m_v = new double[recTable.row_count() + shotTable.row_count()];
            this.m_count = 0;
            if (this.m_useRecCheck.isSelected() && recTable.column_exists(col)) {
                int indexRecX = recTable.column_indexOfColumn("Easting");
                int indexRecY = recTable.column_indexOfColumn("Northing");
                int indexRecDead = recTable.column_indexOfColumn("Killed");
                int indexRec = recTable.column_indexOfColumn(col);
                for (n = 0; n < recTable.row_count(); ++n) {
                    if (recTable.getBool(n, indexRecDead)) continue;
                    this.m_x[this.m_count] = recTable.getDouble(n, indexRecX);
                    this.m_y[this.m_count] = recTable.getDouble(n, indexRecY);
                    this.m_v[this.m_count] = recTable.getDouble(n, indexRec);
                    ++this.m_count;
                }
            }
            if (this.m_useShotCheck.isSelected() && shotTable.column_exists(col)) {
                int indexShotX = shotTable.column_indexOfColumn("Easting");
                int indexShotY = shotTable.column_indexOfColumn("Northing");
                int indexShotDead = shotTable.column_indexOfColumn("Killed");
                int indexShot = shotTable.column_indexOfColumn(col);
                for (n = 0; n < shotTable.row_count(); ++n) {
                    if (shotTable.getBool(n, indexShotDead)) continue;
                    this.m_x[this.m_count] = shotTable.getDouble(n, indexShotX);
                    this.m_y[this.m_count] = shotTable.getDouble(n, indexShotY);
                    this.m_v[this.m_count] = shotTable.getDouble(n, indexShot);
                    ++this.m_count;
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.m_recCheck.isSelected()) {
                this.getFromPolygon(this.m_project.receiverTable());
                this.database().writeColumnContentsToDatabase(this.m_project.receiverTable(), col);
            }
            if (this.m_shotCheck.isSelected()) {
                this.getFromPolygon(this.m_project.shotTable());
                this.database().writeColumnContentsToDatabase(this.m_project.shotTable(), col);
            }
            if (this.m_extrapolateCheck.isSelected()) {
                Tools_RefractionStaticsProject.cutAndRepairUsingPolygon(col, PolygonUsage.Outside);
            }
            this.m_project.reloadAllData();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void getFromPolygon(Table_Abstract table) {
        try {
            Java2D_Polygon poly = this.m_project.polygon();
            String col = this.m_combo.getSelectedString();
            String tableName = table.name();
            double radius = Tools_Widget.extractDouble(this.m_radiusText, 0.0, 1.0, 100000.0);
            radius *= radius;
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int index = table.column_indexOfColumn(col);
            for (int row = 0; row < table.row_count(); ++row) {
                double y;
                double x = table.getDouble(row, indexX);
                if (!poly.contains(x, y = table.getDouble(row, indexY))) continue;
                double sum1 = 0.0;
                double sum2 = 1.0E-70;
                for (int n = 0; n < this.m_count; ++n) {
                    double dx = x - this.m_x[n];
                    double dy = y - this.m_y[n];
                    double v = this.m_v[n];
                    double w = radius / (radius + dx * dx + dy * dy);
                    sum1 += w * v;
                    sum2 += w;
                }
                table.putDouble(row, index, sum1 / sum2);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean checkSelected() {
        try {
            boolean required;
            boolean modOkay = this.m_recCheck.isSelected() || this.m_shotCheck.isSelected();
            this.m_btnInterpolate.setEnabled(false);
            if (!modOkay) {
                this.m_label.setText("Must modify at least one table");
                this.m_label.setForeground(Color.red);
                return false;
            }
            if (!this.m_combo.isEnabled()) {
                this.m_label.setText("Cannot modify column - no table selected?");
                this.m_label.setForeground(Color.red);
                return false;
            }
            String col = this.m_combo.getSelectedString();
            boolean bl = required = col.equalsIgnoreCase("Easting") || col.equalsIgnoreCase("Northing") || col.equalsIgnoreCase("LineNumber") || col.equalsIgnoreCase("PointNumber") || col.equalsIgnoreCase("PointIndex") || col.equalsIgnoreCase("ShotID") || col.equalsIgnoreCase("ReceiverID");
            if (required) {
                this.m_label.setText("Cannot modify required column");
                this.m_label.setForeground(Color.red);
                return false;
            }
            this.m_label.setText("Okay to modify this column");
            this.m_label.setForeground(Color.blue);
            this.m_btnInterpolate.setEnabled(true);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected IDatabaseConnection database() {
        try {
            return RefractionStaticsProject.singleton().geometryDatabase();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            this.checkSelected();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_recCheck || e.getSource() == this.m_shotCheck) {
                this.reloadColumns();
                return;
            }
            if (e.getSource() == this.m_btnInterpolate) {
                this.modifyInsidePolygon();
                return;
            }
            if (e.getSource() == this.m_btnCancel) {
                this.dispose();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

