/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Refraction.Database;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.IComponentManager;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Action.Geometry.Action_ExportAllProjects;
import com.PecosLibrary.Action.JDBC.Action_CreateTraceTable;
import com.PecosLibrary.Echos.XtEchos;
import com.PecosLibrary.Refraction.DatabaseEnum;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_SpecialCases;
import com.PecosLibrary.Windows.ASCII.AsciiImportWidget;
import com.PecosLibrary.Windows.Echos.Environment;
import com.PecosLibrary.Windows.Echos.ExportGeometryToEchosDatabaseDialog;
import com.PecosLibrary.Windows.Echos.ExportToEchosDatabaseDialog;
import com.PecosLibrary.Windows.Echos.ImportFromEchosDatabaseDialog;
import com.PecosLibrary.Windows.Geometry.PatternAnalysisWidget;
import com.PecosLibrary.Windows.Geometry.SPSTopLevelWidget;
import com.PecosLibrary.Windows.JDBC.BasemapWidget;
import com.PecosLibrary.Windows.JDBC.ColumnComparisonWidget;
import com.PecosLibrary.Windows.JDBC.ImportColumnDelimitedTableDialog;
import com.PecosLibrary.Windows.JDBC.KrigingTestWidget;
import com.PecosLibrary.Windows.JDBC.MultiBasemapWidget;
import com.PecosLibrary.Windows.JDBC.OutlierMeasurementWidget;
import com.PecosLibrary.Windows.JDBC.ProjectComparisonWidget;
import com.PecosLibrary.Windows.JDBC.SelectTableDialog;
import com.PecosLibrary.Windows.JDBC.TableWrapperWidget;
import com.PecosLibrary.Windows.JDBC.TwoDStackedDatabaseWidget;
import com.PecosLibrary.Windows.Refraction.Database.DropColumnsDialog;
import com.PecosLibrary.Windows.Refraction.Database.SegyHeaderExportDialog;
import com.PecosLibrary.Windows.Refraction.Database.SeismicFileManagerDialog;
import com.PecosLibrary.Windows.Refraction.Database.VersionManagerDialog;
import com.PecosLibrary.Windows.Refraction.DefineGridDialog;
import com.PecosLibrary.Windows.Refraction.DelayTime.VerticalProfileWidget;
import com.PecosLibrary.Windows.Refraction.ReceiverTableWidget;
import com.PecosLibrary.Windows.Refraction.ShotTableWidget;
import com.PecosLibrary.Windows.Refraction.TraceTableWidget;
import com.PecosLibrary.Windows.Segy.CompressSegyDialog;
import com.PecosLibrary.Windows.Segy.TraceSelectSegyFileDialog;
import com.PecosLibrary.Windows.Shared.BatchProcessingDialog;
import com.PecosLibrary.Windows.Shared.InputDataProcessingDialog;
import com.PecosLibrary.Windows.Shared.MultiTextDialog;
import com.PecosLibrary.Windows.Spreadsheet.SpreadsheetImportWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class Menu_RefractionDatabase
implements ActionListener {
    protected JMenu m_menu = new JMenu("Database");
    protected JMenuItem m_menuItem_Reload;
    protected JMenuItem m_menuItem_Backup;
    protected JMenuItem m_menuItem_Basemap;
    protected JMenuItem m_menuItem_MultiBasemap;
    protected JMenuItem m_menuItem_TraceTable;
    protected JMenuItem m_menuItem_ViewShot;
    protected JMenuItem m_menuItem_ViewReceiver;
    protected JMenuItem m_menuItem_ViewPatterns;
    protected JCheckBoxMenuItem m_menuItem_CustomDoubleClickTime;
    protected JMenuItem m_menuItem_DoubleClickTime;
    protected JMenuItem m_menuItem_4D;
    protected JMenuItem m_menuItem_ViewProfiles;
    protected JMenuItem m_menuItem_ColumnComparison;
    protected JMenuItem m_menuItem_OutlierDetecttion;
    protected JMenuItem m_menuItem_TwoDimPlots;
    protected JMenu m_menuExport = new JMenu("Export");
    protected JMenuItem m_menuItem_ExportAllProjects;
    protected JMenuItem m_menuItem_ExportThisProject;
    protected JMenuItem m_menuItem_ExportSRtoXML;
    protected JMenuItem m_menuItem_ExportToEchos;
    protected JMenuItem m_menuItem_ExportGeometryChangesToEchos;
    protected JMenu m_menuExtra = new JMenu("Extras...");
    protected JMenu m_menuImport = new JMenu("Import");
    protected JMenuItem m_menuItem_AsciiImport;
    protected JMenuItem m_menuItem_EchosImport;
    protected JMenuItem m_menuItem_ImportTable;
    protected JMenuItem m_menuItem_ImportSpreadsheet;
    protected JMenuItem m_menuItem_Kriging;
    protected JMenuItem m_menuItem_ViewOther;
    protected JMenuItem m_menuItem_DefineGrid3D;
    protected JMenuItem m_menuItem_SelectUnits;
    protected JMenuItem m_menuItem_InputProcessing;
    protected JMenuItem m_menuItem_DropColumns;
    protected JMenuItem m_menuItem_ComputeDistanceMoved;
    protected JMenu m_menuSegy = new JMenu("SEG-Y");
    protected JMenuItem m_menuItem_SegyConvert;
    protected JMenuItem m_menuItem_SegyHeaderFilter;
    protected JMenuItem m_menuItem_VersionManager;
    protected JMenuItem m_menuItem_SeismicFiles;
    protected JMenuItem m_menuItem_BatchProcessing;
    protected JMenuItem m_menuItem_AnadarkoImport;
    protected JMenuItem m_menuItem_GlobalOptions;
    protected JMenuItem m_menuItem_GeomSPS;
    protected JMenuItem m_menuItem_testTraceBackup;
    protected JMenuItem m_menuItem_CreateSqlTraceTable;
    protected JMenuItem m_menuItem_ScanPicks;
    protected SegyHeaderExportDialog m_dlgExportSegy;

    public Menu_RefractionDatabase(JMenuBar menuBar) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            menuBar.add(this.m_menu);
            this.m_menuItem_Reload = this.addMenuItem(this.m_menu, "Refresh all data");
            this.m_menuItem_Backup = this.addMenuItem(this.m_menu, "Create refraction database backup");
            this.m_menu.addSeparator();
            this.m_menuItem_CustomDoubleClickTime = this.addCheckMenuItem(this.m_menu, "Use custom double-click time interval");
            this.m_menuItem_DoubleClickTime = this.addMenuItem(this.m_menu, "Select double-click time interval");
            boolean useCustomClick = SharedApplicationData.singleton().getParameterTree().bool_get("UseCustomDoubleClick", false);
            this.m_menuItem_CustomDoubleClickTime.setState(useCustomClick);
            this.m_menu.addSeparator();
            this.m_menuItem_ViewPatterns = this.addMenuItem(this.m_menu, "Pattern analysis");
            this.m_menuItem_Basemap = this.addMenuItem(this.m_menu, "Basemap");
            this.m_menuItem_MultiBasemap = this.addMenuItem(this.m_menu, "Multiple basemap display");
            this.m_menuItem_TraceTable = this.addMenuItem(this.m_menu, "Trace table");
            this.m_menuItem_ViewShot = this.addMenuItem(this.m_menu, "Shot table");
            this.m_menuItem_ViewReceiver = this.addMenuItem(this.m_menu, "Receiver table");
            this.m_menu.addSeparator();
            this.m_menuItem_InputProcessing = this.addMenuItem(this.m_menu, "Input data processing options");
            this.m_menu.addSeparator();
            this.m_menuItem_GeomSPS = this.addMenuItem(this.m_menu, "SEG-Y header population using SPS files");
            this.m_menu.addSeparator();
            this.m_menuItem_4D = this.addMenuItem(this.m_menu, "Compare to other projects (for example 4D surveys...)");
            this.m_menuItem_ViewProfiles = this.addMenuItem(this.m_menu, "View vertical cross-sections");
            this.m_menuItem_ColumnComparison = this.addMenuItem(this.m_menu, "Column difference display");
            this.m_menuItem_OutlierDetecttion = this.addMenuItem(this.m_menu, "Database outlier detection display");
            this.m_menuItem_TwoDimPlots = this.addMenuItem(this.m_menu, "Two-dimensional database display");
            this.m_menu.addSeparator();
            this.m_menuItem_DropColumns = this.addMenuItem(this.m_menu, "Drop unused columns");
            this.m_menu.addSeparator();
            this.m_menuItem_DefineGrid3D = this.addMenuItem(this.m_menu, "Define grid");
            this.m_menuItem_SelectUnits = this.addMenuItem(this.m_menu, "Select project units");
            this.m_menu.addSeparator();
            this.m_menuItem_VersionManager = this.addMenuItem(this.m_menu, "Version manager");
            this.m_menu.addSeparator();
            this.m_menuItem_SeismicFiles = this.addMenuItem(this.m_menu, "Seismic file manager");
            this.m_menu.addSeparator();
            this.m_menu.add(this.m_menuImport);
            this.m_menuItem_ImportTable = this.addMenuItem(this.m_menuImport, "ASCII table data");
            this.m_menuItem_AsciiImport = this.addMenuItem(this.m_menuImport, "Open ASCII import window");
            this.m_menuItem_ImportSpreadsheet = this.addMenuItem(this.m_menuImport, "Open spreadsheet import window");
            this.m_menuItem_EchosImport = this.addMenuItem(this.m_menuImport, "Import From Echos Spreadsheet");
            this.m_menuItem_ViewOther = this.addMenuItem(this.m_menu, "View imported table");
            this.m_menuItem_Kriging = this.addMenuItem(this.m_menu, "Test interpolation schemes on imported data");
            this.m_menu.addSeparator();
            this.m_menu.add(this.m_menuExport);
            this.m_menuItem_ExportThisProject = this.addMenuItem(this.m_menuExport, "Export geometry changes for this project");
            this.m_menuItem_ExportAllProjects = this.addMenuItem(this.m_menuExport, "Export geometry changes for ALL projects");
            this.m_menuItem_ExportToEchos = this.addMenuItem(this.m_menuExport, "Export to Echos Spreadsheet");
            this.m_menuItem_ExportGeometryChangesToEchos = this.addMenuItem(this.m_menuExport, "Export geometry changes to Echos Spreadsheet");
            this.m_menu.addSeparator();
            this.m_menuItem_ComputeDistanceMoved = this.addMenuItem(this.m_menu, "Compute \"Distance Moved\" value");
            this.m_menu.addSeparator();
            this.m_menu.add(this.m_menuSegy);
            this.m_menuItem_SegyConvert = this.addMenuItem(this.m_menuSegy, "Convert SEG-Y files");
            this.m_menuItem_SegyHeaderFilter = this.addMenuItem(this.m_menuSegy, "Create header-filtered SEG-Y file");
            this.m_menuItem_GlobalOptions = this.addMenuItem(this.m_menuSegy, "Use current window options as default for new projects");
            this.m_menu.addSeparator();
            this.m_menuItem_BatchProcessing = this.addMenuItem(this.m_menu, "SEG-Y export - batch processing dialog");
            this.m_menuItem_ScanPicks = this.addMenuItem(this.m_menu, "Scan picks");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JCheckBoxMenuItem addCheckMenuItem(JMenu menu, String text) {
        try {
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(text);
            menu.add(mi);
            mi.addActionListener(this);
            return mi;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JMenuItem addMenuItem(JMenu menu, String text) {
        try {
            JMenuItem mi = new JMenuItem(text);
            menu.add(mi);
            mi.addActionListener(this);
            return mi;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void importColumnDelimited() throws Exception {
        try {
            ImportColumnDelimitedTableDialog importColumnDelimitedTableDialog = new ImportColumnDelimitedTableDialog(null, "Import column-delimited table", RefractionStaticsProject.singleton().importDatabase(), false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void changeUnits() {
        try {
            Object[] options = new Object[]{"Feet", "Meters", "Cancel"};
            int n = JOptionPane.showOptionDialog(null, "Select the project units", "Project units", 1, 3, null, options, options[0]);
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (n == 0) {
                if (p.units_feet()) {
                    return;
                }
                p.setUnitsFeet();
                JOptionPane.showMessageDialog(null, "You may want to reassign the grid now", "Units changed to feet", 1);
            }
            if (n == 1) {
                if (!p.units_feet()) {
                    return;
                }
                p.setUnitsMeters();
                JOptionPane.showMessageDialog(null, "You may want to reassign the grid now", "Units changed to meters", 1);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Action_Base action;
            JDialog dlg;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            IComponentManager cm = SharedApplicationData.singleton().getComponentManager();
            if (e.getSource() == this.m_menuItem_Backup) {
                p.backup_version_csv(true);
                p.trace_table_create_backup();
                String versionsPath = RefractionStaticsProject.singleton().versionContainerPath();
                String backupsPath = Tools_FileSystem.confirmSubDirectoryExists(RefractionStaticsProject.singleton().projectPath(), "Backups");
                int year = Calendar.getInstance().get(1);
                int month = Calendar.getInstance().get(2) + 1;
                int day = Calendar.getInstance().get(5);
                int count = 1;
                String timestamp = month < 10 ? year + "-0" + month + "-" + day + "-" + count : year + "-" + month + "-" + day + "-" + count;
                while (Tools_FileSystem.exists_path(backupsPath + "/" + timestamp)) {
                    ++count;
                    if (month < 10) {
                        timestamp = year + "-0" + month + "-" + day + "-" + count;
                        continue;
                    }
                    timestamp = year + "-" + month + "-" + day + "-" + count;
                }
                String backupContainer = Tools_FileSystem.confirmSubDirectoryExists(backupsPath, timestamp);
                ArrayList<String> versions = Tools_FileSystem.subdirectories(versionsPath, false);
                for (String version : versions) {
                    String fullVersionPath = versionsPath + "/" + version;
                    String geomDBScriptPath = fullVersionPath + "/geometry.db.script";
                    if (!Tools_FileSystem.exists_file(geomDBScriptPath)) continue;
                    File DBFile = new File(geomDBScriptPath);
                    long DBSize = DBFile.length();
                    if (DBSize > 65000000L) {
                        System.out.println("Geometry DB file size too large (" + DBSize + "), cancelling backup.");
                        continue;
                    }
                    Tools_FileSystem.copySubdirectory(versionsPath, backupContainer, version);
                }
            }
            if (e.getSource() == this.m_menuItem_DoubleClickTime) {
                dlg = new MultiTextDialog(null, "Double-click time interval", "Double-click time interval, milliseconds");
                int v = SharedApplicationData.singleton().getParameterTree().int_get("DoubleClickTime", 300);
                ((MultiTextDialog)dlg).setText(0, Integer.toString(v));
                ((MultiTextDialog)dlg).showDialog("OK");
                if (!((MultiTextDialog)dlg).OK) {
                    return;
                }
                v = ((MultiTextDialog)dlg).getInt(0, 300, 100, 1000);
                SharedApplicationData.singleton().getParameterTree().int_put("DoubleClickTime", v);
                SharedApplicationData.singleton().saveParameterTree();
            }
            if (e.getSource() == this.m_menuItem_CustomDoubleClickTime) {
                boolean b = this.m_menuItem_CustomDoubleClickTime.getState();
                SharedApplicationData.singleton().getParameterTree().bool_put("UseCustomDoubleClick", b);
                SharedApplicationData.singleton().saveParameterTree();
                return;
            }
            if (e.getSource() == this.m_menuItem_SelectUnits) {
                this.changeUnits();
                return;
            }
            if (e.getSource() == this.m_menuItem_InputProcessing) {
                dlg = new InputDataProcessingDialog();
                p.inputDataProcessor_Save();
                return;
            }
            if (e.getSource() == this.m_menuItem_BatchProcessing) {
                BatchProcessingDialog batchDialog = new BatchProcessingDialog();
                return;
            }
            if (e.getSource() == this.m_menuItem_SegyHeaderFilter) {
                dlg = new TraceSelectSegyFileDialog();
                return;
            }
            if (e.getSource() == this.m_menuItem_ExportThisProject) {
                action = new Action_ExportAllProjects();
                String path = Tools_Chooser.getDirectory("Select output path for ASCII files");
                if (!Tools_FileSystem.exists_path(path)) {
                    return;
                }
                action.exportProject(path, p.name(), p.geometryDatabase(), null);
            }
            if (e.getSource() == this.m_menuItem_ExportAllProjects) {
                action = new Action_ExportAllProjects();
                action.ExportPath = Tools_Chooser.getDirectory("Select output path for ASCII files");
                if (!Tools_FileSystem.exists_path(action.ExportPath)) {
                    return;
                }
                RefractionStaticsProject.singleton().executeSingleAction(action);
            }
            if (e.getSource() == this.m_menuItem_ExportSRtoXML) {
                Table_Abstract m_shotTable = RefractionStaticsProject.singleton().shotTable();
                Table_Abstract m_receiverTable = RefractionStaticsProject.singleton().receiverTable();
                String m_projectPath = RefractionStaticsProject.singleton().projectPath();
                String m_exportPath = Tools_FileSystem.confirmSubDirectoryExists(m_projectPath, "Export");
                String m_shotPath = m_exportPath + "/Shot.table";
                String m_receiverPath = m_exportPath + "/Receiver.table";
                m_shotTable.saveBinary(m_shotPath);
                m_receiverTable.saveBinary(m_receiverPath);
            }
            if (e.getSource() == this.m_menuItem_GlobalOptions) {
                String toPath = SharedApplicationData.singleton().homeDirectory();
                String fromPath = RefractionStaticsProject.singleton().projectPath();
                Tools_FileSystem.copySubdirectory(fromPath, toPath, "GuiOptions");
                return;
            }
            if (e.getSource() == this.m_menuItem_ComputeDistanceMoved) {
                Tools_RefractionStaticsProject.computeDistanceMoved();
                return;
            }
            if (e.getSource() == this.m_menuItem_AnadarkoImport) {
                Tools_SpecialCases.importAnadarko();
                return;
            }
            if (e.getSource() == this.m_menuItem_SegyConvert) {
                dlg = new CompressSegyDialog();
                return;
            }
            if (e.getSource() == this.m_menuItem_DefineGrid3D) {
                DefineGridDialog gridDialog = new DefineGridDialog(true, false);
                return;
            }
            if (e.getSource() == this.m_menuItem_TwoDimPlots) {
                cm.showComponent(TwoDStackedDatabaseWidget.class.getName(), "2D plots", "2D plots", false);
                return;
            }
            if (e.getSource() == this.m_menuItem_4D) {
                cm.showComponent(ProjectComparisonWidget.class.getName(), "4D Comp", "4D Comp", false);
                return;
            }
            if (e.getSource() == this.m_menuItem_OutlierDetecttion) {
                cm.showComponent(OutlierMeasurementWidget.class.getName(), "Outliers", "Outliers", false);
                return;
            }
            if (e.getSource() == this.m_menuItem_ViewProfiles) {
                cm.showComponent(VerticalProfileWidget.class.getName(), "Profiles", "Profiles", false);
                return;
            }
            if (e.getSource() == this.m_menuItem_DropColumns) {
                dlg = new DropColumnsDialog(null);
                if (((DropColumnsDialog)dlg).Dropped) {
                    RefractionStaticsProject.singleton().reloadAllData();
                    cm.closeAllComponents();
                }
            }
            if (e.getSource() == this.m_menuItem_CreateSqlTraceTable) {
                action = new Action_CreateTraceTable();
                RefractionStaticsProject.singleton().executeSingleAction(action);
                return;
            }
            if (e.getSource() == this.m_menuItem_SeismicFiles) {
                dlg = new SeismicFileManagerDialog();
                return;
            }
            if (e.getSource() == this.m_menuItem_VersionManager) {
                dlg = new VersionManagerDialog();
                return;
            }
            if (e.getSource() == this.m_menuItem_Reload) {
                RefractionStaticsProject.singleton().reloadAllData();
                return;
            }
            if (e.getSource() == this.m_menuItem_GeomSPS) {
                cm.showComponent(SPSTopLevelWidget.class.getName(), "Geom/SPS", "Geom/SPS", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_Basemap) {
                cm.showComponent(BasemapWidget.class.getName(), "Basemap", "Basemap", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_MultiBasemap) {
                cm.showComponent(MultiBasemapWidget.class.getName(), "MultiMap", "MultiMap", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_Kriging) {
                cm.showComponent(KrigingTestWidget.class.getName(), "Interpolation test", "Interpolation test", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_ColumnComparison) {
                cm.showComponent(ColumnComparisonWidget.class.getName(), "Diff plot", "Diff plot", false);
                return;
            }
            if (e.getSource() == this.m_menuItem_ViewOther) {
                dlg = new SelectTableDialog(null, "Select table", RefractionStaticsProject.singleton().importDatabase());
                String tableName = SharedApplicationData.singleton().SharedString;
                if (tableName == null) {
                    return;
                }
                if (tableName.equalsIgnoreCase("Receiver") || tableName.equalsIgnoreCase("ReceiverConflicts") || tableName.equalsIgnoreCase("ReceiverLink")) {
                    cm.showComponent(ReceiverTableWidget.class.getName(), "Receiver", "Receiver table", true);
                    return;
                }
                if (tableName.equalsIgnoreCase("Shot") || tableName.equalsIgnoreCase("ShotConflicts") || tableName.equalsIgnoreCase("ShotLink")) {
                    cm.showComponent(ShotTableWidget.class.getName(), "Shot", "Shot table", true);
                    return;
                }
                TableWrapperWidget w = new TableWrapperWidget(RefractionStaticsProject.singleton().importDatabase(), tableName, DatabaseEnum.Import);
                cm.showComponent(w, tableName, tableName);
            }
            if (e.getSource() == this.m_menuItem_TraceTable) {
                cm.showComponent(TraceTableWidget.class.getName(), "Trace", "Trace table", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_ViewReceiver) {
                cm.showComponent(ReceiverTableWidget.class.getName(), "Receiver", "Receiver table", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_ViewShot) {
                cm.showComponent(ShotTableWidget.class.getName(), "Shot", "Shot table", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_ImportTable) {
                this.importColumnDelimited();
                return;
            }
            if (e.getSource() == this.m_menuItem_ImportSpreadsheet) {
                cm.showComponent(SpreadsheetImportWidget.class.getName(), "Spreadsheet", "Spreadsheet import", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_AsciiImport) {
                cm.showComponent(AsciiImportWidget.class.getName(), "ASCII", "ASCII import", false);
                return;
            }
            if (e.getSource() == this.m_menuItem_ViewPatterns) {
                cm.showComponent(PatternAnalysisWidget.class.getName(), "Patterns", "Pattern analysis", true);
                return;
            }
            if (e.getSource() == this.m_menuItem_ExportToEchos) {
                this.exportToEchos();
                return;
            }
            if (e.getSource() == this.m_menuItem_EchosImport) {
                this.importFromEchos();
                return;
            }
            if (e.getSource() == this.m_menuItem_ExportGeometryChangesToEchos) {
                this.exportGeometryChangesToEchos();
                return;
            }
            if (e.getSource() == this.m_menuItem_testTraceBackup) {
                return;
            }
            if (e.getSource() == this.m_menuItem_ScanPicks) {
                RefractionStaticsProject.singleton().scanPicks();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void exportGeometryChangesToEchos() {
        try {
            boolean bEchosInitializedOk;
            RefractionStaticsProject project;
            RefractionStaticsProject tableModelProvider = null;
            tableModelProvider = project = RefractionStaticsProject.singleton();
            String sEchosSurvey = "";
            String sEchosHost = "";
            int iLineID = -1;
            if (project.information().string_exists("EchosSurvey")) {
                sEchosSurvey = project.information().string_get("EchosSurvey");
            }
            if (project.information().string_exists("EchosHost")) {
                sEchosHost = project.information().string_get("EchosHost");
            }
            if (project.information().string_exists("EchosLineID")) {
                iLineID = project.information().int_get("EchosLineID");
            }
            if (!(bEchosInitializedOk = XtEchos.initialize())) {
                Exception lastError = XtEchos.getLastInitializeError();
                boolean bLoadLibraryOK = XtEchos.getLoadEposLibraryOK();
                boolean initializeParadigmOK = XtEchos.getInitializeParadigmEnvironmentOK();
                String sError = "Error connecting to Echos";
                if (!bLoadLibraryOK) {
                    sError = "Error loading Echos library";
                }
                if (!initializeParadigmOK) {
                    sError = "Error calling PG_InitializeApplication";
                }
                String sErrorDetails = "";
                if (lastError != null) {
                    sErrorDetails = lastError.getMessage();
                }
                JOptionPane.showMessageDialog(null, sError, sErrorDetails, 0);
                return;
            }
            String sGeometryModelName = tableModelProvider.getModelName(0);
            ExportGeometryToEchosDatabaseDialog dialog = new ExportGeometryToEchosDatabaseDialog("Flatirons", sGeometryModelName, sEchosSurvey, sEchosHost, iLineID, tableModelProvider);
            if (!dialog.showDialog()) return;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void exportToEchos() {
        try {
            boolean bEchosInitializedOk;
            RefractionStaticsProject project;
            RefractionStaticsProject tableModelProvider = null;
            tableModelProvider = project = RefractionStaticsProject.singleton();
            String sEchosSurvey = "";
            String sEchosHost = "";
            int iLineID = -1;
            if (project.information().string_exists("EchosSurvey")) {
                sEchosSurvey = project.information().string_get("EchosSurvey");
            }
            if (project.information().string_exists("EchosHost")) {
                sEchosHost = project.information().string_get("EchosHost");
            }
            if (project.information().string_exists("EchosLineID")) {
                iLineID = project.information().int_get("EchosLineID");
            }
            if (!(bEchosInitializedOk = XtEchos.initialize())) {
                Exception lastError = XtEchos.getLastInitializeError();
                boolean bLoadLibraryOK = XtEchos.getLoadEposLibraryOK();
                boolean initializeParadigmOK = XtEchos.getInitializeParadigmEnvironmentOK();
                String sError = "Error connecting to Echos";
                if (!bLoadLibraryOK) {
                    sError = "Error loading Echos library";
                }
                if (!initializeParadigmOK) {
                    sError = "Error calling PG_InitializeApplication";
                }
                String sErrorDetails = "";
                if (lastError != null) {
                    sErrorDetails = lastError.getMessage();
                }
                JOptionPane.showMessageDialog(null, sError, sErrorDetails, 0);
                return;
            }
            String sGeometryModelName = tableModelProvider.getModelName(0);
            ExportToEchosDatabaseDialog dialog = new ExportToEchosDatabaseDialog("Flatirons", sGeometryModelName, sEchosSurvey, sEchosHost, iLineID, tableModelProvider);
            if (!dialog.showDialog()) return;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void importFromEchos() {
        try {
            RefractionStaticsProject tableModelProvider = null;
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String sEchosSurvey = "";
            String sEchosHost = "";
            int iLineID = -1;
            if (project.information().string_exists("EchosSurvey")) {
                sEchosSurvey = project.information().string_get("EchosSurvey");
            }
            if (project.information().string_exists("EchosHost")) {
                sEchosHost = project.information().string_get("EchosHost");
            }
            if (project.information().string_exists("EchosLineID")) {
                iLineID = project.information().int_get("EchosLineID");
            }
            tableModelProvider = project;
            String sGeometryModelName = tableModelProvider.getModelName(0);
            boolean bEchosSetupOK = Environment.getIsEchosEnvironmentSetupOK("Pecos");
            if (!bEchosSetupOK) {
                return;
            }
            boolean bEchosInitializedOk = XtEchos.initialize();
            if (!bEchosInitializedOk) {
                Exception lastError = XtEchos.getLastInitializeError();
                boolean bLoadLibraryOK = XtEchos.getLoadEposLibraryOK();
                boolean initializeParadigmOK = XtEchos.getInitializeParadigmEnvironmentOK();
                String sError = "Error connecting to Echos";
                if (!bLoadLibraryOK) {
                    sError = "Error loading Echos library";
                }
                if (!initializeParadigmOK) {
                    sError = "Error calling PG_InitializeApplication";
                }
                String sErrorDetails = "";
                if (lastError != null) {
                    sErrorDetails = lastError.getMessage();
                }
                JOptionPane.showMessageDialog(null, sError, sErrorDetails, 0);
                return;
            }
            ImportFromEchosDatabaseDialog dialog = new ImportFromEchosDatabaseDialog("Flatirons", sGeometryModelName, sEchosSurvey, sEchosHost, iLineID, tableModelProvider);
            if (!dialog.showDialog()) return;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

